/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.CheckFacts;
import run.qontract.core.HttpRequest;
import run.qontract.core.HttpRequestPattern;
import run.qontract.core.HttpResponse;
import run.qontract.core.HttpResponsePattern;
import run.qontract.core.IgnoreFacts;
import run.qontract.core.Resolver;
import run.qontract.core.ResolverKt;
import run.qontract.core.Result;
import run.qontract.core.ScenarioKt;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.ContractExceptionKt;
import run.qontract.core.pattern.Examples;
import run.qontract.core.pattern.KafkaMessagePattern;
import run.qontract.core.pattern.Pattern;
import run.qontract.core.pattern.Row;
import run.qontract.core.utilities.FunctionalKt;
import run.qontract.core.value.BooleanValueKt;
import run.qontract.core.value.KafkaMessage;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\t\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015JD\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010&\u001a\u00020'H\u0002J\t\u0010/\u001a\u00020\u0003H\u00c6\u0003J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0007H\u00c6\u0003J\u0015\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\u0015\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\tH\u00c6\u0003J\u0015\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\t\u00107\u001a\u00020\u0014H\u00c6\u0003J\u008f\u0001\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\t2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u00c6\u0001J\u0013\u00109\u001a\u00020\u00142\b\u0010:\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010;\u001a\u00020<J\u001a\u0010=\u001a\u00020>2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tJ\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00000\fJ\t\u0010A\u001a\u00020BH\u00d6\u0001J6\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\n2\u0006\u0010&\u001a\u00020'2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020D0JH\u0002J\"\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020<2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tJ4\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020<2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010N\u001a\u00020'H\u0002J\u000e\u0010K\u001a\u00020L2\u0006\u0010O\u001a\u00020>J\u0016\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020>J\u000e\u0010P\u001a\u00020L2\u0006\u0010S\u001a\u00020TJ\"\u0010U\u001a\u00020L2\u0006\u0010M\u001a\u00020<2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010V\u001a\u00020\u00002\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00000\fJ\u000e\u0010V\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\u0000J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00000\f2\u0006\u0010Y\u001a\u00020ZH\u0002J\u001c\u0010[\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020>0\\2\b\u0010R\u001a\u0004\u0018\u00010>J$\u0010]\u001a\u00020\u00142\u0012\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010_\u001a\u00020\u0003H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001d\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019\u00a8\u0006`"}, d2={"Lrun/qontract/core/Scenario;", "", "name", "", "httpRequestPattern", "Lrun/qontract/core/HttpRequestPattern;", "httpResponsePattern", "Lrun/qontract/core/HttpResponsePattern;", "expectedFacts", "", "Lrun/qontract/core/value/Value;", "examples", "", "Lrun/qontract/core/pattern/Examples;", "patterns", "Lrun/qontract/core/pattern/Pattern;", "fixtures", "kafkaMessagePattern", "Lrun/qontract/core/pattern/KafkaMessagePattern;", "ignoreFailure", "", "(Ljava/lang/String;Lrun/qontract/core/HttpRequestPattern;Lrun/qontract/core/HttpResponsePattern;Ljava/util/Map;Ljava/util/List;Ljava/util/Map;Ljava/util/Map;Lrun/qontract/core/pattern/KafkaMessagePattern;Z)V", "getExamples", "()Ljava/util/List;", "getExpectedFacts", "()Ljava/util/Map;", "getFixtures", "getHttpRequestPattern", "()Lrun/qontract/core/HttpRequestPattern;", "getHttpResponsePattern", "()Lrun/qontract/core/HttpResponsePattern;", "getIgnoreFailure", "()Z", "getKafkaMessagePattern", "()Lrun/qontract/core/pattern/KafkaMessagePattern;", "getName", "()Ljava/lang/String;", "getPatterns", "resolver", "Lrun/qontract/core/Resolver;", "getResolver", "()Lrun/qontract/core/Resolver;", "serverState", "getServerState", "combineFacts", "expected", "actual", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "generateHttpRequest", "Lrun/qontract/core/HttpRequest;", "generateHttpResponse", "Lrun/qontract/core/HttpResponse;", "actualFacts", "generateTestScenarios", "hashCode", "", "ifMatches", "", "key", "expectedValue", "Lrun/qontract/core/value/StringValue;", "actualValue", "code", "Lkotlin/Function0;", "matches", "Lrun/qontract/core/Result;", "httpRequest", "headersResolver", "httpResponse", "matchesMock", "request", "response", "kafkaMessage", "Lrun/qontract/core/value/KafkaMessage;", "matchesStub", "newBasedOn", "suggestions", "scenario", "row", "Lrun/qontract/core/pattern/Row;", "resolverAndResponseFrom", "Lkotlin/Pair;", "serverStateMatches", "actualState", "toString", "core"})
public final class Scenario {
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final String name;
    @NotNull
    private final HttpRequestPattern httpRequestPattern;
    @NotNull
    private final HttpResponsePattern httpResponsePattern;
    @NotNull
    private final Map<String, Value> expectedFacts;
    @NotNull
    private final List<Examples> examples;
    @NotNull
    private final Map<String, Pattern> patterns;
    @NotNull
    private final Map<String, Value> fixtures;
    @Nullable
    private final KafkaMessagePattern kafkaMessagePattern;
    private final boolean ignoreFailure;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean serverStateMatches(Map<String, ? extends Value> actualState, Resolver resolver) {
        boolean bl;
        if (!Intrinsics.areEqual(this.expectedFacts.keySet(), actualState.keySet())) return false;
        Iterable $this$all$iv = FunctionalKt.mapZip(this.expectedFacts, actualState);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            void expectedStateValue;
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Triple $dstr$key$expectedStateValue$actualStateValue = (Triple)element$iv;
            boolean bl2 = false;
            String string = (String)$dstr$key$expectedStateValue$actualStateValue.component1();
            Value value = (Value)$dstr$key$expectedStateValue$actualStateValue.component2();
            Value actualStateValue = (Value)$dstr$key$expectedStateValue$actualStateValue.component3();
            if (Intrinsics.areEqual((Object)actualStateValue, (Object)BooleanValueKt.getTrue()) || Intrinsics.areEqual((Object)expectedStateValue, (Object)BooleanValueKt.getTrue())) {
                bl = true;
                continue;
            }
            if (expectedStateValue instanceof StringValue && ((StringValue)expectedStateValue).isPatternToken()) {
                boolean bl3;
                Pattern pattern = resolver.getPattern(((StringValue)expectedStateValue).getString());
                try {
                    void key;
                    bl3 = resolver.matchesPattern((String)key, pattern, pattern.parse(actualStateValue.toString(), resolver)).isTrue();
                }
                catch (Exception e) {
                    return false;
                }
                bl = bl3;
                continue;
            }
            bl = Intrinsics.areEqual((Object)expectedStateValue.toStringValue(), (Object)actualStateValue.toStringValue());
        } while (bl);
        return false;
    }

    @NotNull
    public final Result matches(@NotNull HttpRequest httpRequest, @NotNull Map<String, ? extends Value> serverState) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter(serverState, (String)"serverState");
        Resolver resolver = new Resolver(serverState, false, this.patterns);
        return this.matches(httpRequest, serverState, resolver, resolver);
    }

    @NotNull
    public final Result matchesStub(@NotNull HttpRequest httpRequest, @NotNull Map<String, ? extends Value> serverState) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter(serverState, (String)"serverState");
        Resolver headersResolver = new Resolver(serverState, false, this.patterns);
        Resolver nonHeadersResolver = Resolver.copy$default(headersResolver, null, false, null, ResolverKt.getCheckAllKeys(), 7, null);
        return this.matches(httpRequest, serverState, nonHeadersResolver, headersResolver);
    }

    private final Result matches(HttpRequest httpRequest, Map<String, ? extends Value> serverState, Resolver resolver, Resolver headersResolver) {
        if (!this.serverStateMatches(serverState, resolver)) {
            Result.Failure failure = new Result.Failure("Facts mismatch", null, "FACTS", null, 10, null);
            boolean bl = false;
            boolean bl2 = false;
            Result.Failure it = failure;
            boolean bl3 = false;
            it.updateScenario(this);
            return failure;
        }
        Result result2 = this.httpRequestPattern.matches(httpRequest, resolver, headersResolver);
        boolean bl = false;
        boolean bl4 = false;
        Result it = result2;
        boolean bl5 = false;
        it.updateScenario(this);
        return result2;
    }

    @NotNull
    public final HttpResponse generateHttpResponse(@NotNull Map<String, ? extends Value> actualFacts) {
        HttpResponse httpResponse2;
        Intrinsics.checkNotNullParameter(actualFacts, (String)"actualFacts");
        Scenario scenario$iv = this;
        boolean $i$f$scenarioBreadCrumb = false;
        try {
            boolean bl = false;
            new Resolver(MapsKt.emptyMap(), false, this.patterns);
            Resolver resolver = new Resolver(actualFacts, false, this.patterns);
            Map<String, Value> facts = this.combineFacts(this.expectedFacts, actualFacts, resolver);
            httpResponse2 = this.httpResponsePattern.generateResponse(Resolver.copy$default(resolver, new CheckFacts(facts), false, null, null, 14, null));
        }
        catch (ContractException e$iv) {
            throw (Throwable)ContractException.copy$default(e$iv, null, null, null, scenario$iv, 7, null);
        }
        return httpResponse2;
    }

    private final Map<String, Value> combineFacts(Map<String, ? extends Value> expected, Map<String, ? extends Value> actual, Resolver resolver) {
        HashMap combinedServerState = new HashMap();
        for (String key : SetsKt.plus(expected.keySet(), (Iterable)actual.keySet())) {
            Value expectedValue = (Value)MapsKt.getValue(expected, (Object)key);
            Value actualValue = (Value)MapsKt.getValue(actual, (Object)key);
            Map<String, ? extends Value> map2 = expected;
            boolean bl = false;
            Map<String, ? extends Value> map3 = map2;
            boolean bl2 = false;
            if (map3.containsKey(key)) {
                map2 = actual;
                bl = false;
                map3 = map2;
                bl2 = false;
                if (map3.containsKey(key)) {
                    if (Intrinsics.areEqual((Object)expectedValue, (Object)actualValue)) {
                        ((Map)combinedServerState).put(key, actualValue);
                        continue;
                    }
                    if (!(expectedValue instanceof StringValue) || !((StringValue)expectedValue).isPatternToken()) continue;
                    this.ifMatches(key, (StringValue)expectedValue, actualValue, resolver, (Function0<Unit>)((Function0)new Function0<Unit>(actualValue, combinedServerState, key){
                        final /* synthetic */ Value $actualValue;
                        final /* synthetic */ HashMap $combinedServerState;
                        final /* synthetic */ String $key;

                        public final void invoke() {
                            ((Map)this.$combinedServerState).put(this.$key, this.$actualValue);
                        }
                        {
                            this.$actualValue = value;
                            this.$combinedServerState = hashMap;
                            this.$key = string;
                            super(0);
                        }
                    }));
                    continue;
                }
            }
            map2 = expected;
            bl = false;
            map3 = map2;
            bl2 = false;
            if (map3.containsKey(key)) {
                ((Map)combinedServerState).put(key, expectedValue);
                continue;
            }
            map2 = actual;
            bl = false;
            map3 = map2;
            bl2 = false;
            if (!map3.containsKey(key)) continue;
            ((Map)combinedServerState).put(key, actualValue);
        }
        return combinedServerState;
    }

    private final void ifMatches(String key, StringValue expectedValue, Value actualValue, Resolver resolver, Function0<Unit> code) {
        Pattern expectedPattern = resolver.getPattern(expectedValue.getString());
        try {
            if (resolver.matchesPattern(key, expectedPattern, expectedPattern.parse(actualValue.toString(), resolver)).isTrue()) {
                code.invoke();
            }
        }
        catch (Throwable e) {
            throw (Throwable)new ContractException("Couldn't match state values. Expected " + expectedValue + " in key " + key + ", actual value is " + actualValue, null, null, null, 14, null);
        }
    }

    @NotNull
    public final HttpRequest generateHttpRequest() {
        HttpRequest httpRequest;
        Scenario scenario$iv = this;
        boolean $i$f$scenarioBreadCrumb = false;
        try {
            boolean bl = false;
            httpRequest = this.httpRequestPattern.generate(new Resolver(this.expectedFacts, false, this.patterns));
        }
        catch (ContractException e$iv) {
            throw (Throwable)ContractException.copy$default(e$iv, null, null, null, scenario$iv, 7, null);
        }
        return httpRequest;
    }

    @NotNull
    public final Result matches(@NotNull HttpResponse httpResponse2) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)httpResponse2, (String)"httpResponse");
        Resolver resolver = new Resolver(this.expectedFacts, false, this.patterns);
        try {
            result2 = this.httpResponsePattern.matches(httpResponse2, resolver).updateScenario(this);
        }
        catch (Throwable exception) {
            return new Result.Failure("Exception: " + exception.getMessage(), null, null, null, 14, null);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Scenario> newBasedOn(Row row) {
        List list;
        Resolver resolver = new Resolver(this.expectedFacts, false, this.patterns);
        Map<String, Value> newExpectedServerState = ScenarioKt.newExpectedServerStateBasedOn(row, this.expectedFacts, this.fixtures, resolver);
        KafkaMessagePattern kafkaMessagePattern = this.kafkaMessagePattern;
        if (kafkaMessagePattern == null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.httpRequestPattern.newBasedOn(row, resolver);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void newHttpRequestPattern;
                HttpRequestPattern httpRequestPattern = (HttpRequestPattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Scenario scenario = new Scenario(this.name, (HttpRequestPattern)newHttpRequestPattern, this.httpResponsePattern, newExpectedServerState, this.examples, this.patterns, this.fixtures, this.kafkaMessagePattern, this.ignoreFailure);
                collection.add(scenario);
            }
            list = (List)destination$iv$iv;
        } else {
            Iterable $this$map$iv = this.kafkaMessagePattern.newBasedOn(row, resolver);
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void newKafkaMessagePattern;
                KafkaMessagePattern newHttpRequestPattern = (KafkaMessagePattern)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Scenario scenario = new Scenario(this.name, this.httpRequestPattern, this.httpResponsePattern, newExpectedServerState, this.examples, this.patterns, this.fixtures, (KafkaMessagePattern)newKafkaMessagePattern, this.ignoreFailure);
                collection.add(scenario);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final List<Scenario> generateTestScenarios() {
        List list;
        Scenario scenario$iv = this;
        boolean $i$f$scenarioBreadCrumb = false;
        try {
            Iterable list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            boolean $i$f$flatMapTo;
            Collection destination$iv$iv;
            boolean $i$f$flatMap;
            Iterable $this$flatMap$iv;
            List list2;
            boolean bl = false;
            switch (this.examples.size()) {
                case 0: {
                    list2 = CollectionsKt.listOf((Object)new Row(null, null, 3, null));
                    break;
                }
                default: {
                    $this$flatMap$iv = this.examples;
                    $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        Examples it = (Examples)element$iv$iv;
                        boolean bl2 = false;
                        list$iv$iv = it.getRows();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                }
            }
            $this$flatMap$iv = list2;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Row row = (Row)element$iv$iv;
                boolean bl3 = false;
                list$iv$iv = this.newBasedOn(row);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (ContractException e$iv) {
            throw (Throwable)ContractException.copy$default(e$iv, null, null, null, scenario$iv, 7, null);
        }
        return list;
    }

    @NotNull
    public final Resolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public final Map<String, Value> getServerState() {
        return this.expectedFacts;
    }

    @NotNull
    public final Result matchesMock(@NotNull HttpRequest request2, @NotNull HttpResponse response) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Scenario scenario$iv = this;
        boolean $i$f$scenarioBreadCrumb = false;
        try {
            Result responseMatchResult;
            boolean bl = false;
            Resolver resolver = new Resolver(new IgnoreFacts(null, 1, null), true, this.patterns, ResolverKt.getCheckAllKeys());
            Result requestMatchResult = (Result)ContractExceptionKt.attempt$default(null, "REQUEST", (Function0)new Function0<Result>(resolver, this, request2, response){
                final /* synthetic */ Resolver $resolver;
                final /* synthetic */ Scenario this$0;
                final /* synthetic */ HttpRequest $request$inlined;
                final /* synthetic */ HttpResponse $response$inlined;
                {
                    this.$resolver = resolver;
                    this.this$0 = scenario;
                    this.$request$inlined = httpRequest;
                    this.$response$inlined = httpResponse2;
                    super(0);
                }

                @NotNull
                public final Result invoke() {
                    return HttpRequestPattern.matches$default(this.this$0.getHttpRequestPattern(), this.$request$inlined, this.$resolver, null, 4, null);
                }
            }, 1, null);
            result2 = requestMatchResult instanceof Result.Failure ? requestMatchResult.updateScenario(this) : ((responseMatchResult = (Result)ContractExceptionKt.attempt$default(null, "RESPONSE", (Function0)new Function0<Result>(resolver, this, request2, response){
                final /* synthetic */ Resolver $resolver;
                final /* synthetic */ Scenario this$0;
                final /* synthetic */ HttpRequest $request$inlined;
                final /* synthetic */ HttpResponse $response$inlined;
                {
                    this.$resolver = resolver;
                    this.this$0 = scenario;
                    this.$request$inlined = httpRequest;
                    this.$response$inlined = httpResponse2;
                    super(0);
                }

                @NotNull
                public final Result invoke() {
                    return this.this$0.getHttpResponsePattern().matchesMock(this.$response$inlined, this.$resolver);
                }
            }, 1, null)) instanceof Result.Failure ? responseMatchResult.updateScenario(this) : responseMatchResult);
        }
        catch (ContractException e$iv) {
            throw (Throwable)ContractException.copy$default(e$iv, null, null, null, scenario$iv, 7, null);
        }
        return result2;
    }

    @NotNull
    public final Result matchesMock(@NotNull KafkaMessage kafkaMessage) {
        Intrinsics.checkNotNullParameter((Object)kafkaMessage, (String)"kafkaMessage");
        Object object = this.kafkaMessagePattern;
        if (object == null || (object = ((KafkaMessagePattern)object).matches(kafkaMessage, Resolver.copy$default(this.resolver, null, false, null, ResolverKt.getCheckAllKeys(), 7, null))) == null) {
            object = new Result.Failure("This scenario does not have a Kafka mock", null, null, null, 14, null);
        }
        return object;
    }

    @NotNull
    public final Pair<Resolver, HttpResponse> resolverAndResponseFrom(@Nullable HttpResponse response) {
        Pair pair;
        Scenario scenario$iv = this;
        boolean $i$f$scenarioBreadCrumb = false;
        try {
            boolean bl = false;
            pair = (Pair)ContractExceptionKt.attempt$default(null, "RESPONSE", (Function0)new Function0<Pair<? extends Resolver, ? extends HttpResponse>>(this, response){
                final /* synthetic */ Scenario this$0;
                final /* synthetic */ HttpResponse $response$inlined;
                {
                    this.this$0 = scenario;
                    this.$response$inlined = httpResponse2;
                    super(0);
                }

                @NotNull
                public final Pair<Resolver, HttpResponse> invoke() {
                    Resolver resolver = new Resolver(this.this$0.getExpectedFacts(), false, this.this$0.getPatterns());
                    HttpResponse httpResponse2 = this.$response$inlined;
                    Intrinsics.checkNotNull((Object)httpResponse2);
                    return new Pair((Object)resolver, (Object)new HttpResponsePattern(httpResponse2).generateResponse(resolver));
                }
            }, 1, null);
        }
        catch (ContractException e$iv) {
            throw (Throwable)ContractException.copy$default(e$iv, null, null, null, scenario$iv, 7, null);
        }
        return pair;
    }

    @NotNull
    public String toString() {
        String string;
        StringBuilder scenarioDescription = new StringBuilder();
        scenarioDescription.append("Scenario: ");
        CharSequence charSequence = this.name;
        boolean bl = false;
        if (charSequence.length() > 0) {
            scenarioDescription.append(this.name + ' ');
        }
        if (this.kafkaMessagePattern != null) {
            String string2 = scenarioDescription.append(this.kafkaMessagePattern.getTopic()).toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scenarioDescription.appe\u2026Pattern.topic).toString()");
        } else {
            String string3 = scenarioDescription.append(String.valueOf(this.httpRequestPattern)).toString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scenarioDescription.appe\u2026questPattern\").toString()");
        }
        return string;
    }

    @NotNull
    public final Scenario newBasedOn(@NotNull Scenario scenario) {
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        return new Scenario(this.name, this.httpRequestPattern, this.httpResponsePattern, this.expectedFacts, scenario.examples, this.patterns, this.fixtures, this.kafkaMessagePattern, this.ignoreFailure);
    }

    @NotNull
    public final Scenario newBasedOn(@NotNull List<Scenario> suggestions) {
        Scenario scenario;
        Object var11_11;
        Scenario scenario2;
        block2: {
            Object v0;
            Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
            Iterable iterable = suggestions;
            scenario2 = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Scenario it = (Scenario)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)this.name)) continue;
                v0 = t;
                break block2;
            }
            v0 = var11_11 = null;
        }
        if ((scenario = (Scenario)var11_11) == null) {
            scenario = this;
        }
        return scenario2.newBasedOn(scenario);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final HttpRequestPattern getHttpRequestPattern() {
        return this.httpRequestPattern;
    }

    @NotNull
    public final HttpResponsePattern getHttpResponsePattern() {
        return this.httpResponsePattern;
    }

    @NotNull
    public final Map<String, Value> getExpectedFacts() {
        return this.expectedFacts;
    }

    @NotNull
    public final List<Examples> getExamples() {
        return this.examples;
    }

    @NotNull
    public final Map<String, Pattern> getPatterns() {
        return this.patterns;
    }

    @NotNull
    public final Map<String, Value> getFixtures() {
        return this.fixtures;
    }

    @Nullable
    public final KafkaMessagePattern getKafkaMessagePattern() {
        return this.kafkaMessagePattern;
    }

    public final boolean getIgnoreFailure() {
        return this.ignoreFailure;
    }

    public Scenario(@NotNull String name, @NotNull HttpRequestPattern httpRequestPattern, @NotNull HttpResponsePattern httpResponsePattern, @NotNull Map<String, ? extends Value> expectedFacts, @NotNull List<Examples> examples, @NotNull Map<String, ? extends Pattern> patterns, @NotNull Map<String, ? extends Value> fixtures, @Nullable KafkaMessagePattern kafkaMessagePattern, boolean ignoreFailure2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)httpRequestPattern, (String)"httpRequestPattern");
        Intrinsics.checkNotNullParameter((Object)httpResponsePattern, (String)"httpResponsePattern");
        Intrinsics.checkNotNullParameter(expectedFacts, (String)"expectedFacts");
        Intrinsics.checkNotNullParameter(examples, (String)"examples");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(fixtures, (String)"fixtures");
        this.name = name;
        this.httpRequestPattern = httpRequestPattern;
        this.httpResponsePattern = httpResponsePattern;
        this.expectedFacts = expectedFacts;
        this.examples = examples;
        this.patterns = patterns;
        this.fixtures = fixtures;
        this.kafkaMessagePattern = kafkaMessagePattern;
        this.ignoreFailure = ignoreFailure2;
        this.resolver = new Resolver(null, false, this.patterns, 3, null);
    }

    public /* synthetic */ Scenario(String string, HttpRequestPattern httpRequestPattern, HttpResponsePattern httpResponsePattern, Map map2, List list, Map map3, Map map4, KafkaMessagePattern kafkaMessagePattern, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            kafkaMessagePattern = null;
        }
        if ((n & 0x100) != 0) {
            bl = false;
        }
        this(string, httpRequestPattern, httpResponsePattern, map2, list, map3, map4, kafkaMessagePattern, bl);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final HttpRequestPattern component2() {
        return this.httpRequestPattern;
    }

    @NotNull
    public final HttpResponsePattern component3() {
        return this.httpResponsePattern;
    }

    @NotNull
    public final Map<String, Value> component4() {
        return this.expectedFacts;
    }

    @NotNull
    public final List<Examples> component5() {
        return this.examples;
    }

    @NotNull
    public final Map<String, Pattern> component6() {
        return this.patterns;
    }

    @NotNull
    public final Map<String, Value> component7() {
        return this.fixtures;
    }

    @Nullable
    public final KafkaMessagePattern component8() {
        return this.kafkaMessagePattern;
    }

    public final boolean component9() {
        return this.ignoreFailure;
    }

    @NotNull
    public final Scenario copy(@NotNull String name, @NotNull HttpRequestPattern httpRequestPattern, @NotNull HttpResponsePattern httpResponsePattern, @NotNull Map<String, ? extends Value> expectedFacts, @NotNull List<Examples> examples, @NotNull Map<String, ? extends Pattern> patterns, @NotNull Map<String, ? extends Value> fixtures, @Nullable KafkaMessagePattern kafkaMessagePattern, boolean ignoreFailure2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)httpRequestPattern, (String)"httpRequestPattern");
        Intrinsics.checkNotNullParameter((Object)httpResponsePattern, (String)"httpResponsePattern");
        Intrinsics.checkNotNullParameter(expectedFacts, (String)"expectedFacts");
        Intrinsics.checkNotNullParameter(examples, (String)"examples");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(fixtures, (String)"fixtures");
        return new Scenario(name, httpRequestPattern, httpResponsePattern, expectedFacts, examples, patterns, fixtures, kafkaMessagePattern, ignoreFailure2);
    }

    public static /* synthetic */ Scenario copy$default(Scenario scenario, String string, HttpRequestPattern httpRequestPattern, HttpResponsePattern httpResponsePattern, Map map2, List list, Map map3, Map map4, KafkaMessagePattern kafkaMessagePattern, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = scenario.name;
        }
        if ((n & 2) != 0) {
            httpRequestPattern = scenario.httpRequestPattern;
        }
        if ((n & 4) != 0) {
            httpResponsePattern = scenario.httpResponsePattern;
        }
        if ((n & 8) != 0) {
            map2 = scenario.expectedFacts;
        }
        if ((n & 0x10) != 0) {
            list = scenario.examples;
        }
        if ((n & 0x20) != 0) {
            map3 = scenario.patterns;
        }
        if ((n & 0x40) != 0) {
            map4 = scenario.fixtures;
        }
        if ((n & 0x80) != 0) {
            kafkaMessagePattern = scenario.kafkaMessagePattern;
        }
        if ((n & 0x100) != 0) {
            bl = scenario.ignoreFailure;
        }
        return scenario.copy(string, httpRequestPattern, httpResponsePattern, map2, list, map3, map4, kafkaMessagePattern, bl);
    }

    public int hashCode() {
        String string = this.name;
        HttpRequestPattern httpRequestPattern = this.httpRequestPattern;
        HttpResponsePattern httpResponsePattern = this.httpResponsePattern;
        Map<String, Value> map2 = this.expectedFacts;
        List<Examples> list = this.examples;
        Map<String, Pattern> map3 = this.patterns;
        Map<String, Value> map4 = this.fixtures;
        KafkaMessagePattern kafkaMessagePattern = this.kafkaMessagePattern;
        int n = ((((((((string != null ? string.hashCode() : 0) * 31 + (httpRequestPattern != null ? ((Object)httpRequestPattern).hashCode() : 0)) * 31 + (httpResponsePattern != null ? ((Object)httpResponsePattern).hashCode() : 0)) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (map3 != null ? ((Object)map3).hashCode() : 0)) * 31 + (map4 != null ? ((Object)map4).hashCode() : 0)) * 31 + (kafkaMessagePattern != null ? ((Object)kafkaMessagePattern).hashCode() : 0)) * 31;
        int n2 = this.ignoreFailure ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Scenario)) break block3;
                Scenario scenario = (Scenario)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)scenario.name) || !Intrinsics.areEqual((Object)this.httpRequestPattern, (Object)scenario.httpRequestPattern) || !Intrinsics.areEqual((Object)this.httpResponsePattern, (Object)scenario.httpResponsePattern) || !Intrinsics.areEqual(this.expectedFacts, scenario.expectedFacts) || !Intrinsics.areEqual(this.examples, scenario.examples) || !Intrinsics.areEqual(this.patterns, scenario.patterns) || !Intrinsics.areEqual(this.fixtures, scenario.fixtures) || !Intrinsics.areEqual((Object)this.kafkaMessagePattern, (Object)scenario.kafkaMessagePattern) || this.ignoreFailure != scenario.ignoreFailure) break block3;
            }
            return true;
        }
        return false;
    }
}

