/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.git;

import io.ktor.http.CodecsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.git.SystemGit;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.utilities.GitRepo;
import run.qontract.core.utilities.Utilities;
import run.qontract.core.value.JSONObjectValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u0004\u0018\u00010\u0007\u001a\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u001a;\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00050\rH\u0002\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u001a\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a8\u0006\u001d"}, d2={"clone", "Ljava/io/File;", "workingDirectory", "gitRepo", "Lrun/qontract/core/utilities/GitRepo;", "", "gitRepositoryURI", "", "cloneDirectory", "getBearerToken", "getPersonalAccessToken", "jgitClone", "onFailure", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "exception", "loadFromPath", "Lrun/qontract/core/value/Value;", "json", "path", "", "readBearerFromEnvVariable", "qontractConfig", "readBearerFromFile", "readQontractConfig", "qontractConfigFile", "resetCloneDirectory", "core"})
public final class GitOperationsKt {
    @NotNull
    public static final File clone(@NotNull File workingDirectory, @NotNull GitRepo gitRepo) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)gitRepo, (String)"gitRepo");
        File cloneDirectory = gitRepo.directoryRelativeTo(workingDirectory);
        GitOperationsKt.resetCloneDirectory(cloneDirectory);
        GitOperationsKt.clone(gitRepo.getGitRepositoryURL(), cloneDirectory);
        return cloneDirectory;
    }

    private static final void clone(String gitRepositoryURI, File cloneDirectory) {
        GitOperationsKt.jgitClone(gitRepositoryURI, cloneDirectory, (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(cloneDirectory, gitRepositoryURI){
            final /* synthetic */ File $cloneDirectory;
            final /* synthetic */ String $gitRepositoryURI;

            public final void invoke(@NotNull Throwable exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                String string = "Falling back to git command after getting error from jgit (" + exception.getClass().getName() + ": " + exception.getMessage() + ')';
                boolean bl = false;
                System.out.println((Object)string);
                String string2 = this.$cloneDirectory.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cloneDirectory.parent");
                new SystemGit(string2, "-").clone(this.$gitRepositoryURI, this.$cloneDirectory);
            }
            {
                this.$cloneDirectory = file;
                this.$gitRepositoryURI = string;
                super(1);
            }
        }));
    }

    private static final void resetCloneDirectory(File cloneDirectory) {
        String string = "Resetting " + cloneDirectory.getAbsolutePath();
        boolean bl = false;
        System.out.println((Object)string);
        if (cloneDirectory.exists()) {
            FilesKt.deleteRecursively((File)cloneDirectory);
        }
        cloneDirectory.mkdirs();
    }

    private static final void jgitClone(String gitRepositoryURI, File cloneDirectory, Function1<? super Throwable, Unit> onFailure) {
        try {
            CloneCommand cloneCommand = Git.cloneRepository();
            boolean bl = false;
            boolean bl2 = false;
            CloneCommand $this$apply = cloneCommand;
            boolean bl3 = false;
            $this$apply.setTransportConfigCallback(Utilities.getTransportCallingCallback$default(null, 1, null));
            $this$apply.setURI(gitRepositoryURI);
            $this$apply.setDirectory(cloneDirectory);
            CloneCommand cloneCommand2 = cloneCommand;
            String accessToken = GitOperationsKt.getPersonalAccessToken();
            if (accessToken != null) {
                CredentialsProvider credentialsProvider = (CredentialsProvider)new UsernamePasswordCredentialsProvider(accessToken, "");
                cloneCommand2.setCredentialsProvider(credentialsProvider);
            } else {
                String ciBearerToken = GitOperationsKt.getBearerToken();
                if (ciBearerToken != null) {
                    cloneCommand2.setTransportConfigCallback(Utilities.getTransportCallingCallback(CodecsKt.encodeOAuth((String)ciBearerToken)));
                }
            }
            cloneCommand2.call();
        }
        catch (Throwable e) {
            onFailure.invoke((Object)e);
        }
    }

    @Nullable
    public static final Value loadFromPath(@Nullable Value json, @NotNull List<String> path) {
        Value value;
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (!(json instanceof JSONObjectValue)) {
            return null;
        }
        switch (path.size()) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                value = ((JSONObjectValue)json).getJsonObject().get(CollectionsKt.first(path));
                break;
            }
            default: {
                value = GitOperationsKt.loadFromPath(((JSONObjectValue)json).getJsonObject().get(CollectionsKt.first(path)), CollectionsKt.drop((Iterable)path, (int)1));
            }
        }
        return value;
    }

    @Nullable
    public static final String getBearerToken() {
        String string;
        File qontractConfigFile = new File("./qontract.json");
        if (qontractConfigFile.exists()) {
            Value value = GitOperationsKt.readQontractConfig(qontractConfigFile);
            boolean bl = false;
            boolean bl2 = false;
            Value qontractConfig = value;
            boolean bl3 = false;
            string = GitOperationsKt.readBearerFromEnvVariable(qontractConfig);
            if (string == null) {
                string = GitOperationsKt.readBearerFromFile(qontractConfig);
            }
        } else {
            Object var1_2 = null;
            boolean bl = false;
            boolean bl4 = false;
            Void it = var1_2;
            boolean bl5 = false;
            String string2 = "./qontract.json not found";
            boolean bl6 = false;
            System.out.println((Object)string2);
            string2 = "Current working directory is " + new File(".").getAbsolutePath();
            bl6 = false;
            System.out.println((Object)string2);
            string = var1_2;
        }
        return string;
    }

    private static final String readBearerFromEnvVariable(Value qontractConfig) {
        String string;
        Object object = GitOperationsKt.loadFromPath(qontractConfig, CollectionsKt.listOf((Object[])new String[]{"auth", "bearer-environment-variable"}));
        if (object != null && (object = object.toStringValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object bearerName = object2;
            boolean bl3 = false;
            String string2 = "Found bearer name " + (String)bearerName;
            boolean bl4 = false;
            System.out.println((Object)string2);
            string2 = System.getenv((String)bearerName);
            bl4 = false;
            boolean bl5 = false;
            String it = string2;
            boolean bl6 = false;
            if (it != null) {
                String string3 = (String)bearerName + " is not empty";
                boolean bl7 = false;
                System.out.println((Object)string3);
            }
            string = string2;
        } else {
            string = null;
        }
        return string;
    }

    private static final String readBearerFromFile(Value qontractConfig) {
        String string;
        Object object = GitOperationsKt.loadFromPath(qontractConfig, CollectionsKt.listOf((Object[])new String[]{"auth", "bearer-file"}));
        if (object != null && (object = object.toStringValue()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object bearerFileName = object2;
            boolean bl3 = false;
            Object object3 = "Found bearer file name " + (String)bearerFileName;
            boolean bl4 = false;
            System.out.println(object3);
            object3 = new File("./" + (String)bearerFileName);
            bl4 = false;
            boolean bl5 = false;
            Object it = object3;
            boolean bl6 = false;
            Object object4 = ((File)it).exists() ? object3 : null;
            if (object4 != null) {
                object3 = object4;
                bl4 = false;
                bl5 = false;
                it = object3;
                boolean bl7 = false;
                String string2 = "Found bearer file";
                boolean bl8 = false;
                System.out.println((Object)string2);
                string2 = FilesKt.readText$default((File)it, null, (int)1, null);
                bl8 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final String getPersonalAccessToken() {
        File configFile;
        File homeDir = new File(System.getProperty("user.home"));
        if (homeDir.exists() && (configFile = FilesKt.resolve((File)homeDir, (String)"qontract.json")).exists()) {
            Value qontractConfig = GitOperationsKt.readQontractConfig(configFile);
            String azureAccessTokenKey = "azure-access-token";
            if (qontractConfig instanceof JSONObjectValue && ((JSONObjectValue)qontractConfig).getJsonObject().containsKey(azureAccessTokenKey)) {
                return ((JSONObjectValue)qontractConfig).getString(azureAccessTokenKey);
            }
        }
        return null;
    }

    private static final Value readQontractConfig(File qontractConfigFile) {
        return GrammarKt.parsedJSON(FilesKt.readText$default((File)qontractConfigFile, null, (int)1, null));
    }
}

