/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.git;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import run.qontract.core.git.GitCommand;
import run.qontract.core.git.SystemGitKt;
import run.qontract.core.utilities.Utilities;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\u0010\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0000H\u0016J!\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0011\"\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0000H\u0016J\b\u0010\u001d\u001a\u00020\u0000H\u0016J\b\u0010\u001e\u001a\u00020\u0000H\u0016J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030 2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020\u0000H\u0016J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010%\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lrun/qontract/core/git/SystemGit;", "Lrun/qontract/core/git/GitCommand;", "workingDirectory", "", "prefix", "(Ljava/lang/String;Ljava/lang/String;)V", "add", "relativePath", "checkout", "branchName", "clone", "gitRepositoryURI", "cloneDirectory", "Ljava/io/File;", "commit", "execute", "command", "", "([Ljava/lang/String;)Ljava/lang/String;", "fileIsInGitDir", "", "newerContractPath", "getChangedFiles", "", "gitRoot", "inGitRootOf", "contractPath", "merge", "mergeAbort", "pull", "push", "relativeGitPath", "Lkotlin/Pair;", "resetHard", "resetMixed", "show", "treeish", "workingDirectoryIsGitRepo", "core"})
public final class SystemGit
implements GitCommand {
    private final String workingDirectory;
    private final String prefix;

    private final String execute(String ... command) {
        Collection $this$toTypedArray$iv = ArraysKt.toList((Object[])command);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return SystemGitKt.access$executeCommandWithWorkingDirectory(this.prefix, this.workingDirectory, stringArray);
    }

    @Override
    @NotNull
    public SystemGit add() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "add", ".");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit add(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "add", relativePath);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit commit() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "commit", "-m", "Updated contract");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit push() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "push");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit pull() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "pull");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetHard() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "reset", "--hard", "HEAD");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit resetMixed() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "reset", "--mixed", "HEAD");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit mergeAbort() {
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "merge", "--aborg");
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit checkout(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "checkout", branchName);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit merge(@NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        this.execute("git", "merge", branchName);
        return systemGit;
    }

    @Override
    @NotNull
    public SystemGit clone(@NotNull String gitRepositoryURI, @NotNull File cloneDirectory) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURI, (String)"gitRepositoryURI");
        Intrinsics.checkNotNullParameter((Object)cloneDirectory, (String)"cloneDirectory");
        SystemGit systemGit = this;
        boolean bl = false;
        boolean bl2 = false;
        SystemGit it = systemGit;
        boolean bl3 = false;
        String[] stringArray = new String[4];
        stringArray[0] = "git";
        stringArray[1] = "clone";
        stringArray[2] = gitRepositoryURI;
        String string = cloneDirectory.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cloneDirectory.absolutePath");
        stringArray[3] = string;
        this.execute(stringArray);
        return systemGit;
    }

    @Override
    @NotNull
    public String gitRoot() {
        String string = this.execute("git", "rev-parse", "--show-toplevel");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    @Override
    @NotNull
    public String show(@NotNull String treeish, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)treeish, (String)"treeish");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        return this.execute("git", "show", treeish + ':' + relativePath);
    }

    @Override
    public boolean workingDirectoryIsGitRepo() {
        boolean bl;
        try {
            String string = this.execute("git", "rev-parse", "--is-inside-work-tree");
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            bl = Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)string2)).toString(), (Object)"true");
        }
        catch (Throwable e) {
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean it = bl3;
            boolean bl6 = false;
            String string = "This must not be a git dir, got error " + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e);
            boolean bl7 = false;
            System.out.println((Object)string);
            bl = bl3;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getChangedFiles() {
        void $this$mapTo$iv$iv;
        CharSequence charSequence = this.execute("git", "status", "--porcelain=1");
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String result2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        charSequence = result2;
        bl = false;
        if (charSequence.length() == 0) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = StringsKt.lines((CharSequence)result2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var11_11 = it;
            boolean bl3 = false;
            void v1 = var11_11;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string3 = (String)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString(), (String[])new String[]{" "}, (boolean)false, (int)2, (int)2, null).get(1);
            collection.add(string3);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Pair<SystemGit, String> relativeGitPath(@NotNull String newerContractPath) {
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        File file = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(newerContractPath).absoluteFile");
        String string = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(newerContractPath).absoluteFile.parent");
        File gitRoot = new File(new SystemGit(string, null, 2, null).gitRoot());
        String string2 = gitRoot.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gitRoot.absolutePath");
        SystemGit git = new SystemGit(string2, null, 2, null);
        File file2 = new File(newerContractPath).getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"File(newerContractPath).absoluteFile");
        File file3 = gitRoot.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"gitRoot.absoluteFile");
        String relativeContractPath = FilesKt.relativeTo((File)file2, (File)file3).getPath();
        return new Pair((Object)git, (Object)relativeContractPath);
    }

    @Override
    public boolean fileIsInGitDir(@NotNull String newerContractPath) {
        String parentDir;
        Intrinsics.checkNotNullParameter((Object)newerContractPath, (String)"newerContractPath");
        File file = new File(newerContractPath).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(newerContractPath).parentFile");
        String string = parentDir = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentDir");
        return new SystemGit(string, null, 2, null).workingDirectoryIsGitRepo();
    }

    @Override
    @NotNull
    public GitCommand inGitRootOf(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        File file = new File(contractPath).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"File(contractPath).parentFile");
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(contractPath).parentFile.absolutePath");
        return new SystemGit(string, null, 2, null);
    }

    public SystemGit(@NotNull String workingDirectory, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.workingDirectory = workingDirectory;
        this.prefix = prefix;
    }

    public /* synthetic */ SystemGit(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        if ((n & 2) != 0) {
            string2 = "- ";
        }
        this(string, string2);
    }

    public SystemGit() {
        this(null, null, 3, null);
    }
}

