/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.Resolver;
import run.qontract.core.Result;
import run.qontract.core.ResultKt;
import run.qontract.core.pattern.ConsumeResult;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.DictionaryPattern;
import run.qontract.core.pattern.ExactValuePattern;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.pattern.JSONArrayPatternKt;
import run.qontract.core.pattern.PairOfTypes;
import run.qontract.core.pattern.Pattern;
import run.qontract.core.pattern.Row;
import run.qontract.core.pattern.TypeStackKt;
import run.qontract.core.value.JSONArrayValue;
import run.qontract.core.value.JSONObjectValue;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0001H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00012\b\b\u0002\u0010\u0003\u001a\u00020\u00012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\t\u0010&\u001a\u00020'H\u00d6\u0001J\u001e\u0010(\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020$0*2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u001a\u0010+\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00010*2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0018\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u001aH\u0016J\t\u00102\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u00063"}, d2={"Lrun/qontract/core/pattern/DictionaryPattern;", "Lrun/qontract/core/pattern/Pattern;", "keyPattern", "valuePattern", "typeAlias", "", "(Lrun/qontract/core/pattern/Pattern;Lrun/qontract/core/pattern/Pattern;Ljava/lang/String;)V", "getKeyPattern", "()Lrun/qontract/core/pattern/Pattern;", "pattern", "", "getPattern", "()Ljava/lang/Object;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "getValuePattern", "component1", "component2", "component3", "copy", "encompasses", "Lrun/qontract/core/Result;", "otherPattern", "thisResolver", "Lrun/qontract/core/Resolver;", "otherResolver", "typeStack", "", "Lrun/qontract/core/pattern/PairOfTypes;", "Lrun/qontract/core/pattern/TypeStack;", "equals", "", "other", "generate", "Lrun/qontract/core/value/Value;", "resolver", "hashCode", "", "listOf", "valueList", "", "matches", "sampleData", "newBasedOn", "row", "Lrun/qontract/core/pattern/Row;", "parse", "value", "toString", "core"})
public final class DictionaryPattern
implements Pattern {
    @NotNull
    private final String typeName;
    @NotNull
    private final Object pattern;
    @NotNull
    private final Pattern keyPattern;
    @NotNull
    private final Pattern valuePattern;
    @Nullable
    private final String typeAlias;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        if (!(sampleData instanceof JSONObjectValue)) {
            return ResultKt.mismatchResult("JSON object", sampleData);
        }
        Map<String, Value> $this$forEach$iv = ((JSONObjectValue)sampleData).getJsonObject();
        boolean $i$f$forEach = false;
        Map<String, Value> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, Value>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object result2;
            void key;
            Map.Entry<String, Value> element$iv;
            Map.Entry<String, Value> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, Value> entry = $dstr$key$value;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            Value value = entry.getValue();
            try {
                Value parsedKey = this.keyPattern.parse((String)key, resolver);
                result2 = resolver.matchesPattern(null, this.keyPattern, parsedKey);
                if (result2 instanceof Result.Failure) {
                    return ((Result.Failure)result2).breadCrumb((String)key);
                }
            }
            catch (ContractException e) {
                return e.failure().breadCrumb((String)key);
            }
            try {
                result2 = value;
                Value parsedValue = result2 instanceof StringValue ? this.valuePattern.parse(((StringValue)value).getString(), resolver) : value;
                if (!((result2 = resolver.matchesPattern(null, this.valuePattern, parsedValue)) instanceof Result.Failure)) continue;
                return ((Result.Failure)result2).breadCrumb((String)key);
            }
            catch (ContractException e) {
                return e.failure().breadCrumb((String)key);
            }
        }
        return new Result.Success();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Map map2;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        int n = 1;
        Iterable iterable = (Iterable)new IntRange(n, JSONArrayPatternKt.randomNumber(10));
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int n2 = element$iv = ((IntIterator)iterator).nextInt();
            Map obj = accumulator$iv;
            boolean bl = false;
            String key = this.keyPattern.generate(resolver).toStringValue();
            Value value = this.valuePattern.generate(resolver);
            accumulator$iv = MapsKt.plus((Map)obj, (Pair)TuplesKt.to((Object)key, (Object)value));
        }
        Map map3 = map2 = accumulator$iv;
        return new JSONObjectValue(map3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        List<Pattern> newValuePatterns = this.valuePattern.newBasedOn(new Row(null, null, 3, null), resolver);
        Iterable $this$map$iv = newValuePatterns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pattern pattern = (Pattern)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DictionaryPattern dictionaryPattern = new DictionaryPattern(this.keyPattern, (Pattern)it, null, 4, null);
            collection.add(dictionaryPattern);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return GrammarKt.parsedJSON(value);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Pattern pattern = otherPattern;
        if (pattern instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf((Object)this), otherResolver, thisResolver, typeStack);
        } else if (!(pattern instanceof DictionaryPattern)) {
            result2 = new Result.Failure("Expected dictionary type, got " + otherPattern.getTypeName(), null, null, null, 14, null);
        } else {
            Object v1;
            block6: {
                Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOf((Object[])new Function0[]{(Function0)new Function0<Result>(this, otherPattern, thisResolver, otherResolver, typeStack){
                    final /* synthetic */ DictionaryPattern this$0;
                    final /* synthetic */ Pattern $otherPattern;
                    final /* synthetic */ Resolver $thisResolver;
                    final /* synthetic */ Resolver $otherResolver;
                    final /* synthetic */ Set $typeStack;

                    @NotNull
                    public final Result invoke() {
                        return TypeStackKt.biggerEncompassesSmaller(this.this$0.getKeyPattern(), ((DictionaryPattern)this.$otherPattern).getKeyPattern(), this.$thisResolver, this.$otherResolver, this.$typeStack);
                    }
                    {
                        this.this$0 = dictionaryPattern;
                        this.$otherPattern = pattern;
                        this.$thisResolver = resolver;
                        this.$otherResolver = resolver2;
                        this.$typeStack = set;
                        super(0);
                    }
                }, (Function0)new Function0<Result>(this, otherPattern, thisResolver, otherResolver, typeStack){
                    final /* synthetic */ DictionaryPattern this$0;
                    final /* synthetic */ Pattern $otherPattern;
                    final /* synthetic */ Resolver $thisResolver;
                    final /* synthetic */ Resolver $otherResolver;
                    final /* synthetic */ Set $typeStack;

                    @NotNull
                    public final Result invoke() {
                        return TypeStackKt.biggerEncompassesSmaller(this.this$0.getValuePattern(), ((DictionaryPattern)this.$otherPattern).getValuePattern(), this.$thisResolver, this.$otherResolver, this.$typeStack);
                    }
                    {
                        this.this$0 = dictionaryPattern;
                        this.$otherPattern = pattern;
                        this.$thisResolver = resolver;
                        this.$otherResolver = resolver2;
                        this.$typeStack = set;
                        super(0);
                    }
                }})), (Function1)encompasses.3.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Result it = (Result)element$iv;
                    boolean bl = false;
                    if (!(it instanceof Result.Failure)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((result2 = (Result)v1) == null) {
                result2 = new Result.Success();
            }
        }
        return result2;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return this.pattern;
    }

    @NotNull
    public final Pattern getKeyPattern() {
        return this.keyPattern;
    }

    @NotNull
    public final Pattern getValuePattern() {
        return this.valuePattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    public DictionaryPattern(@NotNull Pattern keyPattern, @NotNull Pattern valuePattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)keyPattern, (String)"keyPattern");
        Intrinsics.checkNotNullParameter((Object)valuePattern, (String)"valuePattern");
        this.keyPattern = keyPattern;
        this.valuePattern = valuePattern;
        this.typeAlias = typeAlias;
        this.typeName = "object with key type " + this.keyPattern.getTypeName() + " and value type " + this.valuePattern.getTypeName();
        this.pattern = '(' + GrammarKt.withoutPatternDelimiters(this.keyPattern.getPattern().toString()) + ':' + GrammarKt.withoutPatternDelimiters(this.valuePattern.getPattern().toString()) + ')';
    }

    public /* synthetic */ DictionaryPattern(Pattern pattern, Pattern pattern2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(pattern, pattern2, string);
    }

    @Override
    @NotNull
    public ConsumeResult encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(others, (String)"others");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter((Object)lengthError, (String)"lengthError");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(otherPatterns, (String)"otherPatterns");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @NotNull
    public final Pattern component1() {
        return this.keyPattern;
    }

    @NotNull
    public final Pattern component2() {
        return this.valuePattern;
    }

    @Nullable
    public final String component3() {
        return this.getTypeAlias();
    }

    @NotNull
    public final DictionaryPattern copy(@NotNull Pattern keyPattern, @NotNull Pattern valuePattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)keyPattern, (String)"keyPattern");
        Intrinsics.checkNotNullParameter((Object)valuePattern, (String)"valuePattern");
        return new DictionaryPattern(keyPattern, valuePattern, typeAlias);
    }

    public static /* synthetic */ DictionaryPattern copy$default(DictionaryPattern dictionaryPattern, Pattern pattern, Pattern pattern2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            pattern = dictionaryPattern.keyPattern;
        }
        if ((n & 2) != 0) {
            pattern2 = dictionaryPattern.valuePattern;
        }
        if ((n & 4) != 0) {
            string = dictionaryPattern.getTypeAlias();
        }
        return dictionaryPattern.copy(pattern, pattern2, string);
    }

    @NotNull
    public String toString() {
        return "DictionaryPattern(keyPattern=" + this.keyPattern + ", valuePattern=" + this.valuePattern + ", typeAlias=" + this.getTypeAlias() + ")";
    }

    public int hashCode() {
        Pattern pattern = this.keyPattern;
        Pattern pattern2 = this.valuePattern;
        String string = this.getTypeAlias();
        return ((pattern != null ? pattern.hashCode() : 0) * 31 + (pattern2 != null ? pattern2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DictionaryPattern)) break block3;
                DictionaryPattern dictionaryPattern = (DictionaryPattern)object;
                if (!Intrinsics.areEqual((Object)this.keyPattern, (Object)dictionaryPattern.keyPattern) || !Intrinsics.areEqual((Object)this.valuePattern, (Object)dictionaryPattern.valuePattern) || !Intrinsics.areEqual((Object)this.getTypeAlias(), (Object)dictionaryPattern.getTypeAlias())) break block3;
            }
            return true;
        }
        return false;
    }
}

