/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.pattern;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.Resolver;
import run.qontract.core.Result;
import run.qontract.core.ResultKt;
import run.qontract.core.pattern.ConsumeResult;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.PairOfTypes;
import run.qontract.core.pattern.Pattern;
import run.qontract.core.pattern.Row;
import run.qontract.core.value.EmptyStringKt;
import run.qontract.core.value.JSONArrayValue;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0010\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00150\u0014j\u0002`\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u001e\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u001a\u0010\u001d\u001a\u00020\u000e2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006%"}, d2={"Lrun/qontract/core/pattern/EmptyStringPattern;", "Lrun/qontract/core/pattern/Pattern;", "()V", "pattern", "", "getPattern", "()Ljava/lang/Object;", "typeAlias", "", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "encompasses", "Lrun/qontract/core/Result;", "otherPattern", "thisResolver", "Lrun/qontract/core/Resolver;", "otherResolver", "typeStack", "", "Lrun/qontract/core/pattern/PairOfTypes;", "Lrun/qontract/core/pattern/TypeStack;", "generate", "Lrun/qontract/core/value/Value;", "resolver", "listOf", "valueList", "", "matches", "sampleData", "newBasedOn", "row", "Lrun/qontract/core/pattern/Row;", "parse", "value", "toString", "core"})
public final class EmptyStringPattern
implements Pattern {
    @NotNull
    private static final String typeName;
    @NotNull
    private static final Object pattern;
    public static final EmptyStringPattern INSTANCE;

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Value value = sampleData;
        return Intrinsics.areEqual((Object)value, (Object)EmptyStringKt.getEmptyString()) ? (Result)new Result.Success() : (Result)ResultKt.mismatchResult("empty string", sampleData);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new StringValue("");
    }

    @Override
    @NotNull
    public List<Pattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return CollectionsKt.listOf((Object)this);
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        CharSequence charSequence = value;
        boolean bl = false;
        if (!(charSequence.length() == 0)) {
            throw (Throwable)new ContractException("No data was expected, but got \"" + value + "\" instead", null, null, null, 14, null);
        }
        return EmptyStringKt.getEmptyString();
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        if (otherPattern instanceof EmptyStringPattern) {
            return new Result.Success();
        }
        return new Result.Failure("No data was expected, but got \"" + otherPattern.getTypeName() + "\" instead", null, null, null, 14, null);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return pattern;
    }

    @NotNull
    public String toString() {
        return "(nothing)";
    }

    private EmptyStringPattern() {
    }

    static {
        EmptyStringPattern emptyStringPattern;
        INSTANCE = emptyStringPattern = new EmptyStringPattern();
        typeName = "nothing";
        pattern = "";
    }

    @Override
    @NotNull
    public ConsumeResult encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(others, (String)"others");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter((Object)lengthError, (String)"lengthError");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(otherPatterns, (String)"otherPatterns");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }
}

