/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.pattern;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.Resolver;
import run.qontract.core.Result;
import run.qontract.core.ResultKt;
import run.qontract.core.pattern.ConsumeResult;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.DeferredPatternKt;
import run.qontract.core.pattern.ExactValuePattern;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.pattern.JSONArrayPatternKt;
import run.qontract.core.pattern.MemberList;
import run.qontract.core.pattern.PairOfTypes;
import run.qontract.core.pattern.Pattern;
import run.qontract.core.pattern.RestPattern;
import run.qontract.core.pattern.ResultWithIndex;
import run.qontract.core.pattern.Row;
import run.qontract.core.pattern.SequenceType;
import run.qontract.core.pattern.TypeStackKt;
import run.qontract.core.utilities.JSONSerialisationKt;
import run.qontract.core.utilities.Utilities;
import run.qontract.core.value.JSONArrayValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0006B!\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J%\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u001f0\u001ej\u0002` H\u0016J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u00d6\u0003J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u001e\u0010*\u001a\u00020&2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\b2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u001a\u0010,\u001a\u00020\u00182\b\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u001bH\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010/\u001a\u0002002\u0006\u0010'\u001a\u00020\u001bH\u0016J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u001bH\u0016J\t\u00103\u001a\u00020\u0004H\u00d6\u0001J\u0018\u00104\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u000bH\u0002R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u00067"}, d2={"Lrun/qontract/core/pattern/JSONArrayPattern;", "Lrun/qontract/core/pattern/Pattern;", "Lrun/qontract/core/pattern/SequenceType;", "jsonString", "", "typeAlias", "(Ljava/lang/String;Ljava/lang/String;)V", "pattern", "", "(Ljava/util/List;Ljava/lang/String;)V", "memberList", "Lrun/qontract/core/pattern/MemberList;", "getMemberList", "()Lrun/qontract/core/pattern/MemberList;", "getPattern", "()Ljava/util/List;", "getTypeAlias", "()Ljava/lang/String;", "typeName", "getTypeName", "component1", "component2", "copy", "encompasses", "Lrun/qontract/core/Result;", "otherPattern", "thisResolver", "Lrun/qontract/core/Resolver;", "otherResolver", "typeStack", "", "Lrun/qontract/core/pattern/PairOfTypes;", "Lrun/qontract/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "Lrun/qontract/core/value/Value;", "resolver", "hashCode", "", "listOf", "valueList", "matches", "sampleData", "newBasedOn", "row", "Lrun/qontract/core/pattern/Row;", "parse", "value", "toString", "validateInfiniteLength", "otherMembers", "theseMembers", "core"})
public final class JSONArrayPattern
implements Pattern,
SequenceType {
    @NotNull
    private final String typeName;
    @NotNull
    private final List<Pattern> pattern;
    @Nullable
    private final String typeAlias;

    @Override
    @NotNull
    public MemberList getMemberList() {
        int n;
        block4: {
            if (this.getPattern().isEmpty()) {
                return new MemberList(CollectionsKt.emptyList(), null);
            }
            Object $this$indexOfFirst$iv = this.getPattern();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv = iterator.next();
                Pattern it = (Pattern)item$iv;
                boolean bl = false;
                if (it instanceof RestPattern) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        boolean bl = false;
        boolean bl2 = false;
        int it = n2;
        boolean bl3 = false;
        if (it >= 0 && it < CollectionsKt.getLastIndex((List)this.getPattern())) {
            throw (Throwable)new ContractException("A rest operator ... can only be used in the last entry of an array.", null, null, null, 14, null);
        }
        Object object = CollectionsKt.last((List)this.getPattern());
        bl = false;
        bl2 = false;
        Pattern last = (Pattern)object;
        boolean bl4 = false;
        Pattern pattern = last;
        return pattern instanceof RestPattern ? new MemberList(CollectionsKt.dropLast((List)this.getPattern(), (int)1), ((RestPattern)last).getPattern()) : new MemberList((List<? extends Pattern>)this.getPattern(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) throws Exception {
        Result result2;
        Object v2;
        block13: {
            void $this$mapIndexedTo$iv$iv;
            Object object;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            if (!(sampleData instanceof JSONArrayValue)) {
                return new Result.Failure("Value is not a JSON array", null, null, null, 14, null);
            }
            if (((JSONArrayValue)sampleData).getList().isEmpty()) {
                return new Result.Success();
            }
            Resolver resolverWithNumberType = Utilities.withNumberType(Utilities.withNullPattern(resolver));
            Iterable $this$map$iv = (Iterable)this.getPattern();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pattern pattern = (Pattern)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = DeferredPatternKt.resolvedHop((Pattern)it, resolverWithNumberType);
                collection.add(object);
            }
            List resolvedTypes = (List)destination$iv$iv;
            Iterable $this$mapIndexed$iv = resolvedTypes;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                Result result3;
                void index;
                void patternValue;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pattern pattern = (Pattern)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl2 = false;
                if (patternValue instanceof RestPattern) {
                    List list;
                    void var18_25 = index;
                    if (var18_25 == ((JSONArrayValue)sampleData).getList().size()) {
                        list = CollectionsKt.emptyList();
                    } else {
                        void var19_26 = index;
                        list = CollectionsKt.slice(((JSONArrayValue)sampleData).getList(), (IntRange)new IntRange((int)var19_26, CollectionsKt.getLastIndex(((JSONArrayValue)sampleData).getList())));
                    }
                    List rest = list;
                    result3 = ResultKt.breadCrumb(patternValue.matches(new JSONArrayValue(rest), resolverWithNumberType), "" + '[' + (int)index + "..." + CollectionsKt.getLastIndex(((JSONArrayValue)sampleData).getList()) + ']');
                } else if (index == ((JSONArrayValue)sampleData).getList().size()) {
                    result3 = new Result.Failure("Expected an array of length " + this.getPattern().size() + ", actual length " + ((JSONArrayValue)sampleData).getList().size(), null, null, null, 14, null);
                } else {
                    Value sampleValue = ((JSONArrayValue)sampleData).getList().get((int)index);
                    result3 = ResultKt.breadCrumb(patternValue.matches(sampleValue, resolverWithNumberType), "" + '[' + (int)index + ']');
                }
                object = result3;
                collection.add(object);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl3 = false;
            for (Object t : iterable) {
                Result it = (Result)t;
                boolean bl4 = false;
                if (!(it instanceof Result.Failure)) continue;
                v2 = t;
                break block13;
            }
            v2 = null;
        }
        if ((result2 = (Result)v2) == null) {
            result2 = new Result.Success();
        }
        return result2;
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        return new JSONArrayValue(JSONArrayPatternKt.generate((List<? extends Pattern>)this.getPattern(), resolverWithNullType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<JSONArrayPattern> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Resolver resolverWithNullType = Utilities.withNullPattern(resolver);
        Iterable $this$map$iv = JSONArrayPatternKt.newBasedOn((List<? extends Pattern>)this.getPattern(), row, resolverWithNullType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JSONArrayPattern jSONArrayPattern = new JSONArrayPattern((List)it, null, 2, null);
            collection.add(jSONArrayPattern);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return GrammarKt.parsedJSON(value);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Resolver thisResolverWithNullType = Utilities.withNullPattern(thisResolver);
        Resolver otherResolverWithNullType = Utilities.withNullPattern(otherResolver);
        Pattern pattern = otherPattern;
        if (pattern instanceof ExactValuePattern) {
            result2 = otherPattern.fitsWithin(CollectionsKt.listOf((Object)this), otherResolverWithNullType, thisResolverWithNullType, typeStack);
        } else if (pattern instanceof SequenceType) {
            Result result3;
            try {
                MemberList otherMembers = ((SequenceType)((Object)otherPattern)).getMemberList();
                MemberList theseMembers = this.getMemberList();
                result3 = this.validateInfiniteLength(otherMembers, theseMembers).ifSuccess((Function0<? extends Result>)((Function0)new Function0<Result>(this, otherMembers, otherResolverWithNullType, theseMembers, thisResolverWithNullType, typeStack){
                    final /* synthetic */ JSONArrayPattern this$0;
                    final /* synthetic */ MemberList $otherMembers;
                    final /* synthetic */ Resolver $otherResolverWithNullType;
                    final /* synthetic */ MemberList $theseMembers;
                    final /* synthetic */ Resolver $thisResolverWithNullType;
                    final /* synthetic */ Set $typeStack;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Result invoke() {
                        Object object;
                        block8: {
                            block7: {
                                Object v0;
                                boolean bl;
                                Object object2;
                                block6: {
                                    void $this$mapIndexedTo$iv$iv;
                                    List<Pattern> otherEncompassables = this.$otherMembers.getEncompassableList(this.this$0.getPattern().size(), this.$otherResolverWithNullType);
                                    List<Pattern> encompassables = otherEncompassables.size() > this.this$0.getPattern().size() ? this.$theseMembers.getEncompassableList(otherEncompassables.size(), this.$thisResolverWithNullType) : this.this$0.getMemberList().getEncompassables(this.$thisResolverWithNullType);
                                    Iterable $this$mapIndexed$iv = CollectionsKt.zip((Iterable)encompassables, (Iterable)otherEncompassables);
                                    boolean $i$f$mapIndexed = false;
                                    Iterable iterable = $this$mapIndexed$iv;
                                    Collection destination$iv$iv22 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                                    boolean $i$f$mapIndexedTo = false;
                                    int index$iv$iv = 0;
                                    for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                                        void bigger;
                                        void index;
                                        void $dstr$bigger$smaller;
                                        int n = index$iv$iv++;
                                        boolean bl2 = false;
                                        if (n < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        Pair pair = (Pair)item$iv$iv;
                                        int n2 = n;
                                        Collection collection = destination$iv$iv22;
                                        boolean bl3 = false;
                                        Pattern pattern = (Pattern)$dstr$bigger$smaller.component1();
                                        Pattern smaller = (Pattern)$dstr$bigger$smaller.component2();
                                        ResultWithIndex resultWithIndex = new ResultWithIndex((int)index, TypeStackKt.biggerEncompassesSmaller((Pattern)bigger, smaller, this.$thisResolverWithNullType, this.$otherResolverWithNullType, this.$typeStack));
                                        collection.add(resultWithIndex);
                                    }
                                    List results2 = (List)destination$iv$iv22;
                                    object2 = results2;
                                    bl = false;
                                    iterable = object2;
                                    boolean destination$iv$iv22 = false;
                                    for (T t : iterable) {
                                        ResultWithIndex it = (ResultWithIndex)t;
                                        boolean bl4 = false;
                                        if (!(it.getResult() instanceof Result.Failure)) continue;
                                        v0 = t;
                                        break block6;
                                    }
                                    v0 = null;
                                }
                                if ((object = (ResultWithIndex)v0) == null) break block7;
                                object2 = object;
                                bl = false;
                                boolean bl5 = false;
                                Object result2 = object2;
                                boolean bl6 = false;
                                object = ResultKt.breadCrumb(((ResultWithIndex)result2).getResult(), "" + '[' + ((ResultWithIndex)result2).getIndex() + ']');
                                if (object != null) break block8;
                            }
                            object = new Result.Success();
                        }
                        return object;
                    }
                    {
                        this.this$0 = jSONArrayPattern;
                        this.$otherMembers = memberList;
                        this.$otherResolverWithNullType = resolver;
                        this.$theseMembers = memberList2;
                        this.$thisResolverWithNullType = resolver2;
                        this.$typeStack = set;
                        super(0);
                    }
                }));
            }
            catch (ContractException e) {
                result3 = new Result.Failure(e.report(), null, null, null, 14, null);
            }
            result2 = result3;
        } else {
            result2 = new Result.Failure("Expected array or list, got " + otherPattern.getTypeName(), null, null, null, 14, null);
        }
        return result2;
    }

    private final Result validateInfiniteLength(MemberList otherMembers, MemberList theseMembers) {
        return otherMembers.isEndless() && !theseMembers.isEndless() ? (Result)new Result.Failure("Finite list is not a superset of an infinite list.", null, null, null, 14, null) : (Result)new Result.Success();
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public List<Pattern> getPattern() {
        return this.pattern;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    public JSONArrayPattern(@NotNull List<? extends Pattern> pattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        this.pattern = pattern;
        this.typeAlias = typeAlias;
        this.typeName = "json array";
    }

    public /* synthetic */ JSONArrayPattern(List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(list, string);
    }

    public JSONArrayPattern() {
        this(null, null, 3, null);
    }

    public JSONArrayPattern(@NotNull String jsonString, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        this(JSONSerialisationKt.stringTooPatternArray(jsonString), typeAlias);
    }

    @Override
    @NotNull
    public ConsumeResult encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(others, (String)"others");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter((Object)lengthError, (String)"lengthError");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter(otherPatterns, (String)"otherPatterns");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns, thisResolver, otherResolver, typeStack);
    }

    @NotNull
    public final List<Pattern> component1() {
        return this.getPattern();
    }

    @Nullable
    public final String component2() {
        return this.getTypeAlias();
    }

    @NotNull
    public final JSONArrayPattern copy(@NotNull List<? extends Pattern> pattern, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        return new JSONArrayPattern(pattern, typeAlias);
    }

    public static /* synthetic */ JSONArrayPattern copy$default(JSONArrayPattern jSONArrayPattern, List object, String string, int n, Object object2) {
        if ((n & 1) != 0) {
            object = jSONArrayPattern.getPattern();
        }
        if ((n & 2) != 0) {
            string = jSONArrayPattern.getTypeAlias();
        }
        return jSONArrayPattern.copy((List<? extends Pattern>)object, string);
    }

    @NotNull
    public String toString() {
        return "JSONArrayPattern(pattern=" + this.getPattern() + ", typeAlias=" + this.getTypeAlias() + ")";
    }

    public int hashCode() {
        Object object = this.getPattern();
        String string = this.getTypeAlias();
        return (object != null ? object.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof JSONArrayPattern)) break block3;
                JSONArrayPattern jSONArrayPattern = (JSONArrayPattern)object;
                if (!Intrinsics.areEqual((Object)this.getPattern(), (Object)jSONArrayPattern.getPattern()) || !Intrinsics.areEqual((Object)this.getTypeAlias(), (Object)jSONArrayPattern.getTypeAlias())) break block3;
            }
            return true;
        }
        return false;
    }
}

