/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.utilities;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import run.qontract.core.git.NonZeroExitError;
import run.qontract.core.git.SystemGit;
import run.qontract.core.git.SystemGitKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"commitAndPush", "", "sourceGit", "Lrun/qontract/core/git/SystemGit;", "core"})
public final class ContractSourceKt {
    public static final void commitAndPush(@NotNull SystemGit sourceGit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        try {
            sourceGit.commit();
            bl = true;
        }
        catch (NonZeroExitError e) {
            if (!SystemGitKt.exitErrorMessageContains(e, CollectionsKt.listOf((Object)"nothing to commit"))) {
                throw (Throwable)e;
            }
            bl = SystemGitKt.exitErrorMessageContains(e, CollectionsKt.listOf((Object)"branch is ahead of"));
        }
        boolean pushRequired = bl;
        if (pushRequired) {
            String string = "Pushing changes";
            boolean bl2 = false;
            System.out.println((Object)string);
            sourceGit.push();
        } else {
            String string = "No changes were made to the repo, so nothing was pushed.";
            boolean bl3 = false;
            System.out.println((Object)string);
        }
    }
}

