/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.utilities;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import run.qontract.core.git.SystemGit;
import run.qontract.core.utilities.ContractSource;
import run.qontract.core.utilities.ContractSourceKt;
import run.qontract.core.utilities.Utilities;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006%"}, d2={"Lrun/qontract/core/utilities/GitRepo;", "Lrun/qontract/core/utilities/ContractSource;", "gitRepositoryURL", "", "testContracts", "", "stubContracts", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getGitRepositoryURL", "()Ljava/lang/String;", "repoName", "getRepoName", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "component1", "component2", "component3", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lrun/qontract/core/git/SystemGit;", "hashCode", "", "install", "pathDescriptor", "path", "pushUpdates", "toString", "core"})
public final class GitRepo
extends ContractSource {
    @NotNull
    private final String repoName;
    @NotNull
    private final String gitRepositoryURL;
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;

    @NotNull
    public final String getRepoName() {
        return this.repoName;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.repoName + ':' + path;
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)this.repoName);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        sourceGit.pull();
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        ContractSourceKt.commitAndPush(sourceGit);
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        File sourceDir = FilesKt.resolve((File)workingDirectory, (String)this.repoName);
        String string = sourceDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceDir.path");
        SystemGit sourceGit = new SystemGit(string, null, 2, null);
        try {
            String string2 = "Checking " + sourceDir.getPath();
            boolean bl = false;
            System.out.println((Object)string2);
            if (!sourceDir.exists()) {
                sourceDir.mkdirs();
            }
            if (!sourceGit.workingDirectoryIsGitRepo()) {
                string2 = "Found it, not a git dir, recreating...";
                bl = false;
                System.out.println((Object)string2);
                FilesKt.deleteRecursively((File)sourceDir);
                sourceDir.mkdirs();
                string2 = "Cloning " + this.gitRepositoryURL + " into " + sourceDir.getAbsolutePath();
                bl = false;
                System.out.println((Object)string2);
                File file = sourceDir.getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"sourceDir.absoluteFile");
                sourceGit.clone(this.gitRepositoryURL, file);
            } else {
                string2 = "Git repo already exists at " + sourceDir.getPath() + ", so ignoring it and moving on";
                bl = false;
                System.out.println((Object)string2);
            }
        }
        catch (Throwable e) {
            String string3 = "Could not clone " + this.gitRepositoryURL + '\n' + e.getClass().getName() + ": " + Utilities.exceptionCauseMessage(e);
            boolean bl = false;
            System.out.println((Object)string3);
        }
    }

    @NotNull
    public final String getGitRepositoryURL() {
        return this.gitRepositoryURL;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    public GitRepo(@NotNull String gitRepositoryURL, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        super(null);
        this.gitRepositoryURL = gitRepositoryURL;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.repoName = StringsKt.removeSuffix((String)((String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)this.gitRepositoryURL, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null))), (CharSequence)".git");
    }

    @NotNull
    public final String component1() {
        return this.gitRepositoryURL;
    }

    @NotNull
    public final List<String> component2() {
        return this.getTestContracts();
    }

    @NotNull
    public final List<String> component3() {
        return this.getStubContracts();
    }

    @NotNull
    public final GitRepo copy(@NotNull String gitRepositoryURL, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)gitRepositoryURL, (String)"gitRepositoryURL");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitRepo(gitRepositoryURL, testContracts, stubContracts);
    }

    public static /* synthetic */ GitRepo copy$default(GitRepo gitRepo, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = gitRepo.gitRepositoryURL;
        }
        if ((n & 2) != 0) {
            list = gitRepo.getTestContracts();
        }
        if ((n & 4) != 0) {
            list2 = gitRepo.getStubContracts();
        }
        return gitRepo.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "GitRepo(gitRepositoryURL=" + this.gitRepositoryURL + ", testContracts=" + this.getTestContracts() + ", stubContracts=" + this.getStubContracts() + ")";
    }

    public int hashCode() {
        String string = this.gitRepositoryURL;
        List<String> list = this.getTestContracts();
        List<String> list2 = this.getStubContracts();
        return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof GitRepo)) break block3;
                GitRepo gitRepo = (GitRepo)object;
                if (!Intrinsics.areEqual((Object)this.gitRepositoryURL, (Object)gitRepo.gitRepositoryURL) || !Intrinsics.areEqual(this.getTestContracts(), gitRepo.getTestContracts()) || !Intrinsics.areEqual(this.getStubContracts(), gitRepo.getStubContracts())) break block3;
            }
            return true;
        }
        return false;
    }
}

