/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.utilities;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import run.qontract.core.HttpRequestKt;
import run.qontract.core.Resolver;
import run.qontract.core.git.GitOperationsKt;
import run.qontract.core.git.SystemGit;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.pattern.GrammarKt;
import run.qontract.core.pattern.NullPattern;
import run.qontract.core.pattern.NumberPattern;
import run.qontract.core.utilities.ContractPathData;
import run.qontract.core.utilities.ContractSource;
import run.qontract.core.utilities.ContractsSelectorPredicate;
import run.qontract.core.utilities.GitMonoRepo;
import run.qontract.core.utilities.GitRepo;
import run.qontract.core.utilities.Utilities;
import run.qontract.core.value.JSONArrayValue;
import run.qontract.core.value.JSONObjectValue;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0018H\u0000\u001a\u0016\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001c\u001a\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\f\u001a\u0016\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0001\u001a\u0012\u0010%\u001a\u00020&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0001\u001a\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0001H\u0000\u001a\u000e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0018\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\f2\u0006\u0010-\u001a\u00020\u0018\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\f2\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\f2\u0006\u00100\u001a\u00020*\u001a\b\u00101\u001a\u000202H\u0000\u001a\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0001\u001a\u000e\u00106\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u000e\u00107\u001a\u0002042\u0006\u00108\u001a\u000204\u001a\u000e\u00107\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u00010\f2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\f\u001a\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0000\u001a\u0010\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020=H\u0000\u001a\u0010\u0010A\u001a\u00020\u00012\u0006\u0010B\u001a\u00020CH\u0002\u001a\u000e\u0010A\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"contractDirectory", "", "contractFilePath", "getContractFilePath", "()Ljava/lang/String;", "currentDirectory", "defaultContractFilePath", "containsTextContent", "", "node", "Lorg/w3c/dom/Node;", "contractFilePathsFrom", "", "Lrun/qontract/core/utilities/ContractPathData;", "configFilePath", "workingDirectory", "selector", "Lrun/qontract/core/utilities/ContractsSelectorPredicate;", "contractStubPaths", "contractTestPathsFrom", "createIfDoesNotExist", "", "workingDirectoryPath", "ensureEmptyOrNotExists", "Ljava/io/File;", "ensureExists", "exceptionCauseMessage", "e", "", "exceptionMessageStack", "messages", "exitIfDoesNotExist", "label", "filePath", "exitWithMessage", "", "message", "getTransportCallingCallback", "Lorg/eclipse/jgit/api/TransportConfigCallback;", "bearerToken", "jsonArray", "source", "Lrun/qontract/core/value/JSONObjectValue;", "key", "loadConfigJSON", "configFile", "loadSources", "Lrun/qontract/core/utilities/ContractSource;", "configJson", "newBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "parseXML", "Lorg/w3c/dom/Document;", "xmlData", "readFile", "removeWhiteSpace", "document", "strings", "list", "Lrun/qontract/core/value/Value;", "withNullPattern", "Lrun/qontract/core/Resolver;", "resolver", "withNumberType", "resolverWithNullType", "xmlToString", "domSource", "Ljavax/xml/transform/dom/DOMSource;", "core"})
@JvmName(name="Utilities")
public final class Utilities {
    private static final String currentDirectory = "./";
    private static final String contractDirectory = "contract";
    private static final String defaultContractFilePath = "contract/service.contract";

    @NotNull
    public static final Void exitWithMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int n = 0;
        System.out.println((Object)message);
        n = 1;
        boolean bl = false;
        System.exit(n);
        throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    @NotNull
    public static final String exceptionCauseMessage(@NotNull Throwable e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List<String> messageStack = Utilities.exceptionMessageStack(e, CollectionsKt.emptyList());
        if (Intrinsics.areEqual(messageStack, (Object)CollectionsKt.emptyList())) {
            string = "Exception class=" + e.getClass().getName() + ", no message found";
        } else {
            String messageString2 = CollectionsKt.joinToString$default((Iterable)messageStack, (CharSequence)"; ", null, null, (int)0, null, (Function1)exceptionCauseMessage.messageString.1.INSTANCE, (int)30, null);
            string = "Error: " + messageString2;
        }
        return string;
    }

    @NotNull
    public static final List<String> exceptionMessageStack(@NotNull Throwable e, @NotNull List<String> messages) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        String string = e.getLocalizedMessage();
        if (string == null) {
            string = e.getMessage();
        }
        String message = string;
        List<String> newMessages = message != null ? CollectionsKt.plus((Collection)messages, (Object)message) : messages;
        Throwable cause = e.getCause();
        return cause == null ? newMessages : Utilities.exceptionMessageStack(cause, newMessages);
    }

    @NotNull
    public static final String readFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String string = FilesKt.readText$default((File)new File(filePath), null, (int)1, null);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string2)).toString();
    }

    @NotNull
    public static final Document parseXML(@NotNull String xmlData) {
        Intrinsics.checkNotNullParameter((Object)xmlData, (String)"xmlData");
        DocumentBuilder builder = Utilities.newBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlData)));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"builder.parse(InputSource(StringReader(xmlData)))");
        return Utilities.removeWhiteSpace(document);
    }

    @NotNull
    public static final DocumentBuilder newBuilder() {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        builder.setErrorHandler(null);
        DocumentBuilder documentBuilder = builder;
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"builder");
        return documentBuilder;
    }

    @NotNull
    public static final Document removeWhiteSpace(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"document.documentElement");
        Utilities.removeWhiteSpace(element);
        return document;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Node removeWhiteSpace(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.hasChildNodes() && !Utilities.containsTextContent(node)) {
            int n;
            void $this$mapTo$iv$iv;
            NodeList nodeList = node.getChildNodes();
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"node.childNodes");
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)nodeList.getLength());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Node node2 = node.getChildNodes().item((int)i);
                collection.add(node2);
            }
            List childNodes = (List)destination$iv$iv;
            Iterable $this$forEach$iv = childNodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Node it = (Node)element$iv;
                boolean bl = false;
                Node node3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"it");
                if (node3.getNodeType() == 3 && node.getNodeType() == 1) {
                    String string;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getTextContent(), (String)"it.textContent");
                    n = 0;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString())) {
                        node.removeChild(it);
                        continue;
                    }
                }
                if (!it.hasChildNodes()) continue;
                Utilities.removeWhiteSpace(it);
            }
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean containsTextContent(Node node) {
        NodeList nodeList = node.getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"node.childNodes");
        if (nodeList.getLength() != 1) return false;
        Node node2 = node.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"node.firstChild");
        if (node2.getNodeType() != 3) return false;
        if (node.getNodeType() != 1) return false;
        return true;
    }

    @NotNull
    public static final String xmlToString(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Utilities.xmlToString(new DOMSource(node));
    }

    private static final String xmlToString(DOMSource domSource) {
        StringWriter writer = new StringWriter();
        StreamResult result2 = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(domSource, result2);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    @NotNull
    public static final String getContractFilePath() {
        return "./contract/service.contract";
    }

    @NotNull
    public static final TransportConfigCallback getTransportCallingCallback(@Nullable String bearerToken) {
        return new TransportConfigCallback(bearerToken){
            final /* synthetic */ String $bearerToken;

            public final void configure(Transport transport) {
                if (transport instanceof SshTransport) {
                    ((SshTransport)transport).setSshSessionFactory((SshSessionFactory)new SshdSessionFactory());
                } else if (this.$bearerToken != null && transport instanceof TransportHttp) {
                    String string = "Setting Authorization header";
                    boolean bl = false;
                    System.out.println((Object)string);
                    ((TransportHttp)transport).setAdditionalHeaders(MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + this.$bearerToken))));
                }
            }
            {
                this.$bearerToken = string;
            }
        };
    }

    public static /* synthetic */ TransportConfigCallback getTransportCallingCallback$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return Utilities.getTransportCallingCallback(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> strings(@NotNull List<? extends Value> list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var10_10 = it;
            if (!(var10_10 instanceof StringValue)) {
                Void void_ = Utilities.exitWithMessage("All members of the paths array must be strings, but found one (" + it.toStringValue() + ") which was not");
                throw new KotlinNothingValueException();
            }
            String string = ((StringValue)it).getString();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<ContractSource> loadSources(@NotNull String configFilePath) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        return Utilities.loadSources(new File(configFilePath));
    }

    @NotNull
    public static final List<ContractSource> loadSources(@NotNull File configFile) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        return Utilities.loadSources(Utilities.loadConfigJSON(configFile));
    }

    @NotNull
    public static final JSONObjectValue loadConfigJSON(@NotNull File configFile) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        try {
            value = GrammarKt.parsedJSON(FilesKt.readText$default((File)configFile, null, (int)1, null));
        }
        catch (Throwable e) {
            Void void_ = Utilities.exitWithMessage("Error reading the ./qontract.json: " + Utilities.exceptionCauseMessage(e));
            throw new KotlinNothingValueException();
        }
        Value configJson = value;
        if (!(configJson instanceof JSONObjectValue)) {
            Void void_ = Utilities.exitWithMessage("The contents of ./qontract.json must be a json object");
            throw new KotlinNothingValueException();
        }
        return (JSONObjectValue)configJson;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final List<ContractSource> loadSources(@NotNull JSONObjectValue configJson) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configJson, (String)"configJson");
        Map<String, Value> map2 = configJson.getJsonObject();
        String string = "sources";
        Iterable iterable = null;
        boolean bl = false;
        Map<String, Value> map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        Value sources = map3.getOrDefault(string, (Value)((Object)iterable));
        if (!(sources instanceof JSONArrayValue)) {
            Void void_ = Utilities.exitWithMessage("The \"sources\" key must hold a list of sources.");
            throw new KotlinNothingValueException();
        }
        Iterable $this$map$iv = ((JSONArrayValue)sources).getList();
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ContractSource contractSource;
            String string2;
            void source;
            Value value = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (!(source instanceof JSONObjectValue)) {
                Void void_ = Utilities.exitWithMessage("Every element of the sources json array must be a json object, but got this: " + source.toStringValue());
                throw new KotlinNothingValueException();
            }
            if (HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "provider") == null) throw (Throwable)new ContractException("Provider " + HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "provider") + " not recognised in ./qontract.json", null, null, null, 14, null);
            switch (string2.hashCode()) {
                case 102354: {
                    if (string2.equals("git")) {
                        String repositoryURL = HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "repository");
                        List<String> stubPaths = Utilities.jsonArray((JSONObjectValue)source, "stub");
                        List<String> testPaths = Utilities.jsonArray((JSONObjectValue)source, "test");
                        String string3 = repositoryURL;
                        if (string3 == null) {
                            contractSource = new GitMonoRepo(testPaths, stubPaths);
                            break;
                        }
                        contractSource = new GitRepo(repositoryURL, testPaths, stubPaths);
                        break;
                    }
                }
                default: {
                    throw (Throwable)new ContractException("Provider " + HttpRequestKt.nativeString(((JSONObjectValue)source).getJsonObject(), "provider") + " not recognised in ./qontract.json", null, null, null, 14, null);
                }
            }
            ContractSource contractSource2 = contractSource;
            collection.add(contractSource2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> jsonArray(@NotNull JSONObjectValue source, @NotNull String key) {
        List list;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Value value = source.getJsonObject().get(key);
        if (value instanceof JSONArrayValue) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((JSONArrayValue)value).getList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Value value2 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toStringValue();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else if (value == null) {
            list = CollectionsKt.emptyList();
        } else {
            throw (Throwable)new ContractException("Expected " + key + " to be an array", null, null, null, 14, null);
        }
        return list;
    }

    public static final void ensureEmptyOrNotExists(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (workingDirectory.exists()) {
            File[] fileArray = workingDirectory.listFiles();
            if (fileArray != null) {
                File[] fileArray2 = fileArray;
                boolean bl = false;
                File[] fileArray3 = fileArray2;
                boolean bl2 = false;
                if (!(fileArray3.length == 0)) {
                    Void void_ = Utilities.exitWithMessage("The provided working directory " + workingDirectory.getPath() + " must be empty or must not exist");
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    public static final void ensureExists(@NotNull String configFilePath, @NotNull String workingDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectoryPath, (String)"workingDirectoryPath");
        if (!new File(configFilePath).exists()) {
            Void void_ = Utilities.exitWithMessage(configFilePath + " does not exist");
            throw new KotlinNothingValueException();
        }
        File workingDirectory = new File(workingDirectoryPath);
        if (!workingDirectory.exists()) {
            try {
                workingDirectory.mkdirs();
            }
            catch (Throwable e) {
                Void void_ = Utilities.exitWithMessage(Utilities.exceptionCauseMessage(e));
                throw new KotlinNothingValueException();
            }
        }
    }

    public static final void createIfDoesNotExist(@NotNull String workingDirectoryPath) {
        Intrinsics.checkNotNullParameter((Object)workingDirectoryPath, (String)"workingDirectoryPath");
        File workingDirectory = new File(workingDirectoryPath);
        if (!workingDirectory.exists()) {
            try {
                workingDirectory.mkdirs();
            }
            catch (Throwable e) {
                Void void_ = Utilities.exitWithMessage(Utilities.exceptionCauseMessage(e));
                throw new KotlinNothingValueException();
            }
        }
    }

    public static final void exitIfDoesNotExist(@NotNull String label, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!new File(filePath).exists()) {
            Void void_ = Utilities.exitWithMessage(StringsKt.capitalize((String)label) + ' ' + filePath + " does not exist");
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public static final List<ContractPathData> contractStubPaths() {
        return Utilities.contractFilePathsFrom("./qontract.json", ".qontract", contractStubPaths.1.INSTANCE);
    }

    @NotNull
    public static final List<ContractPathData> contractTestPathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return Utilities.contractFilePathsFrom(configFilePath, workingDirectory, contractTestPathsFrom.1.INSTANCE);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final List<ContractPathData> contractFilePathsFrom(@NotNull String configFilePath, @NotNull String workingDirectory, @NotNull ContractsSelectorPredicate selector) {
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        var3_3 = "Loading config file " + configFilePath;
        var4_4 = false;
        System.out.println((Object)var3_3);
        sources = Utilities.loadSources(configFilePath);
        $this$flatMap$iv = sources;
        $i$f$flatMap = false;
        var6_7 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            block8: {
                block7: {
                    source = (ContractSource)element$iv$iv;
                    $i$a$-flatMap-Utilities$contractFilePathsFrom$1 = false;
                    var13_17 = source;
                    if (!(var13_17 instanceof GitRepo)) break block7;
                    var14_19 = "Looking for contracts in local environment";
                    var15_21 = false;
                    System.out.println((Object)var14_19);
                    userHome = new File(System.getProperty("user.home"));
                    defaultQontractWorkingDir = FilesKt.resolve((File)userHome, (String)".qontract/repos");
                    defaultRepoDir = source.directoryRelativeTo((File)defaultQontractWorkingDir);
                    if (!defaultRepoDir.exists()) ** GOTO lbl-1000
                    v0 = defaultRepoDir.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"defaultRepoDir.path");
                    if (new SystemGit(v0, null, 2, null).workingDirectoryIsGitRepo()) {
                        var17_24 = "Using local contracts";
                        var18_27 = false;
                        System.out.println((Object)var17_24);
                        v1 = defaultRepoDir;
                    } else lbl-1000:
                    // 2 sources

                    {
                        reposBaseDir = FilesKt.resolve((File)new File(workingDirectory), (String)"repos");
                        var18_26 = "Couldn't find local contracts, cloning " + ((GitRepo)source).getGitRepositoryURL() + " into " + reposBaseDir.getPath();
                        var19_28 = false;
                        System.out.println((Object)var18_26);
                        if (!reposBaseDir.exists()) {
                            reposBaseDir.mkdirs();
                        }
                        v1 = GitOperationsKt.clone(reposBaseDir, (GitRepo)source);
                    }
                    break block8;
                }
                if (var13_17 instanceof GitMonoRepo) {
                    v1 = new File(".");
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            repoDir = v1;
            $this$map$iv = selector.select(source);
            $i$f$map = false;
            defaultQontractWorkingDir = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var21_31 = (String)item$iv$iv;
                var22_32 = destination$iv$iv;
                $i$a$-map-Utilities$contractFilePathsFrom$1$1 = false;
                v2 = repoDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"repoDir.path");
                v3 = FilesKt.resolve((File)repoDir, (String)it).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"repoDir.resolve(it).path");
                var24_34 = new ContractPathData(v2, v3);
                var22_32.add(var24_34);
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var4_5 = (List)destination$iv$iv;
        var5_6 = false;
        var6_8 = false;
        it = var4_5;
        $i$a$-also-Utilities$contractFilePathsFrom$2 = false;
        var9_11 = "Contract file paths #######";
        var10_14 = false;
        System.out.println((Object)var9_11);
        var9_12 = false;
        System.out.println(it);
        return var4_5;
    }

    @NotNull
    public static final Resolver withNullPattern(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return Resolver.copy$default(resolver, null, false, MapsKt.plus(resolver.getNewPatterns(), (Pair)TuplesKt.to((Object)"(empty)", (Object)NullPattern.INSTANCE)), null, 11, null);
    }

    @NotNull
    public static final Resolver withNumberType(@NotNull Resolver resolverWithNullType) {
        Intrinsics.checkNotNullParameter((Object)resolverWithNullType, (String)"resolverWithNullType");
        return Resolver.copy$default(resolverWithNullType, null, false, MapsKt.plus(resolverWithNullType.getNewPatterns(), (Pair)TuplesKt.to((Object)"(number)", (Object)NumberPattern.INSTANCE)), null, 11, null);
    }
}

