/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.core.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import run.qontract.core.utilities.Utilities;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.XMLNode;
import run.qontract.core.value.XMLValue;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001c\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u00a8\u0006\u0010"}, d2={"XMLNode", "Lrun/qontract/core/value/XMLNode;", "xmlData", "", "document", "Lorg/w3c/dom/Document;", "Lrun/qontract/core/value/XMLValue;", "node", "Lorg/w3c/dom/Node;", "attributes", "", "Lrun/qontract/core/value/StringValue;", "nodes", "", "xmlNameWithoutNamespace", "name", "core"})
public final class XMLNodeKt {
    @NotNull
    public static final XMLNode XMLNode(@NotNull Document document) {
        Element node;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Element element = node = document.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"node");
        XMLValue xMLValue = XMLNodeKt.XMLNode(element);
        if (xMLValue == null) {
            throw new NullPointerException("null cannot be cast to non-null type run.qontract.core.value.XMLNode");
        }
        return (XMLNode)xMLValue;
    }

    @NotNull
    public static final XMLValue XMLNode(@NotNull Node node) {
        XMLValue xMLValue;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        switch (node.getNodeType()) {
            case 3: {
                String string = node.getTextContent();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.textContent");
                xMLValue = new StringValue(string);
                break;
            }
            default: {
                String string = node.getNodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.nodeName");
                xMLValue = new XMLNode(string, XMLNodeKt.attributes(node), XMLNodeKt.nodes(node));
            }
        }
        return xMLValue;
    }

    private static final String xmlNameWithoutNamespace(String name) {
        return StringsKt.substringAfter$default((String)name, (char)':', null, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<XMLValue> nodes(Node node) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        NodeList nodeList = node.getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"node.childNodes");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)nodeList.getLength());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node2 = node.getChildNodes().item((int)it);
            collection.add(node2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void item;
            Node item$iv$iv = (Node)element$iv;
            List acc = accumulator$iv;
            boolean bl = false;
            Collection collection = acc;
            void v2 = item;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"item");
            accumulator$iv = CollectionsKt.plus((Collection)collection, (Object)XMLNodeKt.XMLNode((Node)v2));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<String, StringValue> attributes(Node node) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)namedNodeMap, (String)"node.attributes");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)namedNodeMap.getLength());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Node node2 = node.getAttributes().item((int)it);
            if (node2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Attr");
            }
            Attr attr = (Attr)node2;
            collection.add(attr);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void item;
            Attr item$iv$iv = (Attr)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            String string = item.getName();
            String string2 = item.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.value");
            accumulator$iv = MapsKt.plus((Map)acc, (Pair)TuplesKt.to((Object)string, (Object)new StringValue(string2)));
        }
        return accumulator$iv;
    }

    @NotNull
    public static final XMLNode XMLNode(@NotNull String xmlData) {
        Intrinsics.checkNotNullParameter((Object)xmlData, (String)"xmlData");
        Document document = Utilities.parseXML(xmlData);
        return XMLNodeKt.XMLNode(document);
    }

    public static final /* synthetic */ String access$xmlNameWithoutNamespace(String name) {
        return XMLNodeKt.xmlNameWithoutNamespace(name);
    }
}

