/*
 * Decompiled with CFR 0.152.
 */
package run.qontract.stub;

import java.io.Closeable;
import java.io.File;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.Producer;
import org.jetbrains.annotations.NotNull;
import run.qontract.LogUtilsKt;
import run.qontract.core.Feature;
import run.qontract.core.FeatureKt;
import run.qontract.core.QontractKafkaKt;
import run.qontract.core.Result;
import run.qontract.core.Results;
import run.qontract.core.Scenario;
import run.qontract.core.pattern.ContractException;
import run.qontract.core.utilities.ContractPathData;
import run.qontract.core.utilities.JSONSerialisationKt;
import run.qontract.core.utilities.Utilities;
import run.qontract.core.value.KafkaMessage;
import run.qontract.core.value.StringValue;
import run.qontract.core.value.Value;
import run.qontract.mock.NoMatchingScenario;
import run.qontract.mock.ScenarioStub;
import run.qontract.mock.ScenarioStubKt;
import run.qontract.stub.API;
import run.qontract.stub.ContractStub;
import run.qontract.stub.HttpStub;
import run.qontract.stub.HttpStubData;
import run.qontract.stub.HttpStubKt;
import run.qontract.stub.KafkaStubKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001a\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a(\u0010\b\u001a\u00020\t2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a*\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a(\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a6\u0010\u0010\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u00022\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0002\u001a\"\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00020\u00020\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a:\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00010\u00180\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a,\u0010\u001b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00010\u00180\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001aR\u0010\u001c\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00010\u00180\u00012\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00190\u00180\u00012\u0018\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001a0\u00180\u0001\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001H\u0002\u001a\u0016\u0010$\u001a\u00020 2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001H\u0002\u001a\u001e\u0010&\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u0002\u001a\u001e\u0010)\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+\u001a\u001e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+\u00a8\u00060"}, d2={"allContractsFromDirectory", "", "", "dirContainingContracts", "allDirsInTree", "Ljava/io/File;", "dataDirPath", "dataDirPaths", "createStub", "Lrun/qontract/stub/HttpStub;", "host", "port", "", "createStubFromContractAndData", "contractGherkin", "dataDirectory", "createStubFromContracts", "Lrun/qontract/stub/ContractStub;", "contractPaths", "implicitContractDataDir", "contractPath", "implicitContractDataDirs", "kotlin.jvm.PlatformType", "loadContractStubsFromFiles", "Lkotlin/Pair;", "Lrun/qontract/core/Feature;", "Lrun/qontract/mock/ScenarioStub;", "loadContractStubsFromImplicitPaths", "loadQontractStubs", "features", "stubData", "logIgnoredFiles", "", "implicitDataDir", "pathToFileListRecursive", "dataDirFiles", "printDataFiles", "dataFiles", "stubKafkaMessage", "message", "bootstrapServers", "testKafkaMessage", "commit", "", "testKafkaMessages", "Lrun/qontract/core/Result;", "scenario", "Lrun/qontract/core/Scenario;", "core"})
@JvmName(name="API")
public final class API {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpStub createStubFromContractAndData(@NotNull String contractGherkin, @NotNull String dataDirectory, @NotNull String host, int port) {
        void $this$mapTo$iv$iv;
        List list;
        Iterable $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        Intrinsics.checkNotNullParameter((Object)contractGherkin, (String)"contractGherkin");
        Intrinsics.checkNotNullParameter((Object)dataDirectory, (String)"dataDirectory");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Feature contractBehaviour = FeatureKt.Feature(contractGherkin);
        File[] fileArray = new File(dataDirectory).listFiles();
        if (fileArray != null) {
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterable iterable = $this$filterTo$iv$iv;
            int n = ((Iterable)iterable).length;
            for (int i = 0; i < n; ++i) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterable[i];
                boolean bl = false;
                Object object = it;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                String string = ((File)object).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                if (!StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Loading data from ");
            void v5 = file;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"file");
            LogUtilsKt.consoleLog(stringBuilder.append(v5.getName()).toString());
            ScenarioStub scenarioStub = HttpStubKt.stringToMockScenario(new StringValue(FilesKt.readText((File)file, (Charset)Charsets.UTF_8)));
            boolean bl2 = false;
            boolean bl3 = false;
            ScenarioStub it = scenarioStub;
            boolean bl4 = false;
            contractBehaviour.matchingStub(it);
            ScenarioStub scenarioStub2 = scenarioStub;
            collection.add(scenarioStub2);
        }
        List mocks = (List)destination$iv$iv;
        return new HttpStub(contractBehaviour, (List<ScenarioStub>)mocks, host, port, (Function1<? super String, Unit>)((Function1)createStubFromContractAndData.1.INSTANCE));
    }

    public static /* synthetic */ HttpStub createStubFromContractAndData$default(String string, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string3 = "localhost";
        }
        if ((n2 & 8) != 0) {
            n = 9000;
        }
        return API.createStubFromContractAndData(string, string2, string3, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> allContractsFromDirectory(@NotNull String dirContainingContracts) {
        List list;
        Intrinsics.checkNotNullParameter((Object)dirContainingContracts, (String)"dirContainingContracts");
        File[] fileArray = new File(dirContainingContracts).listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)v1), (Object)"qontract")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file = (File)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                String string = v2.getAbsolutePath();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpStub createStub(@NotNull String host, int port) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Iterable $this$map$iv = Utilities.contractStubPaths();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ContractPathData contractPathData = (ContractPathData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getPath();
            collection.add(object);
        }
        List contractPaths = (List)destination$iv$iv;
        List<Pair<Feature, List<ScenarioStub>>> stubs = API.loadContractStubsFromImplicitPaths(contractPaths);
        Iterable $this$map$iv2 = stubs;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = (Feature)it.getFirst();
            collection.add(object);
        }
        List features = (List)destination$iv$iv2;
        List<HttpStubData> expectations = HttpStubKt.contractInfoToHttpExpectations(stubs);
        return new HttpStub(features, expectations, host, port, null, false, null, 112, null);
    }

    public static /* synthetic */ HttpStub createStub$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 9000;
        }
        return API.createStub(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpStub createStub(@NotNull List<String> dataDirPaths, @NotNull String host, int port) {
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(dataDirPaths, (String)"dataDirPaths");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Iterable $this$map$iv = Utilities.contractStubPaths();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ContractPathData contractPathData = (ContractPathData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = it.getPath();
            collection.add(object);
        }
        List contractPaths = (List)destination$iv$iv;
        List<Pair<Feature, List<ScenarioStub>>> contractInfo = API.loadContractStubsFromFiles(contractPaths, dataDirPaths);
        Iterable $this$map$iv2 = contractInfo;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = (Feature)it.getFirst();
            collection.add(object);
        }
        List features = (List)destination$iv$iv2;
        List<HttpStubData> httpExpectations = HttpStubKt.contractInfoToHttpExpectations(contractInfo);
        return new HttpStub(features, httpExpectations, host, port, createStub.1.INSTANCE, false, null, 96, null);
    }

    public static /* synthetic */ HttpStub createStub$default(List list, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 9000;
        }
        return API.createStub(list, string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpStub createStubFromContracts(@NotNull List<String> contractPaths, @NotNull List<String> dataDirPaths, @NotNull String host, int port) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        Intrinsics.checkNotNullParameter(dataDirPaths, (String)"dataDirPaths");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<Pair<Feature, List<ScenarioStub>>> contractInfo = API.loadContractStubsFromFiles(contractPaths, dataDirPaths);
        Iterable $this$map$iv = contractInfo;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Feature feature2 = (Feature)it.getFirst();
            collection.add(feature2);
        }
        List features = (List)destination$iv$iv;
        List<HttpStubData> httpExpectations = HttpStubKt.contractInfoToHttpExpectations(contractInfo);
        return new HttpStub(features, httpExpectations, host, port, createStubFromContracts.1.INSTANCE, false, null, 96, null);
    }

    public static /* synthetic */ HttpStub createStubFromContracts$default(List list, List list2, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = "localhost";
        }
        if ((n2 & 8) != 0) {
            n = 9000;
        }
        return API.createStubFromContracts(list, list2, string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Feature, List<ScenarioStub>>> loadContractStubsFromImplicitPaths(@NotNull List<String> contractPaths) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        Iterable $this$map$iv = contractPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it);
            collection.add(file);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Pair<Feature, List<ScenarioStub>>> list;
            Iterable stubData;
            String string;
            Object object;
            Object destination$iv$iv2;
            File contractPath = (File)element$iv$iv;
            boolean bl = false;
            if (contractPath.isFile() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)contractPath), (Object)"qontract")) {
                List list2;
                LogUtilsKt.consoleLog("Loading " + contractPath);
                String string2 = FilesKt.readText$default((File)contractPath, null, (int)1, null);
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                Feature feature2 = FeatureKt.Feature(((Object)StringsKt.trim((CharSequence)string3)).toString());
                String string4 = contractPath.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"contractPath.path");
                File implicitDataDir = API.implicitContractDataDir(string4);
                if (implicitDataDir.isDirectory()) {
                    void $this$mapTo$iv$iv2;
                    List list3;
                    File it;
                    Iterable $this$filterTo$iv$iv;
                    LogUtilsKt.consoleLog(StringsKt.prependIndent((String)("Loading stub expectations from " + implicitDataDir.getPath()), (String)"  "));
                    API.logIgnoredFiles(implicitDataDir);
                    Object object2 = implicitDataDir.listFiles();
                    if (object2 != null && (object2 = ArraysKt.toList((Object[])object2)) != null) {
                        Iterable $this$filter$iv = (Iterable)object2;
                        boolean $i$f$filter = false;
                        Iterable iterable2 = $this$filter$iv;
                        destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                            it = (File)element$iv$iv2;
                            boolean bl3 = false;
                            File file = it;
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json")) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        list3 = (List)destination$iv$iv2;
                    } else {
                        list3 = CollectionsKt.emptyList();
                    }
                    List stubDataFiles = list3;
                    API.printDataFiles(stubDataFiles);
                    Iterable $this$map$iv2 = stubDataFiles;
                    boolean $i$f$map2 = false;
                    $this$filterTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        it = (File)item$iv$iv;
                        object = destination$iv$iv2;
                        boolean bl4 = false;
                        File file = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                        string = new Pair((Object)file.getPath(), (Object)HttpStubKt.stringToMockScenario(new StringValue(FilesKt.readText$default((File)it, null, (int)1, null))));
                        object.add(string);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                stubData = list2;
                list = API.loadQontractStubs(CollectionsKt.listOf((Object)new Pair((Object)contractPath.getPath(), (Object)feature2)), (List<Pair<String, ScenarioStub>>)stubData);
            } else if (contractPath.isDirectory()) {
                List list4;
                Object object3 = contractPath.listFiles();
                if (object3 != null && (object3 = ArraysKt.toList((Object[])object3)) != null) {
                    void $this$mapTo$iv$iv3;
                    Iterable $this$map$iv3 = (Iterable)object3;
                    boolean $i$f$map3 = false;
                    stubData = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it;
                        destination$iv$iv2 = (File)item$iv$iv;
                        object = destination$iv$iv3;
                        boolean bl5 = false;
                        void v9 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"it");
                        string = v9.getAbsolutePath();
                        object.add(string);
                    }
                    list4 = (List)destination$iv$iv3;
                } else {
                    list4 = CollectionsKt.emptyList();
                }
                list = API.loadContractStubsFromImplicitPaths(list4);
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void logIgnoredFiles(File implicitDataDir) {
        List list;
        Iterable $this$filter$iv;
        Object object = implicitDataDir.listFiles();
        if (object != null && (object = ArraysKt.toList((Object[])object)) != null) {
            void $this$filterTo$iv$iv;
            $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                if (!(Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json") ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List ignoredFiles = list;
        $this$filter$iv = ignoredFiles;
        boolean bl = false;
        if (!$this$filter$iv.isEmpty()) {
            LogUtilsKt.consoleLog(StringsKt.prependIndent((String)"Ignoring the following files:", (String)"  "));
            Iterator iterator = ignoredFiles.iterator();
            while (iterator.hasNext()) {
                File file;
                File file2 = file = (File)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                String string = file2.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                LogUtilsKt.consoleLog(StringsKt.prependIndent((String)string, (String)"    "));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Feature, List<ScenarioStub>>> loadContractStubsFromFiles(@NotNull List<String> contractPaths, @NotNull List<String> dataDirPaths) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Pair pair;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        Intrinsics.checkNotNullParameter(dataDirPaths, (String)"dataDirPaths");
        Iterable iterable = contractPaths;
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.lineSeparator()");
        String contactPathsString = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        LogUtilsKt.consoleLog("Loading the following contracts:" + System.lineSeparator() + contactPathsString);
        LogUtilsKt.consoleLog("");
        List<File> dataDirFileList = API.allDirsInTree(dataDirPaths);
        Iterable $this$map$iv = contractPaths;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void path;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            pair = new Pair((Object)path, (Object)FeatureKt.Feature(Utilities.readFile((String)path)));
            collection.add(pair);
        }
        List features = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = dataDirFileList;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            LogUtilsKt.consoleLog(StringsKt.prependIndent((String)("Loading stub expectations from " + it.getPath()), (String)"  "));
            API.logIgnoredFiles(it);
            Object object = it.listFiles();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            File file = it;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
            if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"json")) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List dataFiles = (List)destination$iv$iv2;
        API.printDataFiles(dataFiles);
        Iterable $this$map$iv2 = dataFiles;
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File bl = (File)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            pair = new Pair((Object)v4.getPath(), (Object)HttpStubKt.stringToMockScenario(new StringValue(FilesKt.readText$default((File)it, null, (int)1, null))));
            collection.add(pair);
        }
        List mockData = (List)destination$iv$iv3;
        return API.loadQontractStubs(features, mockData);
    }

    private static final void printDataFiles(List<? extends File> dataFiles) {
        Collection collection = dataFiles;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterable iterable = dataFiles;
            String string = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"System.lineSeparator()");
            String dataFilesString2 = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)printDataFiles.dataFilesString.1.INSTANCE, (int)30, null);
            LogUtilsKt.consoleLog(StringsKt.prependIndent((String)("Reading the following stub files:" + System.lineSeparator() + dataFilesString2), (String)"  "));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Pair<Feature, List<ScenarioStub>>> loadQontractStubs(@NotNull List<Pair<String, Feature>> features, @NotNull List<Pair<String, ScenarioStub>> stubData) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        List list;
        Object object;
        Object object2;
        Iterable $this$mapValuesTo$iv$iv;
        Object list$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Pair it;
        Object $this$groupByTo$iv$iv;
        Object object3;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(stubData, (String)"stubData");
        Iterable $this$mapNotNull$iv = stubData;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair $dstr$stubFile$stub = (Pair)element$iv$iv;
            boolean bl2 = false;
            String string = (String)$dstr$stubFile$stub.component1();
            ScenarioStub stub = (ScenarioStub)$dstr$stubFile$stub.component2();
            Sequence matchResults2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)features), (Function1)((Function1)new Function1<Pair<? extends String, ? extends Feature>, Pair<? extends Feature, ? extends Pair<? extends NoMatchingScenario, ? extends String>>>(stub){
                final /* synthetic */ ScenarioStub $stub;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Pair<Feature, Pair<NoMatchingScenario, String>> invoke(@NotNull Pair<String, Feature> $dstr$qontractFile$feature) {
                    Pair pair;
                    Intrinsics.checkNotNullParameter($dstr$qontractFile$feature, (String)"<name for destructuring parameter 0>");
                    String string = (String)$dstr$qontractFile$feature.component1();
                    Feature feature2 = (Feature)$dstr$qontractFile$feature.component2();
                    try {
                        KafkaMessage kafkaMessage = this.$stub.getKafkaMessage();
                        if (kafkaMessage != null) {
                            feature2.assertMatchesMockKafkaMessage(kafkaMessage);
                        } else {
                            feature2.matchingStub(this.$stub.getRequest(), this.$stub.getResponse());
                        }
                        pair = new Pair((Object)feature2, null);
                    }
                    catch (NoMatchingScenario e) {
                        void qontractFile;
                        pair = new Pair(null, (Object)new Pair((Object)e, (Object)qontractFile));
                    }
                    return pair;
                }
                {
                    this.$stub = scenarioStub;
                    super(1);
                }
            }));
            Feature feature2 = (Feature)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)matchResults2, (Function1)loadQontractStubs.contractInfoFromStubs.1.feature.1.INSTANCE));
            if (feature2 == null) {
                void stubFile;
                LogUtilsKt.consoleLog(StringsKt.prependIndent((String)SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)matchResults2, (Function1)loadQontractStubs.contractInfoFromStubs.1.1.INSTANCE), (Function1)((Function1)new Function1<Pair<? extends NoMatchingScenario, ? extends String>, String>((String)stubFile){
                    final /* synthetic */ String $stubFile;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final String invoke(@NotNull Pair<NoMatchingScenario, String> $dstr$exception$contractFile) {
                        void exception;
                        Intrinsics.checkNotNullParameter($dstr$exception$contractFile, (String)"<name for destructuring parameter 0>");
                        NoMatchingScenario noMatchingScenario = (NoMatchingScenario)$dstr$exception$contractFile.component1();
                        String contractFile = (String)$dstr$exception$contractFile.component2();
                        String string = exception.getMessage();
                        return this.$stubFile + " didn't match " + contractFile + System.lineSeparator() + (string != null ? StringsKt.prependIndent((String)string, (String)"  ") : null);
                    }
                    {
                        this.$stubFile = string;
                        super(1);
                    }
                })), (CharSequence)(System.lineSeparator() + System.lineSeparator()), null, null, (int)0, null, null, (int)62, null), (String)"  "));
                pair = null;
            } else {
                pair = new Pair((Object)feature2, (Object)stub);
            }
            if (pair == null) continue;
            object3 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair it$iv$iv = object3;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        $this$forEach$iv$iv$iv = $this$groupByTo$iv$iv.iterator();
        while ($this$forEach$iv$iv$iv.hasNext()) {
            Object object4;
            Object element$iv$iv = $this$forEach$iv$iv$iv.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            key$iv$iv = (Feature)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object4 = answer$iv$iv$iv;
            } else {
                object4 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object4;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            void $this$mapTo$iv$iv4;
            void it2;
            void it$iv$iv;
            Object element$iv$iv$iv = list$iv$iv.next();
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            object2 = k;
            object = $this$getOrPut$iv$iv$iv;
            boolean bl7 = false;
            Iterable $this$map$iv = (Iterable)it2.getValue();
            boolean $i$f$map = false;
            object3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it3;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                ScenarioStub scenarioStub = (ScenarioStub)it3.getSecond();
                collection.add(scenarioStub);
            }
            list = (List)destination$iv$iv2;
            object.put(object2, list);
        }
        Iterable $this$map$iv = destination$iv$iv.entrySet();
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            list$iv$iv = (Map.Entry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object2 = new Pair(it.getKey(), it.getValue());
            object.add(object2);
        }
        List contractInfoFromStubs2 = (List)destination$iv$iv;
        Iterable $this$map$iv2 = contractInfoFromStubs2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it4;
            Pair bl = (Pair)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl9 = false;
            object2 = (Feature)it4.getFirst();
            object.add(object2);
        }
        List stubbedFeatures = (List)destination$iv$iv3;
        Iterable $this$map$iv3 = features;
        boolean $i$f$map3 = false;
        destination$iv$iv3 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            Pair bl9 = (Pair)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            object2 = (Feature)it5.getSecond();
            object.add(object2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Feature it6 = (Feature)element$iv$iv;
            boolean bl = false;
            if (!(!stubbedFeatures.contains(it6))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List missingFeatures = (List)destination$iv$iv4;
        $this$filter$iv = missingFeatures;
        object = contractInfoFromStubs2;
        $i$f$map3 = false;
        $this$filterTo$iv$iv = $this$map$iv3;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Feature it6 = (Feature)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl = false;
            list = new Pair((Object)it6, (Object)CollectionsKt.emptyList());
            object2.add((List)list);
        }
        object2 = (List)destination$iv$iv4;
        return CollectionsKt.plus((Collection)object, (Iterable)((Iterable)object2));
    }

    @NotNull
    public static final List<File> allDirsInTree(@NotNull String dataDirPath) {
        Intrinsics.checkNotNullParameter((Object)dataDirPath, (String)"dataDirPath");
        return API.allDirsInTree(CollectionsKt.listOf((Object)dataDirPath));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> allDirsInTree(@NotNull List<String> dataDirPaths) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        File it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dataDirPaths, (String)"dataDirPaths");
        Iterable $this$map$iv = dataDirPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)((Object)it));
            collection.add(file);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            Object object = it.listFiles();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null || (object = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) == null) {
                object = CollectionsKt.emptyList();
            }
            Object fileList = object;
            Iterable list$iv$iv = CollectionsKt.plus((Collection)API.pathToFileListRecursive((List<? extends File>)fileList), (Object)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> pathToFileListRecursive(List<? extends File> dataDirFiles) {
        void $this$mapTo$iv$iv;
        File it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dataDirFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isDirectory()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = it.listFiles();
            if (object == null || (object = ArraysKt.toList((Object[])object)) == null || (object = CollectionsKt.filterNotNull((Iterable)((Iterable)object))) == null) {
                object = CollectionsKt.emptyList();
            }
            Object fileList = object;
            List list = CollectionsKt.plus((Collection)API.pathToFileListRecursive((List<? extends File>)fileList), (Object)it);
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final ContractStub createStubFromContracts(@NotNull List<String> contractPaths, @NotNull String host, int port) {
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        List<String> dataDirPaths = API.implicitContractDataDirs(contractPaths);
        return API.createStubFromContracts(contractPaths, dataDirPaths, host, port);
    }

    public static /* synthetic */ ContractStub createStubFromContracts$default(List list, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "localhost";
        }
        if ((n2 & 4) != 0) {
            n = 9000;
        }
        return API.createStubFromContracts(list, string, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> implicitContractDataDirs(@NotNull List<String> contractPaths) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        Iterable $this$map$iv = contractPaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = API.implicitContractDataDir((String)it).getAbsolutePath();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final File implicitContractDataDir(@NotNull String contractPath) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        File contractFile = new File(contractPath);
        StringBuilder stringBuilder = new StringBuilder();
        File file = contractFile.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"contractFile.absoluteFile");
        return new File(stringBuilder.append(file.getParent()).append('/').append(FilesKt.getNameWithoutExtension((File)contractFile)).append("_data").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void stubKafkaMessage(@NotNull String contractPath, @NotNull String message, @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        KafkaMessage kafkaMessage = ScenarioStubKt.kafkaMessageFromJSON(ScenarioStubKt.getJSONObjectValue("kafka-message", JSONSerialisationKt.jsonStringToValueMap(message)));
        FeatureKt.Feature(FilesKt.readText$default((File)new File(contractPath), null, (int)1, null)).assertMatchesMockKafkaMessage(kafkaMessage);
        Closeable closeable = (Closeable)QontractKafkaKt.createProducer(bootstrapServers);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Producer it = (Producer)closeable;
            boolean bl3 = false;
            Future future = it.send(KafkaStubKt.producerRecord(kafkaMessage));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void testKafkaMessage(@NotNull String contractPath, @NotNull String bootstrapServers, boolean commit) {
        boolean bl;
        List results2;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
            Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
            Feature feature2 = FeatureKt.Feature(FilesKt.readText$default((File)new File(contractPath), null, (int)1, null));
            Iterable $this$map$iv = feature2.getScenarios();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Scenario scenario = (Scenario)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Result result2 = API.testKafkaMessages((Scenario)it, bootstrapServers, commit);
                collection.add(result2);
            }
            results2 = (List)destination$iv$iv;
            Iterable $this$any$iv = results2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Result it = (Result)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof Result.Failure)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new ContractException(Results.report$default(new Results(CollectionsKt.toMutableList((Collection)results2)), null, 1, null), null, null, null, 14, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Result testKafkaMessages(@NotNull Scenario scenario, @NotNull String bootstrapServers, boolean commit) {
        Result result2;
        Intrinsics.checkNotNullParameter((Object)scenario, (String)"scenario");
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Closeable closeable = (Closeable)QontractKafkaKt.createConsumer(bootstrapServers, commit);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            Consumer consumer = (Consumer)closeable;
            boolean bl3 = false;
            if (scenario.getKafkaMessagePattern() == null) {
                throw (Throwable)new ContractException("No kafka message found to test with", null, null, null, 14, null);
            }
            String topic = scenario.getKafkaMessagePattern().getTopic();
            consumer.subscribe((Collection)CollectionsKt.listOf((Object)topic));
            ConsumerRecords consumerRecords = consumer.poll(Duration.ofSeconds(1L));
            Intrinsics.checkNotNullExpressionValue((Object)consumerRecords, (String)"consumer.poll(Duration.ofSeconds(1))");
            Iterable $this$map$iv = (Iterable)consumerRecords;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                StringValue stringValue;
                void it;
                ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string = topic;
                if ((String)it.key() != null) {
                    void key;
                    String string2;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String string3 = string2;
                    String string4 = string;
                    boolean bl7 = false;
                    StringValue stringValue2 = new StringValue((String)key);
                    string = string4;
                    stringValue = stringValue2;
                } else {
                    stringValue = null;
                }
                Object object2 = it.value();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.value()");
                Value value = new StringValue((String)object2);
                StringValue stringValue3 = stringValue;
                String string5 = string;
                object = new KafkaMessage(string5, stringValue3, value);
                collection.add(object);
            }
            List messages = (List)destination$iv$iv;
            Iterable $this$map$iv2 = messages;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KafkaMessage bl4 = (KafkaMessage)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl8 = false;
                object = scenario.getKafkaMessagePattern().matches((KafkaMessage)it, scenario.getResolver());
                collection.add(object);
            }
            List results2 = (List)destination$iv$iv2;
            result2 = new Results(CollectionsKt.toMutableList((Collection)results2)).toResultIfAny();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return result2;
    }
}

