/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExprUtils;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLBinaryOpExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected SQLExpr left;
    protected SQLExpr right;
    protected SQLBinaryOperator operator;
    protected String dbType;
    private boolean bracket = false;
    protected transient List<SQLObject> mergedList;

    public SQLBinaryOpExpr() {
    }

    public SQLBinaryOpExpr(String dbType) {
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right) {
        this(left, operator, right, null);
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right, String dbType) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
        this.setRight(right);
        this.operator = operator;
        if (dbType == null && left instanceof SQLBinaryOpExpr) {
            dbType = ((SQLBinaryOpExpr)left).dbType;
        }
        if (dbType == null && right instanceof SQLBinaryOpExpr) {
            dbType = ((SQLBinaryOpExpr)right).dbType;
        }
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLExpr right, SQLBinaryOperator operator) {
        this.setLeft(left);
        this.setRight(right);
        this.operator = operator;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public SQLExpr getLeft() {
        return this.left;
    }

    public void setLeft(SQLExpr left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLExpr getRight() {
        return this.right;
    }

    public void setRight(SQLExpr right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    public boolean isBracket() {
        return this.bracket;
    }

    public void setBracket(boolean bracket) {
        this.bracket = bracket;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.left);
            this.acceptChild(visitor, this.right);
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr other = (SQLBinaryOpExpr)obj;
        return this.operator == other.operator && SQLExprUtils.equals(this.left, other.left) && SQLExprUtils.equals(this.right, other.right);
    }

    public boolean equals(SQLBinaryOpExpr other) {
        return this.operator == other.operator && SQLExprUtils.equals(this.left, other.left) && SQLExprUtils.equals(this.right, other.right);
    }

    public boolean equalsIgoreOrder(SQLBinaryOpExpr other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return Utils.equals(this.left, other.left) && Utils.equals(this.right, other.right) || Utils.equals(this.left, other.right) && Utils.equals(this.right, other.left);
    }

    @Override
    public SQLBinaryOpExpr clone() {
        SQLBinaryOpExpr x = new SQLBinaryOpExpr();
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        x.operator = this.operator;
        x.dbType = this.dbType;
        x.bracket = this.bracket;
        return x;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.getDbType());
    }

    @Override
    public void output(StringBuffer buf) {
        SQLASTOutputVisitor visitor = SQLUtils.createOutputVisitor(buf, this.dbType);
        this.accept(visitor);
    }

    public static SQLExpr combine(List<? extends SQLExpr> items, SQLBinaryOperator op) {
        if (items == null || op == null) {
            return null;
        }
        int size = items.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return items.get(0);
        }
        SQLBinaryOpExpr expr = new SQLBinaryOpExpr(items.get(0), op, items.get(1));
        for (int i2 = 2; i2 < size; ++i2) {
            SQLExpr item = items.get(i2);
            expr = new SQLBinaryOpExpr((SQLExpr)expr, op, item);
        }
        return expr;
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x) {
        return SQLBinaryOpExpr.split(x, x.getOperator());
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x, SQLBinaryOperator op) {
        if (x.getOperator() != op) {
            ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>(1);
            groupList.add(x);
            return groupList;
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupList, x, op);
        return groupList;
    }

    public static void split(List<SQLExpr> outList, SQLExpr expr, SQLBinaryOperator op) {
        ArrayList<SQLExpr> rightList;
        block14: {
            if (expr == null) {
                return;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) {
                outList.add(expr);
                return;
            }
            SQLBinaryOpExpr binaryExpr = (SQLBinaryOpExpr)expr;
            if (binaryExpr.getOperator() != op) {
                outList.add(binaryExpr);
                return;
            }
            rightList = new ArrayList<SQLExpr>();
            rightList.add(binaryExpr.getRight());
            SQLExpr left = binaryExpr.getLeft();
            while (left instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)left;
                if (leftBinary.operator == op) {
                    left = leftBinary.getLeft();
                    rightList.add(leftBinary.getRight());
                    continue;
                }
                outList.add(leftBinary);
                break block14;
            }
            outList.add(left);
        }
        for (int i2 = rightList.size() - 1; i2 >= 0; --i2) {
            SQLExpr right = (SQLExpr)rightList.get(i2);
            if (right instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryRight = (SQLBinaryOpExpr)right;
                if (binaryRight.operator == op) {
                    SQLExpr rightLeft = binaryRight.getLeft();
                    if (rightLeft instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightLeftBinary = (SQLBinaryOpExpr)rightLeft;
                        if (rightLeftBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightLeftBinary, op);
                        } else {
                            outList.add(rightLeftBinary);
                        }
                    } else {
                        outList.add(rightLeft);
                    }
                    SQLExpr rightRight = binaryRight.getRight();
                    if (rightRight instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightRightBinary = (SQLBinaryOpExpr)rightRight;
                        if (rightRightBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightRightBinary, op);
                            continue;
                        }
                        outList.add(rightRightBinary);
                        continue;
                    }
                    outList.add(rightRight);
                    continue;
                }
                outList.add(binaryRight);
                continue;
            }
            outList.add(right);
        }
    }

    public static SQLExpr and(SQLExpr a, SQLExpr b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr bb = (SQLBinaryOpExpr)b;
            if (bb.operator == SQLBinaryOperator.BooleanAnd) {
                return SQLBinaryOpExpr.and(SQLBinaryOpExpr.and(a, bb.left), bb.right);
            }
        }
        return new SQLBinaryOpExpr(a, SQLBinaryOperator.BooleanAnd, b);
    }

    public static SQLExpr andIfNotExists(SQLExpr a, SQLExpr b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<SQLExpr> groupListA = new ArrayList<SQLExpr>();
        ArrayList<SQLExpr> groupListB = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupListA, a, SQLBinaryOperator.BooleanAnd);
        SQLBinaryOpExpr.split(groupListB, a, SQLBinaryOperator.BooleanAnd);
        for (SQLExpr itemB : groupListB) {
            boolean exist = false;
            for (SQLExpr itemA : groupListA) {
                if (itemA.equals(itemB)) {
                    exist = true;
                    continue;
                }
                if (!(itemA instanceof SQLBinaryOpExpr) || !(itemB instanceof SQLBinaryOpExpr) || !((SQLBinaryOpExpr)itemA).equalsIgoreOrder((SQLBinaryOpExpr)itemB)) continue;
                exist = true;
            }
            if (exist) continue;
            groupListA.add(itemB);
        }
        return SQLBinaryOpExpr.combine(groupListA, SQLBinaryOperator.BooleanAnd);
    }

    public static SQLBinaryOpExpr isNotNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.IsNot, new SQLNullExpr());
    }

    public static SQLBinaryOpExpr isNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Is, new SQLNullExpr());
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr taget) {
        SQLObject parent = this.getParent();
        if (this.left == expr) {
            if (taget == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.right);
                }
                return false;
            }
            this.setLeft(taget);
            return true;
        }
        if (this.right == expr) {
            if (taget == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.left);
                }
                return false;
            }
            this.setRight(taget);
            return true;
        }
        return false;
    }

    public SQLExpr other(SQLExpr x) {
        if (x == this.left) {
            return this.right;
        }
        if (x == this.right) {
            return this.left;
        }
        return null;
    }

    public boolean contains(SQLExpr item) {
        if (item instanceof SQLBinaryOpExpr) {
            if (this.equalsIgoreOrder((SQLBinaryOpExpr)item)) {
                return true;
            }
            return this.left.equals(item) || this.right.equals(item);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.operator != null && this.operator.isRelational()) {
            return SQLBooleanExpr.DEFAULT_DATA_TYPE;
        }
        SQLDataType leftDataType = null;
        SQLDataType rightDataType = null;
        if (this.left != null) {
            leftDataType = this.left.computeDataType();
        }
        if (this.right != null) {
            rightDataType = this.right.computeDataType();
        }
        if (this.operator == SQLBinaryOperator.Concat) {
            if (leftDataType != null) {
                return leftDataType;
            }
            if (rightDataType != null) {
                return rightDataType;
            }
            return SQLCharExpr.DEFAULT_DATA_TYPE;
        }
        return null;
    }

    public boolean conditionContainsTable(String alias) {
        if (this.left == null || this.right == null) {
            return false;
        }
        if (this.left instanceof SQLPropertyExpr ? ((SQLPropertyExpr)this.left).matchOwner(alias) : this.left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)this.left).conditionContainsTable(alias)) {
            return true;
        }
        if (this.right instanceof SQLPropertyExpr) {
            if (((SQLPropertyExpr)this.right).matchOwner(alias)) {
                return true;
            }
        } else if (this.right instanceof SQLBinaryOpExpr) {
            return ((SQLBinaryOpExpr)this.right).conditionContainsTable(alias);
        }
        return false;
    }

    public boolean conditionContainsColumn(String column) {
        if (this.left == null || this.right == null) {
            return false;
        }
        return this.left instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)this.left).nameEquals(column) : this.right instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)this.right).nameEquals(column);
    }

    public static SQLBinaryOpExpr merge(ParameterizedVisitor v, SQLBinaryOpExpr x) {
        SQLBinaryOpExpr mergedLeft;
        SQLObject parent = x.parent;
        while (x.right instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr mergedRight;
            SQLBinaryOpExpr rightBinary = (SQLBinaryOpExpr)x.right;
            if (x.left instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr leftBinaryExpr = (SQLBinaryOpExpr)x.left;
                if (SQLExprUtils.equals(leftBinaryExpr.right, rightBinary)) {
                    x = leftBinaryExpr;
                    v.incrementReplaceCunt();
                    continue;
                }
            }
            if ((mergedRight = SQLBinaryOpExpr.merge(v, rightBinary)) != x.right) {
                x = new SQLBinaryOpExpr(x.left, x.operator, mergedRight);
                v.incrementReplaceCunt();
            }
            x.setParent(parent);
            break;
        }
        if (x.left instanceof SQLBinaryOpExpr && (mergedLeft = SQLBinaryOpExpr.merge(v, (SQLBinaryOpExpr)x.left)) != x.left) {
            SQLBinaryOpExpr tmp = new SQLBinaryOpExpr((SQLExpr)mergedLeft, x.operator, x.right);
            tmp.setParent(parent);
            x = tmp;
            v.incrementReplaceCunt();
        }
        if (x.operator == SQLBinaryOperator.BooleanOr && x.left instanceof SQLBinaryOpExpr && x.right instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)x.left;
            SQLBinaryOpExpr rightBinary = (SQLBinaryOpExpr)x.right;
            if (SQLBinaryOpExpr.mergeEqual(leftBinary, rightBinary)) {
                v.incrementReplaceCunt();
                leftBinary.setParent(x.parent);
                leftBinary.addMergedItem(rightBinary);
                return leftBinary;
            }
            if (SQLExprUtils.isLiteralExpr(leftBinary.left) && leftBinary.operator == SQLBinaryOperator.BooleanOr && SQLBinaryOpExpr.mergeEqual(leftBinary.right, x.right)) {
                v.incrementReplaceCunt();
                leftBinary.addMergedItem(rightBinary);
                return leftBinary;
            }
        }
        return x;
    }

    private void addMergedItem(SQLBinaryOpExpr item) {
        if (this.mergedList == null) {
            this.mergedList = new ArrayList<SQLObject>();
        }
        this.mergedList.add(item);
    }

    public List<SQLObject> getMergedList() {
        return this.mergedList;
    }

    private static boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.getOperator() != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.getRight() instanceof SQLLiteralExpr) && !(binaryA.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.getRight() instanceof SQLLiteralExpr) && !(binaryB.getRight() instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.getLeft().toString().equals(binaryB.getLeft().toString());
    }
}

