/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLInsertStatement
extends SQLInsertInto
implements SQLStatement {
    protected SQLWithSubqueryClause with;
    protected String dbType;
    protected boolean upsert = false;
    private boolean afterSemi;

    public void cloneTo(SQLInsertStatement x) {
        super.cloneTo(x);
        x.dbType = this.dbType;
        x.upsert = this.upsert;
        x.afterSemi = this.afterSemi;
        if (this.with != null) {
            x.setWith(this.with.clone());
        }
    }

    @Override
    public SQLInsertStatement clone() {
        SQLInsertStatement x = new SQLInsertStatement();
        this.cloneTo(x);
        return x;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, this.tableSource);
            this.acceptChild(visitor, this.columns);
            this.acceptChild(visitor, this.valuesList);
            this.acceptChild(visitor, this.query);
        }
        visitor.endVisit(this);
    }

    @Override
    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.add(this.tableSource);
        children.addAll(this.columns);
        children.addAll(this.valuesList);
        if (this.query != null) {
            children.add(this.query);
        }
        return children;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public void setUpsert(boolean upsert) {
        this.upsert = upsert;
    }

    @Override
    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public boolean isAfterSemi() {
        return this.afterSemi;
    }

    @Override
    public void setAfterSemi(boolean afterSemi) {
        this.afterSemi = afterSemi;
    }

    public SQLWithSubqueryClause getWith() {
        return this.with;
    }

    public void setWith(SQLWithSubqueryClause with) {
        if (with != null) {
            with.setParent(this);
        }
        this.with = with;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString(this, this.dbType);
    }

    @Override
    public String toLowerCaseString() {
        return SQLUtils.toSQLString(this, this.dbType, SQLUtils.DEFAULT_LCASE_FORMAT_OPTION);
    }

    public static class ValuesClause
    extends SQLObjectImpl {
        private final List<SQLExpr> values;
        private transient String originalString;
        private transient int replaceCount;

        public ValuesClause() {
            this(new ArrayList<SQLExpr>());
        }

        @Override
        public ValuesClause clone() {
            ValuesClause x = new ValuesClause(new ArrayList<SQLExpr>(this.values.size()));
            for (SQLExpr v : this.values) {
                x.addValue(v);
            }
            return x;
        }

        public ValuesClause(List<SQLExpr> values) {
            this.values = values;
            for (int i2 = 0; i2 < values.size(); ++i2) {
                values.get(i2).setParent(this);
            }
        }

        public void addValue(SQLExpr value) {
            value.setParent(this);
            this.values.add(value);
        }

        public List<SQLExpr> getValues() {
            return this.values;
        }

        @Override
        public void output(StringBuffer buf) {
            buf.append(" VALUES (");
            int size = this.values.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 != 0) {
                    buf.append(", ");
                }
                this.values.get(i2).output(buf);
            }
            buf.append(")");
        }

        @Override
        protected void accept0(SQLASTVisitor visitor) {
            if (visitor.visit(this)) {
                this.acceptChild(visitor, this.values);
            }
            visitor.endVisit(this);
        }

        public String getOriginalString() {
            return this.originalString;
        }

        public void setOriginalString(String originalString) {
            this.originalString = originalString;
        }

        public int getReplaceCount() {
            return this.replaceCount;
        }

        public void incrementReplaceCount() {
            ++this.replaceCount;
        }
    }
}

