/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLParameter;
import com.alibaba.druid.sql.ast.SQLPartitionBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntervalExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableAddColumn;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnConstraint;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCommentStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateFunctionStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateProcedureStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLIfStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLLoopStatement;
import com.alibaba.druid.sql.ast.statement.SQLReplaceStatement;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLShowTablesStatement;
import com.alibaba.druid.sql.ast.statement.SQLStartTransactionStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlForceIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlIgnoreIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlPrimaryKey;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUnique;
import com.alibaba.druid.sql.dialect.mysql.ast.MySqlUseIndexHint;
import com.alibaba.druid.sql.dialect.mysql.ast.MysqlForeignKey;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.ConditionValue;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlCursorDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareConditionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareHandlerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlDeclareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlIterateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlLeaveStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlRepeatStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.clause.MySqlSelectIntoStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlCharExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlExtractExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlMatchAgainstExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOrderingExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlOutFileExpr;
import com.alibaba.druid.sql.dialect.mysql.ast.expr.MySqlUserName;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.CobarShowStatus;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterLogFileGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterServerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableAlterColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableChangeColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableDiscardTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableImportTablespace;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableModifyColumn;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTableOption;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAlterUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlAnalyzeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlBinlogStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlChecksumTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateAddLogFileGroupStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateServerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableSpaceStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateUserStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlDeleteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlEventSchedule;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExecuteStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlExplainStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlFlushStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHelpStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlHintStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlInsertStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlKillStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadDataInFileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLoadXmlStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlLockTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlOptimizeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlPrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlRenameTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlResetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSetTransactionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowAuthorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowBinaryLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCharacterSetStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCollationStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowColumnsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowContributorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateDatabaseStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateEventStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateFunctionStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTableStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateTriggerStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowCreateViewStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasePartitionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowDatabasesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEngineStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEnginesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowErrorsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowFunctionStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowGrantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowIndexesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowKeysStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterLogsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowMasterStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowOpenTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPluginsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowPrivilegesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureCodeStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcedureStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProcessListStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfileStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowProfilesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowRelayLogEventsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveHostsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowSlaveStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTableStatusStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowTriggersStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowVariantsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlShowWarningsStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByKey;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSubPartitionByList;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlTableIndex;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUnlockTablesStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateTableSource;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MysqlDeallocatePrepareStatement;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.visitor.ExportParameterVisitorUtils;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MySqlOutputVisitor
extends SQLASTOutputVisitor
implements MySqlASTVisitor {
    public MySqlOutputVisitor(Appendable appender) {
        super(appender);
        this.dbType = "mysql";
        this.shardingSupport = true;
    }

    public MySqlOutputVisitor(Appendable appender, boolean parameterized) {
        super(appender, parameterized);
        this.dbType = "mysql";
        this.shardingSupport = true;
        try {
            this.configFromProperty(System.getProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    public void configFromProperty(Properties properties) {
        if (this.parameterized) {
            String property = properties.getProperty("druid.parameterized.shardingSupport");
            if ("true".equals(property)) {
                this.setShardingSupport(true);
            } else if ("false".equals(property)) {
                this.setShardingSupport(false);
            }
        }
    }

    public boolean isShardingSupport() {
        return this.parameterized && this.shardingSupport;
    }

    public void setShardingSupport(boolean shardingSupport) {
        this.shardingSupport = shardingSupport;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof MySqlSelectQueryBlock) {
            return this.visit((MySqlSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        SQLName procedureName;
        SQLLimit limit;
        SQLOrderBy orderBy;
        SQLExpr where;
        SQLTableSource from;
        String cachedSelectList;
        boolean bracket = x.isBracket();
        if (bracket) {
            this.print('(');
        }
        if (!this.isParameterized() && this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        if ((cachedSelectList = x.getCachedSelectList()) != null) {
            if (!this.isEnabled(VisitorFeature.OutputSkipSelectListCacheString)) {
                this.print0(cachedSelectList);
            }
        } else {
            SQLExprTableSource into;
            this.print0(this.ucase ? "SELECT " : "select ");
            int size = x.getHintsSize();
            for (int i2 = 0; i2 < size; ++i2) {
                SQLCommentHint hint = x.getHints().get(i2);
                hint.accept(this);
                this.print(' ');
            }
            int distionOption = x.getDistionOption();
            if (1 == distionOption) {
                this.print0(this.ucase ? "ALL " : "all ");
            } else if (2 == distionOption) {
                this.print0(this.ucase ? "DISTINCT " : "distinct ");
            } else if (4 == distionOption) {
                this.print0(this.ucase ? "DISTINCTROW " : "distinctrow ");
            }
            if (x.isHignPriority()) {
                this.print0(this.ucase ? "HIGH_PRIORITY " : "high_priority ");
            }
            if (x.isStraightJoin()) {
                this.print0(this.ucase ? "STRAIGHT_JOIN " : "straight_join ");
            }
            if (x.isSmallResult()) {
                this.print0(this.ucase ? "SQL_SMALL_RESULT " : "sql_small_result ");
            }
            if (x.isBigResult()) {
                this.print0(this.ucase ? "SQL_BIG_RESULT " : "sql_big_result ");
            }
            if (x.isBufferResult()) {
                this.print0(this.ucase ? "SQL_BUFFER_RESULT " : "sql_buffer_result ");
            }
            if (x.getCache() != null) {
                if (x.getCache().booleanValue()) {
                    this.print0(this.ucase ? "SQL_CACHE " : "sql_cache ");
                } else {
                    this.print0(this.ucase ? "SQL_NO_CACHE " : "sql_no_cache ");
                }
            }
            if (x.isCalcFoundRows()) {
                this.print0(this.ucase ? "SQL_CALC_FOUND_ROWS " : "sql_calc_found_rows ");
            }
            this.printSelectList(x.getSelectList());
            SQLName forcePartition = x.getForcePartition();
            if (forcePartition != null) {
                this.println();
                this.print0(this.ucase ? "FORCE PARTITION " : "force partition ");
                this.printExpr(forcePartition);
            }
            if ((into = x.getInto()) != null) {
                this.println();
                this.print0(this.ucase ? "INTO " : "into ");
                this.printTableSource(into);
            }
        }
        if ((from = x.getFrom()) != null) {
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            this.printTableSource(from);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
        }
        this.printHierarchical(x);
        SQLSelectGroupByClause groupBy = x.getGroupBy();
        if (groupBy != null) {
            this.println();
            this.visit(groupBy);
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            this.visit(orderBy);
        }
        if ((limit = x.getLimit()) != null) {
            this.println();
            this.visit(limit);
        }
        if ((procedureName = x.getProcedureName()) != null) {
            this.print0(this.ucase ? " PROCEDURE " : " procedure ");
            procedureName.accept(this);
            if (!x.getProcedureArgumentList().isEmpty()) {
                this.print('(');
                this.printAndAccept(x.getProcedureArgumentList(), ", ");
                this.print(')');
            }
        }
        if (x.isForUpdate()) {
            this.println();
            this.print0(this.ucase ? "FOR UPDATE" : "for update");
            if (x.isNoWait()) {
                this.print0(this.ucase ? " NOWAIT" : " nowait");
            } else if (x.getWaitTime() != null) {
                this.print0(this.ucase ? " WAIT " : " wait ");
                x.getWaitTime().accept(this);
            }
        }
        if (x.isLockInShareMode()) {
            this.println();
            this.print0(this.ucase ? "LOCK IN SHARE MODE" : "lock in share mode");
        }
        if (bracket) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(SQLColumnDefinition x) {
        SQLExpr onUpdate;
        SQLExpr storage;
        SQLExpr charsetExpr;
        boolean parameterized = this.parameterized;
        this.parameterized = false;
        x.getName().accept(this);
        SQLDataType dataType = x.getDataType();
        if (dataType != null) {
            this.print(' ');
            dataType.accept(this);
        }
        if ((charsetExpr = x.getCharsetExpr()) != null) {
            this.print0(this.ucase ? " CHARSET " : " charset ");
            charsetExpr.accept(this);
        }
        for (SQLColumnConstraint item : x.getConstraints()) {
            this.print(' ');
            item.accept(this);
        }
        SQLExpr defaultExpr = x.getDefaultExpr();
        if (defaultExpr != null) {
            this.print0(this.ucase ? " DEFAULT " : " default ");
            defaultExpr.accept(this);
        }
        if ((storage = x.getStorage()) != null) {
            this.print0(this.ucase ? " STORAGE " : " storage ");
            storage.accept(this);
        }
        if ((onUpdate = x.getOnUpdate()) != null) {
            this.print0(this.ucase ? " ON UPDATE " : " on update ");
            onUpdate.accept(this);
        }
        if (x.isAutoIncrement()) {
            this.print0(this.ucase ? " AUTO_INCREMENT" : " auto_increment");
        }
        if (x.getComment() != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        if (x.getAsExpr() != null) {
            this.print0(this.ucase ? " AS (" : " as (");
            x.getAsExpr().accept(this);
            this.print(')');
        }
        if (x.isSorted()) {
            this.print0(this.ucase ? " SORTED" : " sorted");
        }
        if (x.isVirtual()) {
            this.print0(this.ucase ? " VIRTUAL" : " virtual");
        }
        this.parameterized = parameterized;
        return false;
    }

    @Override
    public boolean visit(SQLDataType x) {
        this.printDataType(x);
        if (x instanceof SQLDataTypeImpl) {
            SQLDataTypeImpl dataTypeImpl = (SQLDataTypeImpl)x;
            if (dataTypeImpl.isUnsigned()) {
                this.print0(this.ucase ? " UNSIGNED" : " unsigned");
            }
            if (dataTypeImpl.isZerofill()) {
                this.print0(this.ucase ? " ZEROFILL" : " zerofill");
            }
        }
        if (x instanceof SQLCharacterDataType) {
            List<SQLCommentHint> hints;
            SQLCharacterDataType charType = (SQLCharacterDataType)x;
            if (charType.getCharSetName() != null) {
                this.print0(this.ucase ? " CHARACTER SET " : " character set ");
                this.print0(charType.getCharSetName());
                if (charType.getCollate() != null) {
                    this.print0(this.ucase ? " COLLATE " : " collate ");
                    this.print0(charType.getCollate());
                }
            }
            if ((hints = ((SQLCharacterDataType)x).hints) != null) {
                this.print(' ');
                for (SQLCommentHint hint : hints) {
                    hint.accept(this);
                }
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLCharacterDataType x) {
        List<SQLCommentHint> hints;
        this.printDataType(x);
        if (x.isHasBinary()) {
            this.print0(this.ucase ? " BINARY " : " binary ");
        }
        if (x.getCharSetName() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharSetName());
            if (x.getCollate() != null) {
                this.print0(this.ucase ? " COLLATE " : " collate ");
                this.print0(x.getCollate());
            }
        } else if (x.getCollate() != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(x.getCollate());
        }
        if ((hints = x.hints) != null) {
            this.print(' ');
            for (SQLCommentHint hint : hints) {
                hint.accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlTableIndex x) {
    }

    @Override
    public boolean visit(MySqlTableIndex x) {
        String indexType = x.getIndexType();
        boolean indexTypePrinted = false;
        if ("FULLTEXT".equalsIgnoreCase(indexType)) {
            this.print0(this.ucase ? "FULLTEXT " : "fulltext ");
            indexTypePrinted = true;
        } else if ("SPATIAL".equalsIgnoreCase(indexType)) {
            this.print0(this.ucase ? "SPATIAL " : "spatial ");
            indexTypePrinted = true;
        }
        this.print0(this.ucase ? "INDEX" : "index");
        if (x.getName() != null) {
            this.print(' ');
            x.getName().accept(this);
        }
        if (indexType != null && !indexTypePrinted) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(indexType);
        }
        this.print('(');
        int size = x.getColumns().size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i2).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement x) {
        SQLPartitionBy tbPartitionsBy;
        SQLPartitionBy dbPartitionBy;
        SQLPartitionBy sQLPartitionBy;
        if (this.isPrettyFormat() && x.hasBeforeComment()) {
            this.printlnComments(x.getBeforeCommentsDirect());
        }
        this.print0(this.ucase ? "CREATE " : "create ");
        for (SQLCommentHint sQLCommentHint : x.getHints()) {
            sQLCommentHint.accept(this);
            this.print(' ');
        }
        if (SQLCreateTableStatement.Type.GLOBAL_TEMPORARY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "TEMPORARY TABLE " : "temporary table ");
        } else {
            this.print0(this.ucase ? "TABLE " : "table ");
        }
        if (x.isIfNotExiists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printTableSourceExpr(x.getName());
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        this.printTableElements(x.getTableElementList());
        for (Map.Entry entry : x.getTableOptions().entrySet()) {
            String key = (String)entry.getKey();
            this.print(' ');
            this.print0(this.ucase ? key : key.toLowerCase());
            if ("TABLESPACE".equals(key)) {
                this.print(' ');
                ((SQLObject)entry.getValue()).accept(this);
                continue;
            }
            if ("UNION".equals(key)) {
                this.print0(" = (");
                ((SQLObject)entry.getValue()).accept(this);
                this.print(')');
                continue;
            }
            this.print0(" = ");
            ((SQLObject)entry.getValue()).accept(this);
        }
        SQLExpr comment = x.getComment();
        if (comment != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            comment.accept(this);
        }
        if ((sQLPartitionBy = x.getPartitioning()) != null) {
            this.println();
            this.print0(this.ucase ? "PARTITION BY " : "partition by ");
            sQLPartitionBy.accept(this);
        }
        if ((dbPartitionBy = x.getDbPartitionBy()) != null) {
            this.println();
            this.print0(this.ucase ? "DBPARTITION BY " : "dbpartition by ");
            dbPartitionBy.accept(this);
        }
        if ((tbPartitionsBy = x.getTablePartitionBy()) != null) {
            this.println();
            this.print0(this.ucase ? "TBPARTITION BY " : "tbpartition by ");
            tbPartitionsBy.accept(this);
        }
        if (x.getTbpartitions() != null) {
            this.println();
            this.print0(this.ucase ? "TBPARTITIONS " : "tbpartitions ");
            x.getTbpartitions().accept(this);
        }
        if (x.getTableGroup() != null) {
            this.println();
            this.print0(this.ucase ? "TABLEGROUP " : "tablegroup ");
            x.getTableGroup().accept(this);
        }
        if (x.getSelect() != null) {
            this.println();
            this.print0(this.ucase ? "AS" : "as");
            this.println();
            x.getSelect().accept(this);
        }
        for (SQLCommentHint hint : x.getOptionHints()) {
            this.print(' ');
            hint.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlKey x) {
    }

    @Override
    public void endVisit(MySqlPrimaryKey x) {
    }

    @Override
    public void endVisit(MysqlForeignKey x) {
    }

    @Override
    public boolean visit(MySqlKey x) {
        if (x.isHasConstaint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "KEY" : "key");
        SQLName name = x.getName();
        if (name != null) {
            this.print(' ');
            name.accept(this);
        }
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        int size = x.getColumns().size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i2).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(MySqlPrimaryKey x) {
        if (x.getName() != null) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            x.getName().accept(this);
            this.print(' ');
        }
        this.print0(this.ucase ? "PRIMARY KEY" : "primary key");
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        int size = x.getColumns().size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            x.getColumns().get(i2).accept(this);
        }
        this.print(')');
        return false;
    }

    @Override
    public boolean visit(SQLCharExpr x) {
        if (this.appender == null) {
            return false;
        }
        try {
            char ch;
            int i2;
            if (this.parameterized) {
                this.appender.append('?');
                this.incrementReplaceCunt();
                if (this.parameters != null) {
                    ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
                }
                return false;
            }
            this.appender.append('\'');
            String text = x.getText();
            boolean hasSpecial = false;
            for (i2 = 0; i2 < text.length(); ++i2) {
                ch = text.charAt(i2);
                if (ch != '\'' && ch != '\\' && ch != '\u0000') continue;
                hasSpecial = true;
                break;
            }
            if (hasSpecial) {
                for (i2 = 0; i2 < text.length(); ++i2) {
                    ch = text.charAt(i2);
                    if (ch == '\'') {
                        this.appender.append('\'');
                        this.appender.append('\'');
                        continue;
                    }
                    if (ch == '\\') {
                        this.appender.append('\\');
                        this.appender.append('\\');
                        continue;
                    }
                    if (ch == '\u0000') {
                        this.appender.append('\\');
                        this.appender.append('0');
                        continue;
                    }
                    this.appender.append(ch);
                }
            } else {
                this.appender.append(text);
            }
            this.appender.append('\'');
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException("println error", e);
        }
    }

    @Override
    public boolean visit(SQLVariantRefExpr x) {
        int index = x.getIndex();
        if (this.inputParameters != null && index < this.inputParameters.size()) {
            return super.visit(x);
        }
        if (x.isGlobal()) {
            this.print0("@@global.");
        } else if (x.isSession()) {
            this.print0("@@session.");
        }
        String varName = x.getName();
        for (int i2 = 0; i2 < varName.length(); ++i2) {
            char ch = varName.charAt(i2);
            if (ch == '\'') {
                if (varName.startsWith("@@") && i2 == 2) {
                    this.print(ch);
                    continue;
                }
                if (varName.startsWith("@") && i2 == 1) {
                    this.print(ch);
                    continue;
                }
                if (i2 != 0 && i2 != varName.length() - 1) {
                    this.print0("\\'");
                    continue;
                }
                this.print(ch);
                continue;
            }
            this.print(ch);
        }
        String collate = (String)x.getAttribute("COLLATE");
        if (collate != null) {
            this.print0(this.ucase ? " COLLATE " : " collate ");
            this.print0(collate);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlExtractExpr x) {
        this.print0(this.ucase ? "EXTRACT(" : "extract(");
        this.print0(x.getUnit().name());
        this.print0(this.ucase ? " FROM " : " from ");
        x.getValue().accept(this);
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlExtractExpr x) {
    }

    @Override
    public void endVisit(MySqlMatchAgainstExpr x) {
    }

    @Override
    public boolean visit(MySqlMatchAgainstExpr x) {
        this.print0(this.ucase ? "MATCH (" : "match (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        this.print0(this.ucase ? " AGAINST (" : " against (");
        x.getAgainst().accept(this);
        if (x.getSearchModifier() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getSearchModifier().name : x.getSearchModifier().name_lcase);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlPrepareStatement x) {
    }

    @Override
    public boolean visit(MySqlPrepareStatement x) {
        this.print0(this.ucase ? "PREPARE " : "prepare ");
        x.getName().accept(this);
        this.print0(this.ucase ? " FROM " : " from ");
        x.getFrom().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlExecuteStatement x) {
    }

    @Override
    public boolean visit(MySqlExecuteStatement x) {
        this.print0(this.ucase ? "EXECUTE " : "execute ");
        x.getStatementName().accept(this);
        if (x.getParameters().size() > 0) {
            this.print0(this.ucase ? " USING " : " using ");
            this.printAndAccept(x.getParameters(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(MysqlDeallocatePrepareStatement x) {
    }

    @Override
    public boolean visit(MysqlDeallocatePrepareStatement x) {
        this.print0(this.ucase ? "DEALLOCATE PREPARE " : "deallocate prepare ");
        x.getStatementName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlDeleteStatement x) {
    }

    @Override
    public boolean visit(MySqlDeleteStatement x) {
        SQLExpr where;
        this.print0(this.ucase ? "DELETE " : "delete ");
        int size = x.getHintsSize();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLCommentHint hint = x.getHints().get(i2);
            hint.accept(this);
            this.print(' ');
        }
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isQuick()) {
            this.print0(this.ucase ? "QUICK " : "quick ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.isForceAllPartitions()) {
            this.print0(this.ucase ? "FORCE ALL PARTITIONS " : "force all partitions ");
        } else {
            SQLName partition = x.getForcePartition();
            if (partition != null) {
                this.print0(this.ucase ? "FORCE PARTITION " : "force partition ");
                this.printExpr(partition);
                this.print(' ');
            }
        }
        SQLTableSource from = x.getFrom();
        if (from == null) {
            this.print0(this.ucase ? "FROM " : "from ");
            x.getTableSource().accept(this);
        } else {
            x.getTableSource().accept(this);
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
            from.accept(this);
        }
        SQLTableSource using = x.getUsing();
        if (using != null) {
            this.println();
            this.print0(this.ucase ? "USING " : "using ");
            using.accept(this);
        }
        if ((where = x.getWhere()) != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
            --this.indentCount;
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlInsertStatement x) {
    }

    @Override
    public boolean visit(MySqlInsertStatement x) {
        List<SQLExpr> duplicateKeyUpdate;
        List<SQLInsertStatement.ValuesClause> valuesList;
        this.print0(this.ucase ? "INSERT " : "insert ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isDelayed()) {
            this.print0(this.ucase ? "DELAYED " : "delayed ");
        }
        if (x.isHighPriority()) {
            this.print0(this.ucase ? "HIGH_PRIORITY " : "high_priority ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.isRollbackOnFail()) {
            this.print0(this.ucase ? "ROLLBACK_ON_FAIL " : "rollback_on_fail ");
        }
        this.print0(this.ucase ? "INTO " : "into ");
        SQLExprTableSource tableSource = x.getTableSource();
        if (tableSource.getClass() == SQLExprTableSource.class) {
            this.visit(tableSource);
        } else {
            tableSource.accept(this);
        }
        String columnsString = x.getColumnsString();
        if (columnsString != null) {
            if (!this.isEnabled(VisitorFeature.OutputSkipInsertColumnsString)) {
                this.print0(columnsString);
            }
        } else {
            List<SQLExpr> columns = x.getColumns();
            if (columns.size() > 0) {
                ++this.indentCount;
                this.print0(" (");
                int size = columns.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    SQLExpr column;
                    if (i2 != 0) {
                        if (i2 % 5 == 0) {
                            this.println();
                        }
                        this.print0(", ");
                    }
                    if ((column = columns.get(i2)) instanceof SQLIdentifierExpr) {
                        this.print0(((SQLIdentifierExpr)column).getName());
                        continue;
                    }
                    this.printExpr(column);
                }
                this.print(')');
                --this.indentCount;
            }
        }
        if (!(valuesList = x.getValuesList()).isEmpty()) {
            this.println();
            this.printValuesList(valuesList);
        }
        if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if ((duplicateKeyUpdate = x.getDuplicateKeyUpdate()).size() != 0) {
            this.println();
            this.print0(this.ucase ? "ON DUPLICATE KEY UPDATE " : "on duplicate key update ");
            int size = duplicateKeyUpdate.size();
            for (int i3 = 0; i3 < size; ++i3) {
                if (i3 != 0) {
                    if (i3 % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                duplicateKeyUpdate.get(i3).accept(this);
            }
        }
        return false;
    }

    protected void printValuesList(List<SQLInsertStatement.ValuesClause> valuesList) {
        if (this.parameterized && valuesList.size() > 0) {
            this.print0(this.ucase ? "VALUES " : "values ");
            ++this.indentCount;
            this.visit(valuesList.get(0));
            --this.indentCount;
            if (valuesList.size() > 1) {
                this.incrementReplaceCunt();
            }
            return;
        }
        this.print0(this.ucase ? "VALUES " : "values ");
        if (valuesList.size() > 1) {
            ++this.indentCount;
        }
        int size = valuesList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.print(',');
                this.println();
            }
            SQLInsertStatement.ValuesClause item = valuesList.get(i2);
            this.visit(item);
        }
        if (valuesList.size() > 1) {
            --this.indentCount;
        }
    }

    @Override
    public void endVisit(MySqlLoadDataInFileStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadDataInFileStatement x) {
        this.print0(this.ucase ? "LOAD DATA " : "load data ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isConcurrent()) {
            this.print0(this.ucase ? "CONCURRENT " : "concurrent ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INFILE " : "infile ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print0(this.ucase ? " REPLACE " : " replace ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
        }
        this.print0(this.ucase ? " INTO TABLE " : " into table ");
        x.getTableName().accept(this);
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print0(this.ucase ? " COLUMNS" : " columns");
            if (x.getColumnsTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print0(this.ucase ? " OPTIONALLY" : " optionally");
                }
                this.print0(this.ucase ? " ENCLOSED BY " : " enclosed by ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print0(this.ucase ? " ESCAPED BY " : " escaped by ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print0(this.ucase ? " LINES" : " lines");
            if (x.getLinesStartingBy() != null) {
                this.print0(this.ucase ? " STARTING BY " : " starting by ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        if (x.getIgnoreLinesNumber() != null) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
            x.getIgnoreLinesNumber().accept(this);
            this.print0(this.ucase ? " LINES" : " lines");
        }
        if (x.getColumns().size() != 0) {
            this.print0(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(')');
        }
        if (x.getSetList().size() != 0) {
            this.print0(this.ucase ? " SET " : " set ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(SQLReplaceStatement x) {
        SQLQueryExpr query;
        List<SQLInsertStatement.ValuesClause> valuesClauseList;
        int size;
        this.print0(this.ucase ? "REPLACE " : "replace ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isDelayed()) {
            this.print0(this.ucase ? "DELAYED " : "delayed ");
        }
        this.print0(this.ucase ? "INTO " : "into ");
        this.printTableSourceExpr(x.getTableName());
        List<SQLExpr> columns = x.getColumns();
        if (columns.size() > 0) {
            this.print0(" (");
            size = columns.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 != 0) {
                    this.print0(", ");
                }
                SQLExpr columnn = columns.get(i2);
                this.printExpr(columnn);
            }
            this.print(')');
        }
        if ((valuesClauseList = x.getValuesList()).size() != 0) {
            this.println();
            this.print0(this.ucase ? "VALUES " : "values ");
            size = valuesClauseList.size();
            if (size == 0) {
                this.print0("()");
            } else {
                for (int i3 = 0; i3 < size; ++i3) {
                    if (i3 != 0) {
                        this.print0(", ");
                    }
                    this.visit(valuesClauseList.get(i3));
                }
            }
        }
        if ((query = x.getQuery()) != null) {
            this.visit(query);
        }
        return false;
    }

    @Override
    public boolean visit(SQLStartTransactionStatement x) {
        this.print0(this.ucase ? "START TRANSACTION" : "start transaction");
        if (x.isConsistentSnapshot()) {
            this.print0(this.ucase ? " WITH CONSISTENT SNAPSHOT" : " with consistent snapshot");
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        if (x.isBegin()) {
            this.print0(this.ucase ? " BEGIN" : " begin");
        }
        if (x.isWork()) {
            this.print0(this.ucase ? " WORK" : " work");
        }
        return false;
    }

    @Override
    public boolean visit(SQLRollbackStatement x) {
        this.print0(this.ucase ? "ROLLBACK" : "rollback");
        if (x.getChain() != null) {
            if (x.getChain().booleanValue()) {
                this.print0(this.ucase ? " AND CHAIN" : " and chain");
            } else {
                this.print0(this.ucase ? " AND NO CHAIN" : " and no chain");
            }
        }
        if (x.getRelease() != null) {
            if (x.getRelease().booleanValue()) {
                this.print0(this.ucase ? " AND RELEASE" : " and release");
            } else {
                this.print0(this.ucase ? " AND NO RELEASE" : " and no release");
            }
        }
        if (x.getTo() != null) {
            this.print0(this.ucase ? " TO " : " to ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowColumnsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowColumnsStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL COLUMNS" : "show full columns");
        } else {
            this.print0(this.ucase ? "SHOW COLUMNS" : "show columns");
        }
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLShowTablesStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL TABLES" : "show full tables");
        } else {
            this.print0(this.ucase ? "SHOW TABLES" : "show tables");
        }
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowDatabasesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowDatabasesStatement x) {
        this.print0(this.ucase ? "SHOW DATABASES" : "show databases");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowWarningsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowWarningsStatement x) {
        if (x.isCount()) {
            this.print0(this.ucase ? "SHOW COUNT(*) WARNINGS" : "show count(*) warnings");
        } else {
            this.print0(this.ucase ? "SHOW WARNINGS" : "show warnings");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowStatusStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isGlobal()) {
            this.print0(this.ucase ? "GLOBAL " : "global ");
        }
        if (x.isSession()) {
            this.print0(this.ucase ? "SESSION " : "session ");
        }
        this.print0(this.ucase ? "STATUS" : "status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLoadXmlStatement x) {
    }

    @Override
    public boolean visit(MySqlLoadXmlStatement x) {
        this.print0(this.ucase ? "LOAD XML " : "load xml ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isConcurrent()) {
            this.print0(this.ucase ? "CONCURRENT " : "concurrent ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "INFILE " : "infile ");
        x.getFileName().accept(this);
        if (x.isReplicate()) {
            this.print0(this.ucase ? " REPLACE " : " replace ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? " IGNORE " : " ignore ");
        }
        this.print0(this.ucase ? " INTO TABLE " : " into table ");
        x.getTableName().accept(this);
        if (x.getCharset() != null) {
            this.print0(this.ucase ? " CHARSET " : " charset ");
            this.print0(x.getCharset());
        }
        if (x.getRowsIdentifiedBy() != null) {
            this.print0(this.ucase ? " ROWS IDENTIFIED BY " : " rows identified by ");
            x.getRowsIdentifiedBy().accept(this);
        }
        if (x.getSetList().size() != 0) {
            this.print0(this.ucase ? " SET " : " set ");
            this.printAndAccept(x.getSetList(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(CobarShowStatus x) {
    }

    @Override
    public boolean visit(CobarShowStatus x) {
        this.print0(this.ucase ? "SHOW COBAR_STATUS" : "show cobar_status");
        return false;
    }

    @Override
    public void endVisit(MySqlKillStatement x) {
    }

    @Override
    public boolean visit(MySqlKillStatement x) {
        if (MySqlKillStatement.Type.CONNECTION.equals((Object)x.getType())) {
            this.print0(this.ucase ? "KILL CONNECTION " : "kill connection ");
        } else if (MySqlKillStatement.Type.QUERY.equals((Object)x.getType())) {
            this.print0(this.ucase ? "KILL QUERY " : "kill query ");
        } else {
            this.print0(this.ucase ? "KILL " : "kill ");
        }
        this.printAndAccept(x.getThreadIds(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlBinlogStatement x) {
    }

    @Override
    public boolean visit(MySqlBinlogStatement x) {
        this.print0(this.ucase ? "BINLOG " : "binlog ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlResetStatement x) {
    }

    @Override
    public boolean visit(MySqlResetStatement x) {
        this.print0(this.ucase ? "RESET " : "reset ");
        for (int i2 = 0; i2 < x.getOptions().size(); ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            this.print0(x.getOptions().get(i2));
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement x) {
        this.print0(this.ucase ? "CREATE USER " : "create user ");
        this.printAndAccept(x.getUsers(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlCreateUserStatement.UserSpecification x) {
    }

    @Override
    public boolean visit(MySqlCreateUserStatement.UserSpecification x) {
        x.getUser().accept(this);
        if (x.getPassword() != null) {
            this.print0(this.ucase ? " IDENTIFIED BY " : " identified by ");
            if (x.isPasswordHash()) {
                this.print0(this.ucase ? "PASSWORD " : "password ");
            }
            x.getPassword().accept(this);
        }
        if (x.getAuthPlugin() != null) {
            this.print0(this.ucase ? " IDENTIFIED WITH " : " identified with ");
            x.getAuthPlugin().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlPartitionByKey x) {
    }

    @Override
    public boolean visit(MySqlPartitionByKey x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "LINEAR KEY (" : "linear key (");
        } else {
            this.print0(this.ucase ? "KEY (" : "key (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        this.printPartitionsCountAndSubPartitions(x);
        return false;
    }

    @Override
    public void endVisit(MySqlSelectQueryBlock x) {
    }

    @Override
    public boolean visit(MySqlOutFileExpr x) {
        this.print0(this.ucase ? "OUTFILE " : "outfile ");
        x.getFile().accept(this);
        if (x.getCharset() != null) {
            this.print0(this.ucase ? " CHARACTER SET " : " character set ");
            this.print0(x.getCharset());
        }
        if (x.getColumnsTerminatedBy() != null || x.getColumnsEnclosedBy() != null || x.getColumnsEscaped() != null) {
            this.print0(this.ucase ? " COLUMNS" : " columns");
            if (x.getColumnsTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getColumnsTerminatedBy().accept(this);
            }
            if (x.getColumnsEnclosedBy() != null) {
                if (x.isColumnsEnclosedOptionally()) {
                    this.print0(this.ucase ? " OPTIONALLY" : " optionally");
                }
                this.print0(this.ucase ? " ENCLOSED BY " : " enclosed by ");
                x.getColumnsEnclosedBy().accept(this);
            }
            if (x.getColumnsEscaped() != null) {
                this.print0(this.ucase ? " ESCAPED BY " : " escaped by ");
                x.getColumnsEscaped().accept(this);
            }
        }
        if (x.getLinesStartingBy() != null || x.getLinesTerminatedBy() != null) {
            this.print0(this.ucase ? " LINES" : " lines");
            if (x.getLinesStartingBy() != null) {
                this.print0(this.ucase ? " STARTING BY " : " starting by ");
                x.getLinesStartingBy().accept(this);
            }
            if (x.getLinesTerminatedBy() != null) {
                this.print0(this.ucase ? " TERMINATED BY " : " terminated by ");
                x.getLinesTerminatedBy().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlOutFileExpr x) {
    }

    @Override
    public boolean visit(MySqlExplainStatement x) {
        String name = x.isDescribe() ? "desc" : "explain";
        this.print0(this.ucase ? name.toUpperCase() : name);
        this.print(' ');
        if (x.getTableName() != null) {
            x.getTableName().accept(this);
            if (x.getColumnName() != null) {
                this.print(' ');
                x.getColumnName().accept(this);
            } else if (x.getWild() != null) {
                this.print(' ');
                x.getWild().accept(this);
            }
        } else {
            String type = x.getType();
            if (type != null) {
                this.print0(type);
                this.print(' ');
                if ("format".equalsIgnoreCase(type)) {
                    this.print0("= ");
                    this.print0(x.getFormat());
                    this.print(' ');
                }
            }
            if (x.getConnectionId() != null) {
                this.print0(this.ucase ? "FOR CONNECTION " : "for connection ");
                x.getConnectionId().accept(this);
            } else {
                x.getStatement().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlExplainStatement x) {
    }

    @Override
    public boolean visit(MySqlUpdateStatement x) {
        SQLLimit limit;
        SQLOrderBy orderBy;
        SQLExpr targetAffectRow;
        List<SQLExpr> returning = x.getReturning();
        if (returning != null && returning.size() > 0) {
            this.print0(this.ucase ? "SELECT " : "select ");
            this.printAndAccept(returning, ", ");
            this.println();
            this.print0(this.ucase ? "FROM " : "from ");
        }
        this.print0(this.ucase ? "UPDATE " : "update ");
        if (x.isLowPriority()) {
            this.print0(this.ucase ? "LOW_PRIORITY " : "low_priority ");
        }
        if (x.isIgnore()) {
            this.print0(this.ucase ? "IGNORE " : "ignore ");
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), " ");
            this.print0(" ");
        }
        if (x.isCommitOnSuccess()) {
            this.print0(this.ucase ? "COMMIT_ON_SUCCESS " : "commit_on_success ");
        }
        if (x.isRollBackOnFail()) {
            this.print0(this.ucase ? "ROLLBACK_ON_FAIL " : "rollback_on_fail ");
        }
        if (x.isQueryOnPk()) {
            this.print0(this.ucase ? "QUEUE_ON_PK " : "queue_on_pk ");
        }
        if ((targetAffectRow = x.getTargetAffectRow()) != null) {
            this.print0(this.ucase ? "TARGET_AFFECT_ROW " : "target_affect_row ");
            this.printExpr(targetAffectRow);
            this.print(' ');
        }
        if (x.isForceAllPartitions()) {
            this.print0(this.ucase ? "FORCE ALL PARTITIONS " : "force all partitions ");
        } else {
            SQLName partition = x.getForcePartition();
            if (partition != null) {
                this.print0(this.ucase ? "FORCE PARTITION " : "force partition ");
                this.printExpr(partition);
                this.print(' ');
            }
        }
        this.printTableSource(x.getTableSource());
        this.println();
        this.print0(this.ucase ? "SET " : "set ");
        List<SQLUpdateSetItem> items = x.getItems();
        int size = items.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            SQLUpdateSetItem item = items.get(i2);
            this.visit(item);
        }
        SQLExpr where = x.getWhere();
        if (where != null) {
            this.println();
            ++this.indentCount;
            this.print0(this.ucase ? "WHERE " : "where ");
            this.printExpr(where);
            --this.indentCount;
        }
        if ((orderBy = x.getOrderBy()) != null) {
            this.println();
            this.visit(orderBy);
        }
        if ((limit = x.getLimit()) != null) {
            this.println();
            this.visit(limit);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUpdateStatement x) {
    }

    @Override
    public boolean visit(MySqlSetTransactionStatement x) {
        if (x.getGlobal() == null) {
            this.print0(this.ucase ? "SET TRANSACTION " : "set transaction ");
        } else if (x.getGlobal().booleanValue()) {
            this.print0(this.ucase ? "SET GLOBAL TRANSACTION " : "set global transaction ");
        } else {
            this.print0(this.ucase ? "SET SESSION TRANSACTION " : "set session transaction ");
        }
        if (x.getIsolationLevel() != null) {
            this.print0(this.ucase ? "ISOLATION LEVEL " : "isolation level ");
            this.print0(x.getIsolationLevel());
        }
        if (x.getAccessModel() != null) {
            this.print0(this.ucase ? "READ " : "read ");
            this.print0(x.getAccessModel());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSetTransactionStatement x) {
    }

    @Override
    public void endVisit(MySqlShowAuthorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowAuthorsStatement x) {
        this.print0(this.ucase ? "SHOW AUTHORS" : "show authors");
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinaryLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinaryLogsStatement x) {
        this.print0(this.ucase ? "SHOW BINARY LOGS" : "show binary logs");
        return false;
    }

    @Override
    public boolean visit(MySqlShowMasterLogsStatement x) {
        this.print0(this.ucase ? "SHOW MASTER LOGS" : "show master logs");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterLogsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCollationStatement x) {
        this.print0(this.ucase ? "SHOW COLLATION" : "show collation");
        if (x.getPattern() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCollationStatement x) {
    }

    @Override
    public boolean visit(MySqlShowBinLogEventsStatement x) {
        this.print0(this.ucase ? "SHOW BINLOG EVENTS" : "show binlog events");
        if (x.getIn() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            x.getIn().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowBinLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCharacterSetStatement x) {
        this.print0(this.ucase ? "SHOW CHARACTER SET" : "show character set");
        if (x.getPattern() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getPattern().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowCharacterSetStatement x) {
    }

    @Override
    public boolean visit(MySqlShowContributorsStatement x) {
        this.print0(this.ucase ? "SHOW CONTRIBUTORS" : "show contributors");
        return false;
    }

    @Override
    public void endVisit(MySqlShowContributorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateDatabaseStatement x) {
        this.print0(this.ucase ? "SHOW CREATE DATABASE " : "show create database ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateDatabaseStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateEventStatement x) {
        this.print0(this.ucase ? "SHOW CREATE EVENT " : "show create event ");
        x.getEventName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateEventStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateFunctionStatement x) {
        this.print0(this.ucase ? "SHOW CREATE FUNCTION " : "show create function ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateFunctionStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateProcedureStatement x) {
        this.print0(this.ucase ? "SHOW CREATE PROCEDURE " : "show create procedure ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateProcedureStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTableStatement x) {
        this.print0(this.ucase ? "SHOW CREATE TABLE " : "show create table ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateTriggerStatement x) {
        this.print0(this.ucase ? "SHOW CREATE TRIGGER " : "show create trigger ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateTriggerStatement x) {
    }

    @Override
    public boolean visit(MySqlShowCreateViewStatement x) {
        this.print0(this.ucase ? "SHOW CREATE VIEW " : "show create view ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowCreateViewStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEngineStatement x) {
        this.print0(this.ucase ? "SHOW ENGINE " : "show engine ");
        x.getName().accept(this);
        this.print(' ');
        this.print0(x.getOption().name());
        return false;
    }

    @Override
    public void endVisit(MySqlShowEngineStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEventsStatement x) {
        this.print0(this.ucase ? "SHOW EVENTS" : "show events");
        if (x.getSchema() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getSchema().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionCodeStatement x) {
        this.print0(this.ucase ? "SHOW FUNCTION CODE " : "show function code ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowFunctionStatusStatement x) {
        this.print0(this.ucase ? "SHOW FUNCTION STATUS" : "show function status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowFunctionStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowEnginesStatement x) {
        if (x.isStorage()) {
            this.print0(this.ucase ? "SHOW STORAGE ENGINES" : "show storage engines");
        } else {
            this.print0(this.ucase ? "SHOW ENGINES" : "show engines");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowEnginesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowErrorsStatement x) {
        if (x.isCount()) {
            this.print0(this.ucase ? "SHOW COUNT(*) ERRORS" : "show count(*) errors");
        } else {
            this.print0(this.ucase ? "SHOW ERRORS" : "show errors");
            if (x.getLimit() != null) {
                this.print(' ');
                x.getLimit().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowErrorsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowGrantsStatement x) {
        this.print0(this.ucase ? "SHOW GRANTS" : "show grants");
        if (x.getUser() != null) {
            this.print0(this.ucase ? " FOR " : " for ");
            x.getUser().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowGrantsStatement x) {
    }

    @Override
    public boolean visit(MySqlUserName x) {
        String identifiedBy;
        this.print0(x.getUserName());
        String host = x.getHost();
        if (host != null) {
            this.print('@');
            this.print0(host);
        }
        if ((identifiedBy = x.getIdentifiedBy()) != null) {
            this.print0(this.ucase ? " IDENTIFIED BY '" : " identified by '");
            this.print0(identifiedBy);
            this.print('\'');
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUserName x) {
    }

    @Override
    public boolean visit(MySqlShowIndexesStatement x) {
        this.print0(this.ucase ? "SHOW INDEX" : "show index");
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowIndexesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowKeysStatement x) {
        this.print0(this.ucase ? "SHOW KEYS" : "show keys");
        if (x.getTable() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            if (x.getDatabase() != null) {
                x.getDatabase().accept(this);
                this.print('.');
            }
            x.getTable().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowKeysStatement x) {
    }

    @Override
    public boolean visit(MySqlShowMasterStatusStatement x) {
        this.print0(this.ucase ? "SHOW MASTER STATUS" : "show master status");
        return false;
    }

    @Override
    public void endVisit(MySqlShowMasterStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowOpenTablesStatement x) {
        this.print0(this.ucase ? "SHOW OPEN TABLES" : "show open tables");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowOpenTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPluginsStatement x) {
        this.print0(this.ucase ? "SHOW PLUGINS" : "show plugins");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPluginsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowPrivilegesStatement x) {
        this.print0(this.ucase ? "SHOW PRIVILEGES" : "show privileges");
        return false;
    }

    @Override
    public void endVisit(MySqlShowPrivilegesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureCodeStatement x) {
        this.print0(this.ucase ? "SHOW PROCEDURE CODE " : "show procedure code ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureCodeStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcedureStatusStatement x) {
        this.print0(this.ucase ? "SHOW PROCEDURE STATUS" : "show procedure status");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcedureStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProcessListStatement x) {
        if (x.isFull()) {
            this.print0(this.ucase ? "SHOW FULL PROCESSLIST" : "show full processlist");
        } else {
            this.print0(this.ucase ? "SHOW PROCESSLIST" : "show processlist");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProcessListStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfileStatement x) {
        this.print0(this.ucase ? "SHOW PROFILE" : "show profile");
        for (int i2 = 0; i2 < x.getTypes().size(); ++i2) {
            if (i2 == 0) {
                this.print(' ');
            } else {
                this.print0(", ");
            }
            this.print0(x.getTypes().get((int)i2).name);
        }
        if (x.getForQuery() != null) {
            this.print0(this.ucase ? " FOR QUERY " : " for query ");
            x.getForQuery().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfileStatement x) {
    }

    @Override
    public boolean visit(MySqlShowProfilesStatement x) {
        this.print0(this.ucase ? "SHOW PROFILES" : "show profiles");
        return false;
    }

    @Override
    public void endVisit(MySqlShowProfilesStatement x) {
    }

    @Override
    public boolean visit(MySqlShowRelayLogEventsStatement x) {
        this.print0("SHOW RELAYLOG EVENTS");
        if (x.getLogName() != null) {
            this.print0(this.ucase ? " IN " : " in ");
            x.getLogName().accept(this);
        }
        if (x.getFrom() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getFrom().accept(this);
        }
        if (x.getLimit() != null) {
            this.print(' ');
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowRelayLogEventsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveHostsStatement x) {
        this.print0(this.ucase ? "SHOW SLAVE HOSTS" : "show slave hosts");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveHostsStatement x) {
    }

    @Override
    public boolean visit(MySqlShowSlaveStatusStatement x) {
        this.print0(this.ucase ? "SHOW SLAVE STATUS" : "show slave status");
        return false;
    }

    @Override
    public void endVisit(MySqlShowSlaveStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTableStatusStatement x) {
        this.print0(this.ucase ? "SHOW TABLE STATUS" : "show table status");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTableStatusStatement x) {
    }

    @Override
    public boolean visit(MySqlShowTriggersStatement x) {
        this.print0(this.ucase ? "SHOW TRIGGERS" : "show triggers");
        if (x.getDatabase() != null) {
            this.print0(this.ucase ? " FROM " : " from ");
            x.getDatabase().accept(this);
        }
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowTriggersStatement x) {
    }

    @Override
    public boolean visit(MySqlShowVariantsStatement x) {
        this.print0(this.ucase ? "SHOW " : "show ");
        if (x.isGlobal()) {
            this.print0(this.ucase ? "GLOBAL " : "global ");
        }
        if (x.isSession()) {
            this.print0(this.ucase ? "SESSION " : "session ");
        }
        this.print0(this.ucase ? "VARIABLES" : "variables");
        if (x.getLike() != null) {
            this.print0(this.ucase ? " LIKE " : " like ");
            x.getLike().accept(this);
        }
        if (x.getWhere() != null) {
            this.print0(this.ucase ? " WHERE " : " where ");
            x.getWhere().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlShowVariantsStatement x) {
    }

    @Override
    public boolean visit(SQLAlterTableStatement x) {
        int i2;
        if (x.isIgnore()) {
            this.print0(this.ucase ? "ALTER IGNORE TABLE " : "alter ignore table ");
        } else {
            this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
        }
        this.printTableSourceExpr(x.getName());
        ++this.indentCount;
        for (i2 = 0; i2 < x.getItems().size(); ++i2) {
            SQLAlterTableItem item = x.getItems().get(i2);
            if (i2 != 0) {
                this.print(',');
            }
            this.println();
            item.accept(this);
        }
        if (x.isRemovePatiting()) {
            this.println();
            this.print0(this.ucase ? "REMOVE PARTITIONING" : "remove partitioning");
        }
        if (x.isUpgradePatiting()) {
            this.println();
            this.print0(this.ucase ? "UPGRADE PARTITIONING" : "upgrade partitioning");
        }
        if (x.getTableOptions().size() > 0) {
            this.println();
        }
        --this.indentCount;
        i2 = 0;
        for (Map.Entry<String, SQLObject> option : x.getTableOptions().entrySet()) {
            String key = option.getKey();
            if (i2 != 0) {
                this.print(' ');
            }
            this.print0(this.ucase ? key : key.toLowerCase());
            if ("TABLESPACE".equals(key)) {
                this.print(' ');
                option.getValue().accept(this);
                continue;
            }
            if ("UNION".equals(key)) {
                this.print0(" = (");
                option.getValue().accept(this);
                this.print(')');
                continue;
            }
            this.print0(" = ");
            option.getValue().accept(this);
            ++i2;
        }
        return false;
    }

    @Override
    public boolean visit(SQLAlterTableAddColumn x) {
        this.print0(this.ucase ? "ADD COLUMN " : "add column ");
        if (x.getColumns().size() > 1) {
            this.print('(');
        }
        this.printAndAccept(x.getColumns(), ", ");
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        if (x.getColumns().size() > 1) {
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(MySqlRenameTableStatement.Item x) {
        x.getName().accept(this);
        this.print0(this.ucase ? " TO " : " to ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement.Item x) {
    }

    @Override
    public boolean visit(MySqlRenameTableStatement x) {
        this.print0(this.ucase ? "RENAME TABLE " : "rename table ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlRenameTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUseIndexHint x) {
        this.print0(this.ucase ? "USE INDEX " : "use index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlUseIndexHint x) {
    }

    @Override
    public boolean visit(MySqlIgnoreIndexHint x) {
        this.print0(this.ucase ? "IGNORE INDEX " : "ignore index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(this.ucase ? x.getOption().name : x.getOption().name_lcase);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlIgnoreIndexHint x) {
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        this.printTableSourceExpr(x.getExpr());
        String alias = x.getAlias();
        if (alias != null) {
            this.print(' ');
            this.print0(alias);
        }
        for (int i2 = 0; i2 < x.getHintsSize(); ++i2) {
            this.print(' ');
            x.getHints().get(i2).accept(this);
        }
        if (x.getPartitionSize() > 0) {
            this.print0(this.ucase ? " PARTITION (" : " partition (");
            this.printlnAndAccept(x.getPartitions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public boolean visit(MySqlLockTableStatement x) {
        this.print0(this.ucase ? "LOCK TABLES " : "lock tables ");
        x.getTableSource().accept(this);
        if (x.getLockType() != null) {
            this.print(' ');
            this.print0(x.getLockType().name);
        }
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlLockTableStatement x) {
    }

    @Override
    public boolean visit(MySqlUnlockTablesStatement x) {
        this.print0(this.ucase ? "UNLOCK TABLES" : "unlock tables");
        return false;
    }

    @Override
    public void endVisit(MySqlUnlockTablesStatement x) {
    }

    @Override
    public boolean visit(MySqlForceIndexHint x) {
        this.print0(this.ucase ? "FORCE INDEX " : "force index ");
        if (x.getOption() != null) {
            this.print0(this.ucase ? "FOR " : "for ");
            this.print0(x.getOption().name);
            this.print(' ');
        }
        this.print('(');
        this.printAndAccept(x.getIndexList(), ", ");
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlForceIndexHint x) {
    }

    @Override
    public boolean visit(MySqlAlterTableChangeColumn x) {
        this.print0(this.ucase ? "CHANGE COLUMN " : "change column ");
        x.getColumnName().accept(this);
        this.print(' ');
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableChangeColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableModifyColumn x) {
        this.print0(this.ucase ? "MODIFY COLUMN " : "modify column ");
        x.getNewColumnDefinition().accept(this);
        if (x.getFirstColumn() != null) {
            this.print0(this.ucase ? " FIRST " : " first ");
            x.getFirstColumn().accept(this);
        } else if (x.getAfterColumn() != null) {
            this.print0(this.ucase ? " AFTER " : " after ");
            x.getAfterColumn().accept(this);
        } else if (x.isFirst()) {
            this.print0(this.ucase ? " FIRST" : " first");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableModifyColumn x) {
    }

    @Override
    public boolean visit(MySqlAlterTableOption x) {
        this.print0(x.getName());
        this.print0(" = ");
        this.print0(x.getValue().toString());
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableOption x) {
    }

    @Override
    public void endVisit(MySqlCreateTableStatement x) {
    }

    @Override
    public boolean visit(MySqlHelpStatement x) {
        this.print0(this.ucase ? "HELP " : "help ");
        x.getContent().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlHelpStatement x) {
    }

    @Override
    public boolean visit(MySqlCharExpr x) {
        if (this.parameterized) {
            this.print('?');
            this.incrementReplaceCunt();
            if (this.parameters != null) {
                ExportParameterVisitorUtils.exportParameter((List<Object>)this.parameters, x);
            }
            return false;
        }
        this.print0(x.toString());
        return false;
    }

    @Override
    public void endVisit(MySqlCharExpr x) {
    }

    @Override
    public boolean visit(MySqlUnique x) {
        SQLExpr comment;
        if (x.isHasConstaint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "UNIQUE" : "unique");
        SQLName name = x.getName();
        if (name != null) {
            this.print(' ');
            name.accept(this);
        }
        if (x.getIndexType() != null) {
            this.print0(this.ucase ? " USING " : " using ");
            this.print0(x.getIndexType());
        }
        this.print0(" (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        SQLExpr keyBlockSize = x.getKeyBlockSize();
        if (keyBlockSize != null) {
            this.print0(this.ucase ? " KEY_BLOCK_SIZE = " : " key_block_size = ");
            keyBlockSize.accept(this);
        }
        if ((comment = x.getComment()) != null) {
            this.print0(" COMMENT ");
            comment.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MysqlForeignKey x) {
        if (x.isHasConstraint()) {
            this.print0(this.ucase ? "CONSTRAINT " : "constraint ");
            if (x.getName() != null) {
                x.getName().accept(this);
                this.print(' ');
            }
        }
        this.print0(this.ucase ? "FOREIGN KEY" : "foreign key");
        if (x.getIndexName() != null) {
            this.print(' ');
            x.getIndexName().accept(this);
        }
        this.print0(" (");
        this.printAndAccept(x.getReferencingColumns(), ", ");
        this.print(')');
        this.print0(this.ucase ? " REFERENCES " : " references ");
        x.getReferencedTableName().accept(this);
        this.print0(" (");
        this.printAndAccept(x.getReferencedColumns(), ", ");
        this.print(')');
        SQLForeignKeyImpl.Match match = x.getReferenceMatch();
        if (match != null) {
            this.print0(this.ucase ? " MATCH " : " match ");
            this.print0(this.ucase ? match.name : match.name_lcase);
        }
        if (x.getOnDelete() != null) {
            this.print0(this.ucase ? " ON DELETE " : " on delete ");
            this.print0(this.ucase ? x.getOnDelete().name : x.getOnDelete().name_lcase);
        }
        if (x.getOnUpdate() != null) {
            this.print0(this.ucase ? " ON UPDATE " : " on update ");
            this.print0(this.ucase ? x.getOnUpdate().name : x.getOnUpdate().name_lcase);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUnique x) {
    }

    @Override
    public boolean visit(MySqlAlterTableDiscardTablespace x) {
        this.print0(this.ucase ? "DISCARD TABLESPACE" : "discard tablespace");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableDiscardTablespace x) {
    }

    @Override
    public boolean visit(MySqlAlterTableImportTablespace x) {
        this.print0(this.ucase ? "IMPORT TABLESPACE" : "import tablespace");
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableImportTablespace x) {
    }

    @Override
    public boolean visit(SQLAssignItem x) {
        String tagetString = x.getTarget().toString();
        boolean mysqlSpecial = false;
        if ("mysql".equals(this.dbType)) {
            boolean bl = mysqlSpecial = "NAMES".equalsIgnoreCase(tagetString) || "CHARACTER SET".equalsIgnoreCase(tagetString) || "CHARSET".equalsIgnoreCase(tagetString);
        }
        if (!mysqlSpecial) {
            x.getTarget().accept(this);
            this.print0(" = ");
        } else {
            this.print0(this.ucase ? tagetString.toUpperCase() : tagetString.toLowerCase());
            this.print(' ');
        }
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(MySqlCreateTableStatement.TableSpaceOption x) {
        x.getName().accept(this);
        if (x.getStorage() != null) {
            this.print(' ');
            x.getStorage().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateTableStatement.TableSpaceOption x) {
    }

    @Override
    protected void visitAggreateRest(SQLAggregateExpr aggregateExpr) {
        Object value = (SQLOrderBy)aggregateExpr.getAttribute("ORDER BY");
        if (value != null) {
            this.print(' ');
            value.accept(this);
        }
        if ((value = aggregateExpr.getAttribute("SEPARATOR")) != null) {
            this.print0(this.ucase ? " SEPARATOR " : " separator ");
            ((SQLObject)value).accept(this);
        }
    }

    @Override
    public boolean visit(MySqlAnalyzeStatement x) {
        this.print0(this.ucase ? "ANALYZE " : "analyze ");
        if (x.isNoWriteToBinlog()) {
            this.print0(this.ucase ? "NO_WRITE_TO_BINLOG " : "no_write_to_binlog ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlAnalyzeStatement x) {
    }

    @Override
    public boolean visit(MySqlOptimizeStatement x) {
        this.print0(this.ucase ? "OPTIMIZE " : "optimize ");
        if (x.isNoWriteToBinlog()) {
            this.print0(this.ucase ? "NO_WRITE_TO_BINLOG " : "No_write_to_binlog ");
        }
        if (x.isLocal()) {
            this.print0(this.ucase ? "LOCAL " : "local ");
        }
        this.print0(this.ucase ? "TABLE " : "table ");
        this.printAndAccept(x.getTableSources(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlOptimizeStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterUserStatement x) {
        this.print0(this.ucase ? "ALTER USER" : "alter user");
        for (SQLExpr user : x.getUsers()) {
            this.print(' ');
            user.accept(this);
            this.print0(this.ucase ? " PASSWORD EXPIRE" : " password expire");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterUserStatement x) {
    }

    @Override
    public boolean visit(SQLSetStatement x) {
        SQLSetStatement.Option option;
        boolean printSet;
        boolean bl = printSet = x.getAttribute("parser.set") == Boolean.TRUE || !"oracle".equals(this.dbType);
        if (printSet) {
            this.print0(this.ucase ? "SET " : "set ");
        }
        if ((option = x.getOption()) != null) {
            this.print(option.name());
            this.print(' ');
        }
        if (option == SQLSetStatement.Option.PASSWORD) {
            this.print0("FOR ");
        }
        this.printAndAccept(x.getItems(), ", ");
        if (x.getHints() != null && x.getHints().size() > 0) {
            this.print(' ');
            this.printAndAccept(x.getHints(), " ");
        }
        return false;
    }

    @Override
    public boolean visit(MySqlHintStatement x) {
        List<SQLCommentHint> hints = x.getHints();
        for (SQLCommentHint hint : hints) {
            hint.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlHintStatement x) {
    }

    @Override
    public boolean visit(MySqlOrderingExpr x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(' ');
            this.print0(this.ucase ? x.getType().name : x.getType().name_lcase);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlOrderingExpr x) {
    }

    @Override
    public boolean visit(SQLBlockStatement x) {
        List<SQLParameter> parameters;
        SQLObject parent = x.getParent();
        String labelName = x.getLabelName();
        if (labelName != null && !labelName.equals("")) {
            this.print0(labelName);
            this.print0(": ");
        }
        if ((parameters = x.getParameters()).size() != 0) {
            ++this.indentCount;
            if (parent instanceof SQLCreateProcedureStatement) {
                this.printIndent();
            }
            if (!(parent instanceof SQLCreateProcedureStatement)) {
                this.print0(this.ucase ? "DECLARE" : "declare");
                this.println();
            }
            int size = parameters.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 != 0) {
                    this.println();
                }
                SQLParameter param = parameters.get(i2);
                this.visit(param);
                this.print(';');
            }
            --this.indentCount;
            this.println();
        }
        this.print0(this.ucase ? "BEGIN" : "begin");
        if (!x.isEndOfCommit()) {
            ++this.indentCount;
        } else {
            this.print(';');
        }
        this.println();
        List<SQLStatement> statementList = x.getStatementList();
        int size = statementList.size();
        for (int i3 = 0; i3 < size; ++i3) {
            if (i3 != 0) {
                this.println();
            }
            SQLStatement stmt = statementList.get(i3);
            stmt.accept(this);
        }
        if (!x.isEndOfCommit()) {
            --this.indentCount;
            this.println();
            this.print0(this.ucase ? "END" : "end");
            if (labelName != null && !labelName.equals("")) {
                this.print(' ');
                this.print0(labelName);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement x) {
        this.print0(this.ucase ? "IF " : "if ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        ++this.indentCount;
        this.println();
        List<SQLStatement> statements = x.getStatements();
        int size = statements.size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLStatement item = statements.get(i2);
            item.accept(this);
            if (i2 == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        for (SQLIfStatement.ElseIf iterable_element : x.getElseIfList()) {
            iterable_element.accept(this);
        }
        if (x.getElseItem() != null) {
            x.getElseItem().accept(this);
        }
        this.print0(this.ucase ? "END IF" : "end if");
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.ElseIf x) {
        this.print0(this.ucase ? "ELSE IF " : "else if ");
        x.getCondition().accept(this);
        this.print0(this.ucase ? " THEN" : " then");
        ++this.indentCount;
        this.println();
        int size = x.getStatements().size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLStatement item = x.getStatements().get(i2);
            item.accept(this);
            if (i2 == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        return false;
    }

    @Override
    public boolean visit(SQLIfStatement.Else x) {
        this.print0(this.ucase ? "ELSE " : "else ");
        ++this.indentCount;
        this.println();
        int size = x.getStatements().size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLStatement item = x.getStatements().get(i2);
            item.accept(this);
            if (i2 == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        return false;
    }

    @Override
    public boolean visit(MySqlCaseStatement x) {
        this.print0(this.ucase ? "CASE " : "case ");
        x.getCondition().accept(this);
        this.println();
        for (int i2 = 0; i2 < x.getWhenList().size(); ++i2) {
            x.getWhenList().get(i2).accept(this);
        }
        if (x.getElseItem() != null) {
            x.getElseItem().accept(this);
        }
        this.print0(this.ucase ? "END CASE" : "end case");
        return false;
    }

    @Override
    public void endVisit(MySqlCaseStatement x) {
    }

    @Override
    public boolean visit(MySqlDeclareStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.printAndAccept(x.getVarList(), ", ");
        return false;
    }

    @Override
    public void endVisit(MySqlDeclareStatement x) {
    }

    @Override
    public boolean visit(MySqlSelectIntoStatement x) {
        x.getSelect().accept(this);
        this.print0(this.ucase ? " INTO " : " into ");
        for (int i2 = 0; i2 < x.getVarList().size(); ++i2) {
            x.getVarList().get(i2).accept(this);
            if (i2 == x.getVarList().size() - 1) continue;
            this.print0(", ");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSelectIntoStatement x) {
    }

    @Override
    public boolean visit(MySqlCaseStatement.MySqlWhenStatement x) {
        this.print0(this.ucase ? "WHEN " : "when ");
        x.getCondition().accept(this);
        this.print0(" THEN");
        this.println();
        for (int i2 = 0; i2 < x.getStatements().size(); ++i2) {
            x.getStatements().get(i2).accept(this);
            if (i2 == x.getStatements().size() - 1) continue;
            this.println();
        }
        this.println();
        return false;
    }

    @Override
    public void endVisit(MySqlCaseStatement.MySqlWhenStatement x) {
    }

    @Override
    public boolean visit(SQLLoopStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "LOOP " : "loop ");
        ++this.indentCount;
        this.println();
        int size = x.getStatements().size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLStatement item = x.getStatements().get(i2);
            item.accept(this);
            if (i2 == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print0(this.ucase ? "END LOOP" : "end loop");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(" ");
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public boolean visit(MySqlLeaveStatement x) {
        this.print0(this.ucase ? "LEAVE " : "leave ");
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public void endVisit(MySqlLeaveStatement x) {
    }

    @Override
    public boolean visit(MySqlIterateStatement x) {
        this.print0(this.ucase ? "ITERATE " : "iterate ");
        this.print0(x.getLabelName());
        return false;
    }

    @Override
    public void endVisit(MySqlIterateStatement x) {
    }

    @Override
    public boolean visit(MySqlRepeatStatement x) {
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print0(x.getLabelName());
            this.print0(": ");
        }
        this.print0(this.ucase ? "REPEAT " : "repeat ");
        ++this.indentCount;
        this.println();
        int size = x.getStatements().size();
        for (int i2 = 0; i2 < size; ++i2) {
            SQLStatement item = x.getStatements().get(i2);
            item.accept(this);
            if (i2 == size - 1) continue;
            this.println();
        }
        --this.indentCount;
        this.println();
        this.print0(this.ucase ? "UNTIL " : "until ");
        x.getCondition().accept(this);
        this.println();
        this.print0(this.ucase ? "END REPEAT" : "end repeat");
        if (x.getLabelName() != null && !x.getLabelName().equals("")) {
            this.print(' ');
            this.print0(x.getLabelName());
        }
        return false;
    }

    @Override
    public void endVisit(MySqlRepeatStatement x) {
    }

    @Override
    public boolean visit(MySqlCursorDeclareStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.printExpr(x.getCursorName());
        this.print0(this.ucase ? " CURSOR FOR" : " cursor for");
        ++this.indentCount;
        this.println();
        x.getSelect().accept(this);
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(MySqlCursorDeclareStatement x) {
    }

    @Override
    public boolean visit(MySqlUpdateTableSource x) {
        MySqlUpdateStatement update = x.getUpdate();
        if (update != null) {
            update.accept0(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlUpdateTableSource x) {
    }

    @Override
    public boolean visit(MySqlAlterTableAlterColumn x) {
        this.print0(this.ucase ? "ALTER COLUMN " : "alter column ");
        x.getColumn().accept(this);
        if (x.getDefaultExpr() != null) {
            this.print0(this.ucase ? " SET DEFAULT " : " set default ");
            x.getDefaultExpr().accept(this);
        } else if (x.isDropDefault()) {
            this.print0(this.ucase ? " DROP DEFAULT" : " drop default");
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTableAlterColumn x) {
    }

    @Override
    public boolean visit(MySqlSubPartitionByKey x) {
        if (x.isLinear()) {
            this.print0(this.ucase ? "SUBPARTITION BY LINEAR KEY (" : "subpartition by linear key (");
        } else {
            this.print0(this.ucase ? "SUBPARTITION BY KEY (" : "subpartition by key (");
        }
        this.printAndAccept(x.getColumns(), ", ");
        this.print(')');
        if (x.getSubPartitionsCount() != null) {
            this.print0(this.ucase ? " SUBPARTITIONS " : " subpartitions ");
            x.getSubPartitionsCount().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSubPartitionByKey x) {
    }

    @Override
    public boolean visit(MySqlSubPartitionByList x) {
        this.print0(this.ucase ? "SUBPARTITION BY LIST " : "subpartition by list ");
        if (x.getExpr() != null) {
            this.print('(');
            x.getExpr().accept(this);
            this.print0(") ");
        } else {
            if (x.getColumns().size() == 1 && Boolean.TRUE.equals(x.getAttribute("ads.subPartitionList"))) {
                this.print('(');
            } else {
                this.print0(this.ucase ? "COLUMNS (" : "columns (");
            }
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        if (x.getOptions().size() != 0) {
            this.println();
            this.print0(this.ucase ? "SUBPARTITION OPTIONS (" : "subpartition options (");
            this.printAndAccept(x.getOptions(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(MySqlSubPartitionByList x) {
    }

    @Override
    public boolean visit(MySqlDeclareHandlerStatement x) {
        String handleType = x.getHandleType().name();
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.print0(this.ucase ? handleType : handleType.toLowerCase());
        this.print0(this.ucase ? " HANDLER FOR " : " handler for ");
        for (int i2 = 0; i2 < x.getConditionValues().size(); ++i2) {
            ConditionValue cv = x.getConditionValues().get(i2);
            if (cv.getType() == ConditionValue.ConditionType.SQLSTATE) {
                this.print0(this.ucase ? " SQLSTATE " : " sqlstate ");
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.MYSQL_ERROR_CODE) {
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.SELF) {
                this.print0(cv.getValue());
            } else if (cv.getType() == ConditionValue.ConditionType.SYSTEM) {
                this.print0(this.ucase ? cv.getValue().toUpperCase() : cv.getValue().toLowerCase());
            }
            if (i2 == x.getConditionValues().size() - 1) continue;
            this.print0(", ");
        }
        ++this.indentCount;
        this.println();
        x.getSpStatement().accept(this);
        --this.indentCount;
        return false;
    }

    @Override
    public void endVisit(MySqlDeclareHandlerStatement x) {
    }

    @Override
    public boolean visit(MySqlDeclareConditionStatement x) {
        this.print0(this.ucase ? "DECLARE " : "declare ");
        this.print0(x.getConditionName());
        this.print0(this.ucase ? " CONDITION FOR " : " condition for ");
        if (x.getConditionValue().getType() == ConditionValue.ConditionType.SQLSTATE) {
            this.print0(this.ucase ? "SQLSTATE " : "sqlstate ");
            this.print0(x.getConditionValue().getValue());
        } else {
            this.print0(x.getConditionValue().getValue());
        }
        this.println();
        return false;
    }

    @Override
    public void endVisit(MySqlDeclareConditionStatement x) {
    }

    @Override
    public boolean visit(SQLAlterTableDropColumnItem x) {
        for (int i2 = 0; i2 < x.getColumns().size(); ++i2) {
            if (i2 != 0) {
                this.print0(", ");
            }
            SQLName columnn = x.getColumns().get(i2);
            this.print0(this.ucase ? "DROP COLUMN " : "drop column ");
            columnn.accept(this);
            if (!x.isCascade()) continue;
            this.print0(this.ucase ? " CASCADE" : " cascade");
        }
        return false;
    }

    @Override
    public boolean visit(SQLCreateProcedureStatement x) {
        SQLName authid;
        if (x.isOrReplace()) {
            this.print0(this.ucase ? "CREATE OR REPLACE PROCEDURE " : "create or replace procedure ");
        } else {
            this.print0(this.ucase ? "CREATE PROCEDURE " : "create procedure ");
        }
        x.getName().accept(this);
        int paramSize = x.getParameters().size();
        this.print0(" (");
        if (paramSize > 0) {
            ++this.indentCount;
            this.println();
            for (int i2 = 0; i2 < paramSize; ++i2) {
                if (i2 != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = x.getParameters().get(i2);
                param.accept(this);
            }
            --this.indentCount;
            this.println();
        }
        this.print(')');
        if (x.isDeterministic()) {
            this.println();
            this.print(this.ucase ? "DETERMINISTIC" : "deterministic");
        }
        if (x.isContainsSql()) {
            this.println();
            this.print0(this.ucase ? "CONTAINS SQL" : "contains sql");
        }
        if (x.isNoSql()) {
            this.println();
            this.print(this.ucase ? "NO SQL" : "no sql");
        }
        if (x.isModifiesSqlData()) {
            this.println();
            this.print(this.ucase ? "MODIFIES SQL DATA" : "modifies sql data");
        }
        if ((authid = x.getAuthid()) != null) {
            this.println();
            this.print(this.ucase ? "SQL SECURITY " : "sql security ");
            authid.accept(this);
        }
        this.println();
        x.getBlock().accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCreateFunctionStatement x) {
        this.print0(this.ucase ? "CREATE FUNCTION " : "create function ");
        x.getName().accept(this);
        int paramSize = x.getParameters().size();
        if (paramSize > 0) {
            this.print0(" (");
            ++this.indentCount;
            this.println();
            for (int i2 = 0; i2 < paramSize; ++i2) {
                if (i2 != 0) {
                    this.print0(", ");
                    this.println();
                }
                SQLParameter param = x.getParameters().get(i2);
                param.accept(this);
            }
            --this.indentCount;
            this.println();
            this.print(')');
        }
        this.println();
        this.print(this.ucase ? "RETURNS " : "returns ");
        x.getReturnDataType().accept(this);
        if (x.isDeterministic()) {
            this.print(this.ucase ? " DETERMINISTIC" : " deterministic");
        }
        SQLStatement block = x.getBlock();
        this.println();
        block.accept(this);
        return false;
    }

    @Override
    public boolean visit(SQLCommentStatement x) {
        SQLCommentStatement.Type type = x.getType();
        SQLExprTableSource on = x.getOn();
        if (type == SQLCommentStatement.Type.TABLE) {
            this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
            on.accept(this);
            this.print0(this.ucase ? " COMMENT = " : " comment = ");
            x.getComment().accept(this);
        } else {
            SQLPropertyExpr propertyExpr = (SQLPropertyExpr)on.getExpr();
            SQLExpr table = propertyExpr.getOwner();
            String column = propertyExpr.getName();
            this.print0(this.ucase ? "ALTER TABLE " : "alter table ");
            this.printTableSourceExpr(table);
            this.print0(this.ucase ? " MODIFY COLUMN " : " modify column ");
            this.print(column);
            this.print0(this.ucase ? " COMMENT " : " comment ");
            x.getComment().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(MySqlFlushStatement x) {
        this.print0(this.ucase ? "FLUSH" : "flush");
        if (x.isNoWriteToBinlog()) {
            this.print0(this.ucase ? " NO_WRITE_TO_BINLOG" : " no_write_to_binlog");
        } else if (x.isLocal()) {
            this.print0(this.ucase ? " LOCAL" : " local");
        }
        if (x.isBinaryLogs()) {
            this.print0(this.ucase ? " BINARY LOGS" : " binary logs");
        }
        if (x.isDesKeyFile()) {
            this.print0(this.ucase ? " DES_KEY_FILE" : " des_key_file");
        }
        if (x.isEngineLogs()) {
            this.print0(this.ucase ? " ENGINE LOGS" : " engine logs");
        }
        if (x.isErrorLogs()) {
            this.print0(this.ucase ? " ERROR LOGS" : " error logs");
        }
        if (x.isGeneralLogs()) {
            this.print0(this.ucase ? " GENERAL LOGS" : " general logs");
        }
        if (x.isHots()) {
            this.print0(this.ucase ? " HOSTS" : " hosts");
        }
        if (x.isLogs()) {
            this.print0(this.ucase ? " LOGS" : " logs");
        }
        if (x.isPrivileges()) {
            this.print0(this.ucase ? " PRIVILEGES" : " privileges");
        }
        if (x.isOptimizerCosts()) {
            this.print0(this.ucase ? " OPTIMIZER_COSTS" : " optimizer_costs");
        }
        if (x.isQueryCache()) {
            this.print0(this.ucase ? " QUERY CACHE" : " query cache");
        }
        if (x.isRelayLogs()) {
            this.print0(this.ucase ? " RELAY LOGS" : " relay logs");
            SQLExpr channel = x.getRelayLogsForChannel();
            if (channel != null) {
                this.print(' ');
                channel.accept(this);
            }
        }
        if (x.isSlowLogs()) {
            this.print0(this.ucase ? " SLOW LOGS" : " slow logs");
        }
        if (x.isStatus()) {
            this.print0(this.ucase ? " STATUS" : " status");
        }
        if (x.isUserResources()) {
            this.print0(this.ucase ? " USER_RESOURCES" : " user_resources");
        }
        if (x.isTableOption()) {
            this.print0(this.ucase ? " TABLES" : " tables");
            List<SQLExprTableSource> tables = x.getTables();
            if (tables != null && tables.size() > 0) {
                this.print(' ');
                this.printAndAccept(tables, ", ");
            }
            if (x.isWithReadLock()) {
                this.print0(this.ucase ? " WITH READ LOCK" : " with read lock");
            }
            if (x.isForExport()) {
                this.print0(this.ucase ? " FOR EXPORT" : " for export");
            }
        }
        return false;
    }

    @Override
    public void endVisit(MySqlFlushStatement x) {
    }

    @Override
    public boolean visit(MySqlEventSchedule x) {
        int cnt = 0;
        if (x.getAt() != null) {
            this.print0(this.ucase ? "AT " : "at ");
            this.printExpr(x.getAt());
            ++cnt;
        }
        if (x.getEvery() != null) {
            this.print0(this.ucase ? "EVERY " : "every ");
            SQLIntervalExpr interval = (SQLIntervalExpr)x.getEvery();
            this.printExpr(interval.getValue());
            this.print(' ');
            this.print(interval.getUnit().name());
            ++cnt;
        }
        if (x.getStarts() != null) {
            if (cnt > 0) {
                this.print(' ');
            }
            this.print0(this.ucase ? "STARTS " : "starts ");
            this.printExpr(x.getStarts());
            ++cnt;
        }
        if (x.getEnds() != null) {
            if (cnt > 0) {
                this.print(' ');
            }
            this.print0(this.ucase ? "ENDS " : "ends ");
            this.printExpr(x.getEnds());
            ++cnt;
        }
        return false;
    }

    @Override
    public void endVisit(MySqlEventSchedule x) {
    }

    @Override
    public boolean visit(MySqlCreateEventStatement x) {
        SQLExpr comment;
        this.print0(this.ucase ? "CREATE " : "create ");
        SQLName definer = x.getDefiner();
        if (definer != null) {
            this.print0(this.ucase ? "DEFINER = " : "definer = ");
        }
        this.print0(this.ucase ? "EVENT " : "evnet ");
        if (x.isIfNotExists()) {
            this.print0(this.ucase ? "IF NOT EXISTS " : "if not exists ");
        }
        this.printExpr(x.getName());
        MySqlEventSchedule schedule = x.getSchedule();
        this.print0(this.ucase ? " ON SCHEDULE " : " on schedule ");
        schedule.accept(this);
        Boolean enable = x.getEnable();
        if (enable != null) {
            if (enable.booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
                if (x.isDisableOnSlave()) {
                    this.print0(this.ucase ? " ON SLAVE" : " on slave");
                }
            }
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        this.println();
        SQLStatement body2 = x.getEventBody();
        if (!(body2 instanceof SQLExprStatement)) {
            this.print0(this.ucase ? "DO" : "do");
            this.println();
        }
        body2.accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlCreateEventStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateAddLogFileGroupStatement x) {
        SQLExpr engine;
        SQLExpr comment;
        SQLExpr nodeGroup;
        SQLExpr redoBufferSize;
        SQLExpr undoBufferSize;
        this.print0(this.ucase ? "CREATE LOGFILE GROUP " : "create logfile group ");
        x.getName().accept(this);
        this.print(' ');
        this.print0(this.ucase ? "ADD UNDOFILE " : "add undofile ");
        this.printExpr(x.getAddUndoFile());
        SQLExpr initialSize = x.getInitialSize();
        if (initialSize != null) {
            this.print0(this.ucase ? " INITIAL_SIZE " : " initial_size ");
            this.printExpr(initialSize);
        }
        if ((undoBufferSize = x.getUndoBufferSize()) != null) {
            this.print0(this.ucase ? " UNDO_BUFFER_SIZE " : " undo_buffer_size ");
            this.printExpr(undoBufferSize);
        }
        if ((redoBufferSize = x.getRedoBufferSize()) != null) {
            this.print0(this.ucase ? " REDO_BUFFER_SIZE " : " redo_buffer_size ");
            this.printExpr(redoBufferSize);
        }
        if ((nodeGroup = x.getNodeGroup()) != null) {
            this.print0(this.ucase ? " NODEGROUP " : " nodegroup ");
            this.printExpr(nodeGroup);
        }
        if (x.isWait()) {
            this.print0(this.ucase ? " WAIT" : " wait");
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            this.printExpr(comment);
        }
        if ((engine = x.getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE " : " engine ");
            this.printExpr(engine);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateAddLogFileGroupStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateServerStatement x) {
        SQLExpr port;
        SQLExpr owner;
        SQLExpr socket;
        SQLExpr password;
        SQLExpr user;
        SQLExpr database;
        this.print0(this.ucase ? "CREATE SERVER " : "create server ");
        x.getName().accept(this);
        this.print0(this.ucase ? " FOREIGN DATA WRAPPER " : " foreign data wrapper ");
        this.printExpr(x.getForeignDataWrapper());
        this.print(" OPTIONS(");
        int cnt = 0;
        SQLExpr host = x.getHost();
        if (host != null) {
            this.print0(this.ucase ? "HOST " : "host ");
            this.printExpr(host);
            ++cnt;
        }
        if ((database = x.getDatabase()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "DATABASE " : "database ");
            this.printExpr(database);
        }
        if ((user = x.getUser()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "USER " : "user ");
            this.printExpr(user);
        }
        if ((password = x.getPassword()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "PASSWORD " : "password ");
            this.printExpr(password);
        }
        if ((socket = x.getSocket()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "SOCKET " : "socket ");
            this.printExpr(socket);
        }
        if ((owner = x.getOwner()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "OWNER " : "owner ");
            this.printExpr(owner);
        }
        if ((port = x.getPort()) != null) {
            if (cnt++ > 0) {
                this.print(", ");
            }
            this.print0(this.ucase ? "PORT " : "port ");
            this.printExpr(port);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlCreateServerStatement x) {
    }

    @Override
    public boolean visit(MySqlCreateTableSpaceStatement x) {
        SQLExpr engine;
        SQLExpr comment;
        SQLExpr nodeGroup;
        SQLExpr autoExtentSize;
        SQLExpr initialSize;
        SQLExpr extentSize;
        SQLExpr logFileGroup;
        SQLExpr fileBlockSize;
        this.print0(this.ucase ? "CREATE TABLESPACE " : "create tablespace ");
        x.getName().accept(this);
        SQLExpr addDataFile = x.getAddDataFile();
        if (addDataFile != null) {
            this.print0(this.ucase ? " ADD DATAFILE " : " add datafile ");
            addDataFile.accept(this);
        }
        if ((fileBlockSize = x.getFileBlockSize()) != null) {
            this.print0(this.ucase ? " FILE_BLOCK_SIZE = " : " file_block_size = ");
            fileBlockSize.accept(this);
        }
        if ((logFileGroup = x.getLogFileGroup()) != null) {
            this.print0(this.ucase ? " USE LOGFILE GROUP " : " use logfile group ");
            logFileGroup.accept(this);
        }
        if ((extentSize = x.getExtentSize()) != null) {
            this.print0(this.ucase ? " EXTENT_SIZE = " : " extent_size = ");
            extentSize.accept(this);
        }
        if ((initialSize = x.getInitialSize()) != null) {
            this.print0(this.ucase ? " INITIAL_SIZE = " : " initial_size = ");
            initialSize.accept(this);
        }
        if ((autoExtentSize = x.getAutoExtentSize()) != null) {
            this.print0(this.ucase ? " AUTOEXTEND_SIZE = " : " autoextend_size = ");
            autoExtentSize.accept(this);
        }
        SQLExpr maxSize = x.getMaxSize();
        if (autoExtentSize != null) {
            this.print0(this.ucase ? " MAX_SIZE = " : " max_size = ");
            maxSize.accept(this);
        }
        if ((nodeGroup = x.getNodeGroup()) != null) {
            this.print0(this.ucase ? " NODEGROUP = " : " nodegroup = ");
            nodeGroup.accept(this);
        }
        if (x.isWait()) {
            this.print0(this.ucase ? " WAIT" : " wait");
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? " COMMENT " : " comment ");
            this.printExpr(comment);
        }
        if ((engine = x.getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE " : " engine ");
            this.printExpr(engine);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlCreateTableSpaceStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterEventStatement x) {
        SQLStatement body2;
        SQLExpr comment;
        Boolean enable;
        this.print0(this.ucase ? "ALTER " : "alter ");
        SQLName definer = x.getDefiner();
        if (definer != null) {
            this.print0(this.ucase ? "DEFINER = " : "definer = ");
        }
        this.print0(this.ucase ? "EVENT " : "evnet ");
        this.printExpr(x.getName());
        MySqlEventSchedule schedule = x.getSchedule();
        if (schedule != null) {
            this.print0(this.ucase ? " ON SCHEDULE " : " on schedule ");
            schedule.accept(this);
        }
        if ((enable = x.getEnable()) != null) {
            if (enable.booleanValue()) {
                this.print0(this.ucase ? " ENABLE" : " enable");
            } else {
                this.print0(this.ucase ? " DISABLE" : " disable");
                if (x.isDisableOnSlave()) {
                    this.print0(this.ucase ? " ON SLAVE" : " on slave");
                }
            }
        }
        if ((comment = x.getComment()) != null) {
            this.print0(this.ucase ? "COMMENT " : "comment ");
            comment.accept(this);
        }
        if ((body2 = x.getEventBody()) != null) {
            this.println();
            if (!(body2 instanceof SQLExprStatement)) {
                this.print0(this.ucase ? "DO" : "do");
                this.println();
            }
            body2.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterEventStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterLogFileGroupStatement x) {
        SQLExpr engine;
        this.print0(this.ucase ? "ALTER LOGFILE GROUP " : "alter logfile group ");
        x.getName().accept(this);
        this.print(' ');
        this.print0(this.ucase ? "ADD UNDOFILE " : "add undofile ");
        this.printExpr(x.getAddUndoFile());
        SQLExpr initialSize = x.getInitialSize();
        if (initialSize != null) {
            this.print0(this.ucase ? " INITIAL_SIZE " : " initial_size ");
            this.printExpr(initialSize);
        }
        if (x.isWait()) {
            this.print0(this.ucase ? " WAIT" : " wait");
        }
        if ((engine = x.getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE " : " engine ");
            this.printExpr(engine);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterLogFileGroupStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterServerStatement x) {
        this.print0(this.ucase ? "ATLER SERVER " : "alter server ");
        x.getName().accept(this);
        this.print(" OPTIONS(");
        SQLExpr user = x.getUser();
        if (user != null) {
            this.print0(this.ucase ? "USER " : "user ");
            this.printExpr(user);
        }
        this.print(')');
        return false;
    }

    @Override
    public void endVisit(MySqlAlterServerStatement x) {
    }

    @Override
    public boolean visit(MySqlAlterTablespaceStatement x) {
        SQLExpr engine;
        SQLExpr initialSize;
        this.print0(this.ucase ? "CREATE TABLESPACE " : "create tablespace ");
        x.getName().accept(this);
        SQLExpr addDataFile = x.getAddDataFile();
        if (addDataFile != null) {
            this.print0(this.ucase ? " ADD DATAFILE " : " add datafile ");
            addDataFile.accept(this);
        }
        if ((initialSize = x.getInitialSize()) != null) {
            this.print0(this.ucase ? " INITIAL_SIZE = " : " initial_size = ");
            initialSize.accept(this);
        }
        if (x.isWait()) {
            this.print0(this.ucase ? " WAIT" : " wait");
        }
        if ((engine = x.getEngine()) != null) {
            this.print0(this.ucase ? " ENGINE " : " engine ");
            this.printExpr(engine);
        }
        return false;
    }

    @Override
    public void endVisit(MySqlAlterTablespaceStatement x) {
    }

    @Override
    public boolean visit(MySqlShowDatabasePartitionStatusStatement x) {
        this.print0(this.ucase ? "SHOW DATABASE PARTITION STATUS FOR " : "show database partition status for ");
        x.getDatabase().accept(this);
        return false;
    }

    @Override
    public void endVisit(MySqlShowDatabasePartitionStatusStatement x) {
    }

    @Override
    protected void printQuery(SQLSelectQuery x) {
        Class<?> clazz = x.getClass();
        if (clazz == MySqlSelectQueryBlock.class) {
            this.visit((MySqlSelectQueryBlock)x);
        } else if (clazz == SQLSelectQueryBlock.class) {
            this.visit((SQLSelectQueryBlock)x);
        } else if (clazz == SQLUnionQuery.class) {
            this.visit((SQLUnionQuery)x);
        } else {
            x.accept(this);
        }
    }

    @Override
    public void printInsertColumns(List<SQLExpr> columns) {
        int size = columns.size();
        if (size > 0) {
            if (size > 5) {
                ++this.indentCount;
                this.print(' ');
            }
            this.print('(');
            for (int i2 = 0; i2 < size; ++i2) {
                SQLExpr column;
                if (i2 != 0) {
                    if (i2 % 5 == 0) {
                        this.println();
                    }
                    this.print0(", ");
                }
                if ((column = columns.get(i2)) instanceof SQLIdentifierExpr) {
                    this.visit((SQLIdentifierExpr)column);
                } else {
                    this.printExpr(column);
                }
                String dataType = (String)column.getAttribute("dataType");
                if (dataType == null) continue;
                this.print(' ');
                this.print(dataType);
            }
            this.print(')');
            if (size > 5) {
                --this.indentCount;
            }
        }
    }

    @Override
    public void endVisit(MySqlChecksumTableStatement x) {
    }

    @Override
    public boolean visit(MySqlChecksumTableStatement x) {
        this.print0(this.ucase ? "CHECKSUM TABLE " : "checksum table ");
        this.printAndAccept(x.getTables(), "\uff0c");
        return false;
    }
}

