/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.mysql.visitor.transform;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLCreateViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitorAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FromSubqueryResolver
extends OracleASTVisitorAdapter {
    private final List<SQLStatement> targetList;
    private final String viewName;
    private final Map<String, String> mappings = new LinkedHashMap<String, String>();
    private int viewNameSeed = 1;

    public FromSubqueryResolver(List<SQLStatement> targetList, String viewName) {
        this.targetList = targetList;
        this.viewName = viewName;
    }

    @Override
    public boolean visit(OracleSelectSubqueryTableSource x) {
        return this.visit((SQLSubqueryTableSource)x);
    }

    @Override
    public boolean visit(SQLSubqueryTableSource x) {
        String subViewName = this.generateSubViewName();
        SQLObject parent = x.getParent();
        if (parent instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock queryBlock = (SQLSelectQueryBlock)parent;
            queryBlock.setFrom(subViewName, x.getAlias());
        } else if (parent instanceof SQLJoinTableSource) {
            SQLJoinTableSource join = (SQLJoinTableSource)parent;
            if (join.getLeft() == x) {
                join.setLeft(subViewName, x.getAlias());
            } else if (join.getRight() == x) {
                join.setRight(subViewName, x.getAlias());
            }
        }
        SQLCreateViewStatement stmt = new SQLCreateViewStatement();
        stmt.setName(this.generateSubViewName());
        SQLSelect select = x.getSelect();
        stmt.setSubQuery(select);
        this.targetList.add(0, stmt);
        stmt.accept(new FromSubqueryResolver(this.targetList, this.viewName));
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        SQLIdentifierExpr identifierExpr;
        String ident;
        String mappingIdent;
        SQLExpr expr = x.getExpr();
        if (expr instanceof SQLIdentifierExpr && (mappingIdent = this.mappings.get(ident = (identifierExpr = (SQLIdentifierExpr)expr).getName())) != null) {
            x.setExpr(new SQLIdentifierExpr(mappingIdent));
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        return this.visit((SQLExprTableSource)x);
    }

    private String generateSubViewName() {
        return this.viewName + "_" + this.targetList.size();
    }

    public static List<SQLStatement> resolve(SQLCreateViewStatement stmt) {
        ArrayList<SQLStatement> targetList = new ArrayList<SQLStatement>();
        targetList.add(stmt);
        String viewName = SQLUtils.normalize(stmt.getName().getSimpleName());
        FromSubqueryResolver visitor = new FromSubqueryResolver(targetList, viewName);
        SQLWithSubqueryClause withSubqueryClause = stmt.getSubQuery().getWithSubQuery();
        if (withSubqueryClause != null) {
            stmt.getSubQuery().setWithSubQuery(null);
            for (SQLWithSubqueryClause.Entry entry : withSubqueryClause.getEntries()) {
                String entryName = entry.getAlias();
                SQLCreateViewStatement entryStmt = new SQLCreateViewStatement();
                entryStmt.setOrReplace(true);
                entryStmt.setDbType(stmt.getDbType());
                String entryViewName = visitor.generateSubViewName();
                entryStmt.setName(entryViewName);
                entryStmt.setSubQuery(entry.getSubQuery());
                visitor.targetList.add(0, entryStmt);
                visitor.mappings.put(entryName, entryViewName);
                entryStmt.accept(visitor);
            }
        }
        stmt.accept(visitor);
        String dbType = stmt.getDbType();
        for (int i2 = 0; i2 < targetList.size() - 1; ++i2) {
            SQLCreateViewStatement targetStmt = (SQLCreateViewStatement)targetList.get(i2);
            targetStmt.setOrReplace(true);
            targetStmt.setDbType(dbType);
            targetStmt.setAfterSemi(true);
        }
        return targetList;
    }
}

