/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.jconsole.model;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

final class RowHeaderRenderer
extends JLabel
implements TableCellRenderer,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JTable refTable;
    private JTable tableShow;
    private ArrayList<String> headerList;
    private int rowHeightNow;
    private int rowSpan;

    public RowHeaderRenderer(JTable refTable, JTable tableShow) {
        this(null, refTable, tableShow, 0);
    }

    public RowHeaderRenderer(ArrayList<String> headerList, JTable refTable, JTable tableShow, int rowSpan) {
        this.headerList = headerList;
        this.refTable = refTable;
        this.tableShow = tableShow;
        ListSelectionModel listModel = refTable.getSelectionModel();
        listModel.addListSelectionListener(this);
        this.rowHeightNow = refTable.getRowCount() * refTable.getRowHeight();
        this.rowSpan = rowSpan;
        if (rowSpan > 1) {
            this.rowHeightNow = rowSpan * refTable.getRowHeight();
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int col) {
        int rowCountNow = this.refTable.getRowCount() / this.rowSpan;
        ((DefaultTableModel)table.getModel()).setRowCount(rowCountNow);
        JTableHeader header2 = this.refTable.getTableHeader();
        this.setOpaque(true);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        this.setHorizontalAlignment(0);
        this.setBackground(header2.getBackground());
        if (this.isSelect(row)) {
            this.setForeground(Color.white);
            this.setBackground(Color.lightGray);
        } else {
            this.setForeground(header2.getForeground());
        }
        this.setFont(header2.getFont());
        if (row <= rowCountNow) {
            this.showCol(row);
        }
        return this;
    }

    private void showCol(int row) {
        String text = null;
        text = this.headerList != null && row < this.headerList.size() ? this.headerList.get(row) : String.valueOf(row + 1);
        if (this.rowSpan > 1) {
            this.setText(text);
            this.tableShow.setRowHeight(row, this.rowHeightNow);
        } else {
            this.setText(text);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.tableShow.repaint();
    }

    private boolean isSelect(int row) {
        int[] sel = this.refTable.getSelectedRows();
        if (this.rowSpan <= 1) {
            for (int item : sel) {
                if (item != row) continue;
                return true;
            }
        } else {
            for (int item : sel) {
                if (item / this.rowSpan != row) continue;
                return true;
            }
        }
        return false;
    }
}

