/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.monitor.dao;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.pool.DruidDataSourceStatValue;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.support.http.stat.WebAppStatValue;
import com.alibaba.druid.support.http.stat.WebURIStatValue;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.support.monitor.MonitorContext;
import com.alibaba.druid.support.monitor.annotation.AggregateType;
import com.alibaba.druid.support.monitor.annotation.MField;
import com.alibaba.druid.support.monitor.annotation.MTable;
import com.alibaba.druid.support.monitor.dao.MonitorDao;
import com.alibaba.druid.support.monitor.entity.MonitorApp;
import com.alibaba.druid.support.monitor.entity.MonitorCluster;
import com.alibaba.druid.support.monitor.entity.MonitorInstance;
import com.alibaba.druid.support.spring.stat.SpringMethodStatValue;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import com.alibaba.druid.wall.WallFunctionStatValue;
import com.alibaba.druid.wall.WallProviderStatValue;
import com.alibaba.druid.wall.WallSqlStatValue;
import com.alibaba.druid.wall.WallTableStatValue;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;

public class MonitorDaoJdbcImpl
implements MonitorDao {
    private static final Log LOG = LogFactory.getLog(MonitorDaoJdbcImpl.class);
    private DataSource dataSource;
    private BeanInfo dataSourceStatBeanInfo = new BeanInfo(DruidDataSourceStatValue.class);
    private BeanInfo sqlStatBeanInfo = new BeanInfo(JdbcSqlStatValue.class);
    private BeanInfo springMethodStatBeanInfo = new BeanInfo(SpringMethodStatValue.class);
    private BeanInfo webURIStatBeanInfo = new BeanInfo(WebURIStatValue.class);
    private BeanInfo webAppStatBeanInfo = new BeanInfo(WebAppStatValue.class);
    private BeanInfo wallProviderStatBeanInfo = new BeanInfo(WallProviderStatValue.class);
    private BeanInfo wallSqlStatBeanInfo = new BeanInfo(WallSqlStatValue.class);
    private BeanInfo wallTableStatBeanInfo = new BeanInfo(WallTableStatValue.class);
    private BeanInfo wallFunctionStatBeanInfo = new BeanInfo(WallFunctionStatValue.class);
    private ConcurrentMap<String, ConcurrentMap<Long, String>> cacheMap = new ConcurrentHashMap<String, ConcurrentMap<Long, String>>();

    public void createTables(String dbType) {
        String[] resources2;
        for (String item : resources2 = new String[]{"basic.sql", "const.sql", "datasource.sql", "springmethod.sql", "sql.sql", "webapp.sql", "weburi.sql", "wall.sql"}) {
            String path = "/support/monitor/" + dbType + "/" + item;
            try {
                String[] sqls;
                String text = Utils.readFromResource(path);
                for (String sql : sqls = text.split(";")) {
                    JdbcUtils.execute(this.dataSource, sql, new Object[0]);
                }
            }
            catch (Exception ex) {
                LOG.error("create table error", ex);
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void saveSql(MonitorContext ctx, List<DruidDataSourceStatValue> dataSourceList) {
        this.save(this.dataSourceStatBeanInfo, ctx, dataSourceList);
        for (DruidDataSourceStatValue dataSourceStatValue : dataSourceList) {
            List<JdbcSqlStatValue> sqlList = dataSourceStatValue.getSqlList();
            this.save(this.sqlStatBeanInfo, ctx, sqlList);
        }
    }

    @Override
    public void saveSpringMethod(MonitorContext ctx, List<SpringMethodStatValue> list) {
        this.save(this.springMethodStatBeanInfo, ctx, list);
    }

    @Override
    public void saveWebURI(MonitorContext ctx, List<WebURIStatValue> list) {
        this.save(this.webURIStatBeanInfo, ctx, list);
    }

    @Override
    public void saveSqlWall(MonitorContext ctx, List<WallProviderStatValue> statList) {
        this.save(this.wallProviderStatBeanInfo, ctx, statList);
        for (WallProviderStatValue providerStat : statList) {
            this.save(this.wallSqlStatBeanInfo, ctx, providerStat.getWhiteList());
            this.save(this.wallSqlStatBeanInfo, ctx, providerStat.getBlackList());
            this.save(this.wallTableStatBeanInfo, ctx, providerStat.getTables());
            this.save(this.wallFunctionStatBeanInfo, ctx, providerStat.getFunctions());
        }
    }

    @Override
    public void saveWebApp(MonitorContext ctx, List<WebAppStatValue> list) {
        this.save(this.webAppStatBeanInfo, ctx, list);
    }

    @Override
    public List<JdbcSqlStatValue> loadSqlList(Map<String, Object> filters) {
        return this.load(this.sqlStatBeanInfo, filters);
    }

    static Integer getInteger(Map<String, Object> filters, String key) {
        Object value = filters.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            if (StringUtils.isEmpty(text)) {
                return null;
            }
            return Integer.parseInt(text);
        }
        return null;
    }

    static Date getDate(Map<String, Object> filters, String key) {
        Object value = filters.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            long millis = ((Number)value).longValue();
            return new Date(millis);
        }
        if (value instanceof String) {
            String text = (String)value;
            if (StringUtils.isEmpty(text)) {
                return null;
            }
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(text);
            }
            catch (ParseException e) {
                LOG.error("parse filter error", e);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> load(BeanInfo beanInfo, Map<String, Object> filters) {
        Integer pid;
        String host;
        String cluster;
        String app;
        String domain;
        Date endTime;
        ArrayList<Object> list = new ArrayList<Object>();
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        List<FieldInfo> fields = beanInfo.getFields();
        block8: for (int i2 = 0; i2 < fields.size(); ++i2) {
            FieldInfo fieldInfo = fields.get(i2);
            if (i2 != 0) {
                buf.append(", ");
            }
            AggregateType aggregateType = fieldInfo.getField().getAnnotation(MField.class).aggregate();
            switch (aggregateType) {
                case Sum: {
                    buf.append("SUM(");
                    buf.append(fieldInfo.getColumnName());
                    buf.append(")");
                    continue block8;
                }
                case Max: {
                    buf.append("MAX(");
                    buf.append(fieldInfo.getColumnName());
                    buf.append(")");
                    continue block8;
                }
                default: {
                    buf.append(fieldInfo.getColumnName());
                }
            }
        }
        buf.append("\nFROM ");
        buf.append(this.getTableName(beanInfo));
        buf.append("\nWHERE collectTime >= ? AND collectTime <= ? AND domain = ? AND app = ? AND cluster = ?");
        Date startTime = MonitorDaoJdbcImpl.getDate(filters, "startTime");
        if (startTime == null) {
            long now = System.currentTimeMillis();
            startTime = new Date(now - 1800000L);
        }
        if ((endTime = MonitorDaoJdbcImpl.getDate(filters, "endTime")) == null) {
            endTime = new Date();
        }
        if (StringUtils.isEmpty(domain = (String)filters.get("domain"))) {
            domain = "default";
        }
        if (StringUtils.isEmpty(app = (String)filters.get("app"))) {
            app = "default";
        }
        if (StringUtils.isEmpty(cluster = (String)filters.get("cluster"))) {
            cluster = "default";
        }
        if (!StringUtils.isEmpty(host = (String)filters.get("host"))) {
            buf.append("\nAND host = ?");
        }
        if ((pid = MonitorDaoJdbcImpl.getInteger(filters, "pid")) != null) {
            buf.append("\nAND pid = ?");
        }
        List<FieldInfo> groupByFields = beanInfo.getGroupByFields();
        for (int i3 = 0; i3 < groupByFields.size(); ++i3) {
            if (i3 == 0) {
                buf.append("\nGROUP BY ");
            } else {
                buf.append(", ");
            }
            FieldInfo fieldInfo = groupByFields.get(i3);
            buf.append(fieldInfo.getColumnName());
        }
        Integer offset = (Integer)filters.get("offset");
        Integer limit = (Integer)filters.get("limit");
        if (limit == null) {
            limit = 1000;
        }
        buf.append("\nLIMIT ");
        if (offset != null) {
            buf.append(offset);
            buf.append(", ");
        }
        buf.append(limit);
        String sql = buf.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            int paramIndex = 1;
            stmt.setTimestamp(paramIndex++, new Timestamp(startTime.getTime()));
            stmt.setTimestamp(paramIndex++, new Timestamp(endTime.getTime()));
            stmt.setString(paramIndex++, domain);
            stmt.setString(paramIndex++, app);
            stmt.setString(paramIndex++, cluster);
            if (!StringUtils.isEmpty(host)) {
                stmt.setString(paramIndex++, host);
            }
            if (pid != null) {
                stmt.setInt(paramIndex++, pid);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                Object object = this.createInstance(beanInfo);
                for (int i4 = 0; i4 < fields.size(); ++i4) {
                    FieldInfo field = fields.get(i4);
                    this.readFieldValue(object, field, rs, i4 + 1);
                }
                list.add(object);
            }
            stmt.close();
        }
        catch (SQLException ex) {
            try {
                LOG.error("save sql error", ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        for (FieldInfo hashField : beanInfo.getHashFields()) {
            this.loadHashValue(hashField, list, filters);
        }
        return list;
    }

    protected void readFieldValue(Object object, FieldInfo field, ResultSet rs, int paramIndex) throws SQLException {
        Class<?> fieldType = field.getFieldType();
        Object fieldValue = null;
        if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
            fieldValue = rs.getInt(paramIndex);
        } else if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
            fieldValue = rs.getLong(paramIndex);
        } else if (fieldType.equals(String.class)) {
            fieldValue = rs.getString(paramIndex);
        } else if (fieldType.equals(Date.class)) {
            Timestamp timestamp = rs.getTimestamp(paramIndex);
            if (timestamp != null) {
                fieldValue = new Date(timestamp.getTime());
            }
        } else {
            throw new UnsupportedOperationException();
        }
        try {
            field.getField().set(object, fieldValue);
        }
        catch (IllegalArgumentException e) {
            throw new DruidRuntimeException("set field error" + field.getField(), e);
        }
        catch (IllegalAccessException e) {
            throw new DruidRuntimeException("set field error" + field.getField(), e);
        }
    }

    private void loadHashValue(FieldInfo hashField, List<?> list, Map<String, Object> filters) {
        String app;
        String domain = (String)filters.get("domain");
        if (StringUtils.isEmpty(domain)) {
            domain = "default";
        }
        if (StringUtils.isEmpty(app = (String)filters.get("app"))) {
            app = "default";
        }
        for (Object statValue : list) {
            try {
                Long hash = (Long)hashField.field.get(statValue);
                String value = this.cacheGet(hashField.getHashForType(), hash);
                if (value == null) {
                    value = this.getConstValueFromDb(domain, app, hashField.getHashForType(), hash);
                }
                hashField.getHashFor().set(statValue, value);
            }
            catch (IllegalArgumentException e) {
                throw new DruidRuntimeException("set field error" + hashField.getField(), e);
            }
            catch (IllegalAccessException e) {
                throw new DruidRuntimeException("set field error" + hashField.getField(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getConstValueFromDb(String domain, String app, String type, Long hash) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block4: {
            String string;
            String sql = "select value from druid_const where domain = ? AND app = ? and type = ? and hash = ?";
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, domain);
                stmt.setString(2, app);
                stmt.setString(3, type);
                stmt.setLong(4, hash);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                string = rs.getString(1);
            }
            catch (SQLException ex) {
                try {
                    LOG.error("save const error error", ex);
                }
                catch (Throwable throwable) {
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    JdbcUtils.close(conn);
                    throw throwable;
                }
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            return string;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveHash(FieldInfo hashField, MonitorContext ctx, List<?> list) {
        String hashType = hashField.getHashForType();
        for (Object statValue : list) {
            try {
                Long hash = (Long)hashField.field.get(statValue);
                if (this.cacheContains(hashField.getHashForType(), hash)) continue;
                String value = (String)hashField.getHashFor().get(statValue);
                String sql = "insert into druid_const (domain, app, type, hash, value) values (?, ?, ?, ?, ?)";
                Connection conn = null;
                PreparedStatement stmt = null;
                try {
                    conn = this.dataSource.getConnection();
                    stmt = conn.prepareStatement("insert into druid_const (domain, app, type, hash, value) values (?, ?, ?, ?, ?)");
                    stmt.setString(1, ctx.getDomain());
                    stmt.setString(2, ctx.getApp());
                    stmt.setString(3, hashType);
                    stmt.setLong(4, hash);
                    stmt.setString(5, value);
                    stmt.execute();
                    stmt.close();
                }
                catch (SQLException sQLException) {
                    JdbcUtils.close(stmt);
                    JdbcUtils.close(conn);
                    catch (Throwable throwable) {
                        JdbcUtils.close(stmt);
                        JdbcUtils.close(conn);
                        throw throwable;
                    }
                }
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                this.cachePut(hashField.getHashForType(), hash, value);
            }
            catch (IllegalArgumentException e) {
                throw new DruidRuntimeException("set field error" + hashField.getField(), e);
            }
            catch (IllegalAccessException e) {
                throw new DruidRuntimeException("set field error" + hashField.getField(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(BeanInfo beanInfo, MonitorContext ctx, List<?> list) {
        if (list.size() == 0) {
            return;
        }
        for (FieldInfo hashField : beanInfo.getHashFields()) {
            this.saveHash(hashField, ctx, list);
        }
        String sql = this.buildInsertSql(beanInfo);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            for (Object statValue : list) {
                this.setParameterForSqlStat(beanInfo, ctx, stmt, statValue);
                stmt.addBatch();
            }
            stmt.executeBatch();
            stmt.close();
        }
        catch (SQLException ex) {
            try {
                LOG.error("save sql error", ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
        }
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
    }

    protected void setParameterForSqlStat(BeanInfo beanInfo, MonitorContext ctx, PreparedStatement stmt, Object sqlStat) throws SQLException {
        int paramIndex = 1;
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getDomain());
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getApp());
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getCluster());
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getHost());
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getPID());
        MonitorDaoJdbcImpl.setParam(stmt, paramIndex++, ctx.getCollectTime());
        try {
            List<FieldInfo> fields = beanInfo.getFields();
            for (FieldInfo field : fields) {
                Class<?> fieldType = field.getFieldType();
                Object value = field.getField().get(sqlStat);
                if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                    MonitorDaoJdbcImpl.setParam(stmt, paramIndex, (Integer)value);
                } else if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                    MonitorDaoJdbcImpl.setParam(stmt, paramIndex, (Long)value);
                } else if (fieldType.equals(String.class)) {
                    MonitorDaoJdbcImpl.setParam(stmt, paramIndex, (String)value);
                } else if (fieldType.equals(Date.class)) {
                    MonitorDaoJdbcImpl.setParam(stmt, paramIndex, (Date)value);
                } else if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                    MonitorDaoJdbcImpl.setParam(stmt, paramIndex, (Boolean)value);
                } else {
                    throw new UnsupportedOperationException("not support type : " + fieldType);
                }
                ++paramIndex;
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DruidRuntimeException("setParam error", ex);
        }
    }

    public Object createInstance(BeanInfo beanInfo) {
        try {
            return beanInfo.getClazz().newInstance();
        }
        catch (InstantiationException ex) {
            throw new DruidRuntimeException("create instance error", ex);
        }
        catch (IllegalAccessException ex) {
            throw new DruidRuntimeException("create instance error", ex);
        }
    }

    public String buildInsertSql(BeanInfo beanInfo) {
        String sql = beanInfo.insertSql;
        if (sql != null) {
            return sql;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("INSERT INTO ").append(this.getTableName(beanInfo));
        buf.append(" (domain, app, cluster, host, pid, collectTime");
        List<FieldInfo> fields = beanInfo.getFields();
        for (FieldInfo field : fields) {
            buf.append(", ");
            buf.append(field.getColumnName());
        }
        buf.append(")\nVALUES (?, ?, ?, ?, ?, ?");
        for (int i2 = 0; i2 < fields.size(); ++i2) {
            buf.append(", ?");
        }
        buf.append(")");
        sql = buf.toString();
        beanInfo.setInsertSql(sql);
        return sql;
    }

    public String getTableName(BeanInfo beanInfo) {
        return beanInfo.getTableName();
    }

    protected long getSqlHash(String sql) {
        return Utils.fnv_64(sql);
    }

    static void setParam(PreparedStatement stmt, int paramIndex, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 12);
        } else {
            stmt.setString(paramIndex, value);
        }
    }

    static void setParam(PreparedStatement stmt, int paramIndex, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 16);
        } else {
            stmt.setBoolean(paramIndex, value);
        }
    }

    static void setParam(PreparedStatement stmt, int paramIndex, Long value) throws SQLException {
        if (value == null || value == 0L) {
            stmt.setNull(paramIndex, -5);
        } else {
            stmt.setLong(paramIndex, value);
        }
    }

    static void setParam(PreparedStatement stmt, int paramIndex, Integer value) throws SQLException {
        if (value == null || value == 0) {
            stmt.setNull(paramIndex, 4);
        } else {
            stmt.setInt(paramIndex, value);
        }
    }

    static void setParam(PreparedStatement stmt, int paramIndex, Date value) throws SQLException {
        if (value == null) {
            stmt.setNull(paramIndex, 93);
        } else {
            stmt.setTimestamp(paramIndex, new Timestamp(value.getTime()));
        }
    }

    public boolean cacheContains(String type, Long hash) {
        Map cache = (Map)this.cacheMap.get(type);
        if (cache == null) {
            return false;
        }
        return cache.containsKey(hash);
    }

    public String cacheGet(String type, Long hash) {
        Map cache = (Map)this.cacheMap.get(type);
        if (cache == null) {
            return null;
        }
        return (String)cache.get(hash);
    }

    public void cachePut(String type, Long hash, String value) {
        ConcurrentMap cache = (ConcurrentMap)this.cacheMap.get(type);
        if (cache == null) {
            this.cacheMap.putIfAbsent(type, new ConcurrentHashMap(16, 0.75f, 1));
            cache = (ConcurrentMap)this.cacheMap.get(type);
        }
        cache.putIfAbsent(hash, value);
    }

    @Override
    public void insertAppIfNotExits(String domain, String app) throws SQLException {
        MonitorApp monitorApp = this.findApp(domain, app);
        if (monitorApp != null) {
            return;
        }
        String sql = "insert druid_app (domain, app) values (?, ?)";
        JdbcUtils.execute(this.dataSource, sql, domain, app);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorApp> listApp(String domain) throws SQLException {
        ArrayList<MonitorApp> arrayList;
        ArrayList<MonitorApp> list = new ArrayList<MonitorApp>();
        String sql = "select id, domain, app from druid_app  where domain = ?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, domain);
            rs = stmt.executeQuery();
            if (rs.next()) {
                list.add(this.readApp(rs));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorApp findApp(String domain, String app) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            MonitorApp monitorApp;
            String sql = "select id, domain, app from druid_app  where domain = ? and app = ?";
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, domain);
                stmt.setString(2, app);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                monitorApp = this.readApp(rs);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            return monitorApp;
        }
        MonitorApp monitorApp = null;
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return monitorApp;
    }

    private MonitorApp readApp(ResultSet rs) throws SQLException {
        MonitorApp app = new MonitorApp();
        app.setId(rs.getLong(1));
        app.setDomain(rs.getString(2));
        app.setApp(rs.getString(3));
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorCluster> listCluster(String domain, String app) throws SQLException {
        ArrayList<MonitorCluster> arrayList;
        ArrayList<MonitorCluster> list = new ArrayList<MonitorCluster>();
        String sql = "select id, domain, app, cluster from druid_cluster  where domain = ?";
        if (app != null) {
            sql = sql + " and app = ?";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, domain);
            if (app != null) {
                stmt.setString(2, app);
            }
            if ((rs = stmt.executeQuery()).next()) {
                list.add(this.readCluster(rs));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    @Override
    public void insertClusterIfNotExits(String domain, String app, String cluster) throws SQLException {
        MonitorCluster monitorApp = this.findCluster(domain, app, cluster);
        if (monitorApp != null) {
            return;
        }
        String sql = "insert druid_cluster (domain, app, cluster) values (?, ?, ?)";
        JdbcUtils.execute(this.dataSource, sql, domain, app, cluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorCluster findCluster(String domain, String app, String cluster) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            MonitorCluster monitorCluster;
            String sql = "select id, domain, app, cluster from druid_cluster  where domain = ? and app = ? and cluster = ?";
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, domain);
                stmt.setString(2, app);
                stmt.setString(3, cluster);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                monitorCluster = this.readCluster(rs);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            return monitorCluster;
        }
        MonitorCluster monitorCluster = null;
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return monitorCluster;
    }

    private MonitorCluster readCluster(ResultSet rs) throws SQLException {
        MonitorCluster app = new MonitorCluster();
        app.setId(rs.getLong(1));
        app.setDomain(rs.getString(2));
        app.setApp(rs.getString(3));
        app.setCluster(rs.getString(4));
        return app;
    }

    @Override
    public void insertOrUpdateInstance(String domain, String app, String cluster, String host, String ip, Date startTime, long pid) throws SQLException {
        MonitorInstance monitorInst = this.findInst(domain, app, cluster, host);
        if (monitorInst == null) {
            String sql = "insert into druid_inst (domain, app, cluster, host, ip, lastActiveTime, lastPID)  values (?, ?, ?, ?, ?, ?, ?)";
            JdbcUtils.execute(this.dataSource, sql, domain, app, cluster, host, ip, startTime, pid);
        } else {
            String sql = "update druid_inst set ip = ?, lastActiveTime = ?, lastPID = ?  where domain = ? and app = ? and cluster = ? and host = ? ";
            JdbcUtils.execute(this.dataSource, sql, ip, startTime, pid, domain, app, cluster, host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MonitorInstance findInst(String domain, String app, String cluster, String host) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block3: {
            MonitorInstance monitorInstance;
            String sql = "select id, domain, app, cluster, host, ip, lastActiveTime, lastPID from druid_inst  where domain = ? and app = ? and cluster = ? and host = ?  limit 1";
            conn = null;
            stmt = null;
            rs = null;
            try {
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, domain);
                stmt.setString(2, app);
                stmt.setString(3, cluster);
                stmt.setString(4, host);
                rs = stmt.executeQuery();
                if (!rs.next()) break block3;
                monitorInstance = this.readInst(rs);
            }
            catch (Throwable throwable) {
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                JdbcUtils.close(conn);
                throw throwable;
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            return monitorInstance;
        }
        MonitorInstance monitorInstance = null;
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return monitorInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MonitorInstance> listInst(String domain, String app, String cluster) throws SQLException {
        ArrayList<MonitorInstance> arrayList;
        ArrayList<MonitorInstance> list = new ArrayList<MonitorInstance>();
        String sql = "select id, domain, app, cluster, host, ip, lastActiveTime, lastPID from druid_inst where domain = ?";
        if (app != null) {
            sql = sql + " and app = ?";
        }
        if (cluster != null) {
            sql = sql + " and cluster = ?";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            int paramIndex = 1;
            stmt.setString(paramIndex++, domain);
            if (app != null) {
                stmt.setString(paramIndex++, app);
            }
            if (cluster != null) {
                stmt.setString(paramIndex++, cluster);
            }
            if ((rs = stmt.executeQuery()).next()) {
                list.add(this.readInst(rs));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            JdbcUtils.close(conn);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        JdbcUtils.close(conn);
        return arrayList;
    }

    private MonitorInstance readInst(ResultSet rs) throws SQLException {
        MonitorInstance inst = new MonitorInstance();
        inst.setId(rs.getLong(1));
        inst.setDomain(rs.getString(2));
        inst.setApp(rs.getString(3));
        inst.setCluster(rs.getString(4));
        inst.setHost(rs.getString(5));
        inst.setIp(rs.getString(6));
        inst.setLastActiveTime(rs.getTimestamp(7));
        inst.setLastPID(rs.getLong(8));
        return inst;
    }

    public static class FieldInfo {
        private final Field field;
        private final String columnName;
        private final Field hashFor;
        private final String hashForType;

        public FieldInfo(Field field, String columnName, Field hashFor, String hashForType) {
            this.field = field;
            this.columnName = columnName;
            this.hashFor = hashFor;
            this.hashForType = hashForType;
            field.setAccessible(true);
            if (hashFor != null) {
                hashFor.setAccessible(true);
            }
        }

        public String getHashForType() {
            return this.hashForType;
        }

        public Field getField() {
            return this.field;
        }

        public Field getHashFor() {
            return this.hashFor;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getFieldType() {
            return this.field.getType();
        }
    }

    public static class BeanInfo {
        private final Class<?> clazz;
        private final List<FieldInfo> fields = new ArrayList<FieldInfo>();
        private final List<FieldInfo> groupByFields = new ArrayList<FieldInfo>();
        private final List<FieldInfo> hashFields = new ArrayList<FieldInfo>();
        private final String tableName;
        private String insertSql;

        public BeanInfo(Class<?> clazz) {
            this.clazz = clazz;
            MTable annotation = clazz.getAnnotation(MTable.class);
            if (annotation == null) {
                throw new IllegalArgumentException(clazz.getName() + " not contains @MTable");
            }
            this.tableName = annotation.name();
            for (Field field : clazz.getDeclaredFields()) {
                MField annotation2 = field.getAnnotation(MField.class);
                if (annotation2 == null) continue;
                String columnName = annotation2.name();
                if (StringUtils.isEmpty(columnName)) {
                    columnName = field.getName();
                }
                Field hashFor = null;
                String hashForType = null;
                if (!StringUtils.isEmpty(annotation2.hashFor())) {
                    try {
                        hashFor = clazz.getDeclaredField(annotation2.hashFor());
                        hashForType = annotation2.hashForType();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("hashFor error", e);
                    }
                }
                FieldInfo fieldInfo = new FieldInfo(field, columnName, hashFor, hashForType);
                this.fields.add(fieldInfo);
                if (annotation2.groupBy()) {
                    this.groupByFields.add(fieldInfo);
                }
                if (hashFor == null) continue;
                this.hashFields.add(fieldInfo);
            }
        }

        public String getTableName() {
            return this.tableName;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public String getInsertSql() {
            return this.insertSql;
        }

        public void setInsertSql(String insertSql) {
            this.insertSql = insertSql;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<FieldInfo> getGroupByFields() {
            return this.groupByFields;
        }

        public List<FieldInfo> getHashFields() {
            return this.hashFields;
        }
    }
}

