/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

public final class HexBin {
    private static final int BASE_LENGTH = 128;
    private static final int LOOKUP_LENGTH = 16;
    private static final byte[] HEX_NUMBER_TABLE;
    private static final char[] UPPER_CHARS;
    private static final char[] LOWER_CHARS;

    public static String encode(byte[] bytes) {
        return HexBin.encode(bytes, true);
    }

    public static String encode(byte[] bytes, boolean upperCase) {
        if (bytes == null) {
            return null;
        }
        char[] chars = upperCase ? UPPER_CHARS : LOWER_CHARS;
        char[] hex = new char[bytes.length * 2];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int b = bytes[i2] & 0xFF;
            hex[i2 * 2] = chars[b >> 4];
            hex[i2 * 2 + 1] = chars[b & 0xF];
        }
        return new String(hex);
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i2 = 0; i2 < lengthDecode; ++i2) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i2 * 2];
            int n = temp1 = tempChar < '\u0080' ? HEX_NUMBER_TABLE[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i2 * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? HEX_NUMBER_TABLE[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i2] = (byte)(temp1 << 4 | temp2);
        }
        return decodedData;
    }

    static {
        int i2;
        HEX_NUMBER_TABLE = new byte[128];
        UPPER_CHARS = new char[16];
        LOWER_CHARS = new char[16];
        for (i2 = 0; i2 < 128; ++i2) {
            HexBin.HEX_NUMBER_TABLE[i2] = -1;
        }
        for (i2 = 57; i2 >= 48; --i2) {
            HexBin.HEX_NUMBER_TABLE[i2] = (byte)(i2 - 48);
        }
        for (i2 = 70; i2 >= 65; --i2) {
            HexBin.HEX_NUMBER_TABLE[i2] = (byte)(i2 - 65 + 10);
        }
        for (i2 = 102; i2 >= 97; --i2) {
            HexBin.HEX_NUMBER_TABLE[i2] = (byte)(i2 - 97 + 10);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            HexBin.UPPER_CHARS[i2] = (char)(48 + i2);
            HexBin.LOWER_CHARS[i2] = (char)(48 + i2);
        }
        for (i2 = 10; i2 <= 15; ++i2) {
            HexBin.UPPER_CHARS[i2] = (char)(65 + i2 - 10);
            HexBin.LOWER_CHARS[i2] = (char)(97 + i2 - 10);
        }
    }
}

