/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;

public class Histogram {
    private final long[] ranges;
    private final AtomicLongArray rangeCounters;

    public Histogram(long ... ranges) {
        this.ranges = ranges;
        this.rangeCounters = new AtomicLongArray(ranges.length + 1);
    }

    public static Histogram makeHistogram(int rangeCount) {
        long[] rangeValues = new long[rangeCount];
        for (int i2 = 0; i2 < rangeValues.length; ++i2) {
            rangeValues[i2] = (long)Math.pow(10.0, i2);
        }
        return new Histogram(rangeValues);
    }

    public Histogram(TimeUnit timeUnit, long ... ranges) {
        this.ranges = new long[ranges.length];
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            this.ranges[i2] = TimeUnit.MILLISECONDS.convert(ranges[i2], timeUnit);
        }
        this.rangeCounters = new AtomicLongArray(ranges.length + 1);
    }

    public void reset() {
        for (int i2 = 0; i2 < this.rangeCounters.length(); ++i2) {
            this.rangeCounters.set(i2, 0L);
        }
    }

    public void record(long millis) {
        int index = this.rangeCounters.length() - 1;
        for (int i2 = 0; i2 < this.ranges.length; ++i2) {
            if (millis >= this.ranges[i2]) continue;
            index = i2;
            break;
        }
        this.rangeCounters.incrementAndGet(index);
    }

    public long get(int index) {
        return this.rangeCounters.get(index);
    }

    public long[] toArray() {
        long[] array = new long[this.rangeCounters.length()];
        for (int i2 = 0; i2 < this.rangeCounters.length(); ++i2) {
            array[i2] = this.rangeCounters.get(i2);
        }
        return array;
    }

    public long[] toArrayAndReset() {
        long[] array = new long[this.rangeCounters.length()];
        for (int i2 = 0; i2 < this.rangeCounters.length(); ++i2) {
            array[i2] = this.rangeCounters.getAndSet(i2, 0L);
        }
        return array;
    }

    public long[] getRanges() {
        return this.ranges;
    }

    public long getValue(int index) {
        return this.rangeCounters.get(index);
    }

    public long getSum() {
        long sum = 0L;
        for (int i2 = 0; i2 < this.rangeCounters.length(); ++i2) {
            sum += this.rangeCounters.get(i2);
        }
        return sum;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i2 = 0; i2 < this.rangeCounters.length(); ++i2) {
            if (i2 != 0) {
                buf.append(',');
            }
            buf.append(this.rangeCounters.get(i2));
        }
        buf.append(']');
        return buf.toString();
    }
}

