/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ListDG {
    private List<VNode> mVexs;

    public ListDG(List vexs, List<Edge> edges) {
        int i2;
        int vlen = vexs.size();
        int elen = edges.size();
        this.mVexs = new ArrayList<VNode>();
        for (i2 = 0; i2 < vlen; ++i2) {
            VNode vnode = new VNode();
            vnode.data = vexs.get(i2);
            vnode.firstEdge = null;
            this.mVexs.add(vnode);
        }
        for (i2 = 0; i2 < elen; ++i2) {
            Object c1 = edges.get((int)i2).from;
            Object c2 = edges.get((int)i2).to;
            int p1 = this.getPosition(edges.get((int)i2).from);
            int p2 = this.getPosition(edges.get((int)i2).to);
            ENode node1 = new ENode();
            node1.ivex = p2;
            if (this.mVexs.get((int)p1).firstEdge == null) {
                this.mVexs.get((int)p1).firstEdge = node1;
                continue;
            }
            this.linkLast(this.mVexs.get((int)p1).firstEdge, node1);
        }
    }

    private void linkLast(ENode list, ENode node) {
        ENode p2 = list;
        while (p2.nextEdge != null) {
            p2 = p2.nextEdge;
        }
        p2.nextEdge = node;
    }

    private int getPosition(Object ch) {
        for (int i2 = 0; i2 < this.mVexs.size(); ++i2) {
            if (this.mVexs.get((int)i2).data != ch) continue;
            return i2;
        }
        return -1;
    }

    private void DFS(int i2, boolean[] visited) {
        visited[i2] = true;
        ENode node = this.mVexs.get((int)i2).firstEdge;
        while (node != null) {
            if (!visited[node.ivex]) {
                this.DFS(node.ivex, visited);
            }
            node = node.nextEdge;
        }
    }

    public void DFS() {
        int i2;
        boolean[] visited = new boolean[this.mVexs.size()];
        for (i2 = 0; i2 < this.mVexs.size(); ++i2) {
            visited[i2] = false;
        }
        for (i2 = 0; i2 < this.mVexs.size(); ++i2) {
            if (visited[i2]) continue;
            this.DFS(i2, visited);
        }
    }

    public void BFS() {
        int i2;
        int head = 0;
        int rear = 0;
        int[] queue = new int[this.mVexs.size()];
        boolean[] visited = new boolean[this.mVexs.size()];
        for (i2 = 0; i2 < this.mVexs.size(); ++i2) {
            visited[i2] = false;
        }
        for (i2 = 0; i2 < this.mVexs.size(); ++i2) {
            if (!visited[i2]) {
                visited[i2] = true;
                System.out.printf("%c ", this.mVexs.get((int)i2).data);
                queue[rear++] = i2;
            }
            while (head != rear) {
                int j = queue[head++];
                ENode node = this.mVexs.get((int)j).firstEdge;
                while (node != null) {
                    int k = node.ivex;
                    if (!visited[k]) {
                        visited[k] = true;
                        System.out.printf("%c ", this.mVexs.get((int)k).data);
                        queue[rear++] = k;
                    }
                    node = node.nextEdge;
                }
            }
        }
    }

    public void print() {
        System.out.printf("== List Graph:\n", new Object[0]);
        for (int i2 = 0; i2 < this.mVexs.size(); ++i2) {
            System.out.printf("%d(%c): ", i2, this.mVexs.get((int)i2).data);
            ENode node = this.mVexs.get((int)i2).firstEdge;
            while (node != null) {
                System.out.printf("%d(%c) ", node.ivex, this.mVexs.get((int)node.ivex).data);
                node = node.nextEdge;
            }
        }
    }

    public boolean topologicalSort() {
        return this.topologicalSort(new Object[this.mVexs.size()]);
    }

    public boolean topologicalSort(Object[] tops) {
        ENode node;
        int i2;
        int index = 0;
        int num = this.mVexs.size();
        int[] ins = new int[num];
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (i2 = 0; i2 < num; ++i2) {
            node = this.mVexs.get((int)i2).firstEdge;
            while (node != null) {
                int n = node.ivex;
                ins[n] = ins[n] + 1;
                node = node.nextEdge;
            }
        }
        for (i2 = 0; i2 < num; ++i2) {
            if (ins[i2] != 0) continue;
            queue.offer(i2);
        }
        while (!queue.isEmpty()) {
            int j = (Integer)queue.poll();
            tops[index++] = this.mVexs.get((int)j).data;
            node = this.mVexs.get((int)j).firstEdge;
            while (node != null) {
                int n = node.ivex;
                ins[n] = ins[n] - 1;
                if (ins[node.ivex] == 0) {
                    queue.offer(node.ivex);
                }
                node = node.nextEdge;
            }
        }
        return index == num;
    }

    private class VNode {
        Object data;
        ENode firstEdge;

        private VNode() {
        }
    }

    private class ENode {
        int ivex;
        ENode nextEdge;

        private ENode() {
        }
    }

    public static class Edge {
        public Object from;
        public Object to;

        public Edge(Object from, Object to) {
            this.from = from;
            this.to = to;
        }
    }
}

