/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;

public class StringUtils {
    private static final Log LOG = LogFactory.getLog(StringUtils.class);

    public static Integer subStringToInteger(String src, String start, String to) {
        return StringUtils.stringToInteger(StringUtils.subString(src, start, to));
    }

    public static String subString(String src, String start, String to) {
        int indexTo;
        int indexFrom = start == null ? 0 : src.indexOf(start);
        int n = indexTo = to == null ? src.length() : src.indexOf(to);
        if (indexFrom < 0 || indexTo < 0 || indexFrom > indexTo) {
            return null;
        }
        if (null != start) {
            indexFrom += start.length();
        }
        return src.substring(indexFrom, indexTo);
    }

    public static String subString(String src, String start, String to, boolean toLast) {
        int indexTo;
        if (!toLast) {
            return StringUtils.subString(src, start, to);
        }
        int indexFrom = start == null ? 0 : src.indexOf(start);
        int n = indexTo = to == null ? src.length() : src.lastIndexOf(to);
        if (indexFrom < 0 || indexTo < 0 || indexFrom > indexTo) {
            return null;
        }
        if (null != start) {
            indexFrom += start.length();
        }
        return src.substring(indexFrom, indexTo);
    }

    public static Integer stringToInteger(String in) {
        if (in == null) {
            return null;
        }
        if ((in = in.trim()).length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (NumberFormatException e) {
            LOG.warn("stringToInteger fail,string=" + in, e);
            return null;
        }
    }

    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equalsIgnoreCase(b);
    }

    public static boolean isEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value);
    }

    public static boolean isEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static int lowerHashCode(String text) {
        if (text == null) {
            return 0;
        }
        int h = 0;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char ch = text.charAt(i2);
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            h = 31 * h + ch;
        }
        return h;
    }

    public static boolean isNumber(String str) {
        char ch;
        int i2;
        int start;
        if (str.length() == 0) {
            return false;
        }
        int sz = str.length();
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = str.charAt(0) == '-' ? 1 : 0;
        if (sz > start + 1 && str.charAt(start) == '0' && str.charAt(start + 1) == 'x') {
            int i3 = start + 2;
            if (i3 == sz) {
                return false;
            }
            while (i3 < str.length()) {
                char ch2 = str.charAt(i3);
                if (!(ch2 >= '0' && ch2 <= '9' || ch2 >= 'a' && ch2 <= 'f' || ch2 >= 'A' && ch2 <= 'F')) {
                    return false;
                }
                ++i3;
            }
            return true;
        }
        --sz;
        for (i2 = start; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            ch = str.charAt(i2);
            if (ch >= '0' && ch <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ch == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ch == '+' || ch == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < str.length()) {
            ch = str.charAt(i2);
            if (ch >= '0' && ch <= '9') {
                return true;
            }
            if (ch == 'e' || ch == 'E') {
                return false;
            }
            if (!(allowSigns || ch != 'd' && ch != 'D' && ch != 'f' && ch != 'F')) {
                return foundDigit;
            }
            if (ch == 'l' || ch == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isNumber(char[] chars) {
        char ch;
        int i2;
        int start;
        if (chars.length == 0) {
            return false;
        }
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i3 = start + 2;
            if (i3 == sz) {
                return false;
            }
            while (i3 < chars.length) {
                char ch2 = chars[i3];
                if (!(ch2 >= '0' && ch2 <= '9' || ch2 >= 'a' && ch2 <= 'f' || ch2 >= 'A' && ch2 <= 'F')) {
                    return false;
                }
                ++i3;
            }
            return true;
        }
        --sz;
        for (i2 = start; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            ch = chars[i2];
            if (ch >= '0' && ch <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (ch == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (ch == '+' || ch == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < chars.length) {
            ch = chars[i2];
            if (ch >= '0' && ch <= '9') {
                return true;
            }
            if (ch == 'e' || ch == 'E') {
                return false;
            }
            if (!(allowSigns || ch != 'd' && ch != 'D' && ch != 'f' && ch != 'F')) {
                return foundDigit;
            }
            if (ch == 'l' || ch == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

