/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.Fastjson1xReaderModule;
import com.alibaba.fastjson.Fastjson1xWriterModule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.AfterFilter;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.ContextValueFilter;
import com.alibaba.fastjson.serializer.LabelFilter;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.support.AwtRederModule;
import com.alibaba.fastjson2.support.AwtWriterModule;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public class JSON {
    private static TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final String VERSION = "2.0.12";
    static final Cache CACHE = new Cache();
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
    public static TimeZone defaultTimeZone = DEFAULT_TIME_ZONE;
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    static final Supplier<List> arraySupplier;
    static final Supplier<Map> defaultSupplier;
    static final Supplier<Map> orderedSupplier;

    public static JSONObject parseObject(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader reader = JSONReader.of(str);
        JSONReader.Context context = reader.getContext();
        context.config(JSONReader.Feature.AllowUnQuotedFieldNames);
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks(jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader reader = JSONReader.of(text);
        JSONReader.Context context = reader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        context.config(JSONReader.Feature.AllowUnQuotedFieldNames);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        JSON.config(context, features);
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks(jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(char[] str, Class<T> objectClass, Feature ... features) {
        if (str == null || str.length == 0) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of(str);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, TypeReference typeReference, Feature ... features) {
        return JSON.parseObject(str, typeReference.getType(), features);
    }

    public static <T> T parseObject(String str, Class<T> objectClass) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of(str);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        context.config(JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Class<T> objectType, Feature ... features) {
        String defaultDateFormat;
        if (str == null || str.isEmpty()) {
            return null;
        }
        boolean useNativeJavaObject = false;
        for (Feature feature : features) {
            if (feature != Feature.UseNativeJavaObject) continue;
            useNativeJavaObject = true;
        }
        JSONReader jsonReader = JSONReader.of(str);
        JSONReader.Context context = jsonReader.getContext();
        if (!useNativeJavaObject) {
            context.setArraySupplier(arraySupplier);
            context.setObjectSupplier(defaultSupplier);
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat = DEFFAULT_DATE_FORMAT)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Type objectType, Feature ... features) {
        String defaultDateFormat;
        if (str == null || str.isEmpty()) {
            return null;
        }
        boolean useNativeJavaObject = false;
        for (Feature feature : features) {
            if (feature != Feature.UseNativeJavaObject) continue;
            useNativeJavaObject = true;
        }
        JSONReader jsonReader = JSONReader.of(str);
        JSONReader.Context context = jsonReader.getContext();
        if (!useNativeJavaObject) {
            context.setArraySupplier(arraySupplier);
            context.setObjectSupplier(defaultSupplier);
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat = DEFFAULT_DATE_FORMAT)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(InputStream is, Type objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Class<T> objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type objectType, Feature ... features) throws IOException {
        if (is == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of(is, charset);
        JSONReader.Context context = jsonReader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> JSONObject parseObject(byte[] jsonBytes, Feature ... features) {
        if (jsonBytes == null || jsonBytes.length == 0) {
            return null;
        }
        JSONReader reader = JSONReader.of(jsonBytes);
        JSONReader.Context context = reader.getContext();
        context.setArraySupplier(arraySupplier);
        context.setObjectSupplier(defaultSupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        JSON.config(context, features);
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks(jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of(jsonBytes);
        JSONReader.Context context = jsonReader.getContext();
        context.setObjectSupplier(defaultSupplier);
        context.setArraySupplier(arraySupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, SerializeFilter filter2, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader jsonReader = JSONReader.of(jsonBytes);
        JSONReader.Context context = jsonReader.getContext();
        context.setObjectSupplier(defaultSupplier);
        context.setArraySupplier(arraySupplier);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        if (filter2 instanceof Filter) {
            context.config((Filter)((Object)filter2), new JSONReader.Feature[0]);
        }
        JSON.config(context, features);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, Feature ... features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of(str);){
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            JSON.config(context, features);
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                JSONObject jSONObject = jsonReader.read(JSONObject.class);
                return jSONObject;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    protected static void config(JSONReader.Context context, Feature[] features) {
        block13: for (Feature feature : features) {
            switch (feature) {
                case SupportArrayToBean: {
                    context.config(JSONReader.Feature.SupportArrayToBean);
                    continue block13;
                }
                case SupportAutoType: {
                    context.config(JSONReader.Feature.SupportAutoType);
                    continue block13;
                }
                case ErrorOnEnumNotMatch: {
                    context.config(JSONReader.Feature.ErrorOnEnumNotMatch);
                    continue block13;
                }
                case SupportNonPublicField: {
                    context.config(JSONReader.Feature.FieldBased);
                    continue block13;
                }
                case SupportClassForName: {
                    context.config(JSONReader.Feature.SupportClassForName);
                    continue block13;
                }
                case TrimStringFieldValue: {
                    context.config(JSONReader.Feature.TrimString);
                    continue block13;
                }
                case ErrorOnNotSupportAutoType: {
                    context.config(JSONReader.Feature.ErrorOnNotSupportAutoType);
                    continue block13;
                }
                case AllowUnQuotedFieldNames: {
                    context.config(JSONReader.Feature.AllowUnQuotedFieldNames);
                    continue block13;
                }
                case OrderedField: {
                    context.setObjectSupplier(orderedSupplier);
                    continue block13;
                }
                case UseNativeJavaObject: {
                    context.config(JSONReader.Feature.UseNativeObject);
                    continue block13;
                }
                case NonStringKeyAsString: {
                    context.config(JSONReader.Feature.NonStringKeyAsString);
                    continue block13;
                }
            }
        }
        boolean disableFieldSmartMatch = false;
        for (Feature feature : features) {
            if (feature != Feature.DisableFieldSmartMatch) continue;
            disableFieldSmartMatch = true;
            break;
        }
        if (!disableFieldSmartMatch) {
            context.config(JSONReader.Feature.SupportSmartMatch);
        }
    }

    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charBuf = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charBuf);
            int position = charBuf.position();
            JSONReader jsonReader = JSONReader.of(chars, 0, position);
            JSONReader.Context context = jsonReader.getContext();
            block9: for (Feature feature : Feature.values()) {
                if ((features & feature.mask) == 0) continue;
                switch (feature) {
                    case SupportArrayToBean: {
                        context.config(JSONReader.Feature.SupportArrayToBean);
                        continue block9;
                    }
                    case SupportAutoType: {
                        context.config(JSONReader.Feature.SupportAutoType);
                        continue block9;
                    }
                    case ErrorOnEnumNotMatch: {
                        context.config(JSONReader.Feature.ErrorOnEnumNotMatch);
                    }
                    case SupportNonPublicField: {
                        context.config(JSONReader.Feature.FieldBased);
                    }
                }
            }
            Object object = jsonReader.read(Object.class);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charByte = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charByte);
            int position = charByte.position();
            JSONReader jsonReader = JSONReader.of(chars, 0, position);
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            context.config(JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames);
            JSON.config(context, features);
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    public static <T> T parseObject(byte[] input, int off, int len, Charset charset, Type clazz, Feature ... features) {
        try (JSONReader jsonReader = JSONReader.of(input, off, len, charset);){
            JSON.config(jsonReader.getContext(), features);
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object t = object;
            return t;
        }
    }

    public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        JSONWriter.Context context = JSONFactory.createWriteContext();
        JSON.config(context, features);
        JSONWriter writer = JSONWriter.of(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            JSON.configFilter(context, filters);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONString error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static void configFilter(JSONWriter.Context context, SerializeFilter ... filters) {
        for (SerializeFilter filter2 : filters) {
            JSON.configFilter(context, filter2);
        }
    }

    static void configFilter(JSONWriter.Context context, SerializeFilter filter2) {
        if (filter2 instanceof NameFilter) {
            context.setNameFilter((NameFilter)filter2);
        }
        if (filter2 instanceof ValueFilter) {
            context.setValueFilter((ValueFilter)((Object)filter2));
        }
        if (filter2 instanceof PropertyPreFilter) {
            context.setPropertyPreFilter((PropertyPreFilter)((Object)filter2));
        }
        if (filter2 instanceof PropertyFilter) {
            context.setPropertyFilter((PropertyFilter)((Object)filter2));
        }
        if (filter2 instanceof BeforeFilter) {
            context.setBeforeFilter((BeforeFilter)filter2);
        }
        if (filter2 instanceof AfterFilter) {
            context.setAfterFilter((AfterFilter)filter2);
        }
        if (filter2 instanceof LabelFilter) {
            context.setLabelFilter((LabelFilter)filter2);
        }
        if (filter2 instanceof ContextValueFilter) {
            context.setContextValueFilter((ContextValueFilter)filter2);
        }
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        JSONWriter.Context context = JSONFactory.createWriteContext();
        JSON.config(context, features);
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            JSON.configFilter(context, filters);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.getBytes();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONBytes error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONBytes error", ex);
            }
        }
    }

    public static String toJSONString(Object object, boolean prettyFormat) {
        JSONWriter.Context context = JSONFactory.createWriteContext(JSONWriter.Feature.ReferenceDetection);
        if (prettyFormat) {
            context.config(JSONWriter.Feature.PrettyFormat);
        }
        context.setDateFormat("millis");
        JSONWriter writer = JSONWriter.of(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONString error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static String toJSONString(Object object) {
        JSONWriter.Context context = JSONFactory.createWriteContext(JSONWriter.Feature.ReferenceDetection);
        context.setDateFormat("millis");
        JSONWriter writer = JSONWriter.of(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException(ex.getMessage(), cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static String toJSONString(Object object, SerializeFilter filter0, SerializeFilter filter1, SerializeFilter ... filters) {
        JSONWriter.Context context = JSONFactory.createWriteContext();
        context.setDateFormat("millis");
        JSON.configFilter(context, filter0);
        JSON.configFilter(context, filter1);
        JSON.configFilter(context, filters);
        JSONWriter writer = JSONWriter.of(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            JSON.configFilter(context, filters);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONString error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static String toJSONString(Object object, SerializerFeature ... features) {
        JSONWriter.Context context = JSONFactory.createWriteContext();
        context.setDateFormat("millis");
        JSON.config(context, features);
        JSONWriter writer = JSONWriter.of(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONString error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONString error", ex);
            }
        }
    }

    public static byte[] toJSONBytes(Object object) {
        JSONWriter.Context context = JSONFactory.createWriteContext(JSONWriter.Feature.ReferenceDetection);
        context.setDateFormat("millis");
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.getBytes();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONBytes error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONBytes error", ex);
            }
        }
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter ... filters) {
        return JSON.toJSONBytes(object, filters, new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        JSONWriter.Context context = JSONFactory.createWriteContext();
        JSON.config(context, features);
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            Object valueClass;
            writer.setRootObject(object);
            if (object == null) {
                writer.writeNull();
            } else {
                valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            valueClass = writer.getBytes();
            if (writer != null) {
                writer.close();
            }
            return valueClass;
        }
        catch (Throwable valueClass) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        valueClass.addSuppressed(throwable);
                    }
                }
                throw valueClass;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("toJSONBytes error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("toJSONBytes error", ex);
            }
        }
    }

    public static void config(JSONWriter.Context ctx, SerializerFeature[] features) {
        ctx.setDateFormat("millis");
        if (defaultTimeZone != null && defaultTimeZone != DEFAULT_TIME_ZONE) {
            ctx.setZoneId(defaultTimeZone.toZoneId());
        }
        boolean disableCircularReferenceDetect = false;
        for (SerializerFeature feature : features) {
            if (feature != SerializerFeature.DisableCircularReferenceDetect) continue;
            disableCircularReferenceDetect = true;
            break;
        }
        if (!disableCircularReferenceDetect) {
            ctx.config(JSONWriter.Feature.ReferenceDetection);
        }
        for (SerializerFeature feature : features) {
            JSON.config(ctx, feature);
        }
    }

    static void config(JSONWriter.Context context, SerializerFeature feature) {
        switch (feature) {
            case UseISO8601DateFormat: {
                context.setDateFormat("iso8601");
                break;
            }
            case WriteMapNullValue: {
                context.config(JSONWriter.Feature.WriteNulls);
                break;
            }
            case WriteNullListAsEmpty: {
                context.config(JSONWriter.Feature.WriteNullListAsEmpty);
                break;
            }
            case WriteNullStringAsEmpty: {
                context.config(JSONWriter.Feature.WriteNullStringAsEmpty);
                break;
            }
            case WriteNullNumberAsZero: {
                context.config(JSONWriter.Feature.WriteNullNumberAsZero);
                break;
            }
            case WriteNullBooleanAsFalse: {
                context.config(JSONWriter.Feature.WriteNullBooleanAsFalse);
                break;
            }
            case BrowserCompatible: {
                context.config(JSONWriter.Feature.BrowserCompatible);
                break;
            }
            case WriteClassName: {
                context.config(JSONWriter.Feature.WriteClassName);
                break;
            }
            case WriteNonStringValueAsString: {
                context.config(JSONWriter.Feature.WriteNonStringValueAsString);
                break;
            }
            case WriteEnumUsingToString: {
                context.config(JSONWriter.Feature.WriteEnumUsingToString);
                break;
            }
            case NotWriteRootClassName: {
                context.config(JSONWriter.Feature.NotWriteRootClassName);
                break;
            }
            case IgnoreErrorGetter: {
                context.config(JSONWriter.Feature.IgnoreErrorGetter);
                break;
            }
            case WriteDateUseDateFormat: {
                context.setDateFormat(DEFFAULT_DATE_FORMAT);
                break;
            }
            case BeanToArray: {
                context.config(JSONWriter.Feature.BeanToArray);
                break;
            }
            case UseSingleQuotes: {
                context.config(JSONWriter.Feature.UseSingleQuotes);
                break;
            }
            case MapSortField: {
                context.config(JSONWriter.Feature.MapSortField);
                break;
            }
            case PrettyFormat: {
                context.config(JSONWriter.Feature.PrettyFormat);
                break;
            }
            case WriteNonStringKeyAsString: {
                context.config(JSONWriter.Feature.WriteNonStringKeyAsString);
                break;
            }
        }
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context context = writer.getContext();
            if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
                NameFilter nameFilter = NameFilter.of(config.propertyNamingStrategy);
                JSON.configFilter(context, (SerializeFilter)nameFilter);
            }
            if (config.fieldBased) {
                context.config(JSONWriter.Feature.FieldBased);
            }
            JSON.config(context, features);
            writer.writeAny(object);
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter filter2, SerializerFeature ... features) {
        try (JSONWriter writer = JSONWriter.of();){
            JSONWriter.Context context = writer.getContext();
            if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
                NameFilter nameFilter = NameFilter.of(config.propertyNamingStrategy);
                if (filter2 instanceof NameFilter) {
                    filter2 = NameFilter.compose(nameFilter, (NameFilter)filter2);
                } else {
                    JSON.configFilter(context, (SerializeFilter)nameFilter);
                }
            }
            if (config.fieldBased) {
                context.config(JSONWriter.Feature.FieldBased);
            }
            JSON.configFilter(context, filter2);
            JSON.config(context, features);
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter<?> objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, SerializeFilter filter2, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            JSONWriter.Context context = jsonWriter.getContext();
            JSON.configFilter(context, filter2);
            JSON.config(context, features);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter<?> objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            JSONWriter.Context context = jsonWriter.getContext();
            if (defaultFeatures != 0) {
                for (SerializerFeature feature : SerializerFeature.values()) {
                    if ((defaultFeatures & feature.mask) == 0) continue;
                    JSON.config(context, feature);
                }
            }
            JSON.config(context, features);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter<?> objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        try (JSONWriter jsonWriter = JSONWriter.of();){
            for (SerializerFeature feature : features) {
                if (feature != SerializerFeature.WriteMapNullValue) continue;
                jsonWriter.config(JSONWriter.Feature.WriteNulls);
            }
            JSONWriter.Context context = jsonWriter.getContext();
            context.setDateFormat(dateFormat);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter<?> objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, object, new SerializeFilter[0], features);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters) throws IOException {
        return JSON.writeJSONString(os, object, filters, new SerializerFeature[0]);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters, SerializerFeature ... features) throws IOException {
        JSONWriter jsonWriter = JSONWriter.ofUTF8();
        try {
            JSONWriter.Context context = jsonWriter.getContext();
            jsonWriter.setRootObject(object);
            JSON.config(context, features);
            JSON.configFilter(context, filters);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                ObjectWriter<?> objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            byte[] bytes = jsonWriter.getBytes();
            os.write(bytes);
            int n = bytes.length;
            if (jsonWriter != null) {
                jsonWriter.close();
            }
            return n;
        }
        catch (Throwable context) {
            try {
                if (jsonWriter != null) {
                    try {
                        jsonWriter.close();
                    }
                    catch (Throwable throwable) {
                        context.addSuppressed(throwable);
                    }
                }
                throw context;
            }
            catch (com.alibaba.fastjson2.JSONException ex) {
                Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                throw new JSONException("writeJSONString error", cause);
            }
            catch (RuntimeException ex) {
                throw new JSONException("writeJSONString error", ex);
            }
        }
    }

    public static JSONArray parseArray(String str, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of(str);){
            JSONReader.Context context = jsonReader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            JSON.config(context, features);
            if (jsonReader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray jsonArray = new JSONArray();
            jsonReader.read(jsonArray);
            JSONArray jSONArray = jsonArray;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        JSONReader reader = JSONReader.of(text);
        try {
            JSONReader.Context context = reader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            context.config(JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames);
            List list = (List)reader.read(paramType);
            if (reader != null) {
                reader.close();
            }
            return list;
        }
        catch (Throwable context) {
            try {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        context.addSuppressed(throwable);
                    }
                }
                throw context;
            }
            catch (com.alibaba.fastjson2.JSONException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new JSONException(e.getMessage(), cause);
            }
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type, Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, (Type)((Object)List.class));
        JSONReader reader = JSONReader.of(text);
        try {
            JSONReader.Context context = reader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            JSON.config(context, features);
            List list = (List)reader.read(paramType);
            if (reader != null) {
                reader.close();
            }
            return list;
        }
        catch (Throwable context) {
            try {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        context.addSuppressed(throwable);
                    }
                }
                throw context;
            }
            catch (com.alibaba.fastjson2.JSONException e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                throw new JSONException(e.getMessage(), cause);
            }
        }
    }

    public static boolean isValid(String str) {
        return com.alibaba.fastjson2.JSON.isValid(str);
    }

    public static boolean isValidArray(String str) {
        return com.alibaba.fastjson2.JSON.isValidArray(str);
    }

    public static boolean isValidObject(String str) {
        return com.alibaba.fastjson2.JSON.isValidObject(str);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        if (json instanceof JSONObject) {
            return ((JSONObject)json).toJavaObject(clazz);
        }
        String str = JSON.toJSONString(json);
        return JSON.parseObject(str, clazz);
    }

    public static Object toJSON(Object javaObject) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        Object object = JSON.parse(str, new Feature[0]);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static List<Object> parseArray(String text, Type[] types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray(types.length);
        try (JSONReader reader = JSONReader.of(text);){
            JSONReader.Context context = reader.getContext();
            context.setObjectSupplier(defaultSupplier);
            context.setArraySupplier(arraySupplier);
            context.config(JSONReader.Feature.SupportSmartMatch, JSONReader.Feature.AllowUnQuotedFieldNames);
            reader.startArray();
            for (Type itemType : types) {
                array.add(reader.read(itemType));
            }
            reader.endArray();
            reader.handleResolveTasks(array);
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    static {
        arraySupplier = JSONArray::new;
        defaultSupplier = JSONObject::new;
        orderedSupplier = () -> new JSONObject(true);
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        readerProvider.register(AwtRederModule.INSTANCE);
        readerProvider.register(new Fastjson1xReaderModule(readerProvider));
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.register(AwtWriterModule.INSTANCE);
        writerProvider.register(new Fastjson1xWriterModule(writerProvider));
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

