/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeReference<T> {
    static ConcurrentMap<Type, Type> classTypeCache = new ConcurrentHashMap<Type, Type>(16, 0.75f, 1);
    protected final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        Type type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type cachedType = (Type)classTypeCache.get(type);
        if (cachedType == null) {
            classTypeCache.putIfAbsent(type, type);
            cachedType = (Type)classTypeCache.get(type);
        }
        this.type = cachedType;
    }

    protected TypeReference(Type ... actualTypeArguments) {
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type rawType = argType.getRawType();
        Type[] argTypes = argType.getActualTypeArguments();
        int actualIndex = 0;
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            if (argTypes[i2] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                argTypes[i2] = actualTypeArguments[actualIndex++];
            }
            if (argTypes[i2] instanceof GenericArrayType) {
                argTypes[i2] = TypeUtils.checkPrimitiveArray((GenericArrayType)argTypes[i2]);
            }
            if (!(argTypes[i2] instanceof ParameterizedType)) continue;
            argTypes[i2] = this.handlerParameterizedType((ParameterizedType)argTypes[i2], actualTypeArguments, actualIndex);
        }
        ParameterizedTypeImpl key = new ParameterizedTypeImpl(argTypes, thisClass, rawType);
        Type cachedType = (Type)classTypeCache.get(key);
        if (cachedType == null) {
            classTypeCache.putIfAbsent(key, key);
            cachedType = (Type)classTypeCache.get(key);
        }
        this.type = cachedType;
    }

    private Type handlerParameterizedType(ParameterizedType type, Type[] actualTypeArguments, int actualIndex) {
        Class<?> thisClass = this.getClass();
        Type rawType = type.getRawType();
        Type[] argTypes = type.getActualTypeArguments();
        for (int i2 = 0; i2 < argTypes.length; ++i2) {
            if (argTypes[i2] instanceof TypeVariable && actualIndex < actualTypeArguments.length) {
                argTypes[i2] = actualTypeArguments[actualIndex++];
            }
            if (argTypes[i2] instanceof GenericArrayType) {
                argTypes[i2] = TypeUtils.checkPrimitiveArray((GenericArrayType)argTypes[i2]);
            }
            if (!(argTypes[i2] instanceof ParameterizedType)) continue;
            return this.handlerParameterizedType((ParameterizedType)argTypes[i2], actualTypeArguments, actualIndex);
        }
        ParameterizedTypeImpl key = new ParameterizedTypeImpl(argTypes, thisClass, rawType);
        return key;
    }

    public Type getType() {
        return this.type;
    }
}

