/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONPathCompilerReflectASM;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class JSONFactory {
    public static final String CREATOR;
    public static final String PROPERTY_DENY_PROPERTY = "fastjson2.parser.deny";
    public static final String PROPERTY_AUTO_TYPE_ACCEPT = "fastjson2.autoTypeAccept";
    public static final String PROPERTY_AUTO_TYPE_HANDLER = "fastjson2.autoTypeHandler";
    public static final String PROPERTY_AUTO_TYPE_BEFORE_HANDLER = "fastjson2.autoTypeBeforeHandler";
    static long defaultReaderFeatures;
    static long defaultWriterFeatures;
    static final NameHash64Cache[] NAME_HASH_64_CACHE2;
    static final NameCacheEntry[] NAME_CACHE;
    static final NameCacheEntry2[] NAME_CACHE2;
    static final BigDecimal LOW;
    static final BigDecimal HIGH;
    static final BigInteger LOW_BIGINT;
    static final BigInteger HIGH_BIGINT;
    static final char[] CA;
    static final char[] DIGITS;
    static final int[] DIGITS2;
    static final double[] SMALL_10_POW;
    private static final int CACHE_THRESHOLD = 0x100000;
    private static final byte[][] BYTE_ARRAY_CACHE;
    private static final char[][] CHAR_ARRAY_CACHE;
    static final Properties DEFAULT_PROPERTIES;
    static ObjectWriterProvider defaultObjectWriterProvider;
    static ObjectReaderProvider defaultObjectReaderProvider;
    static final JSONPathCompiler defaultJSONPathCompiler;
    static final ThreadLocal<ObjectReaderCreator> readerCreatorLocal;
    static final ThreadLocal<ObjectReaderProvider> readerProviderLocal;
    static final ThreadLocal<ObjectWriterCreator> writerCreatorLocal;
    static final ThreadLocal<JSONPathCompiler> jsonPathCompilerLocal;
    static final ObjectReader<JSONArray> ARRAY_READER;
    static final ObjectReader<JSONObject> OBJECT_READER;

    public static String getProperty(String key) {
        return DEFAULT_PROPERTIES.getProperty(key);
    }

    static int cacheIndex() {
        return System.identityHashCode(Thread.currentThread()) & 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static char[] allocateCharArray(int cacheIndex) {
        char[][] cArray = CHAR_ARRAY_CACHE;
        synchronized (CHAR_ARRAY_CACHE) {
            char[] chars = CHAR_ARRAY_CACHE[cacheIndex];
            if (chars != null) {
                JSONFactory.CHAR_ARRAY_CACHE[cacheIndex] = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (chars == null) {
                chars = new char[8192];
            }
            return chars;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseCharArray(int cacheIndex, char[] chars) {
        if (chars == null || chars.length > 0x100000) {
            return;
        }
        char[][] cArray = CHAR_ARRAY_CACHE;
        synchronized (CHAR_ARRAY_CACHE) {
            JSONFactory.CHAR_ARRAY_CACHE[cacheIndex] = chars;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] allocateByteArray(int cacheIndex) {
        byte[][] byArray = BYTE_ARRAY_CACHE;
        synchronized (BYTE_ARRAY_CACHE) {
            byte[] bytes = BYTE_ARRAY_CACHE[cacheIndex];
            if (bytes != null) {
                JSONFactory.BYTE_ARRAY_CACHE[cacheIndex] = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (bytes == null) {
                bytes = new byte[8192];
            }
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseByteArray(int cacheIndex, byte[] chars) {
        if (chars == null || chars.length > 0x100000) {
            return;
        }
        byte[][] byArray = BYTE_ARRAY_CACHE;
        synchronized (BYTE_ARRAY_CACHE) {
            JSONFactory.BYTE_ARRAY_CACHE[cacheIndex] = chars;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static JSONWriter.Context createWriteContext() {
        return new JSONWriter.Context(defaultObjectWriterProvider);
    }

    public static JSONWriter.Context createWriteContext(JSONWriter.Feature ... features) {
        return new JSONWriter.Context(defaultObjectWriterProvider, features);
    }

    public static JSONReader.Context createReadContext() {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider);
    }

    public static JSONReader.Context createReadContext(SymbolTable symbolTable) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        return new JSONReader.Context(provider, symbolTable);
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.config(features);
        return context;
    }

    public static JSONReader.Context createReadContext(Supplier<Map> objectSupplier, Supplier<List> arraySupplier, JSONReader.Feature ... features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        context.setObjectSupplier(objectSupplier);
        context.setArraySupplier(arraySupplier);
        context.config(features);
        return context;
    }

    public static ObjectWriterProvider getDefaultObjectWriterProvider() {
        return defaultObjectWriterProvider;
    }

    public static ObjectReaderProvider getDefaultObjectReaderProvider() {
        ObjectReaderProvider providerLocal = readerProviderLocal.get();
        if (providerLocal != null) {
            return providerLocal;
        }
        return defaultObjectReaderProvider;
    }

    public static JSONPathCompiler getDefaultJSONPathCompiler() {
        JSONPathCompiler compilerLocal = jsonPathCompilerLocal.get();
        if (compilerLocal != null) {
            return compilerLocal;
        }
        return defaultJSONPathCompiler;
    }

    public static void setContextReaderCreator(ObjectReaderCreator creator) {
        readerCreatorLocal.set(creator);
    }

    public static void setContextObjectReaderProvider(ObjectReaderProvider creator) {
        readerProviderLocal.set(creator);
    }

    public static ObjectReaderCreator getContextReaderCreator() {
        return readerCreatorLocal.get();
    }

    public static void setContextJSONPathCompiler(JSONPathCompiler compiler) {
        jsonPathCompilerLocal.set(compiler);
    }

    public static void setContextWriterCreator(ObjectWriterCreator creator) {
        writerCreatorLocal.set(creator);
    }

    public static ObjectWriterCreator getContextWriterCreator() {
        return writerCreatorLocal.get();
    }

    static {
        NAME_HASH_64_CACHE2 = new NameHash64Cache[8192];
        NAME_CACHE = new NameCacheEntry[8192];
        NAME_CACHE2 = new NameCacheEntry2[8192];
        LOW = BigDecimal.valueOf(-9007199254740991L);
        HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
        LOW_BIGINT = BigInteger.valueOf(-9007199254740991L);
        HIGH_BIGINT = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
        CA = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
        SMALL_10_POW = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15};
        Properties properties = new Properties();
        InputStream inputStream = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String resourceFile = "fastjson2.properties";
            if (cl != null) {
                return cl.getResourceAsStream("fastjson2.properties");
            }
            return ClassLoader.getSystemResourceAsStream("fastjson2.properties");
        });
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.close(inputStream);
            }
        }
        DEFAULT_PROPERTIES = properties;
        String property = System.getProperty("fastjson2.creator");
        if (property != null) {
            property = property.trim();
        }
        CREATOR = property == null ? "asm" : property;
        BYTE_ARRAY_CACHE = new byte[4][];
        CHAR_ARRAY_CACHE = new char[4][];
        defaultObjectWriterProvider = new ObjectWriterProvider();
        defaultObjectReaderProvider = new ObjectReaderProvider();
        JSONPathCompilerReflect compiler = null;
        switch (CREATOR) {
            case "reflect": 
            case "lambda": {
                compiler = JSONPathCompilerReflect.INSTANCE;
                break;
            }
            default: {
                try {
                    compiler = JSONPathCompilerReflectASM.INSTANCE;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (compiler != null) break;
                compiler = JSONPathCompilerReflect.INSTANCE;
            }
        }
        defaultJSONPathCompiler = compiler;
        readerCreatorLocal = new ThreadLocal();
        readerProviderLocal = new ThreadLocal();
        writerCreatorLocal = new ThreadLocal();
        jsonPathCompilerLocal = new ThreadLocal();
        ARRAY_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONArray.class));
        OBJECT_READER = JSONFactory.getDefaultObjectReaderProvider().getObjectReader((Type)((Object)JSONObject.class));
    }

    public static interface JSONPathCompiler {
        public JSONPath compile(Class var1, JSONPath var2);
    }

    static final class NameHash64Cache {
        final long nameValue;
        final long hashCode64;

        public NameHash64Cache(long nameValue, long hashCode64) {
            this.nameValue = nameValue;
            this.hashCode64 = hashCode64;
        }
    }

    static final class NameCacheEntry {
        final String name;
        final long value;

        public NameCacheEntry(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }

    static final class NameCacheEntry2 {
        final String name;
        final long value0;
        final long value1;

        public NameCacheEntry2(String name, long value0, long value1) {
            this.name = name;
            this.value0 = value0;
            this.value1 = value1;
        }
    }

    static final class SymbolTableImpl
    implements SymbolTable {
        private final String[] names;
        private final long hashCode64;
        private final short[] mapping;
        private final long[] hashCodes;
        private final long[] hashCodesOrigin;

        SymbolTableImpl(String ... input) {
            int i2;
            TreeSet<String> set = new TreeSet<String>();
            for (String name : input) {
                set.add(name);
            }
            this.names = new String[set.size()];
            Iterator it = set.iterator();
            for (int i3 = 0; i3 < this.names.length; ++i3) {
                if (!it.hasNext()) continue;
                this.names[i3] = (String)it.next();
            }
            long[] hashCodes = new long[this.names.length];
            for (i2 = 0; i2 < this.names.length; ++i2) {
                long hashCode;
                hashCodes[i2] = hashCode = Fnv.hashCode64(this.names[i2]);
            }
            this.hashCodesOrigin = hashCodes;
            this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
            Arrays.sort(this.hashCodes);
            this.mapping = new short[this.hashCodes.length];
            for (i2 = 0; i2 < hashCodes.length; ++i2) {
                long hashCode = hashCodes[i2];
                int index = Arrays.binarySearch(this.hashCodes, hashCode);
                this.mapping[index] = (short)i2;
            }
            long hashCode64 = -3750763034362895579L;
            for (long hashCode : hashCodes) {
                hashCode64 ^= hashCode;
                hashCode64 *= 1099511628211L;
            }
            this.hashCode64 = hashCode64;
        }

        @Override
        public int size() {
            return this.names.length;
        }

        @Override
        public long hashCode64() {
            return this.hashCode64;
        }

        @Override
        public String getNameByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return null;
            }
            short index = this.mapping[m];
            return this.names[index];
        }

        @Override
        public int getOrdinalByHashCode(long hashCode) {
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public int getOrdinal(String name) {
            long hashCode = Fnv.hashCode64(name);
            int m = Arrays.binarySearch(this.hashCodes, hashCode);
            if (m < 0) {
                return -1;
            }
            return this.mapping[m] + 1;
        }

        @Override
        public String getName(int ordinal) {
            return this.names[ordinal - 1];
        }

        @Override
        public long getHashCode(int ordinal) {
            return this.hashCodesOrigin[ordinal - 1];
        }
    }

    static final class Utils {
        static BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
        static Function<byte[], String> STRING_CREATOR_JDK11;
        static BiFunction<byte[], Charset, String> STRING_CREATOR_JDK17;
        static volatile boolean STRING_CREATOR_ERROR;

        Utils() {
        }
    }
}

