/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class JSONReaderASCII
extends JSONReaderUTF8 {
    final String str;

    JSONReaderASCII(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, bytes, offset, length);
        this.str = str;
        this.nameAscii = true;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        this.ch = (char)(this.bytes[this.offset] & 0xFF);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = (char)(this.bytes[this.offset] & 0xFF);
        }
        ++this.offset;
    }

    @Override
    public boolean nextIfMatch(char ch) {
        if (this.ch != ch) {
            return false;
        }
        if (ch == ',') {
            this.comma = true;
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = (char)(this.bytes[this.offset] & 0xFF);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)(this.bytes[this.offset] & 0xFF);
        }
        ++this.offset;
        return true;
    }

    @Override
    public boolean nextIfEmptyString() {
        char first = this.ch;
        if (first != '\"' && first != '\'' || this.offset >= this.end || this.bytes[this.offset] != first) {
            return false;
        }
        ++this.offset;
        this.ch = (char)(this.offset == this.end ? 26 : (char)this.bytes[this.offset]);
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        if (this.ch == ',') {
            this.comma = true;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        this.ch = (char)this.bytes[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        ++this.offset;
        return true;
    }

    @Override
    public long readFieldNameHashCode() {
        char c;
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            throw new JSONException("illegal character " + this.ch);
        }
        char quote = this.ch;
        if (this.nameEscape) {
            this.nameEscape = false;
        }
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i2 = 0;
        long nameValue = 0L;
        if (offset + 9 <= this.end) {
            byte c0 = this.bytes[offset];
            c1 = this.bytes[offset + 1];
            c2 = this.bytes[offset + 2];
            c3 = this.bytes[offset + 3];
            c4 = this.bytes[offset + 4];
            byte c5 = this.bytes[offset + 5];
            byte c6 = this.bytes[offset + 6];
            byte c7 = this.bytes[offset + 7];
            byte c8 = this.bytes[offset + 8];
            if (c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92) {
                if (c0 == quote) {
                    i2 = 0;
                } else if (c1 == quote) {
                    nameValue = c0;
                    i2 = 1;
                } else if (c2 == quote) {
                    nameValue = ((long)c0 << 8) + ((long)c1 & 0xFFL);
                    i2 = 2;
                } else if (c3 == quote) {
                    nameValue = ((long)c0 << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c2 & 0xFFL);
                    i2 = 3;
                } else if (c4 == quote) {
                    nameValue = ((long)c0 << 24) + (((long)c1 & 0xFFL) << 16) + (((long)c2 & 0xFFL) << 8) + ((long)c3 & 0xFFL);
                    i2 = 4;
                } else if (c5 == quote) {
                    nameValue = ((long)c0 << 32) + (((long)c1 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c3 & 0xFFL) << 8) + ((long)c4 & 0xFFL);
                    i2 = 5;
                } else if (c6 == quote) {
                    nameValue = ((long)c0 << 40) + (((long)c1 & 0xFFL) << 32) + (((long)c2 & 0xFFL) << 24) + (((long)c3 & 0xFFL) << 16) + (((long)c4 & 0xFFL) << 8) + ((long)c5 & 0xFFL);
                    i2 = 6;
                } else if (c7 == quote) {
                    nameValue = ((long)c0 << 48) + (((long)c1 & 0xFFL) << 40) + (((long)c2 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c4 & 0xFFL) << 16) + (((long)c5 & 0xFFL) << 8) + ((long)c6 & 0xFFL);
                    i2 = 7;
                } else if (c8 == quote) {
                    nameValue = ((long)c0 << 56) + (((long)c1 & 0xFFL) << 48) + (((long)c2 & 0xFFL) << 40) + (((long)c3 & 0xFFL) << 32) + (((long)c4 & 0xFFL) << 24) + (((long)c5 & 0xFFL) << 16) + (((long)c6 & 0xFFL) << 8) + ((long)c7 & 0xFFL);
                    i2 = 8;
                }
                if (nameValue != 0L) {
                    offset = this.offset + i2;
                    this.nameEnd = offset++;
                    this.nameLength = i2;
                    int indexMask = (int)nameValue & JSONFactory.NAME_HASH_64_CACHE2.length - 1;
                    JSONFactory.NameHash64Cache nameHash64Cache = JSONFactory.NAME_HASH_64_CACHE2[indexMask];
                    if (nameHash64Cache != null && nameHash64Cache.nameValue == nameValue) {
                        hashCode = nameHash64Cache.hashCode64;
                    } else {
                        switch (i2) {
                            case 1: {
                                hashCode = Fnv.hashCode64(c0);
                                break;
                            }
                            case 2: {
                                hashCode = Fnv.hashCode64(c0, c1);
                                break;
                            }
                            case 3: {
                                hashCode = Fnv.hashCode64(c0, c1, c2);
                                break;
                            }
                            case 4: {
                                hashCode = Fnv.hashCode64(c0, c1, c2, c3);
                                break;
                            }
                            case 5: {
                                hashCode = Fnv.hashCode64(c0, c1, c2, c3, c4);
                                break;
                            }
                            case 6: {
                                hashCode = Fnv.hashCode64(c0, c1, c2, c3, c4, c5);
                                break;
                            }
                            case 7: {
                                hashCode = Fnv.hashCode64(c0, c1, c2, c3, c4, c5, c6);
                                break;
                            }
                            case 8: {
                                hashCode = Fnv.hashCode64(c0, c1, c2, c3, c4, c5, c6, c7);
                                break;
                            }
                        }
                        if (nameHash64Cache == null) {
                            JSONFactory.NAME_HASH_64_CACHE2[indexMask] = new JSONFactory.NameHash64Cache(nameValue, hashCode);
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            while (true) {
                if ((c = (char)this.bytes[offset]) == '\\') {
                    if (!this.nameEscape) {
                        this.nameEscape = true;
                    }
                    c = (char)this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c3 = this.bytes[++offset];
                            c4 = this.bytes[++offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == quote) {
                        this.nameLength = i2;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i2;
            }
        }
        c = offset < this.end ? (char)((char)this.bytes[offset]) : (char)'\u001a';
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = (char)this.bytes[++offset];
        }
        if (c != ':') {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = (char)this.bytes[++offset];
        while (c <= ' ' && (1L << c & 0x100003700L) != 0L) {
            c = (char)this.bytes[++offset];
        }
        this.offset = offset + 1;
        this.ch = c;
        return hashCode;
    }

    @Override
    public long readValueHashCode() {
        int c;
        if (this.ch != '\"') {
            return -1L;
        }
        if (this.nameEscape) {
            this.nameEscape = false;
        }
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i2 = 0;
        while (true) {
            if ((c = (int)(this.bytes[offset] & 0xFF)) == 92) {
                if (!this.nameEscape) {
                    this.nameEscape = true;
                }
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 117: {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 120: {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    case 34: 
                    case 92: {
                        break;
                    }
                    default: {
                        c = JSONReaderASCII.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == 34) {
                    this.nameLength = i2;
                    this.nameEnd = offset++;
                    c = offset == this.end ? 26 : (int)((char)this.bytes[offset]);
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = (char)this.bytes[++offset];
                    }
                    if (c == 44) {
                        this.comma = true;
                        c = ++offset == this.end ? 26 : (int)((char)this.bytes[offset]);
                        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                            c = (char)this.bytes[++offset];
                        }
                    }
                    break;
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i2;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        long hashCode = -3750763034362895579L;
        int offset = this.nameBegin;
        if (!this.nameEscape) {
            for (int i2 = this.nameBegin; i2 < this.nameEnd; ++i2) {
                byte c1;
                char c = (char)this.bytes[i2];
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((c == '_' || c == '-') && (c1 = this.bytes[i2 + 1]) != 34 && c1 != 39 && c1 != c) continue;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            return hashCode;
        }
        while (true) {
            char c;
            if ((c = (char)(this.bytes[offset] & 0xFF)) == '\\') {
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    default: {
                        c = JSONReaderASCII.char1(c);
                        break;
                    }
                }
            } else {
                if (c == '\"') break;
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
            }
            ++offset;
            if (c == '_') continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        byte c4;
        byte c3;
        byte c2;
        byte c1;
        int i2;
        int offset;
        Object[] chars;
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return new String(this.bytes, this.nameBegin, length, StandardCharsets.US_ASCII);
        }
        if (JDKUtils.JVM_VERSION > 8) {
            chars = new byte[this.nameLength];
            offset = this.nameBegin;
            i2 = 0;
            block10: while (offset < this.nameEnd) {
                byte b = this.bytes[offset];
                if (b == 92) {
                    b = this.bytes[++offset];
                    switch (b) {
                        case 117: {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c3 = this.bytes[++offset];
                            c4 = this.bytes[++offset];
                            char c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            if (c > '\u00ff') {
                                chars = null;
                                break block10;
                            }
                            b = (byte)c;
                            break;
                        }
                        case 120: {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            char c = JSONReaderASCII.char2(c1, c2);
                            if (c > '\u00ff') {
                                chars = null;
                                break block10;
                            }
                            b = (byte)c;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            b = (byte)JSONReaderASCII.char1(b);
                            break;
                        }
                    }
                } else if (b == 34) break;
                chars[i2] = b;
                ++offset;
                ++i2;
            }
            if (chars != null) {
                if (JDKUtils.UNSAFE_ASCII_CREATOR != null) {
                    return JDKUtils.UNSAFE_ASCII_CREATOR.apply((byte[])chars);
                }
                return new String((byte[])chars, 0, chars.length, StandardCharsets.US_ASCII);
            }
        }
        chars = new char[this.nameLength];
        offset = this.nameBegin;
        i2 = 0;
        while (offset < this.nameEnd) {
            char c = (char)this.bytes[offset];
            if (c == '\\') {
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.bytes[++offset];
                        c2 = this.bytes[++offset];
                        c3 = this.bytes[++offset];
                        c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.bytes[++offset];
                        c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': {
                        break;
                    }
                    default: {
                        c = JSONReaderASCII.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i2] = c;
            ++offset;
            ++i2;
        }
        return new String((char[])chars);
    }

    @Override
    public String readFieldName() {
        byte c;
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i2 = 0;
        while (true) {
            if ((c = this.bytes[offset]) == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i2;
                    this.nameEnd = offset++;
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    if (c != 58) {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = this.bytes[++offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    break;
                }
                ++offset;
            }
            ++i2;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            int length = this.nameEnd - this.nameBegin;
            switch (length) {
                case 1: {
                    nameValue0 = this.bytes[this.nameBegin];
                    break;
                }
                case 2: {
                    nameValue0 = (this.bytes[this.nameBegin] << 8) + this.bytes[this.nameBegin + 1];
                    break;
                }
                case 3: {
                    nameValue0 = (this.bytes[this.nameBegin] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin + 2];
                    break;
                }
                case 4: {
                    nameValue0 = (this.bytes[this.nameBegin] << 24) + (this.bytes[this.nameBegin + 1] << 16) + (this.bytes[this.nameBegin + 2] << 8) + this.bytes[this.nameBegin + 3];
                    break;
                }
                case 5: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 32) + ((long)this.bytes[this.nameBegin + 1] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 3] << 8) + (long)this.bytes[this.nameBegin + 4];
                    break;
                }
                case 6: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 40) + ((long)this.bytes[this.nameBegin + 1] << 32) + ((long)this.bytes[this.nameBegin + 2] << 24) + ((long)this.bytes[this.nameBegin + 3] << 16) + ((long)this.bytes[this.nameBegin + 4] << 8) + (long)this.bytes[this.nameBegin + 5];
                    break;
                }
                case 7: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 48) + ((long)this.bytes[this.nameBegin + 1] << 40) + ((long)this.bytes[this.nameBegin + 2] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 4] << 16) + ((long)this.bytes[this.nameBegin + 5] << 8) + (long)this.bytes[this.nameBegin + 6];
                    break;
                }
                case 8: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 56) + ((long)this.bytes[this.nameBegin + 1] << 48) + ((long)this.bytes[this.nameBegin + 2] << 40) + ((long)this.bytes[this.nameBegin + 3] << 32) + ((long)this.bytes[this.nameBegin + 4] << 24) + ((long)this.bytes[this.nameBegin + 5] << 16) + ((long)this.bytes[this.nameBegin + 6] << 8) + (long)this.bytes[this.nameBegin + 7];
                    break;
                }
                case 9: {
                    nameValue0 = this.bytes[this.nameBegin + 0];
                    nameValue1 = ((long)this.bytes[this.nameBegin] + 1L << 56) + ((long)this.bytes[this.nameBegin + 2] << 48) + ((long)this.bytes[this.nameBegin + 3] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 5] << 24) + ((long)this.bytes[this.nameBegin + 6] << 16) + ((long)this.bytes[this.nameBegin + 7] << 8) + (long)this.bytes[this.nameBegin + 8];
                    break;
                }
                case 10: {
                    nameValue0 = (this.bytes[this.nameBegin] << 8) + this.bytes[this.nameBegin + 1];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 2] << 56) + ((long)this.bytes[this.nameBegin + 3] << 48) + ((long)this.bytes[this.nameBegin + 4] << 40) + ((long)this.bytes[this.nameBegin + 5] << 32) + ((long)this.bytes[this.nameBegin + 6] << 24) + ((long)this.bytes[this.nameBegin + 7] << 16) + ((long)this.bytes[this.nameBegin + 8] << 8) + (long)this.bytes[this.nameBegin + 9];
                    break;
                }
                case 11: {
                    nameValue0 = (this.bytes[this.nameBegin] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin + 2];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 3] << 56) + ((long)this.bytes[this.nameBegin + 4] << 48) + ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 6] << 32) + ((long)this.bytes[this.nameBegin + 7] << 24) + ((long)this.bytes[this.nameBegin + 8] << 16) + ((long)this.bytes[this.nameBegin + 9] << 8) + (long)this.bytes[this.nameBegin + 10];
                    break;
                }
                case 12: {
                    nameValue0 = (this.bytes[this.nameBegin] << 24) + (this.bytes[this.nameBegin + 1] << 16) + (this.bytes[this.nameBegin + 2] << 8) + this.bytes[this.nameBegin + 3];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 4] << 56) + ((long)this.bytes[this.nameBegin + 5] << 48) + ((long)this.bytes[this.nameBegin + 6] << 40) + ((long)this.bytes[this.nameBegin + 7] << 32) + ((long)this.bytes[this.nameBegin + 8] << 24) + ((long)this.bytes[this.nameBegin + 9] << 16) + ((long)this.bytes[this.nameBegin + 10] << 8) + (long)this.bytes[this.nameBegin + 11];
                    break;
                }
                case 13: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 32) + ((long)this.bytes[this.nameBegin + 1] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 3] << 8) + (long)this.bytes[this.nameBegin + 4];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 5] << 56) + ((long)this.bytes[this.nameBegin + 6] << 48) + ((long)this.bytes[this.nameBegin + 7] << 40) + ((long)this.bytes[this.nameBegin + 8] << 32) + ((long)this.bytes[this.nameBegin + 9] << 24) + ((long)this.bytes[this.nameBegin + 10] << 16) + ((long)this.bytes[this.nameBegin + 11] << 8) + (long)this.bytes[this.nameBegin + 12];
                    break;
                }
                case 14: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 40) + ((long)this.bytes[this.nameBegin + 1] << 32) + ((long)this.bytes[this.nameBegin + 2] << 24) + ((long)this.bytes[this.nameBegin + 3] << 16) + ((long)this.bytes[this.nameBegin + 4] << 8) + (long)this.bytes[this.nameBegin + 5];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 6] << 56) + ((long)this.bytes[this.nameBegin + 7] << 48) + ((long)this.bytes[this.nameBegin + 8] << 40) + ((long)this.bytes[this.nameBegin + 9] << 32) + ((long)this.bytes[this.nameBegin + 10] << 24) + ((long)this.bytes[this.nameBegin + 11] << 16) + ((long)this.bytes[this.nameBegin + 12] << 8) + (long)this.bytes[this.nameBegin + 13];
                    break;
                }
                case 15: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 48) + ((long)this.bytes[this.nameBegin + 1] << 40) + ((long)this.bytes[this.nameBegin + 2] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 4] << 16) + ((long)this.bytes[this.nameBegin + 5] << 8) + (long)this.bytes[this.nameBegin + 6];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 7] << 56) + ((long)this.bytes[this.nameBegin + 8] << 48) + ((long)this.bytes[this.nameBegin + 9] << 40) + ((long)this.bytes[this.nameBegin + 10] << 32) + ((long)this.bytes[this.nameBegin + 11] << 24) + ((long)this.bytes[this.nameBegin + 12] << 16) + ((long)this.bytes[this.nameBegin + 13] << 8) + (long)this.bytes[this.nameBegin + 14];
                    break;
                }
                case 16: {
                    nameValue0 = ((long)this.bytes[this.nameBegin] << 56) + ((long)this.bytes[this.nameBegin + 1] << 48) + ((long)this.bytes[this.nameBegin + 2] << 40) + ((long)this.bytes[this.nameBegin + 3] << 32) + ((long)this.bytes[this.nameBegin + 4] << 24) + ((long)this.bytes[this.nameBegin + 5] << 16) + ((long)this.bytes[this.nameBegin + 6] << 8) + (long)this.bytes[this.nameBegin + 7];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 8] << 56) + ((long)this.bytes[this.nameBegin + 9] << 48) + ((long)this.bytes[this.nameBegin + 10] << 40) + ((long)this.bytes[this.nameBegin + 11] << 32) + ((long)this.bytes[this.nameBegin + 12] << 24) + ((long)this.bytes[this.nameBegin + 13] << 16) + ((long)this.bytes[this.nameBegin + 14] << 8) + (long)this.bytes[this.nameBegin + 15];
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    int indexMask = (int)nameValue1 & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        if (JSONFactory.Utils.STRING_CREATOR_JDK8 == null && !JSONFactory.Utils.STRING_CREATOR_ERROR) {
                            try {
                                JSONFactory.Utils.STRING_CREATOR_JDK8 = JDKUtils.getStringCreatorJDK8();
                            }
                            catch (Throwable e) {
                                JSONFactory.Utils.STRING_CREATOR_ERROR = true;
                            }
                        }
                        char[] chars = new char[length];
                        for (int i3 = 0; i3 < length; ++i3) {
                            chars[i3] = (char)(this.bytes[this.nameBegin + i3] & 0xFF);
                        }
                        String name = JSONFactory.Utils.STRING_CREATOR_JDK8 != null ? JSONFactory.Utils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)nameValue0 & JSONFactory.NAME_CACHE.length - 1;
                    JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        if (JSONFactory.Utils.STRING_CREATOR_JDK8 == null && !JSONFactory.Utils.STRING_CREATOR_ERROR) {
                            try {
                                JSONFactory.Utils.STRING_CREATOR_JDK8 = JDKUtils.getStringCreatorJDK8();
                            }
                            catch (Throwable e) {
                                JSONFactory.Utils.STRING_CREATOR_ERROR = true;
                            }
                        }
                        char[] chars = new char[length];
                        for (int i4 = 0; i4 < length; ++i4) {
                            chars[i4] = (char)(this.bytes[this.nameBegin + i4] & 0xFF);
                        }
                        String name = JSONFactory.Utils.STRING_CREATOR_JDK8 != null ? JSONFactory.Utils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE) : new String(chars);
                        JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
        }
        return this.getFieldName();
    }

    @Override
    protected void readString0() {
        String str;
        char quote = this.ch;
        int start = this.offset;
        this.valueEscape = false;
        int i2 = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[this.offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++this.offset];
                switch (c) {
                    case 117: {
                        this.offset += 4;
                        break;
                    }
                    case 120: {
                        this.offset += 2;
                        break;
                    }
                }
                ++this.offset;
            } else {
                if (c == quote) break;
                ++this.offset;
            }
            ++i2;
        }
        int valueLength = i2;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            this.offset = start;
            int i3 = 0;
            while (true) {
                char c;
                if ((c = (char)this.bytes[this.offset]) == '\\') {
                    c = (char)this.bytes[++this.offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            byte c3 = this.bytes[++this.offset];
                            byte c4 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderASCII.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i3] = c;
                ++this.offset;
                ++i3;
            }
            str = new String(chars);
        } else if (JDKUtils.JVM_VERSION >= 9) {
            if (JSONFactory.Utils.STRING_CREATOR_JDK11 == null && !JSONFactory.Utils.STRING_CREATOR_ERROR) {
                try {
                    JSONFactory.Utils.STRING_CREATOR_JDK11 = JDKUtils.getStringCreatorJDK11();
                }
                catch (Throwable e) {
                    JSONFactory.Utils.STRING_CREATOR_ERROR = true;
                }
            }
            if (JSONFactory.Utils.STRING_CREATOR_JDK11 == null) {
                str = new String(this.bytes, start, this.offset - start, StandardCharsets.US_ASCII);
            } else {
                byte[] bytes = Arrays.copyOfRange(this.bytes, start, this.offset);
                str = JSONFactory.Utils.STRING_CREATOR_JDK11.apply(bytes);
            }
        } else {
            str = new String(this.bytes, start, this.offset - start, StandardCharsets.US_ASCII);
        }
        byte b = this.bytes[++this.offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++this.offset];
        }
        if (b == 44) {
            this.comma = true;
            ++this.offset;
            this.next();
        } else {
            ++this.offset;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            byte c3;
            byte c2;
            byte c1;
            byte c0;
            int offset;
            byte quote = (byte)this.ch;
            int slash = 92;
            int start = offset = this.offset;
            boolean valueEscape = false;
            int i2 = 0;
            boolean quoted = false;
            while (offset + 8 <= this.end) {
                c0 = this.bytes[offset];
                c1 = this.bytes[offset + 1];
                c2 = this.bytes[offset + 2];
                c3 = this.bytes[offset + 3];
                byte c4 = this.bytes[offset + 4];
                byte c5 = this.bytes[offset + 5];
                byte c6 = this.bytes[offset + 6];
                byte c7 = this.bytes[offset + 7];
                if (c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c4 == 92 || c5 == 92 || c6 == 92 || c7 == 92) break;
                if (c0 == quote || c1 == quote || c2 == quote || c3 == quote || c4 == quote || c5 == quote || c6 == quote || c7 == quote) {
                    quoted = true;
                    break;
                }
                offset += 8;
                i2 += 8;
            }
            if (!quoted) {
                while (offset + 4 <= this.end) {
                    c0 = this.bytes[offset];
                    c1 = this.bytes[offset + 1];
                    c2 = this.bytes[offset + 2];
                    c3 = this.bytes[offset + 3];
                    if (c0 == 92 || c1 == 92 || c2 == 92 || c3 == 92 || c0 == quote || c1 == quote || c2 == quote || c3 == quote) break;
                    offset += 4;
                    i2 += 4;
                }
            }
            while (true) {
                if (offset >= this.end) {
                    throw new JSONException("invalid escape character EOI");
                }
                byte c = this.bytes[offset];
                if (c == 92) {
                    valueEscape = true;
                    c = this.bytes[++offset];
                    switch (c) {
                        case 117: {
                            offset += 4;
                            break;
                        }
                        case 120: {
                            offset += 2;
                            break;
                        }
                    }
                    ++offset;
                } else {
                    if (c == quote) break;
                    ++offset;
                }
                ++i2;
            }
            int valueLength = i2;
            if (valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i3 = 0;
                while (true) {
                    char c;
                    if ((c = (char)this.bytes[offset]) == '\\') {
                        c = (char)this.bytes[++offset];
                        switch (c) {
                            case 'u': {
                                char c12 = (char)this.bytes[++offset];
                                char c22 = (char)this.bytes[++offset];
                                char c32 = (char)this.bytes[++offset];
                                char c4 = (char)this.bytes[++offset];
                                c = JSONReaderASCII.char4(c12, c22, c32, c4);
                                break;
                            }
                            case 'x': {
                                char c12 = (char)this.bytes[++offset];
                                char c22 = (char)this.bytes[++offset];
                                c = JSONReaderASCII.char2(c12, c22);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderASCII.char1(c);
                                break;
                            }
                        }
                    } else if (c == quote) break;
                    chars[i3] = c;
                    ++offset;
                    ++i3;
                }
                str = new String(chars);
            } else if (this.str != null) {
                str = this.str.substring(this.offset, offset);
            } else if (JDKUtils.JVM_VERSION == 11 && !JSONFactory.Utils.STRING_CREATOR_ERROR) {
                if (JSONFactory.Utils.STRING_CREATOR_JDK11 == null) {
                    try {
                        JSONFactory.Utils.STRING_CREATOR_JDK11 = JDKUtils.getStringCreatorJDK11();
                    }
                    catch (Throwable e) {
                        JSONFactory.Utils.STRING_CREATOR_ERROR = true;
                    }
                }
                if (JSONFactory.Utils.STRING_CREATOR_JDK11 == null) {
                    str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.US_ASCII);
                } else {
                    byte[] bytes = Arrays.copyOfRange(this.bytes, this.offset, offset);
                    str = JSONFactory.Utils.STRING_CREATOR_JDK11.apply(bytes);
                }
            } else if (JDKUtils.JVM_VERSION > 8 && JDKUtils.UNSAFE_ASCII_CREATOR != null) {
                byte[] bytes = Arrays.copyOfRange(this.bytes, this.offset, offset);
                str = JDKUtils.UNSAFE_ASCII_CREATOR.apply(bytes);
            } else {
                str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.US_ASCII);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                return str;
            }
            byte b = this.bytes[++offset];
            while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
                b = this.bytes[++offset];
            }
            if (b == 44) {
                this.comma = true;
                this.offset = offset + 1;
                this.ch = (char)this.bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else {
                this.offset = offset + 1;
                this.ch = (char)b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }
}

