/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.filter;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContextAutoTypeBeforeHandler
implements JSONReader.AutoTypeBeforeHandler {
    final long[] acceptHashCodes;
    final Map<String, Class> classCache = new ConcurrentHashMap<String, Class>(16, 0.75f, 1);

    public ContextAutoTypeBeforeHandler(String[] acceptNames) {
        long[] array = new long[acceptNames.length];
        int index = 0;
        for (int i2 = 0; i2 < acceptNames.length; ++i2) {
            String name = acceptNames[i2];
            if (name == null || name.isEmpty()) continue;
            long hashCode = Fnv.hashCode64(name);
            array[index++] = hashCode;
        }
        if (index != array.length) {
            array = Arrays.copyOf(array, index);
        }
        Arrays.sort(array);
        this.acceptHashCodes = array;
    }

    @Override
    public Class<?> apply(String typeName, Class<?> expectClass, long features) {
        long hash = -3750763034362895579L;
        int typeNameLength = typeName.length();
        for (int i2 = 0; i2 < typeNameLength; ++i2) {
            Class origin;
            int ch = typeName.charAt(i2);
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) < 0) continue;
            Class clazz = this.classCache.get(typeName);
            if (clazz == null && (clazz = TypeUtils.loadClass(typeName)) != null && (origin = this.classCache.putIfAbsent(typeName, clazz)) != null) {
                clazz = origin;
            }
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }
}

