/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.function.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import java.util.List;
import java.util.function.Function;

public class ToDouble
implements Function {
    final Double defaultValue;

    public ToDouble(Double defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object apply(Object o) {
        if (o == null) {
            return this.defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.isEmpty()) {
                return this.defaultValue;
            }
            return Double.parseDouble(str);
        }
        if (o instanceof List) {
            List list = (List)o;
            JSONArray array = new JSONArray(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Object item = list.get(i2);
                array.add(this.apply(item));
            }
            return array;
        }
        throw new JSONException("can not cast to Double " + o.getClass());
    }
}

