/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.asm;

public final class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final int METHOD = 11;
    private static final int INTERNAL = 12;
    private static final String PRIMITIVE_DESCRIPTORS = "VZCBSIFJD";
    public static final Type VOID_TYPE = new Type(0, "VZCBSIFJD", 0, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, "VZCBSIFJD", 1, 2);
    public static final Type CHAR_TYPE = new Type(2, "VZCBSIFJD", 2, 3);
    public static final Type BYTE_TYPE = new Type(3, "VZCBSIFJD", 3, 4);
    public static final Type SHORT_TYPE = new Type(4, "VZCBSIFJD", 4, 5);
    public static final Type INT_TYPE = new Type(5, "VZCBSIFJD", 5, 6);
    public static final Type FLOAT_TYPE = new Type(6, "VZCBSIFJD", 6, 7);
    public static final Type LONG_TYPE = new Type(7, "VZCBSIFJD", 7, 8);
    public static final Type DOUBLE_TYPE = new Type(8, "VZCBSIFJD", 8, 9);
    private final int sort;
    private final String valueBuffer;
    private final int valueBegin;
    private final int valueEnd;

    private Type(int sort, String valueBuffer, int valueBegin, int valueEnd) {
        this.sort = sort;
        this.valueBuffer = valueBuffer;
        this.valueBegin = valueBegin;
        this.valueEnd = valueEnd;
    }

    public static Type getType(String typeDescriptor) {
        return Type.getTypeInternal(typeDescriptor, 0, typeDescriptor.length());
    }

    public static Type[] getArgumentTypes(String methodDescriptor) {
        int numArgumentTypes = 0;
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            ++numArgumentTypes;
        }
        Type[] argumentTypes = new Type[numArgumentTypes];
        currentOffset = 1;
        int currentArgumentTypeIndex = 0;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            int currentArgumentTypeOffset = currentOffset;
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) == 'L') {
                int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
            }
            argumentTypes[currentArgumentTypeIndex++] = Type.getTypeInternal(methodDescriptor, currentArgumentTypeOffset, currentOffset);
        }
        return argumentTypes;
    }

    static int getReturnTypeOffset(String methodDescriptor) {
        int currentOffset = 1;
        while (methodDescriptor.charAt(currentOffset) != ')') {
            while (methodDescriptor.charAt(currentOffset) == '[') {
                ++currentOffset;
            }
            if (methodDescriptor.charAt(currentOffset++) != 'L') continue;
            int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
            currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
        }
        return currentOffset + 1;
    }

    private static Type getTypeInternal(String descriptorBuffer, int descriptorBegin, int descriptorEnd) {
        switch (descriptorBuffer.charAt(descriptorBegin)) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                return new Type(9, descriptorBuffer, descriptorBegin, descriptorEnd);
            }
            case 'L': {
                return new Type(10, descriptorBuffer, descriptorBegin + 1, descriptorEnd - 1);
            }
            case '(': {
                return new Type(11, descriptorBuffer, descriptorBegin, descriptorEnd);
            }
        }
        throw new IllegalArgumentException();
    }

    public String getInternalName() {
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public String getDescriptor() {
        if (this.sort == 10) {
            return this.valueBuffer.substring(this.valueBegin - 1, this.valueEnd + 1);
        }
        if (this.sort == 12) {
            return 'L' + this.valueBuffer.substring(this.valueBegin, this.valueEnd) + ';';
        }
        return this.valueBuffer.substring(this.valueBegin, this.valueEnd);
    }

    public int getSort() {
        return this.sort == 12 ? 10 : this.sort;
    }

    public static int getArgumentsAndReturnSizes(String methodDescriptor) {
        int argumentsSize = 1;
        int currentOffset = 1;
        char currentChar = methodDescriptor.charAt(currentOffset);
        while (currentChar != ')') {
            if (currentChar == 'J' || currentChar == 'D') {
                ++currentOffset;
                argumentsSize += 2;
            } else {
                while (methodDescriptor.charAt(currentOffset) == '[') {
                    ++currentOffset;
                }
                if (methodDescriptor.charAt(currentOffset++) == 'L') {
                    int semiColumnOffset = methodDescriptor.indexOf(59, currentOffset);
                    currentOffset = Math.max(currentOffset, semiColumnOffset + 1);
                }
                ++argumentsSize;
            }
            currentChar = methodDescriptor.charAt(currentOffset);
        }
        currentChar = methodDescriptor.charAt(currentOffset + 1);
        if (currentChar == 'V') {
            return argumentsSize << 2;
        }
        int returnSize = currentChar == 'J' || currentChar == 'D' ? 2 : 1;
        return argumentsSize << 2 | returnSize;
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuilder stringBuilder = new StringBuilder(this.getElementType().getClassName());
                for (int i2 = this.getDimensions(); i2 > 0; --i2) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            case 10: 
            case 12: {
                return this.valueBuffer.substring(this.valueBegin, this.valueEnd).replace('/', '.');
            }
        }
        throw new AssertionError();
    }

    public Type getElementType() {
        int numDimensions = this.getDimensions();
        return Type.getTypeInternal(this.valueBuffer, this.valueBegin + numDimensions, this.valueEnd);
    }

    public int getDimensions() {
        int numDimensions = 1;
        while (this.valueBuffer.charAt(this.valueBegin + numDimensions) == '[') {
            ++numDimensions;
        }
        return numDimensions;
    }
}

