/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.trove.map.hash;

import com.alibaba.fastjson2.internal.trove.impl.PrimeFinder;
import com.alibaba.fastjson2.internal.trove.procedure.TLongIntProcedure;

public class TLongIntHashMap {
    public static final int DEFAULT_ENTRY_VALUE = -1;
    static final byte FREE = 0;
    static final byte FULL = 1;
    protected int[] values;
    protected long[] set;
    protected boolean consumeFreeSlot;
    protected byte[] states;
    protected int size;
    protected int free;
    protected int maxSize;

    public TLongIntHashMap() {
        int capacity = 37;
        this.maxSize = 18;
        this.free = capacity;
        this.states = new byte[capacity];
        this.set = new long[capacity];
        this.values = new int[capacity];
    }

    public void put(long key, int value) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int index = hash % this.states.length;
        byte state = this.states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.set[index] = key;
            this.states[index] = 1;
        } else if (state == 1 && this.set[index] == key) {
            index = -index - 1;
        } else {
            int length = this.set.length;
            int probe = 1 + hash % (length - 2);
            int loopIndex = index;
            do {
                if ((index -= probe) < 0) {
                    index += length;
                }
                if ((state = this.states[index]) == 0) {
                    this.consumeFreeSlot = true;
                    this.set[index] = key;
                    this.states[index] = 1;
                    break;
                }
                if (state != 1 || this.set[index] != key) continue;
                index = -index - 1;
                break;
            } while (index != loopIndex);
        }
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            isNewMapping = false;
        }
        this.values[index] = value;
        if (isNewMapping) {
            if (this.consumeFreeSlot) {
                --this.free;
            }
            if (++this.size > this.maxSize || this.free == 0) {
                int capacity = this.states.length;
                int newCapacity = this.size > this.maxSize ? PrimeFinder.nextPrime(capacity << 1) : capacity;
                int oldCapacity = this.set.length;
                long[] oldKeys = this.set;
                int[] oldVals = this.values;
                byte[] oldStates = this.states;
                this.set = new long[newCapacity];
                this.values = new int[newCapacity];
                this.states = new byte[newCapacity];
                int i2 = oldCapacity;
                while (i2-- > 0) {
                    if (oldStates[i2] != 1) continue;
                    long o = oldKeys[i2];
                    index = this.insertKey(o);
                    this.values[index] = oldVals[i2];
                }
                capacity = this.states.length;
                this.maxSize = Math.min(capacity - 1, (int)((float)capacity * 0.5f));
                this.free = capacity - this.size;
            }
        }
    }

    public int get(long key) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int length = this.states.length;
        int index = hash % length;
        byte state = this.states[index];
        if (state == 0) {
            return -1;
        }
        if (state == 1 && this.set[index] == key) {
            return this.values[index];
        }
        int setLength = this.set.length;
        int probe = 1 + hash % (setLength - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += setLength;
            }
            if ((state = this.states[index]) == 0) {
                return -1;
            }
            if (key != this.set[index]) continue;
            return this.values[index];
        } while (index != loopIndex);
        return -1;
    }

    public boolean forEachEntry(TLongIntProcedure procedure) {
        byte[] states = this.states;
        long[] keys = this.set;
        int[] values = this.values;
        int i2 = keys.length;
        while (i2-- > 0) {
            if (states[i2] != 1 || procedure.execute(keys[i2], values[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder("{");
        this.forEachEntry(new TLongIntProcedure(){
            private boolean first = true;

            @Override
            public boolean execute(long key, int value) {
                if (this.first) {
                    this.first = false;
                } else {
                    buf.append(", ");
                }
                buf.append(key);
                buf.append("=");
                buf.append(value);
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public int size() {
        return this.size;
    }

    protected int insertKey(long key) {
        int hash = (int)(key ^ key >>> 32) & Integer.MAX_VALUE;
        int index = hash % this.states.length;
        byte state = this.states[index];
        this.consumeFreeSlot = false;
        if (state == 0) {
            this.consumeFreeSlot = true;
            this.set[index] = key;
            this.states[index] = 1;
            return index;
        }
        if (state == 1 && this.set[index] == key) {
            return -index - 1;
        }
        int length = this.set.length;
        int probe = 1 + hash % (length - 2);
        int loopIndex = index;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if ((state = this.states[index]) == 0) {
                this.consumeFreeSlot = true;
                this.set[index] = key;
                this.states[index] = 1;
                return index;
            }
            if (state != 1 || this.set[index] != key) continue;
            return -index - 1;
        } while (index != loopIndex);
        throw new IllegalStateException("No free or removed slots available. Key set full?!!");
    }
}

