/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.function.Function;

class FactoryFunction<T>
implements Function<Map<Long, Object>, T> {
    final Method factoryMethod;
    final String[] paramNames;
    final long[] hashCodes;

    FactoryFunction(Method factoryMethod, String ... paramNames) {
        this.factoryMethod = factoryMethod;
        Parameter[] parameters = factoryMethod.getParameters();
        this.paramNames = new String[parameters.length];
        this.hashCodes = new long[parameters.length];
        for (int i2 = 0; i2 < parameters.length; ++i2) {
            String name = i2 < paramNames.length ? paramNames[i2] : parameters[i2].getName();
            paramNames[i2] = name;
            this.hashCodes[i2] = Fnv.hashCode64(name);
        }
    }

    @Override
    public T apply(Map<Long, Object> values) {
        Object[] args = new Object[this.hashCodes.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            args[i2] = values.get(this.hashCodes[i2]);
        }
        try {
            return (T)this.factoryMethod.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke factoryMethod error", e);
        }
    }
}

