/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Supplier;

class ObjectReader3<T>
extends ObjectReaderBean<T> {
    final Supplier<T> defaultCreator;
    final long features;
    final Function buildFunction;
    final FieldReader fieldReader0;
    final FieldReader fieldReader1;
    final FieldReader fieldReader2;
    final long hashCode0;
    final long hashCode1;
    final long hashCode2;
    final long hashCode0LCase;
    final long hashCode1LCase;
    final long hashCode2LCase;

    ObjectReader3(Class objectClass, Supplier<T> defaultCreator, long features, JSONSchema schema, Function buildFunction, FieldReader fieldReader0, FieldReader fieldReader1, FieldReader fieldReader2) {
        super(objectClass, null, schema);
        this.defaultCreator = defaultCreator;
        this.features = features;
        this.buildFunction = buildFunction;
        this.fieldReader0 = fieldReader0;
        this.fieldReader1 = fieldReader1;
        this.fieldReader2 = fieldReader2;
        String fieldName0 = fieldReader0.getFieldName();
        String fieldName1 = fieldReader1.getFieldName();
        String fieldName2 = fieldReader2.getFieldName();
        this.hashCode0 = Fnv.hashCode64(fieldName0);
        this.hashCode1 = Fnv.hashCode64(fieldName1);
        this.hashCode2 = Fnv.hashCode64(fieldName2);
        this.hashCode0LCase = Fnv.hashCode64LCase(fieldName0);
        this.hashCode1LCase = Fnv.hashCode64LCase(fieldName1);
        this.hashCode2LCase = Fnv.hashCode64LCase(fieldName2);
        if (fieldReader0.isUnwrapped()) {
            this.extraFieldReader = fieldReader0;
        }
        if (fieldReader1.isUnwrapped()) {
            this.extraFieldReader = fieldReader1;
        }
        if (fieldReader2.isUnwrapped()) {
            this.extraFieldReader = fieldReader2;
        }
        this.hasDefaultValue = fieldReader0.getDefaultValue() != null || fieldReader1.getDefaultValue() != null || fieldReader2.getDefaultValue() != null;
    }

    @Override
    protected void initDefaultValue(T object) {
        this.fieldReader0.setDefault(object);
        this.fieldReader1.setDefault(object);
        this.fieldReader2.setDefault(object);
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T createInstance(long features) {
        return this.defaultCreator.get();
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader = this.checkAutoType(jsonReader, this.objectClass, this.features | features);
        if (autoTypeReader != null && autoTypeReader != this && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        jsonReader.startArray();
        T object = this.defaultCreator.get();
        this.fieldReader0.readFieldValue(jsonReader, object);
        this.fieldReader1.readFieldValue(jsonReader, object);
        this.fieldReader2.readFieldValue(jsonReader, object);
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        if (jsonReader.isArray()) {
            int entryCnt = jsonReader.startArray();
            T object2 = this.defaultCreator.get();
            this.fieldReader0.readFieldValue(jsonReader, object2);
            this.fieldReader1.readFieldValue(jsonReader, object2);
            this.fieldReader2.readFieldValue(jsonReader, object2);
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object2);
            }
            return object2;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (!jsonReader.nextIfMatch((byte)-90)) {
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        if (this.defaultCreator != null) {
            object = this.defaultCreator.get();
        } else if (JDKUtils.UNSAFE_SUPPORT && ((features | jsonReader.getContext().getFeatures()) & JSONReader.Feature.FieldBased.mask) != 0L) {
            try {
                object = UnsafeUtils.UNSAFE.allocateInstance(this.objectClass);
            }
            catch (InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error"), e);
            }
        } else {
            object = null;
        }
        if (object != null && this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        while (!jsonReader.nextIfMatch((byte)-91)) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode == 0L) continue;
            if (hashCode == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (hashCode == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                this.processExtra(jsonReader, object);
                continue;
            }
            long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
            if (nameHashCodeLCase == this.hashCode0) {
                this.fieldReader0.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode1) {
                this.fieldReader1.readFieldValue(jsonReader, object);
                continue;
            }
            if (nameHashCodeLCase == this.hashCode2) {
                this.fieldReader2.readFieldValue(jsonReader, object);
                continue;
            }
            this.processExtra(jsonReader, object);
        }
        if (this.fieldReader0.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader0;
        }
        if (this.fieldReader1.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader1;
        }
        if (this.fieldReader2.isUnwrapped()) {
            this.extraFieldReader = this.fieldReader2;
        }
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isJSONB()) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (jsonReader.nextIfNull()) {
            jsonReader.nextIfMatch(',');
            return null;
        }
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            jsonReader.nextIfMatch('[');
            T object = this.defaultCreator.get();
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            this.fieldReader0.readFieldValue(jsonReader, object);
            this.fieldReader1.readFieldValue(jsonReader, object);
            this.fieldReader2.readFieldValue(jsonReader, object);
            if (!jsonReader.nextIfMatch(']')) {
                throw new JSONException(jsonReader.info("array to bean end error"));
            }
            jsonReader.nextIfMatch(',');
            if (this.buildFunction != null) {
                return (T)this.buildFunction.apply(object);
            }
            return object;
        }
        jsonReader.nextIfMatch('{');
        Object object = this.defaultCreator.get();
        if (this.hasDefaultValue) {
            this.initDefaultValue(object);
        }
        int i2 = 0;
        while (!jsonReader.nextIfMatch('}')) {
            long hashCode = jsonReader.readFieldNameHashCode();
            if (hashCode != 0L) {
                if (i2 == 0 && hashCode == HASH_TYPE) {
                    String typeName;
                    long typeHash = jsonReader.readTypeHashCode();
                    JSONReader.Context context = jsonReader.getContext();
                    ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                    if ((autoTypeObjectReader != null || (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) != null) && autoTypeObjectReader != this) {
                        object = autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, features);
                        break;
                    }
                } else if (hashCode == this.hashCode0) {
                    this.fieldReader0.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode1) {
                    this.fieldReader1.readFieldValue(jsonReader, object);
                } else if (hashCode == this.hashCode2) {
                    this.fieldReader2.readFieldValue(jsonReader, object);
                } else if (!jsonReader.isSupportSmartMatch(features | this.features)) {
                    this.processExtra(jsonReader, object);
                } else {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    if (nameHashCodeLCase == this.hashCode0LCase) {
                        this.fieldReader0.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode1LCase) {
                        this.fieldReader1.readFieldValue(jsonReader, object);
                    } else if (nameHashCodeLCase == this.hashCode2LCase) {
                        this.fieldReader2.readFieldValue(jsonReader, object);
                    } else {
                        this.processExtra(jsonReader, object);
                    }
                }
            }
            ++i2;
        }
        jsonReader.nextIfMatch(',');
        if (this.buildFunction != null) {
            object = this.buildFunction.apply(object);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        if (hashCode == this.hashCode0) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2) {
            return this.fieldReader2;
        }
        return null;
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        if (hashCode == this.hashCode0LCase) {
            return this.fieldReader0;
        }
        if (hashCode == this.hashCode1LCase) {
            return this.fieldReader1;
        }
        if (hashCode == this.hashCode2LCase) {
            return this.fieldReader2;
        }
        return null;
    }
}

