/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerArray;

class ObjectReaderImplAtomicIntegerArray
extends ObjectReaderBaseModule.PrimitiveImpl {
    static final ObjectReaderImplAtomicIntegerArray INSTANCE = new ObjectReaderImplAtomicIntegerArray();

    ObjectReaderImplAtomicIntegerArray() {
    }

    @Override
    public Class getObjectClass() {
        return AtomicIntegerArray.class;
    }

    @Override
    public Object createInstance(Collection collection) {
        AtomicIntegerArray array = new AtomicIntegerArray(collection.size());
        int index = 0;
        for (Object item : collection) {
            array.set(index++, TypeUtils.toIntValue(item));
        }
        return array;
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfMatch('[')) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            while (!jsonReader.nextIfMatch(']')) {
                values.add(jsonReader.readInt32());
            }
            jsonReader.nextIfMatch(',');
            AtomicIntegerArray array = new AtomicIntegerArray(values.size());
            for (int i2 = 0; i2 < values.size(); ++i2) {
                Integer value = (Integer)values.get(i2);
                if (value == null) continue;
                array.set(i2, value);
            }
            return array;
        }
        throw new JSONException(jsonReader.info("TODO"));
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        int entryCnt = jsonReader.startArray();
        if (entryCnt == -1) {
            return null;
        }
        AtomicIntegerArray array = new AtomicIntegerArray(entryCnt);
        for (int i2 = 0; i2 < entryCnt; ++i2) {
            Integer value = jsonReader.readInt32();
            if (value == null) continue;
            array.set(i2, value);
        }
        return array;
    }
}

