/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.schema.Any;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;

final class AnyOf
extends JSONSchema {
    final JSONSchema[] items;

    public AnyOf(JSONSchema[] items) {
        super(null, null);
        this.items = items;
    }

    public AnyOf(JSONObject input, JSONSchema parent) {
        super(input);
        JSONArray items = input.getJSONArray("anyOf");
        if (items == null || items.isEmpty()) {
            throw new JSONException("anyOf not found");
        }
        this.items = new JSONSchema[items.size()];
        for (int i2 = 0; i2 < this.items.length; ++i2) {
            Object item = items.get(i2);
            this.items[i2] = item instanceof Boolean ? ((Boolean)item != false ? Any.INSTANCE : Any.NOT_ANY) : JSONSchema.of((JSONObject)item, parent);
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.AllOf;
    }

    @Override
    public ValidateResult validate(Object value) {
        for (JSONSchema item : this.items) {
            ValidateResult result = item.validate(value);
            if (result != SUCCESS) continue;
            return SUCCESS;
        }
        return FAIL_ANY_OF;
    }
}

