/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.FormatValidator;
import java.nio.ByteBuffer;

final class IPAddressValidator
implements FormatValidator {
    static final IPAddressValidator IPV6 = new IPAddressValidator(false);
    static final IPAddressValidator IPV4 = new IPAddressValidator(true);
    final boolean v4;

    public IPAddressValidator(boolean v4) {
        this.v4 = v4;
    }

    @Override
    public boolean isValid(String address) {
        if (address == null) {
            return false;
        }
        if (!IPAddressValidator.isInetAddress(address)) {
            return false;
        }
        if (this.v4) {
            return address.indexOf(46) != -1;
        }
        return address.indexOf(58) != -1;
    }

    static boolean isInetAddress(String ip) {
        String ipString = ip;
        boolean hasColon = false;
        boolean hasDot = false;
        int percentIndex = -1;
        for (int i2 = 0; i2 < ipString.length(); ++i2) {
            char c = ipString.charAt(i2);
            if (c == '.') {
                hasDot = true;
                continue;
            }
            if (c == ':') {
                if (hasDot) {
                    return false;
                }
                hasColon = true;
                continue;
            }
            if (c == '%') {
                percentIndex = i2;
                break;
            }
            if (Character.digit(c, 16) != -1) continue;
            return false;
        }
        if (hasColon) {
            if (hasDot && (ipString = IPAddressValidator.convertDottedQuadToHex(ipString)) == null) {
                return false;
            }
            if (percentIndex != -1) {
                ipString = ipString.substring(0, percentIndex);
            }
            return IPAddressValidator.numericFormatV6(ipString);
        }
        if (hasDot) {
            if (percentIndex != -1) {
                return false;
            }
            return IPAddressValidator.textToNumericFormatV4(ipString) != null;
        }
        return false;
    }

    static String convertDottedQuadToHex(String ipString) {
        int lastColon = ipString.lastIndexOf(58);
        String initialPart = ipString.substring(0, lastColon + 1);
        String dottedQuad = ipString.substring(lastColon + 1);
        byte[] quad = IPAddressValidator.textToNumericFormatV4(dottedQuad);
        if (quad == null) {
            return null;
        }
        String penultimate = Integer.toHexString((quad[0] & 0xFF) << 8 | quad[1] & 0xFF);
        String ultimate = Integer.toHexString((quad[2] & 0xFF) << 8 | quad[3] & 0xFF);
        return initialPart + penultimate + ":" + ultimate;
    }

    private static byte[] textToNumericFormatV4(String ipString) {
        int dotCount = 0;
        for (int i2 = 0; i2 < ipString.length(); ++i2) {
            if (ipString.charAt(i2) != '.') continue;
            ++dotCount;
        }
        if (dotCount + 1 != 4) {
            return null;
        }
        byte[] bytes = new byte[4];
        int start = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            int end = ipString.indexOf(46, start);
            if (end == -1) {
                end = ipString.length();
            }
            try {
                bytes[i3] = IPAddressValidator.parseOctet(ipString, start, end);
            }
            catch (NumberFormatException ex) {
                return null;
            }
            start = end + 1;
        }
        return bytes;
    }

    private static boolean numericFormatV6(String ipString) {
        int IPV6_PART_COUNT = 8;
        int delimiterCount = 0;
        for (int i2 = 0; i2 < ipString.length(); ++i2) {
            if (ipString.charAt(i2) != ':') continue;
            ++delimiterCount;
        }
        if (delimiterCount < 2 || delimiterCount > 8) {
            return false;
        }
        int partsSkipped = 8 - (delimiterCount + 1);
        boolean hasSkip = false;
        for (int i3 = 0; i3 < ipString.length() - 1; ++i3) {
            if (ipString.charAt(i3) != ':' || ipString.charAt(i3 + 1) != ':') continue;
            if (hasSkip) {
                return false;
            }
            hasSkip = true;
            ++partsSkipped;
            if (i3 == 0) {
                ++partsSkipped;
            }
            if (i3 != ipString.length() - 2) continue;
            ++partsSkipped;
        }
        if (ipString.charAt(0) == ':' && ipString.charAt(1) != ':') {
            return false;
        }
        if (ipString.charAt(ipString.length() - 1) == ':' && ipString.charAt(ipString.length() - 2) != ':') {
            return false;
        }
        if (hasSkip && partsSkipped <= 0) {
            return false;
        }
        if (!hasSkip && delimiterCount + 1 != 8) {
            return false;
        }
        ByteBuffer rawBytes = ByteBuffer.allocate(16);
        try {
            int start = 0;
            if (ipString.charAt(0) == ':') {
                start = 1;
            }
            while (start < ipString.length()) {
                int end = ipString.indexOf(58, start);
                if (end == -1) {
                    end = ipString.length();
                }
                if (ipString.charAt(start) == ':') {
                    for (int i4 = 0; i4 < partsSkipped; ++i4) {
                        rawBytes.putShort((short)0);
                    }
                } else {
                    rawBytes.putShort(IPAddressValidator.parseHextet(ipString, start, end));
                }
                start = end + 1;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    private static byte parseOctet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 3) {
            throw new NumberFormatException();
        }
        if (length > 1 && ipString.charAt(start) == '0') {
            throw new NumberFormatException();
        }
        int octet = 0;
        for (int i2 = start; i2 < end; ++i2) {
            octet *= 10;
            int digit = Character.digit(ipString.charAt(i2), 10);
            if (digit < 0) {
                throw new NumberFormatException();
            }
            octet += digit;
        }
        if (octet > 255) {
            throw new NumberFormatException();
        }
        return (byte)octet;
    }

    private static short parseHextet(String ipString, int start, int end) {
        int length = end - start;
        if (length <= 0 || length > 4) {
            throw new NumberFormatException();
        }
        int hextet = 0;
        for (int i2 = start; i2 < end; ++i2) {
            hextet <<= 4;
            hextet |= Character.digit(ipString.charAt(i2), 16);
        }
        return (short)hextet;
    }
}

