/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.odps;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.support.odps.JSONWritable;
import com.alibaba.fastjson2.util.IOUtils;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.udf.UDF;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class JSONExtract
extends UDF {
    static final byte[] BYTES_TRUE = new byte[]{34, 116, 114, 117, 101, 34};
    static final byte[] BYTES_FALSE = new byte[]{34, 102, 97, 108, 115, 101, 34};
    private static JSONWritable[] cache = new JSONWritable[512];
    private final JSONPath path;
    private JSONWritable text = new JSONWritable();
    private ExtractValueConsumer valueConsumer = new ExtractValueConsumer();

    public JSONExtract(String path) {
        this.path = JSONPath.of(path);
    }

    public Writable eval(Text input) {
        JSONReader jsonReader = JSONReader.of(input.getBytes(), 0, input.getLength(), StandardCharsets.UTF_8);
        this.path.extract(jsonReader, this.valueConsumer);
        if (this.text == null) {
            return NullWritable.get();
        }
        return this.text;
    }

    static {
        for (int i2 = -1; i2 < 511; ++i2) {
            int size = i2 < 0 ? IOUtils.stringSize(-i2) + 1 : IOUtils.stringSize(i2);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars(i2, size + 1, bytes);
            JSONExtract.cache[i2 + 1] = new JSONWritable(bytes);
        }
    }

    class ExtractValueConsumer
    implements ValueConsumer {
        ExtractValueConsumer() {
        }

        @Override
        public void accept(byte[] bytes, int off, int len) {
            ((JSONExtract)JSONExtract.this).text.bytes = bytes;
            ((JSONExtract)JSONExtract.this).text.off = off;
            ((JSONExtract)JSONExtract.this).text.length = len;
        }

        @Override
        public void acceptNull() {
            JSONExtract.this.text = null;
        }

        @Override
        public void accept(boolean val) {
            JSONExtract.this.text.set(val ? BYTES_TRUE : BYTES_FALSE);
        }

        @Override
        public void accept(int val) {
            if (val >= -1 && val < 511) {
                JSONExtract.this.text = cache[val + 1];
                return;
            }
            int size = val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
            JSONExtract.this.text.setCapacity(size + 2, false);
            byte[] bytes = ((JSONExtract)JSONExtract.this).text.bytes;
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars(val, size + 1, bytes);
            ((JSONExtract)JSONExtract.this).text.length = size + 2;
        }

        @Override
        public void accept(long val) {
            int size = val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val);
            byte[] bytes = new byte[size + 2];
            bytes[0] = 34;
            bytes[size + 1] = 34;
            IOUtils.getChars(val, size + 1, bytes);
            JSONExtract.this.text.set(bytes);
        }

        @Override
        public void accept(Number val) {
            if (val instanceof Integer) {
                this.accept(val.intValue());
                return;
            }
            if (val instanceof Long) {
                this.accept(val.longValue());
                return;
            }
            String str = val.toString();
            int len = str.length() + 2;
            byte[] bytes = new byte[len + 2];
            bytes[0] = 34;
            bytes[len + 1] = 34;
            str.getBytes(0, len, bytes, 1);
            JSONExtract.this.text.set(bytes);
        }

        @Override
        public void accept(String val) {
            JSONExtract.this.text.set(val);
        }

        @Override
        public void accept(Map object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void accept(List array) {
            throw new UnsupportedOperationException();
        }
    }
}

