/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public interface ApacheLang3Support {

    public static class PairWriter
    implements ObjectWriter {
        final Class objectClass;
        final String typeName;
        final long typeNameHash;
        Method leftMethod;
        Method rightMethod;
        byte[] nameWithColonUTF8;
        char[] nameWithColonUTF16;
        byte[] typeNameJSONB;
        static byte[] leftName = JSONB.toBytes("left");
        static byte[] rightName = JSONB.toBytes("right");

        public PairWriter(Class objectClass) {
            this.objectClass = objectClass;
            this.typeName = objectClass.getName();
            this.typeNameHash = Fnv.hashCode64(this.typeName);
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            if ((jsonWriter.getFeatures(features) & JSONWriter.Feature.WriteClassName.mask) != 0L) {
                if (this.typeNameJSONB == null) {
                    this.typeNameJSONB = JSONB.toBytes(this.typeName);
                }
                jsonWriter.writeTypeName(this.typeNameJSONB, this.typeNameHash);
            }
            jsonWriter.startObject();
            Object left = this.getLeft(object);
            Object right = this.getRight(object);
            jsonWriter.writeNameRaw(leftName, PairReader.LEFT);
            jsonWriter.writeAny(left);
            jsonWriter.writeNameRaw(rightName, PairReader.RIGHT);
            jsonWriter.writeAny(right);
            jsonWriter.endObject();
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            Object left = this.getLeft(object);
            Object right = this.getRight(object);
            jsonWriter.startObject();
            if ((jsonWriter.getFeatures(features) & JSONWriter.Feature.WritePairAsJavaBean.mask) != 0L) {
                jsonWriter.writeName("left");
                jsonWriter.writeColon();
                jsonWriter.writeAny(left);
                jsonWriter.writeName("right");
                jsonWriter.writeColon();
                jsonWriter.writeAny(right);
            } else {
                jsonWriter.writeNameAny(left);
                jsonWriter.writeColon();
                jsonWriter.writeAny(right);
            }
            jsonWriter.endObject();
        }

        Object getLeft(Object object) {
            Class<?> objectClass = object.getClass();
            if (this.leftMethod == null) {
                try {
                    this.leftMethod = objectClass.getMethod("getLeft", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new JSONException("getLeft method not found", e);
                }
            }
            try {
                return this.leftMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("invoke getLeft method error", e);
            }
        }

        Object getRight(Object object) {
            Class<?> objectClass = object.getClass();
            if (this.rightMethod == null) {
                try {
                    this.rightMethod = objectClass.getMethod("getRight", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new JSONException("getRight method not found", e);
                }
            }
            try {
                return this.rightMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new JSONException("invoke getRight method error", e);
            }
        }
    }

    public static class PairReader
    implements ObjectReader {
        static final long LEFT = Fnv.hashCode64("left");
        static final long RIGHT = Fnv.hashCode64("right");
        static final long PAIR = Fnv.hashCode64("org.apache.commons.lang3.tuple.Pair");
        static final long MUTABLE_PAIR = Fnv.hashCode64("org.apache.commons.lang3.tuple.MutablePair");
        static final long IMMUTABLE_PAIR = Fnv.hashCode64("org.apache.commons.lang3.tuple.ImmutablePair");
        final Class objectClass;
        final Type leftType;
        final Type rightType;
        final Method of;

        public PairReader(Class objectClass, Type leftType, Type rightType) {
            this.objectClass = objectClass;
            this.leftType = leftType;
            this.rightType = rightType;
            try {
                this.of = objectClass.getMethod("of", Object.class, Object.class);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("Pair.of method not found", e);
            }
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            long typeHash;
            if (jsonReader.nextIfNull()) {
                return null;
            }
            if (jsonReader.nextIfMatch((byte)-110) && (typeHash = jsonReader.readTypeHashCode()) != PAIR && typeHash != IMMUTABLE_PAIR && typeHash != MUTABLE_PAIR) {
                throw new JSONException("not support inputType : " + jsonReader.getString());
            }
            String left = null;
            Object right = null;
            if (jsonReader.nextIfObjectStart()) {
                for (int i2 = 0; i2 < 100 && !jsonReader.nextIfObjectEnd(); ++i2) {
                    if (jsonReader.isString()) {
                        long hashCode = jsonReader.readFieldNameHashCode();
                        if (hashCode == LEFT) {
                            left = (String)jsonReader.read(this.leftType);
                            continue;
                        }
                        if (hashCode == RIGHT) {
                            right = jsonReader.read(this.rightType);
                            continue;
                        }
                        if (i2 == 0) {
                            left = jsonReader.getFieldName();
                            right = jsonReader.read(this.rightType);
                            continue;
                        }
                        jsonReader.skipValue();
                        continue;
                    }
                    if (i2 == 0) {
                        left = (String)jsonReader.read(this.leftType);
                        right = jsonReader.read(this.rightType);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support input"));
                }
            } else if (jsonReader.isArray()) {
                int len = jsonReader.startArray();
                if (len != 2) {
                    throw new JSONException(jsonReader.info("not support input"));
                }
                left = (String)jsonReader.read(this.leftType);
                right = jsonReader.read(this.rightType);
            } else {
                throw new JSONException(jsonReader.info("not support input"));
            }
            try {
                return this.of.invoke(null, left, right);
            }
            catch (Exception e) {
                throw new JSONException("create pair error", e);
            }
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            String left = null;
            Object right = null;
            if (jsonReader.nextIfObjectStart()) {
                for (int i2 = 0; i2 < 100 && !jsonReader.nextIfObjectEnd(); ++i2) {
                    if (jsonReader.isString()) {
                        long hashCode = jsonReader.readFieldNameHashCode();
                        if (hashCode == LEFT) {
                            left = (String)jsonReader.read(this.leftType);
                            continue;
                        }
                        if (hashCode == RIGHT) {
                            right = jsonReader.read(this.rightType);
                            continue;
                        }
                        if (i2 == 0) {
                            left = jsonReader.getFieldName();
                            jsonReader.nextIfMatch(':');
                            right = jsonReader.read(this.rightType);
                            continue;
                        }
                        jsonReader.skipValue();
                        continue;
                    }
                    if (i2 == 0) {
                        left = (String)jsonReader.read(this.leftType);
                        jsonReader.nextIfMatch(':');
                        right = jsonReader.read(this.rightType);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support input"));
                }
            } else if (jsonReader.nextIfMatch('[')) {
                left = (String)jsonReader.read(this.leftType);
                right = jsonReader.read(this.rightType);
                if (!jsonReader.nextIfMatch(']')) {
                    throw new JSONException(jsonReader.info("not support input"));
                }
            } else {
                throw new JSONException(jsonReader.info("not support input"));
            }
            try {
                return this.of.invoke(null, left, right);
            }
            catch (Exception e) {
                throw new JSONException("create pair error", e);
            }
        }
    }

    public static interface TripleMixIn<L, M, R> {
        @JSONCreator
        public static <L, M, R> Object of(L left, M middle, R right) {
            return null;
        }
    }
}

