/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterDate;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;

final class FieldWriterDateField<T>
extends FieldWriterDate<T> {
    final Field field;

    protected FieldWriterDateField(String fieldName, int ordinal, long features, String format, String label, Field field) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)Date.class), Date.class);
        this.field = field;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getFieldValue(Object object) {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.name, e);
        }
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        Date value = (Date)this.getFieldValue((Object)object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        this.writeDate(jsonWriter, false, value.getTime());
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Date date2 = (Date)this.getFieldValue((Object)object);
        if (date2 == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeNull();
                return true;
            }
            return false;
        }
        this.writeDate(jsonWriter, date2.getTime());
        return true;
    }
}

