/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import java.lang.reflect.Type;

final class ObjectWriterImplInt64Array
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final ObjectWriterImplInt64Array INSTANCE = new ObjectWriterImplInt64Array();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[Long");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[Long");

    ObjectWriterImplInt64Array() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask)) {
                jsonWriter.startArray();
                jsonWriter.endArray();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        Long[] array = (Long[])object;
        jsonWriter.startArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            Long item;
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            if ((item = array[i2]) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt64(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        Long[] array = (Long[])object;
        jsonWriter.startArray(array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            Long item = array[i2];
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeInt64(item);
        }
    }
}

