/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.zip.GZIPOutputStream;

final class ObjectWriterImplInt8ValueArray
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final ObjectWriterImplInt8ValueArray INSTANCE = new ObjectWriterImplInt8ValueArray();
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[B");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[B");

    ObjectWriterImplInt8ValueArray() {
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        byte[] bytes = (byte[])object;
        jsonWriter.writeBinary(bytes);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        byte[] array = (byte[])object;
        String format = jsonWriter.getContext().getDateFormat();
        if ("gzip".equals(format) || "gzip,base64".equals(format)) {
            GZIPOutputStream gzipOut = null;
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                gzipOut = array.length < 512 ? new GZIPOutputStream((OutputStream)byteOut, array.length) : new GZIPOutputStream(byteOut);
                gzipOut.write(array);
                gzipOut.finish();
                array = byteOut.toByteArray();
            }
            catch (IOException ex) {
                try {
                    throw new JSONException("write gzipBytes error", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.close(gzipOut);
                    throw throwable;
                }
            }
            IOUtils.close(gzipOut);
        }
        if ("base64".equals(format) || "gzip,base64".equals(format)) {
            jsonWriter.writeBase64(array);
            return;
        }
        jsonWriter.startArray();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            jsonWriter.writeInt32(array[i2]);
        }
        jsonWriter.endArray();
    }
}

