/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

final class ObjectWriterImplListStr
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final ObjectWriterImplListStr INSTANCE = new ObjectWriterImplListStr();

    ObjectWriterImplListStr() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        List list = (List)object;
        jsonWriter.startArray();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String item;
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            if ((item = (String)list.get(i2)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        Type fieldItemType = null;
        Class fieldItemClass = null;
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof ParameterizedType) {
            Type rawType;
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 1) {
                fieldItemType = actualTypeArguments[0];
            }
            if ((rawType = parameterizedType.getRawType()) instanceof Class) {
                fieldClass = (Class)rawType;
            }
        }
        if (fieldItemType instanceof Class) {
            fieldItemClass = (Class)fieldItemType;
        }
        Class<?> objectClass = object.getClass();
        if (jsonWriter.isWriteTypeInfo(object, fieldClass, features)) {
            jsonWriter.writeTypeName(TypeUtils.getTypeName(objectClass == ObjectWriterImplList.CLASS_SUBLIST ? ArrayList.class : objectClass));
        }
        List list = (List)object;
        int size = list.size();
        jsonWriter.startArray(size);
        for (int i2 = 0; i2 < size; ++i2) {
            String item = (String)list.get(i2);
            if (item == null) {
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
        jsonWriter.endArray();
    }
}

