/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import java.lang.reflect.Type;

final class ObjectWriterImplStringArray
extends ObjectWriterBaseModule.PrimitiveImpl {
    static final byte[] TYPE_NAME_BYTES = JSONB.toBytes("[String");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[String");
    static final ObjectWriterImplStringArray INSTANCE = new ObjectWriterImplStringArray();

    ObjectWriterImplStringArray() {
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        String[] list = (String[])object;
        jsonWriter.startArray();
        for (int i2 = 0; i2 < list.length; ++i2) {
            String item;
            if (i2 != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list[i2]) == null) {
                if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                    jsonWriter.writeString("");
                    continue;
                }
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeArrayNull();
            return;
        }
        if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
            jsonWriter.writeTypeName(TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        String[] list = (String[])object;
        jsonWriter.startArray(list.length);
        for (int i2 = 0; i2 < list.length; ++i2) {
            String item = list[i2];
            if (item == null) {
                if (jsonWriter.isEnabled(JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) {
                    jsonWriter.writeString("");
                    continue;
                }
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(item);
        }
    }
}

