/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.common;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;

public class PaletteBuilder {
    protected static final int MAXLEVEL = 8;
    protected RenderedImage src;
    protected ColorModel srcColorModel;
    protected Raster srcRaster;
    protected int requiredSize;
    protected ColorNode root;
    protected int numNodes;
    protected int maxNodes;
    protected int currLevel;
    protected int currSize;
    protected ColorNode[] reduceList;
    protected ColorNode[] palette;
    protected int transparency;
    protected ColorNode transColor;

    public static RenderedImage createIndexedImage(RenderedImage src) {
        PaletteBuilder pb = new PaletteBuilder(src);
        pb.buildPalette();
        return pb.getIndexedImage();
    }

    public static IndexColorModel createIndexColorModel(RenderedImage img) {
        PaletteBuilder pb = new PaletteBuilder(img);
        pb.buildPalette();
        return pb.getIndexColorModel();
    }

    public static boolean canCreatePalette(ImageTypeSpecifier type) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        return true;
    }

    public static boolean canCreatePalette(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        ImageTypeSpecifier type = new ImageTypeSpecifier(image);
        return PaletteBuilder.canCreatePalette(type);
    }

    protected RenderedImage getIndexedImage() {
        IndexColorModel icm = this.getIndexColorModel();
        BufferedImage dst = new BufferedImage(this.src.getWidth(), this.src.getHeight(), 13, icm);
        WritableRaster wr = dst.getRaster();
        int minX = this.src.getMinX();
        int minY = this.src.getMinY();
        for (int y = 0; y < dst.getHeight(); ++y) {
            for (int x = 0; x < dst.getWidth(); ++x) {
                Color aColor = this.getSrcColor(x + minX, y + minY);
                wr.setSample(x, y, 0, this.findColorIndex(this.root, aColor));
            }
        }
        return dst;
    }

    protected PaletteBuilder(RenderedImage src) {
        this(src, 256);
    }

    protected PaletteBuilder(RenderedImage src, int size) {
        this.src = src;
        this.srcColorModel = src.getColorModel();
        this.srcRaster = src.getData();
        this.transparency = this.srcColorModel.getTransparency();
        if (this.transparency != 1) {
            this.requiredSize = size - 1;
            this.transColor = new ColorNode();
            this.transColor.isLeaf = true;
        } else {
            this.requiredSize = size;
        }
    }

    private Color getSrcColor(int x, int y) {
        int argb = this.srcColorModel.getRGB(this.srcRaster.getDataElements(x, y, null));
        return new Color(argb, this.transparency != 1);
    }

    protected int findColorIndex(ColorNode aNode, Color aColor) {
        if (this.transparency != 1 && aColor.getAlpha() != 255) {
            return 0;
        }
        if (aNode.isLeaf) {
            return aNode.paletteIndex;
        }
        int childIndex = this.getBranchIndex(aColor, aNode.level);
        return this.findColorIndex(aNode.children[childIndex], aColor);
    }

    protected void buildPalette() {
        this.reduceList = new ColorNode[9];
        for (int i2 = 0; i2 < this.reduceList.length; ++i2) {
            this.reduceList[i2] = null;
        }
        this.numNodes = 0;
        this.maxNodes = 0;
        this.root = null;
        this.currSize = 0;
        this.currLevel = 8;
        int w = this.src.getWidth();
        int h = this.src.getHeight();
        int minX = this.src.getMinX();
        int minY = this.src.getMinY();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color aColor = this.getSrcColor(w - x + minX - 1, h - y + minY - 1);
                if (this.transparency != 1 && aColor.getAlpha() != 255) {
                    this.transColor = this.insertNode(this.transColor, aColor, 0);
                } else {
                    this.root = this.insertNode(this.root, aColor, 0);
                }
                if (this.currSize <= this.requiredSize) continue;
                this.reduceTree();
            }
        }
    }

    protected ColorNode insertNode(ColorNode aNode, Color aColor, int aLevel) {
        if (aNode == null) {
            aNode = new ColorNode();
            ++this.numNodes;
            if (this.numNodes > this.maxNodes) {
                this.maxNodes = this.numNodes;
            }
            aNode.level = aLevel;
            boolean bl = aNode.isLeaf = aLevel > 8;
            if (aNode.isLeaf) {
                ++this.currSize;
            }
        }
        ++aNode.colorCount;
        aNode.red += (long)aColor.getRed();
        aNode.green += (long)aColor.getGreen();
        aNode.blue += (long)aColor.getBlue();
        if (!aNode.isLeaf) {
            int branchIndex = this.getBranchIndex(aColor, aLevel);
            if (aNode.children[branchIndex] == null) {
                ++aNode.childCount;
                if (aNode.childCount == 2) {
                    aNode.nextReducible = this.reduceList[aLevel];
                    this.reduceList[aLevel] = aNode;
                }
            }
            aNode.children[branchIndex] = this.insertNode(aNode.children[branchIndex], aColor, aLevel + 1);
        }
        return aNode;
    }

    protected IndexColorModel getIndexColorModel() {
        int size = this.currSize;
        if (this.transparency != 1) {
            ++size;
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        int index = 0;
        this.palette = new ColorNode[size];
        if (this.transparency != 1) {
            ++index;
        }
        int lastIndex = this.findPaletteEntry(this.root, index, red, green, blue);
        IndexColorModel icm = null;
        icm = this.transparency != 1 ? new IndexColorModel(8, size, red, green, blue, 0) : new IndexColorModel(8, this.currSize, red, green, blue);
        return icm;
    }

    protected int findPaletteEntry(ColorNode aNode, int index, byte[] red, byte[] green, byte[] blue) {
        if (aNode.isLeaf) {
            red[index] = (byte)(aNode.red / (long)aNode.colorCount);
            green[index] = (byte)(aNode.green / (long)aNode.colorCount);
            blue[index] = (byte)(aNode.blue / (long)aNode.colorCount);
            aNode.paletteIndex = index;
            this.palette[index] = aNode;
            ++index;
        } else {
            for (int i2 = 0; i2 < 8; ++i2) {
                if (aNode.children[i2] == null) continue;
                index = this.findPaletteEntry(aNode.children[i2], index, red, green, blue);
            }
        }
        return index;
    }

    protected int getBranchIndex(Color aColor, int aLevel) {
        if (aLevel > 8 || aLevel < 0) {
            throw new IllegalArgumentException("Invalid octree node depth: " + aLevel);
        }
        int shift = 8 - aLevel;
        int red_index = 1 & (0xFF & aColor.getRed()) >> shift;
        int green_index = 1 & (0xFF & aColor.getGreen()) >> shift;
        int blue_index = 1 & (0xFF & aColor.getBlue()) >> shift;
        int index = red_index << 2 | green_index << 1 | blue_index;
        return index;
    }

    protected void reduceTree() {
        int level;
        for (level = this.reduceList.length - 1; this.reduceList[level] == null && level >= 0; --level) {
        }
        ColorNode thisNode = this.reduceList[level];
        if (thisNode == null) {
            return;
        }
        ColorNode pList = thisNode;
        int minColorCount = pList.colorCount;
        int cnt = 1;
        while (pList.nextReducible != null) {
            if (minColorCount > pList.nextReducible.colorCount) {
                thisNode = pList;
                minColorCount = pList.colorCount;
            }
            pList = pList.nextReducible;
            ++cnt;
        }
        if (thisNode == this.reduceList[level]) {
            this.reduceList[level] = thisNode.nextReducible;
        } else {
            pList = thisNode.nextReducible;
            thisNode.nextReducible = pList.nextReducible;
            thisNode = pList;
        }
        if (thisNode.isLeaf) {
            return;
        }
        int leafChildCount = thisNode.getLeafChildCount();
        thisNode.isLeaf = true;
        this.currSize -= leafChildCount - 1;
        int aDepth = thisNode.level;
        for (int i2 = 0; i2 < 8; ++i2) {
            thisNode.children[i2] = this.freeTree(thisNode.children[i2]);
        }
        thisNode.childCount = 0;
    }

    protected ColorNode freeTree(ColorNode aNode) {
        if (aNode == null) {
            return null;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            aNode.children[i2] = this.freeTree(aNode.children[i2]);
        }
        --this.numNodes;
        return null;
    }

    protected class ColorNode {
        public boolean isLeaf = false;
        public int childCount = 0;
        ColorNode[] children = new ColorNode[8];
        public int colorCount;
        public long red;
        public long blue;
        public long green;
        public int paletteIndex;
        public int level = 0;
        ColorNode nextReducible;

        public ColorNode() {
            for (int i2 = 0; i2 < 8; ++i2) {
                this.children[i2] = null;
            }
            this.colorCount = 0;
            this.blue = 0L;
            this.green = 0L;
            this.red = 0L;
            this.paletteIndex = 0;
        }

        public int getLeafChildCount() {
            if (this.isLeaf) {
                return 0;
            }
            int cnt = 0;
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                if (this.children[i2] == null) continue;
                if (this.children[i2].isLeaf) {
                    ++cnt;
                    continue;
                }
                cnt += this.children[i2].getLeafChildCount();
            }
            return cnt;
        }

        public int getRGB() {
            int r = (int)this.red / this.colorCount;
            int g = (int)this.green / this.colorCount;
            int b = (int)this.blue / this.colorCount;
            int c = 0xFF000000 | (0xFF & r) << 16 | (0xFF & g) << 8 | 0xFF & b;
            return c;
        }
    }
}

