/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.tiff;

import com.github.jaiimageio.impl.plugins.tiff.TIFFIFD;
import com.github.jaiimageio.plugins.tiff.TIFFDirectory;
import com.github.jaiimageio.plugins.tiff.TIFFField;
import com.github.jaiimageio.plugins.tiff.TIFFTag;
import com.github.jaiimageio.plugins.tiff.TIFFTagSet;
import java.util.Arrays;
import java.util.List;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class TIFFFieldNode
extends IIOMetadataNode {
    private boolean isIFD;
    private Boolean isInitialized = Boolean.FALSE;
    private TIFFField field;

    private static String getNodeName(TIFFField f) {
        return f.getData() instanceof TIFFDirectory ? "TIFFIFD" : "TIFFField";
    }

    public TIFFFieldNode(TIFFField field) {
        super(TIFFFieldNode.getNodeName(field));
        this.isIFD = field.getData() instanceof TIFFDirectory;
        this.field = field;
        TIFFTag tag = field.getTag();
        int tagNumber = tag.getNumber();
        String tagName = tag.getName();
        if (this.isIFD) {
            TIFFDirectory dir;
            TIFFTagSet[] tagSets;
            if (tagNumber != 0) {
                this.setAttribute("parentTagNumber", Integer.toString(tagNumber));
            }
            if (tagName != null) {
                this.setAttribute("parentTagName", tagName);
            }
            if ((tagSets = (dir = (TIFFDirectory)field.getData()).getTagSets()) != null) {
                String tagSetNames = "";
                for (int i2 = 0; i2 < tagSets.length; ++i2) {
                    tagSetNames = tagSetNames + tagSets[i2].getClass().getName();
                    if (i2 == tagSets.length - 1) continue;
                    tagSetNames = tagSetNames + ",";
                }
                this.setAttribute("tagSets", tagSetNames);
            }
        } else {
            this.setAttribute("number", Integer.toString(tagNumber));
            this.setAttribute("name", tagName);
        }
    }

    private synchronized void initialize() {
        if (this.isInitialized == Boolean.TRUE) {
            return;
        }
        if (this.isIFD) {
            TIFFDirectory dir = (TIFFDirectory)this.field.getData();
            TIFFField[] fields = dir.getTIFFFields();
            if (fields != null) {
                TIFFTagSet[] tagSets = dir.getTagSets();
                List<TIFFTagSet> tagSetList = Arrays.asList(tagSets);
                for (TIFFField f : fields) {
                    int tagNumber = f.getTagNumber();
                    TIFFTag tag = TIFFIFD.getTag(tagNumber, tagSetList);
                    Node node = f.getAsNativeNode();
                    if (node == null) continue;
                    this.appendChild(node);
                }
            }
        } else {
            IIOMetadataNode child;
            int count = this.field.getCount();
            if (this.field.getType() == 7) {
                child = new IIOMetadataNode("TIFFUndefined");
                byte[] data = this.field.getAsBytes();
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < count; ++i2) {
                    sb.append(Integer.toString(data[i2] & 0xFF));
                    if (i2 >= count - 1) continue;
                    sb.append(",");
                }
                child.setAttribute("value", sb.toString());
            } else {
                child = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()) + "s");
                TIFFTag tag = this.field.getTag();
                for (int i3 = 0; i3 < count; ++i3) {
                    int value;
                    String name;
                    IIOMetadataNode cchild = new IIOMetadataNode("TIFF" + TIFFField.getTypeName(this.field.getType()));
                    cchild.setAttribute("value", this.field.getValueAsString(i3));
                    if (tag.hasValueNames() && this.field.isIntegral() && (name = tag.getValueName(value = this.field.getAsInt(i3))) != null) {
                        cchild.setAttribute("description", name);
                    }
                    child.appendChild(cchild);
                }
            }
            this.appendChild(child);
        }
        this.isInitialized = Boolean.TRUE;
    }

    @Override
    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        return super.insertBefore(newChild, null);
    }

    @Override
    public boolean hasChildNodes() {
        this.initialize();
        return super.hasChildNodes();
    }

    @Override
    public int getLength() {
        this.initialize();
        return super.getLength();
    }

    @Override
    public Node getFirstChild() {
        this.initialize();
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        this.initialize();
        return super.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        this.initialize();
        return super.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        this.initialize();
        return super.getNextSibling();
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        this.initialize();
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        this.initialize();
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    public Node removeChild(Node oldChild) {
        this.initialize();
        return super.removeChild(oldChild);
    }

    @Override
    public Node cloneNode(boolean deep) {
        this.initialize();
        return super.cloneNode(deep);
    }
}

