/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.stream;

import com.github.jaiimageio.stream.StreamSegment;
import com.github.jaiimageio.stream.StreamSegmentMapper;

class StreamSegmentMapperImpl
implements StreamSegmentMapper {
    private long[] segmentPositions;
    private int[] segmentLengths;

    public StreamSegmentMapperImpl(long[] segmentPositions, int[] segmentLengths) {
        this.segmentPositions = (long[])segmentPositions.clone();
        this.segmentLengths = (int[])segmentLengths.clone();
    }

    @Override
    public StreamSegment getStreamSegment(long position, int length) {
        int numSegments = this.segmentLengths.length;
        for (int i2 = 0; i2 < numSegments; ++i2) {
            int len = this.segmentLengths[i2];
            if (position < (long)len) {
                return new StreamSegment(this.segmentPositions[i2] + position, Math.min(len - (int)position, length));
            }
            position -= (long)len;
        }
        return null;
    }

    @Override
    public void getStreamSegment(long position, int length, StreamSegment seg) {
        int numSegments = this.segmentLengths.length;
        for (int i2 = 0; i2 < numSegments; ++i2) {
            int len = this.segmentLengths[i2];
            if (position < (long)len) {
                seg.setStartPos(this.segmentPositions[i2] + position);
                seg.setSegmentLength(Math.min(len - (int)position, length));
                return;
            }
            position -= (long)len;
        }
        seg.setStartPos(-1L);
        seg.setSegmentLength(-1);
    }

    long length() {
        int numSegments = this.segmentLengths.length;
        long len = 0L;
        for (int i2 = 0; i2 < numSegments; ++i2) {
            len += (long)this.segmentLengths[i2];
        }
        return len;
    }
}

