/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private static final int[] EMPTY_BITS = new int[0];
    private static final float LOAD_FACTOR = 0.75f;
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = EMPTY_BITS;
    }

    public BitArray(int size) {
        this.size = size;
        this.bits = BitArray.makeArray(size);
    }

    BitArray(int[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.bits.length * 32) {
            int[] newBits = BitArray.makeArray((int)Math.ceil((float)newSize / 0.75f));
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public boolean get(int i2) {
        return (this.bits[i2 / 32] & 1 << (i2 & 0x1F)) != 0;
    }

    public void set(int i2) {
        int n = i2 / 32;
        this.bits[n] = this.bits[n] | 1 << (i2 & 0x1F);
    }

    public void flip(int i2) {
        int n = i2 / 32;
        this.bits[n] = this.bits[n] ^ 1 << (i2 & 0x1F);
    }

    public int getNextSet(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = this.bits[bitsOffset];
        currentBits &= -(1 << (from & 0x1F));
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = this.bits[bitsOffset];
        }
        int result = bitsOffset * 32 + Integer.numberOfTrailingZeros(currentBits);
        return Math.min(result, this.size);
    }

    public int getNextUnset(int from) {
        if (from >= this.size) {
            return this.size;
        }
        int bitsOffset = from / 32;
        int currentBits = ~this.bits[bitsOffset];
        currentBits &= -(1 << (from & 0x1F));
        while (currentBits == 0) {
            if (++bitsOffset == this.bits.length) {
                return this.size;
            }
            currentBits = ~this.bits[bitsOffset];
        }
        int result = bitsOffset * 32 + Integer.numberOfTrailingZeros(currentBits);
        return Math.min(result, this.size);
    }

    public void setBulk(int i2, int newBits) {
        this.bits[i2 / 32] = newBits;
    }

    public void setRange(int start, int end) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        int i2 = firstInt;
        while (i2 <= lastInt) {
            int firstBit = i2 > firstInt ? 0 : start & 0x1F;
            int lastBit = i2 < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << firstBit);
            int n = i2++;
            this.bits[n] = this.bits[n] | mask;
        }
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start || start < 0 || end > this.size) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start / 32;
        int lastInt = --end / 32;
        for (int i2 = firstInt; i2 <= lastInt; ++i2) {
            int firstBit;
            int lastBit = i2 < lastInt ? 31 : end & 0x1F;
            int mask = (2 << lastBit) - (1 << (firstBit = i2 > firstInt ? 0 : start & 0x1F));
            if ((this.bits[i2] & mask) == (value ? mask : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bit) {
        this.ensureCapacity(this.size + 1);
        if (bit) {
            int n = this.size / 32;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int value, int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        int nextSize = this.size;
        this.ensureCapacity(nextSize + numBits);
        for (int numBitsLeft = numBits - 1; numBitsLeft >= 0; --numBitsLeft) {
            if ((value & 1 << numBitsLeft) != 0) {
                int n = nextSize / 32;
                this.bits[n] = this.bits[n] | 1 << (nextSize & 0x1F);
            }
            ++nextSize;
        }
        this.size = nextSize;
    }

    public void appendBitArray(BitArray other) {
        int otherSize = other.size;
        this.ensureCapacity(this.size + otherSize);
        for (int i2 = 0; i2 < otherSize; ++i2) {
            this.appendBit(other.get(i2));
        }
    }

    public void xor(BitArray other) {
        if (this.size != other.size) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            int n = i2;
            this.bits[n] = this.bits[n] ^ other.bits[i2];
        }
    }

    public void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        for (int i2 = 0; i2 < numBytes; ++i2) {
            int theByte = 0;
            for (int j = 0; j < 8; ++j) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j;
                }
                ++bitOffset;
            }
            array[offset + i2] = (byte)theByte;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int len = (this.size - 1) / 32;
        int oldBitsLen = len + 1;
        for (int i2 = 0; i2 < oldBitsLen; ++i2) {
            newBits[len - i2] = Integer.reverse(this.bits[i2]);
        }
        if (this.size != oldBitsLen * 32) {
            int leftOffset = oldBitsLen * 32 - this.size;
            int currentInt = newBits[0] >>> leftOffset;
            for (int i3 = 1; i3 < oldBitsLen; ++i3) {
                int nextInt = newBits[i3];
                newBits[i3 - 1] = currentInt |= nextInt << 32 - leftOffset;
                currentInt = nextInt >>> leftOffset;
            }
            newBits[oldBitsLen - 1] = currentInt;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        return new int[(size + 31) / 32];
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray other = (BitArray)o;
        return this.size == other.size && Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.size + this.size / 8 + 1);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i2) ? (char)'X' : '.');
        }
        return result.toString();
    }

    public BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }
}

