/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_39);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = contents.length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length);
        }
        for (int i2 = 0; i2 < length; ++i2) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(contents.charAt(i2));
            if (indexInString >= 0) continue;
            length = (contents = Code39Writer.tryToConvertToExtendedMode(contents)).length();
            if (length <= 80) break;
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + length + " (extended full ASCII mode)");
        }
        int[] widths = new int[9];
        int codeWidth = 25 + 13 * length;
        boolean[] result = new boolean[codeWidth];
        Code39Writer.toIntArray(148, widths);
        int pos = Code39Writer.appendPattern(result, 0, widths, true);
        int[] narrowWhite = new int[]{1};
        pos += Code39Writer.appendPattern(result, pos, narrowWhite, false);
        for (int i3 = 0; i3 < length; ++i3) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%".indexOf(contents.charAt(i3));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[indexInString], widths);
            pos += Code39Writer.appendPattern(result, pos, widths, true);
            pos += Code39Writer.appendPattern(result, pos, narrowWhite, false);
        }
        Code39Writer.toIntArray(148, widths);
        Code39Writer.appendPattern(result, pos, widths, true);
        return result;
    }

    private static void toIntArray(int a, int[] toReturn) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int temp = a & 1 << 8 - i2;
            toReturn[i2] = temp == 0 ? 1 : 2;
        }
    }

    private static String tryToConvertToExtendedMode(String contents) {
        int length = contents.length();
        StringBuilder extendedContent = new StringBuilder();
        block6: for (int i2 = 0; i2 < length; ++i2) {
            char character = contents.charAt(i2);
            switch (character) {
                case '\u0000': {
                    extendedContent.append("%U");
                    continue block6;
                }
                case ' ': 
                case '-': 
                case '.': {
                    extendedContent.append(character);
                    continue block6;
                }
                case '@': {
                    extendedContent.append("%V");
                    continue block6;
                }
                case '`': {
                    extendedContent.append("%W");
                    continue block6;
                }
                default: {
                    if (character <= '\u001a') {
                        extendedContent.append('$');
                        extendedContent.append((char)(65 + (character - '\u0001')));
                        continue block6;
                    }
                    if (character < ' ') {
                        extendedContent.append('%');
                        extendedContent.append((char)(65 + (character - 27)));
                        continue block6;
                    }
                    if (character <= ',' || character == '/' || character == ':') {
                        extendedContent.append('/');
                        extendedContent.append((char)(65 + (character - 33)));
                        continue block6;
                    }
                    if (character <= '9') {
                        extendedContent.append((char)(48 + (character - 48)));
                        continue block6;
                    }
                    if (character <= '?') {
                        extendedContent.append('%');
                        extendedContent.append((char)(70 + (character - 59)));
                        continue block6;
                    }
                    if (character <= 'Z') {
                        extendedContent.append((char)(65 + (character - 65)));
                        continue block6;
                    }
                    if (character <= '_') {
                        extendedContent.append('%');
                        extendedContent.append((char)(75 + (character - 91)));
                        continue block6;
                    }
                    if (character <= 'z') {
                        extendedContent.append('+');
                        extendedContent.append((char)(65 + (character - 97)));
                        continue block6;
                    }
                    if (character <= '\u007f') {
                        extendedContent.append('%');
                        extendedContent.append((char)(80 + (character - 123)));
                        continue block6;
                    }
                    throw new IllegalArgumentException("Requested content contains a non-encodable character: '" + contents.charAt(i2) + "'");
                }
            }
        }
        return extendedContent.toString();
    }
}

