/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.FormatException;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Collection;
import java.util.Collections;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.EAN_8);
    }

    @Override
    public boolean[] encode(String contents) {
        int digit;
        int i2;
        int length = contents.length();
        switch (length) {
            case 7: {
                int check;
                try {
                    check = UPCEANReader.getStandardUPCEANChecksum(contents);
                }
                catch (FormatException fe) {
                    throw new IllegalArgumentException(fe);
                }
                contents = contents + check;
                break;
            }
            case 8: {
                try {
                    if (!UPCEANReader.checkStandardUPCEANChecksum(contents)) {
                        throw new IllegalArgumentException("Contents do not pass checksum");
                    }
                    break;
                }
                catch (FormatException ignored) {
                    throw new IllegalArgumentException("Illegal contents");
                }
            }
            default: {
                throw new IllegalArgumentException("Requested contents should be 7 or 8 digits long, but got " + length);
            }
        }
        EAN8Writer.checkNumeric(contents);
        boolean[] result = new boolean[67];
        int pos = 0;
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, true);
        for (i2 = 0; i2 <= 3; ++i2) {
            digit = Character.digit(contents.charAt(i2), 10);
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], false);
        }
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.MIDDLE_PATTERN, false);
        for (i2 = 4; i2 <= 7; ++i2) {
            digit = Character.digit(contents.charAt(i2), 10);
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], true);
        }
        EAN8Writer.appendPattern(result, pos, UPCEANReader.START_END_PATTERN, true);
        return result;
    }
}

