/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.ECIInput;
import com.google.zxing.common.MinimalECIInput;
import com.google.zxing.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;
    private static final Charset DEFAULT_ENCODING;

    private PDF417HighLevelEncoder() {
    }

    static String encodeHighLevel(String msg, Compaction compaction, Charset encoding, boolean autoECI) throws WriterException {
        ECIInput input;
        if (encoding == null && !autoECI) {
            for (int i2 = 0; i2 < msg.length(); ++i2) {
                if (msg.charAt(i2) <= '\u00ff') continue;
                throw new WriterException("Non-encodable character detected: " + msg.charAt(i2) + " (Unicode: " + msg.charAt(i2) + "). Consider specifying EncodeHintType.PDF417_AUTO_ECI and/or EncodeTypeHint.CHARACTER_SET.");
            }
        }
        StringBuilder sb = new StringBuilder(msg.length());
        if (autoECI) {
            input = new MinimalECIInput(msg, encoding, -1);
        } else {
            CharacterSetECI eci;
            input = new NoECIInput(msg);
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            } else if (!DEFAULT_ENCODING.equals(encoding) && (eci = CharacterSetECI.getCharacterSetECI(encoding)) != null) {
                PDF417HighLevelEncoder.encodingECI(eci.getValue(), sb);
            }
        }
        int len = input.length();
        int p2 = 0;
        int textSubMode = 0;
        block0 : switch (compaction) {
            case TEXT: {
                PDF417HighLevelEncoder.encodeText(input, p2, len, sb, textSubMode);
                break;
            }
            case BYTE: {
                if (autoECI) {
                    PDF417HighLevelEncoder.encodeMultiECIBinary(input, 0, input.length(), 0, sb);
                    break;
                }
                byte[] msgBytes = input.toString().getBytes(encoding);
                PDF417HighLevelEncoder.encodeBinary(msgBytes, p2, msgBytes.length, 1, sb);
                break;
            }
            case NUMERIC: {
                sb.append('\u0386');
                PDF417HighLevelEncoder.encodeNumeric(input, p2, len, sb);
                break;
            }
            default: {
                int encodingMode = 0;
                while (p2 < len) {
                    byte[] bytes;
                    while (p2 < len && input.isECI(p2)) {
                        PDF417HighLevelEncoder.encodingECI(input.getECIValue(p2), sb);
                        ++p2;
                    }
                    if (p2 >= len) break block0;
                    int n = PDF417HighLevelEncoder.determineConsecutiveDigitCount(input, p2);
                    if (n >= 13) {
                        sb.append('\u0386');
                        encodingMode = 2;
                        textSubMode = 0;
                        PDF417HighLevelEncoder.encodeNumeric(input, p2, n, sb);
                        p2 += n;
                        continue;
                    }
                    int t = PDF417HighLevelEncoder.determineConsecutiveTextCount(input, p2);
                    if (t >= 5 || n == len) {
                        if (encodingMode != 0) {
                            sb.append('\u0384');
                            encodingMode = 0;
                            textSubMode = 0;
                        }
                        textSubMode = PDF417HighLevelEncoder.encodeText(input, p2, t, sb, textSubMode);
                        p2 += t;
                        continue;
                    }
                    int b = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(input, p2, autoECI ? null : encoding);
                    if (b == 0) {
                        b = 1;
                    }
                    byte[] byArray = bytes = autoECI ? null : input.subSequence(p2, p2 + b).toString().getBytes(encoding);
                    if ((bytes == null && b == 1 || bytes != null && bytes.length == 1) && encodingMode == 0) {
                        if (autoECI) {
                            PDF417HighLevelEncoder.encodeMultiECIBinary(input, p2, 1, 0, sb);
                        } else {
                            PDF417HighLevelEncoder.encodeBinary(bytes, 0, 1, 0, sb);
                        }
                    } else {
                        if (autoECI) {
                            PDF417HighLevelEncoder.encodeMultiECIBinary(input, p2, p2 + b, encodingMode, sb);
                        } else {
                            PDF417HighLevelEncoder.encodeBinary(bytes, 0, bytes.length, encodingMode, sb);
                        }
                        encodingMode = 1;
                        textSubMode = 0;
                    }
                    p2 += b;
                }
                break block0;
            }
        }
        return sb.toString();
    }

    private static int encodeText(ECIInput input, int startpos, int count, StringBuilder sb, int initialSubmode) throws WriterException {
        StringBuilder tmp = new StringBuilder(count);
        int submode = initialSubmode;
        int idx = 0;
        block5: while (true) {
            if (input.isECI(startpos + idx)) {
                PDF417HighLevelEncoder.encodingECI(input.getECIValue(startpos + idx), sb);
                ++idx;
                continue;
            }
            char ch = input.charAt(startpos + idx);
            switch (submode) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        if (ch == ' ') {
                            tmp.append('\u001a');
                            break;
                        }
                        tmp.append((char)(ch - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        if (ch == ' ') {
                            tmp.append('\u001a');
                            break;
                        }
                        tmp.append((char)(ch - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        tmp.append('\u001b');
                        tmp.append((char)(ch - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        submode = 2;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.isMixed(ch)) {
                        tmp.append((char)MIXED[ch]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(ch)) {
                        submode = 0;
                        tmp.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(ch)) {
                        submode = 1;
                        tmp.append('\u001b');
                        continue block5;
                    }
                    if (startpos + idx + 1 < count && !input.isECI(startpos + idx + 1) && PDF417HighLevelEncoder.isPunctuation(input.charAt(startpos + idx + 1))) {
                        submode = 3;
                        tmp.append('\u0019');
                        continue block5;
                    }
                    tmp.append('\u001d');
                    tmp.append((char)PUNCTUATION[ch]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(ch)) {
                        tmp.append((char)PUNCTUATION[ch]);
                        break;
                    }
                    submode = 0;
                    tmp.append('\u001d');
                    continue block5;
                }
            }
            if (++idx >= count) break;
        }
        char h = '\u0000';
        int len = tmp.length();
        for (int i2 = 0; i2 < len; ++i2) {
            boolean odd;
            boolean bl = odd = i2 % 2 != 0;
            if (odd) {
                h = (char)(h * 30 + tmp.charAt(i2));
                sb.append(h);
                continue;
            }
            h = tmp.charAt(i2);
        }
        if (len % 2 != 0) {
            sb.append((char)(h * 30 + 29));
        }
        return submode;
    }

    private static void encodeMultiECIBinary(ECIInput input, int startpos, int count, int startmode, StringBuilder sb) throws WriterException {
        int end = Math.min(startpos + count, input.length());
        int localStart = startpos;
        while (true) {
            int localEnd;
            if (localStart < end && input.isECI(localStart)) {
                PDF417HighLevelEncoder.encodingECI(input.getECIValue(localStart), sb);
                ++localStart;
                continue;
            }
            for (localEnd = localStart; localEnd < end && !input.isECI(localEnd); ++localEnd) {
            }
            int localCount = localEnd - localStart;
            if (localCount <= 0) break;
            PDF417HighLevelEncoder.encodeBinary(PDF417HighLevelEncoder.subBytes(input, localStart, localEnd), 0, localCount, localStart == startpos ? startmode : 1, sb);
            localStart = localEnd;
        }
    }

    static byte[] subBytes(ECIInput input, int start, int end) {
        int count = end - start;
        byte[] result = new byte[count];
        for (int i2 = start; i2 < end; ++i2) {
            result[i2 - start] = (byte)(input.charAt(i2) & 0xFF);
        }
        return result;
    }

    private static void encodeBinary(byte[] bytes, int startpos, int count, int startmode, StringBuilder sb) {
        if (count == 1 && startmode == 0) {
            sb.append('\u0391');
        } else if (count % 6 == 0) {
            sb.append('\u039c');
        } else {
            sb.append('\u0385');
        }
        int idx = startpos;
        if (count >= 6) {
            char[] chars = new char[5];
            while (startpos + count - idx >= 6) {
                int i2;
                long t = 0L;
                for (i2 = 0; i2 < 6; ++i2) {
                    t <<= 8;
                    t += (long)(bytes[idx + i2] & 0xFF);
                }
                for (i2 = 0; i2 < 5; ++i2) {
                    chars[i2] = (char)(t % 900L);
                    t /= 900L;
                }
                for (i2 = chars.length - 1; i2 >= 0; --i2) {
                    sb.append(chars[i2]);
                }
                idx += 6;
            }
        }
        for (int i3 = idx; i3 < startpos + count; ++i3) {
            int ch = bytes[i3] & 0xFF;
            sb.append((char)ch);
        }
    }

    private static void encodeNumeric(ECIInput input, int startpos, int count, StringBuilder sb) {
        int len;
        StringBuilder tmp = new StringBuilder(count / 3 + 1);
        BigInteger num900 = BigInteger.valueOf(900L);
        BigInteger num0 = BigInteger.valueOf(0L);
        for (int idx = 0; idx < count; idx += len) {
            tmp.setLength(0);
            len = Math.min(44, count - idx);
            String part = "1" + input.subSequence(startpos + idx, startpos + idx + len);
            BigInteger bigint = new BigInteger(part);
            do {
                tmp.append((char)bigint.mod(num900).intValue());
            } while (!(bigint = bigint.divide(num900)).equals(num0));
            for (int i2 = tmp.length() - 1; i2 >= 0; --i2) {
                sb.append(tmp.charAt(i2));
            }
        }
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static boolean isAlphaUpper(char ch) {
        return ch == ' ' || ch >= 'A' && ch <= 'Z';
    }

    private static boolean isAlphaLower(char ch) {
        return ch == ' ' || ch >= 'a' && ch <= 'z';
    }

    private static boolean isMixed(char ch) {
        return MIXED[ch] != -1;
    }

    private static boolean isPunctuation(char ch) {
        return PUNCTUATION[ch] != -1;
    }

    private static boolean isText(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '~';
    }

    private static int determineConsecutiveDigitCount(ECIInput input, int startpos) {
        int count = 0;
        int idx = startpos;
        int len = input.length();
        if (idx < len) {
            while (idx < len && !input.isECI(idx) && PDF417HighLevelEncoder.isDigit(input.charAt(idx))) {
                ++count;
                ++idx;
            }
        }
        return count;
    }

    private static int determineConsecutiveTextCount(ECIInput input, int startpos) {
        int len = input.length();
        int idx = startpos;
        while (idx < len) {
            int numericCount;
            for (numericCount = 0; numericCount < 13 && idx < len && !input.isECI(idx) && PDF417HighLevelEncoder.isDigit(input.charAt(idx)); ++numericCount, ++idx) {
            }
            if (numericCount >= 13) {
                return idx - startpos - numericCount;
            }
            if (numericCount > 0) continue;
            if (input.isECI(idx) || !PDF417HighLevelEncoder.isText(input.charAt(idx))) break;
            ++idx;
        }
        return idx - startpos;
    }

    private static int determineConsecutiveBinaryCount(ECIInput input, int startpos, Charset encoding) throws WriterException {
        int idx;
        CharsetEncoder encoder = encoding == null ? null : encoding.newEncoder();
        int len = input.length();
        for (idx = startpos; idx < len; ++idx) {
            int numericCount = 0;
            int i2 = idx;
            while (numericCount < 13 && !input.isECI(i2) && PDF417HighLevelEncoder.isDigit(input.charAt(i2)) && (i2 = idx + ++numericCount) < len) {
            }
            if (numericCount >= 13) {
                return idx - startpos;
            }
            if (encoder == null || encoder.canEncode(input.charAt(idx))) continue;
            assert (input instanceof NoECIInput);
            char ch = input.charAt(idx);
            throw new WriterException("Non-encodable character detected: " + ch + " (Unicode: " + ch + ')');
        }
        return idx - startpos;
    }

    private static void encodingECI(int eci, StringBuilder sb) throws WriterException {
        if (eci >= 0 && eci < 900) {
            sb.append('\u039f');
            sb.append((char)eci);
        } else if (eci < 810900) {
            sb.append('\u039e');
            sb.append((char)(eci / 900 - 1));
            sb.append((char)(eci % 900));
        } else if (eci < 811800) {
            sb.append('\u039d');
            sb.append((char)(810900 - eci));
        } else {
            throw new WriterException("ECI number not in valid range from 0..811799, but was " + eci);
        }
    }

    static {
        byte b;
        int i2;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING = StandardCharsets.ISO_8859_1;
        Arrays.fill(MIXED, (byte)-1);
        for (i2 = 0; i2 < TEXT_MIXED_RAW.length; ++i2) {
            b = TEXT_MIXED_RAW[i2];
            if (b <= 0) continue;
            PDF417HighLevelEncoder.MIXED[b] = (byte)i2;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (i2 = 0; i2 < TEXT_PUNCTUATION_RAW.length; ++i2) {
            b = TEXT_PUNCTUATION_RAW[i2];
            if (b <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[b] = (byte)i2;
        }
    }

    private static final class NoECIInput
    implements ECIInput {
        String input;

        private NoECIInput(String input) {
            this.input = input;
        }

        @Override
        public int length() {
            return this.input.length();
        }

        @Override
        public char charAt(int index) {
            return this.input.charAt(index);
        }

        @Override
        public boolean isECI(int index) {
            return false;
        }

        @Override
        public int getECIValue(int index) {
            return -1;
        }

        @Override
        public boolean haveNCharacters(int index, int n) {
            return index + n <= this.input.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.input.subSequence(start, end);
        }

        public String toString() {
            return this.input;
        }
    }
}

