/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.common.BitMatrix;

enum DataMask {
    DATA_MASK_000{

        @Override
        boolean isMasked(int i2, int j) {
            return (i2 + j & 1) == 0;
        }
    }
    ,
    DATA_MASK_001{

        @Override
        boolean isMasked(int i2, int j) {
            return (i2 & 1) == 0;
        }
    }
    ,
    DATA_MASK_010{

        @Override
        boolean isMasked(int i2, int j) {
            return j % 3 == 0;
        }
    }
    ,
    DATA_MASK_011{

        @Override
        boolean isMasked(int i2, int j) {
            return (i2 + j) % 3 == 0;
        }
    }
    ,
    DATA_MASK_100{

        @Override
        boolean isMasked(int i2, int j) {
            return (i2 / 2 + j / 3 & 1) == 0;
        }
    }
    ,
    DATA_MASK_101{

        @Override
        boolean isMasked(int i2, int j) {
            return i2 * j % 6 == 0;
        }
    }
    ,
    DATA_MASK_110{

        @Override
        boolean isMasked(int i2, int j) {
            return i2 * j % 6 < 3;
        }
    }
    ,
    DATA_MASK_111{

        @Override
        boolean isMasked(int i2, int j) {
            return (i2 + j + i2 * j % 3 & 1) == 0;
        }
    };


    final void unmaskBitMatrix(BitMatrix bits, int dimension) {
        for (int i2 = 0; i2 < dimension; ++i2) {
            for (int j = 0; j < dimension; ++j) {
                if (!this.isMasked(i2, j)) continue;
                bits.flip(j, i2);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);
}

