/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    private static final EstimatedModuleComparator moduleComparator = new EstimatedModuleComparator();
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 97;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix image) {
        this(image, null);
    }

    public FinderPatternFinder(BitMatrix image, ResultPointCallback resultPointCallback) {
        this.image = image;
        this.possibleCenters = new ArrayList<FinderPattern>();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> hints) throws NotFoundException {
        boolean tryHarder = hints != null && hints.containsKey((Object)DecodeHintType.TRY_HARDER);
        int maxI = this.image.getHeight();
        int maxJ = this.image.getWidth();
        int iSkip = 3 * maxI / 388;
        if (iSkip < 3 || tryHarder) {
            iSkip = 3;
        }
        boolean done = false;
        int[] stateCount = new int[5];
        for (int i2 = iSkip - 1; i2 < maxI && !done; i2 += iSkip) {
            boolean confirmed;
            FinderPatternFinder.doClearCounts(stateCount);
            int currentState = 0;
            for (int j = 0; j < maxJ; ++j) {
                block5: {
                    block6: {
                        block7: {
                            block10: {
                                block8: {
                                    block9: {
                                        if (this.image.get(j, i2)) {
                                            if (currentState & true) {
                                                // empty if block
                                            }
                                            int n = ++currentState;
                                            stateCount[n] = stateCount[n] + 1;
                                            continue;
                                        }
                                        if (currentState & true) break block5;
                                        if (currentState != 4) break block6;
                                        if (!FinderPatternFinder.foundPatternCross(stateCount)) break block7;
                                        boolean confirmed2 = this.handlePossibleCenter(stateCount, i2, j);
                                        if (!confirmed2) break block8;
                                        iSkip = 2;
                                        if (!this.hasSkipped) break block9;
                                        done = this.haveMultiplyConfirmedCenters();
                                        break block10;
                                    }
                                    int rowSkip = this.findRowSkip();
                                    if (rowSkip <= stateCount[2]) break block10;
                                    i2 += rowSkip - stateCount[2] - iSkip;
                                    j = maxJ - 1;
                                    break block10;
                                }
                                FinderPatternFinder.doShiftCounts2(stateCount);
                                currentState = 3;
                                continue;
                            }
                            currentState = 0;
                            FinderPatternFinder.doClearCounts(stateCount);
                            continue;
                        }
                        FinderPatternFinder.doShiftCounts2(stateCount);
                        currentState = 3;
                        continue;
                    }
                    int n = ++currentState;
                    stateCount[n] = stateCount[n] + 1;
                    continue;
                }
                int n = currentState;
                stateCount[n] = stateCount[n] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(stateCount) || !(confirmed = this.handlePossibleCenter(stateCount, i2, maxJ))) continue;
            iSkip = stateCount[0];
            if (!this.hasSkipped) continue;
            done = this.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] patternInfo = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(patternInfo);
        return new FinderPatternInfo((FinderPattern[])patternInfo);
    }

    private static float centerFromEnd(int[] stateCount, int end) {
        return (float)(end - stateCount[4] - stateCount[3]) - (float)stateCount[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] stateCount) {
        int totalModuleSize = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int count = stateCount[i2];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        float moduleSize = (float)totalModuleSize / 7.0f;
        float maxVariance = moduleSize / 2.0f;
        return Math.abs(moduleSize - (float)stateCount[0]) < maxVariance && Math.abs(moduleSize - (float)stateCount[1]) < maxVariance && Math.abs(3.0f * moduleSize - (float)stateCount[2]) < 3.0f * maxVariance && Math.abs(moduleSize - (float)stateCount[3]) < maxVariance && Math.abs(moduleSize - (float)stateCount[4]) < maxVariance;
    }

    protected static boolean foundPatternDiagonal(int[] stateCount) {
        int totalModuleSize = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int count = stateCount[i2];
            if (count == 0) {
                return false;
            }
            totalModuleSize += count;
        }
        if (totalModuleSize < 7) {
            return false;
        }
        float moduleSize = (float)totalModuleSize / 7.0f;
        float maxVariance = moduleSize / 1.333f;
        return Math.abs(moduleSize - (float)stateCount[0]) < maxVariance && Math.abs(moduleSize - (float)stateCount[1]) < maxVariance && Math.abs(3.0f * moduleSize - (float)stateCount[2]) < 3.0f * maxVariance && Math.abs(moduleSize - (float)stateCount[3]) < maxVariance && Math.abs(moduleSize - (float)stateCount[4]) < maxVariance;
    }

    private int[] getCrossCheckStateCount() {
        FinderPatternFinder.doClearCounts(this.crossCheckStateCount);
        return this.crossCheckStateCount;
    }

    @Deprecated
    protected final void clearCounts(int[] counts) {
        FinderPatternFinder.doClearCounts(counts);
    }

    @Deprecated
    protected final void shiftCounts2(int[] stateCount) {
        FinderPatternFinder.doShiftCounts2(stateCount);
    }

    protected static void doClearCounts(int[] counts) {
        Arrays.fill(counts, 0);
    }

    protected static void doShiftCounts2(int[] stateCount) {
        stateCount[0] = stateCount[2];
        stateCount[1] = stateCount[3];
        stateCount[2] = stateCount[4];
        stateCount[3] = 1;
        stateCount[4] = 0;
    }

    private boolean crossCheckDiagonal(int centerI, int centerJ) {
        int i2;
        int[] stateCount = this.getCrossCheckStateCount();
        for (i2 = 0; centerI >= i2 && centerJ >= i2 && this.image.get(centerJ - i2, centerI - i2); ++i2) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (stateCount[2] == 0) {
            return false;
        }
        while (centerI >= i2 && centerJ >= i2 && !this.image.get(centerJ - i2, centerI - i2)) {
            stateCount[1] = stateCount[1] + 1;
            ++i2;
        }
        if (stateCount[1] == 0) {
            return false;
        }
        while (centerI >= i2 && centerJ >= i2 && this.image.get(centerJ - i2, centerI - i2)) {
            stateCount[0] = stateCount[0] + 1;
            ++i2;
        }
        if (stateCount[0] == 0) {
            return false;
        }
        int maxI = this.image.getHeight();
        int maxJ = this.image.getWidth();
        i2 = 1;
        while (centerI + i2 < maxI && centerJ + i2 < maxJ && this.image.get(centerJ + i2, centerI + i2)) {
            stateCount[2] = stateCount[2] + 1;
            ++i2;
        }
        while (centerI + i2 < maxI && centerJ + i2 < maxJ && !this.image.get(centerJ + i2, centerI + i2)) {
            stateCount[3] = stateCount[3] + 1;
            ++i2;
        }
        if (stateCount[3] == 0) {
            return false;
        }
        while (centerI + i2 < maxI && centerJ + i2 < maxJ && this.image.get(centerJ + i2, centerI + i2)) {
            stateCount[4] = stateCount[4] + 1;
            ++i2;
        }
        if (stateCount[4] == 0) {
            return false;
        }
        return FinderPatternFinder.foundPatternDiagonal(stateCount);
    }

    private float crossCheckVertical(int startI, int centerJ, int maxCount, int originalStateCountTotal) {
        int i2;
        BitMatrix image = this.image;
        int maxI = image.getHeight();
        int[] stateCount = this.getCrossCheckStateCount();
        for (i2 = startI; i2 >= 0 && image.get(centerJ, i2); --i2) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (i2 < 0) {
            return Float.NaN;
        }
        while (i2 >= 0 && !image.get(centerJ, i2) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            --i2;
        }
        if (i2 < 0 || stateCount[1] > maxCount) {
            return Float.NaN;
        }
        while (i2 >= 0 && image.get(centerJ, i2) && stateCount[0] <= maxCount) {
            stateCount[0] = stateCount[0] + 1;
            --i2;
        }
        if (stateCount[0] > maxCount) {
            return Float.NaN;
        }
        for (i2 = startI + 1; i2 < maxI && image.get(centerJ, i2); ++i2) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (i2 == maxI) {
            return Float.NaN;
        }
        while (i2 < maxI && !image.get(centerJ, i2) && stateCount[3] < maxCount) {
            stateCount[3] = stateCount[3] + 1;
            ++i2;
        }
        if (i2 == maxI || stateCount[3] >= maxCount) {
            return Float.NaN;
        }
        while (i2 < maxI && image.get(centerJ, i2) && stateCount[4] < maxCount) {
            stateCount[4] = stateCount[4] + 1;
            ++i2;
        }
        if (stateCount[4] >= maxCount) {
            return Float.NaN;
        }
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= 2 * originalStateCountTotal) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, i2) : Float.NaN;
    }

    private float crossCheckHorizontal(int startJ, int centerI, int maxCount, int originalStateCountTotal) {
        int j;
        BitMatrix image = this.image;
        int maxJ = image.getWidth();
        int[] stateCount = this.getCrossCheckStateCount();
        for (j = startJ; j >= 0 && image.get(j, centerI); --j) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (j < 0) {
            return Float.NaN;
        }
        while (j >= 0 && !image.get(j, centerI) && stateCount[1] <= maxCount) {
            stateCount[1] = stateCount[1] + 1;
            --j;
        }
        if (j < 0 || stateCount[1] > maxCount) {
            return Float.NaN;
        }
        while (j >= 0 && image.get(j, centerI) && stateCount[0] <= maxCount) {
            stateCount[0] = stateCount[0] + 1;
            --j;
        }
        if (stateCount[0] > maxCount) {
            return Float.NaN;
        }
        for (j = startJ + 1; j < maxJ && image.get(j, centerI); ++j) {
            stateCount[2] = stateCount[2] + 1;
        }
        if (j == maxJ) {
            return Float.NaN;
        }
        while (j < maxJ && !image.get(j, centerI) && stateCount[3] < maxCount) {
            stateCount[3] = stateCount[3] + 1;
            ++j;
        }
        if (j == maxJ || stateCount[3] >= maxCount) {
            return Float.NaN;
        }
        while (j < maxJ && image.get(j, centerI) && stateCount[4] < maxCount) {
            stateCount[4] = stateCount[4] + 1;
            ++j;
        }
        if (stateCount[4] >= maxCount) {
            return Float.NaN;
        }
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        if (5 * Math.abs(stateCountTotal - originalStateCountTotal) >= originalStateCountTotal) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(stateCount) ? FinderPatternFinder.centerFromEnd(stateCount, j) : Float.NaN;
    }

    @Deprecated
    protected final boolean handlePossibleCenter(int[] stateCount, int i2, int j, boolean pureBarcode) {
        return this.handlePossibleCenter(stateCount, i2, j);
    }

    protected final boolean handlePossibleCenter(int[] stateCount, int i2, int j) {
        int stateCountTotal = stateCount[0] + stateCount[1] + stateCount[2] + stateCount[3] + stateCount[4];
        float centerJ = FinderPatternFinder.centerFromEnd(stateCount, j);
        float centerI = this.crossCheckVertical(i2, (int)centerJ, stateCount[2], stateCountTotal);
        if (!Float.isNaN(centerI) && !Float.isNaN(centerJ = this.crossCheckHorizontal((int)centerJ, (int)centerI, stateCount[2], stateCountTotal)) && this.crossCheckDiagonal((int)centerI, (int)centerJ)) {
            float estimatedModuleSize = (float)stateCountTotal / 7.0f;
            boolean found = false;
            for (int index = 0; index < this.possibleCenters.size(); ++index) {
                FinderPattern center = this.possibleCenters.get(index);
                if (!center.aboutEquals(estimatedModuleSize, centerI, centerJ)) continue;
                this.possibleCenters.set(index, center.combineEstimate(centerI, centerJ, estimatedModuleSize));
                found = true;
                break;
            }
            if (!found) {
                FinderPattern point = new FinderPattern(centerJ, centerI, estimatedModuleSize);
                this.possibleCenters.add(point);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(point);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int max = this.possibleCenters.size();
        if (max <= 1) {
            return 0;
        }
        FinderPattern firstConfirmedCenter = null;
        for (FinderPattern center : this.possibleCenters) {
            if (center.getCount() < 2) continue;
            if (firstConfirmedCenter == null) {
                firstConfirmedCenter = center;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(firstConfirmedCenter.getX() - center.getX()) - Math.abs(firstConfirmedCenter.getY() - center.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int confirmedCount = 0;
        float totalModuleSize = 0.0f;
        int max = this.possibleCenters.size();
        for (FinderPattern pattern : this.possibleCenters) {
            if (pattern.getCount() < 2) continue;
            ++confirmedCount;
            totalModuleSize += pattern.getEstimatedModuleSize();
        }
        if (confirmedCount < 3) {
            return false;
        }
        float average = totalModuleSize / (float)max;
        float totalDeviation = 0.0f;
        for (FinderPattern pattern : this.possibleCenters) {
            totalDeviation += Math.abs(pattern.getEstimatedModuleSize() - average);
        }
        return totalDeviation <= 0.05f * totalModuleSize;
    }

    private static double squaredDistance(FinderPattern a, FinderPattern b) {
        double x = a.getX() - b.getX();
        double y = a.getY() - b.getY();
        return x * x + y * y;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        int startSize = this.possibleCenters.size();
        if (startSize < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.possibleCenters.sort(moduleComparator);
        double distortion = Double.MAX_VALUE;
        FinderPattern[] bestPatterns = new FinderPattern[3];
        for (int i2 = 0; i2 < this.possibleCenters.size() - 2; ++i2) {
            FinderPattern fpi = this.possibleCenters.get(i2);
            float minModuleSize = fpi.getEstimatedModuleSize();
            for (int j = i2 + 1; j < this.possibleCenters.size() - 1; ++j) {
                FinderPattern fpj = this.possibleCenters.get(j);
                double squares0 = FinderPatternFinder.squaredDistance(fpi, fpj);
                for (int k = j + 1; k < this.possibleCenters.size(); ++k) {
                    double d;
                    double temp;
                    FinderPattern fpk = this.possibleCenters.get(k);
                    float maxModuleSize = fpk.getEstimatedModuleSize();
                    if (maxModuleSize > minModuleSize * 1.4f) continue;
                    double a = squares0;
                    double b = FinderPatternFinder.squaredDistance(fpj, fpk);
                    double c = FinderPatternFinder.squaredDistance(fpi, fpk);
                    if (a < b) {
                        if (b > c) {
                            if (a < c) {
                                temp = b;
                                b = c;
                                c = temp;
                            } else {
                                temp = a;
                                a = c;
                                c = b;
                                b = temp;
                            }
                        }
                    } else if (b < c) {
                        if (a < c) {
                            temp = a;
                            a = b;
                            b = temp;
                        } else {
                            temp = a;
                            a = b;
                            b = c;
                            c = temp;
                        }
                    } else {
                        temp = a;
                        a = c;
                        c = temp;
                    }
                    if (!((d = Math.abs(c - 2.0 * b) + Math.abs(c - 2.0 * a)) < distortion)) continue;
                    distortion = d;
                    bestPatterns[0] = fpi;
                    bestPatterns[1] = fpj;
                    bestPatterns[2] = fpk;
                }
            }
        }
        if (distortion == Double.MAX_VALUE) {
            throw NotFoundException.getNotFoundInstance();
        }
        return bestPatterns;
    }

    private static final class EstimatedModuleComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private EstimatedModuleComparator() {
        }

        @Override
        public int compare(FinderPattern center1, FinderPattern center2) {
            return Float.compare(center1.getEstimatedModuleSize(), center2.getEstimatedModuleSize());
        }
    }
}

